/**      (C) Copyright IBM Corporation 2006                                   
 
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          
 sample code created by IBM Corporation. This sample code is not      
 part of any standard or IBM product and is provided to you solely  
 for  the purpose of assisting you in the development of your       
 applications.  The code is provided "AS IS", without               
 warranty of any kind.  IBM shall not be liable for any damages     
 arising out of your use of the sample code, even if they have been 
 advised of the possibility of such damages.                          */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.JposConst;
import jpos.JposException;
import jpos.Keylock;
import jpos.KeylockConst;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

/** 
 * KeylockDemo class implements a demo 
 * for the basic functionality of the Keylock
 * @author 
 * */

public class KeylockDemo implements DeviceDemo, StatusUpdateListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try KeylockDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n"+ 
               "java com.ibm.jpos.tools.sdicc.demo.KeylockDemo <logicalName>");
            return;
        }
        //create this class that encapsulate the  jpos.Keylock functionality
        DeviceDemo devDemo = new KeylockDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("KeylockDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700, 400);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);

    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_KL_START_TEST },
        { TOOLTIP_TEXT_KL_STARTTEST } };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "Keylock";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_KL_START_TEST))
        {
            // start the device test
            doStartDeviceTest();
            ui.flipButtonLabel(TEXT_KL_START_TEST, new String[]
            { TEXT_KL_STOP_TEST, TOOLTIP_TEXT_KL_STOPTEST });
        }
        else if (button.equals(TEXT_KL_STOP_TEST))
        {
            // stop the device test
            doStopDeviceTest();
            ui.flipButtonLabel(TEXT_KL_STOP_TEST, new String[]
            { TEXT_KL_START_TEST, TOOLTIP_TEXT_KL_STARTTEST });
        }
    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e
     *            the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
        int status = e.getStatus();

        String statusMsg = "StatusUpdateOccurred - ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                break;

            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                break;

            case KeylockConst.LOCK_KP_LOCK:
                statusMsg += "LOCK_KP_LOCK";
                break;

            case KeylockConst.LOCK_KP_NORM:
                statusMsg += "LOCK_KP_NORM";
                break;

            case KeylockConst.LOCK_KP_SUPR:
                statusMsg += "LOCK_KP_SUPR";
                break;
            default :
                statusMsg += "0x"+Integer.toHexString(status);

        }
        // display the status update received
        ui.displayText(statusMsg);

    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties
     * and open the Keylock
     * */
    protected void doStartDeviceTest() throws JposException
    {

        kl.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        try
        {
            // Common Properties
            ui.displayText("DeviceControlVersion = "
                    + kl.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + kl.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + kl.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + kl.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = "
                    + kl.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch (kl.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = " + capPowerReportingName
                    + kl.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = "
                    + kl.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = " + kl.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = "
                    + kl.getCapUpdateStatistics());
            kl.addStatusUpdateListener(this);
            ui.displayText("addStatusUpdateListener(this)");
            if (kl.getCapPowerReporting() != JposConst.JPOS_PR_NONE)
            {
                kl.setPowerNotify(JposConst.JPOS_PN_ENABLED);
                ui.displayText("PowerNotify = JPOS_PN_ENABLED");
            }

            kl.setDeviceEnabled(true);
            ui.displayText("setDeviceEnabled(true)");
            // Specific Properties
            ui.displayText("PositionCount = " + kl.getPositionCount());
            ui.displayText("#\n# Insert a key to test the Keylock...\n#");
        }
        catch (JposException je)
        {
            doStopDeviceTest();
            throw je;
        }
    }

    /**
     * remove data listener
     * disable release and close the device
     * */
    protected void doStopDeviceTest() throws JposException
    {
        kl.removeStatusUpdateListener(this);
        ui.displayText("removeStatusUpdateListener(this)");
        kl.close();
        ui.displayText("close()");
    }

    //-------------------------------------------------------------------------
    // instance variables
    //
    private Keylock kl = new Keylock();

    private static DemoUI ui;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_KL_START_TEST = "Start Keylock Test";

    /** Label for Stop Button */
    private static final String TEXT_KL_STOP_TEST = "Stop Keylock Test";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_KL_STARTTEST = "Open, claim and "+
    "enable the Keylock make it ready to receive keylock position changes";

    /** tool tip text for Stop button */
    private static final String TOOLTIP_TEXT_KL_STOPTEST = "Unregister the " +
            "listener and close the Keylock ";

}
