/**      (C) Copyright IBM Corporation 2006                                   
 
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          
 sample code created by IBM Corporation. This sample code is not      
 part of any standard or IBM product and is provided to you solely  
 for  the purpose of assisting you in the development of your       
 applications.  The code is provided "AS IS", without               
 warranty of any kind.  IBM shall not be liable for any damages     
 arising out of your use of the sample code, even if they have been 
 advised of the possibility of such damages.                          */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.JposConst;
import jpos.JposException;
import jpos.CashDrawer;
import jpos.CashDrawerConst;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

/** 
 * CashDrawerDemo class implements a demo 
 * for the basic functionality of the Cash Drawer
 * @author Raul Garcia 
 * */
public class CashDrawerDemo implements DeviceDemo, StatusUpdateListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try CashDrawerDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n"+
            "java com.ibm.jpos.tools.sdicc.demo.CashDrawerDemo <logicalName>");
            return;
        }
        //create this class that encapsulate the  jpos.CashDrawer functionality
        DeviceDemo devDemo = new CashDrawerDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("CashDrawerDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700, 500);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);
    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_CASH_TEST },
        { TOOLTIP_TEXT_CASH_TEST } };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "CashDrawer";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_CASH_TEST))
        {
            // start the device test
            doStartDeviceTest();
        }

    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e
     *            the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
        int status = e.getStatus();

        String statusMsg = "StatusUpdateOccurred = ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                break;

            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                break;
            case CashDrawerConst.CASH_SUE_DRAWERCLOSED:
                statusMsg += "CASH_SUE_DRAWERCLOSED";
                break;

            case CashDrawerConst.CASH_SUE_DRAWEROPEN:
                statusMsg += "CASH_SUE_DRAWEROPEN";
                break;
            default:
                statusMsg += status;
        }
        //display the status update received
        ui.displayText(statusMsg);

    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties
     * and open the cash drawer
     * */
    protected void doStartDeviceTest() throws JposException
    {
        cd.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        try
        {
            // Common Cap/Properties
            ui.displayText("DeviceControlVersion = "
                    + cd.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + cd.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + cd.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + cd.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = "
                    + cd.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch (cd.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = " + capPowerReportingName
                    + cd.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = "
                    + cd.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = " + cd.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = "
                    + cd.getCapUpdateStatistics());
            // Specific Cap/Properties
            ui.displayText("CapStatus = " + cd.getCapStatus());
            ui.displayText("CapStatusMultiDrawerDetect = "
                    + cd.getCapStatusMultiDrawerDetect());
            ui.displayText("DrawerOpened Property = " + cd.getDrawerOpened());
            cd.claim(1000);
            ui.displayText("Claim(1000)");
            cd.addStatusUpdateListener(this);
            ui.displayText("addStatusUpdateListener(this)");
            if (cd.getCapPowerReporting() != JposConst.JPOS_PR_NONE)
            {
                cd.setPowerNotify(JposConst.JPOS_PN_ENABLED);
                ui.displayText("PowerNotify = JPOS_PN_ENABLED");
            }
            cd.setDeviceEnabled(true);
            ui.displayText("setDeviceEnabled(true)");
            // if the drawer is not opened  then open it
            if (!cd.getDrawerOpened())
            {
                cd.openDrawer();
                ui.displayText("OpenDrawer()");
            }
            else
            {
                ui.displayText("#\n# The drawer is open  please close it.\n#");
            }
        }
        finally
        {
            cd.removeStatusUpdateListener(this);
            ui.displayText("removeStatusUpdateListener(this)");
            cd.close();
            ui.displayText("close()");
        }
    }

    //-------------------------------------------------------------------------
    // instance variables
    //
    private CashDrawer cd = new CashDrawer();

    private static DemoUI ui;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_CASH_TEST = "Start CashDrawer Test";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_CASH_TEST = "Open, claim " +
            "and enable the CashDrawer and phisycally open the drawer";
}
