/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class XmlHelper {
    private String dtdFileName = "jcl.dtd";
    private String dtdFilePath = DEFAULT_DTD_FILE_PATH;
    private String dtdJarFullFileName = this.dtdFilePath + File.separator + this.dtdFileName;
    private boolean createdTempDTD = false;
    private boolean createdTempDir = false;
    private Tracer tracer = TracerFactory.getInstance().createTracer("XmlHelper");
    public static final String DEFAULT_DTD_FILE_NAME = "jcl.dtd";
    public static final String DEFAULT_DTD_FILE_PATH = "jpos" + File.separator + "res" + File.separator;

    public String getDtdFileName() {
        return this.dtdFileName;
    }

    public String getDtdFilePath() {
        return this.dtdFilePath;
    }

    public void setDtdFileName(String string) {
        this.dtdFileName = string;
    }

    public void setDtdFilePath(String string) {
        this.dtdFilePath = string.endsWith(File.separator) ? string : string + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkAndCreateTempDtd() {
        this.createdTempDTD = false;
        this.createdTempDir = false;
        var1_1 = null;
        this.dtdJarFullFileName = this.dtdFilePath + this.dtdFileName;
        try {
            block12: {
                var2_2 = new File(this.dtdFilePath);
                var3_4 = new File(this.dtdJarFullFileName);
                if (!var3_4.exists()) break block12;
                var5_5 = null;
                ** GOTO lbl45
            }
            if (!var2_2.exists()) {
                var2_2.mkdirs();
                this.createdTempDir = true;
                this.tracer.println("DTD file PATH does not exist.  Created path " + this.dtdFilePath);
            }
            var1_1 = ClassLoader.getSystemClassLoader().getResourceAsStream(this.dtdJarFullFileName);
            this.tracer.println("Got DTD InputStream from current ClassLoader");
            if (var1_1 != null) {
                this.readAndCreateTempDtdFile(var1_1);
            }
            ** GOTO lbl52
        }
        catch (IOException var2_3) {
            this.tracer.println("Error creating DTD file: Exception.message = " + var2_3.getMessage());
            var5_7 = null;
            try {
                if (var1_1 == null) return;
                var1_1.close();
                return;
            }
            catch (IOException var6_11) {
                this.tracer.println("Error while closing streams: Exception.message = " + var6_11.getMessage());
                return;
            }
        }
        {
            catch (Throwable var4_13) {
                var5_8 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 202->213)] { 
lbl39:
                // 1 sources

                if (var1_1 == null) throw var4_13;
                var1_1.close();
                throw var4_13;
lbl42:
                // 1 sources

                catch (IOException var6_12) {
                    this.tracer.println("Error while closing streams: Exception.message = " + var6_12.getMessage());
                }
                throw var4_13;
            }
lbl45:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [5 : 202->213)] { 
lbl46:
            // 1 sources

            if (var1_1 == null) return;
            var1_1.close();
            return;
lbl49:
            // 1 sources

            catch (IOException var6_9) {
                this.tracer.println("Error while closing streams: Exception.message = " + var6_9.getMessage());
            }
            return;
lbl52:
            // 1 sources

            var5_6 = null;
            try {}
            catch (IOException var6_10) {}
            this.tracer.println("Error while closing streams: Exception.message = " + var6_10.getMessage());
            return;
            if (var1_1 == null) return;
            var1_1.close();
            return;
        }
    }

    public void removeTempDtd() {
        try {
            if (this.createdTempDTD) {
                File file = new File(this.dtdJarFullFileName);
                file.delete();
                if (this.createdTempDir) {
                    this.removeDirs(this.dtdFilePath);
                }
                this.tracer.println("Removed temp directory with DTD OK");
            }
        }
        catch (Exception exception) {
            this.tracer.println("Error removing temporary DTD file: Exception.msg = " + exception.getMessage());
        }
    }

    private void readAndCreateTempDtdFile(InputStream inputStream) throws IOException {
        File file = new File(this.dtdJarFullFileName);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        StringBuffer stringBuffer = new StringBuffer();
        while (inputStream.available() > 0) {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            stringBuffer.append(new String(byArray));
        }
        outputStreamWriter.write(stringBuffer.toString().trim());
        this.createdTempDTD = true;
        try {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            this.tracer.println("Error while closing streams: IOExeption.msg=" + iOException.getMessage());
        }
        this.tracer.println("Read and created temp " + this.dtdFilePath + this.dtdFileName);
    }

    private Vector getSubdirNames(String string) {
        String string2 = string.replace("\\".charAt(0), "/".charAt(0));
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        Vector<String> vector = new Vector<String>();
        String string3 = string2;
        while (string3.indexOf("/") != -1) {
            vector.add(string3.substring(0, string3.indexOf("/")));
            string3 = string3.substring(string3.indexOf("/") + 1);
        }
        return vector;
    }

    void removeDirs(String string) throws IOException {
        Vector vector = this.getSubdirNames(string);
        while (vector.size() > 0) {
            Vector vector2 = (Vector)vector.clone();
            String string2 = "";
            int n = 0;
            while (n < vector.size()) {
                string2 = string2 + (String)vector.elementAt(n) + File.separator;
                ++n;
            }
            File file = new File(string2);
            if (file.list() != null && file.list().length == 0) {
                file.delete();
            }
            if (vector.size() <= 0) continue;
            vector.removeElementAt(vector.size() - 1);
        }
    }
}

