/*
 * Decompiled with CFR 0.152.
 */
package jpos.profile;

import java.util.Vector;
import jpos.profile.CharacterPropType;
import jpos.profile.DefaultPropValue;
import jpos.profile.DefaultPropValueList;
import jpos.profile.IntegerPropType;
import jpos.profile.PropValue;
import jpos.profile.PropValueList;
import jpos.profile.StringPropType;
import jpos.test.JUnitUtility;
import junit.framework.Assert;
import junit.framework.TestCase;

public class PropValueListTestCase
extends TestCase {
    private PropValueList list = null;
    private PropValue propValue0 = null;
    private PropValue propValue1 = null;
    private PropValue propValue2 = null;

    public PropValueListTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.list = new DefaultPropValueList();
        this.propValue0 = new DefaultPropValue("String", StringPropType.getInstance());
        this.propValue1 = new DefaultPropValue(new Integer(1), IntegerPropType.getInstance());
        this.propValue2 = new DefaultPropValue(new Character('c'), CharacterPropType.getInstance());
    }

    protected void tearDown() {
        this.list = null;
    }

    public void testPropValueList1() {
        Assert.assertTrue((String)"Expects PropValueList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropValueList to be of size 0 and empty", (boolean)this.list.isEmpty());
        this.list.add(this.propValue0);
        this.list.add(this.propValue1);
        this.list.add(this.propValue2);
        Assert.assertTrue((String)"Expects PropValueList to be of size 3", (this.list.getSize() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropValueList to be of size 3 thus NOT empty", (!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.remove(this.propValue1);
        Assert.assertTrue((String)"Expects PropValueList to be of size 2", (this.list.getSize() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects list to have propValue0", (boolean)this.list.contains(this.propValue0));
        Assert.assertTrue((String)"Expects list to NOT have propValue1", (!this.list.contains(this.propValue1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects list to have propValue2", (boolean)this.list.contains(this.propValue2));
        this.list.removeAll();
        Assert.assertTrue((String)"Expects PropValueList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
    }

    public void testPropValueList2() {
        Assert.assertTrue((String)"Expects PropValueList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropValueList to be of size 0 and empty", (boolean)this.list.isEmpty());
        this.list.add(this.propValue0);
        this.list.add(this.propValue1);
        this.list.add(this.propValue2);
        Vector<PropValue> vector = new Vector<PropValue>();
        vector.add(this.propValue0);
        vector.add(this.propValue1);
        vector.add(this.propValue2);
        Assert.assertTrue((String)"Expects PropValueList to be of size 3", (this.list.getSize() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects PropValueList to be of size 3 thus NOT empty", (!this.list.isEmpty() ? 1 : 0) != 0);
        PropValueList.Iterator iterator = this.list.iterator();
        Vector<PropValue> vector2 = new Vector<PropValue>();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents is <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents to be identical as <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.remove(this.propValue0);
        vector.remove(this.propValue0);
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents is <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents to be identical as <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.remove(this.propValue2);
        vector.remove(this.propValue2);
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents is <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents to be identical as <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.removeAll();
        vector.clear();
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents is <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the PropValueList.Iterator contents to be identical as <propValue0, propValue1, propValue2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
    }
}

