/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader.simple;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.JposRegPopulator;
import jpos.loader.AbstractTestCase;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.loader.JposServiceManager;
import jpos.profile.ProfileRegistry;
import jpos.test.JUnitUtility;
import jpos.util.JposProperties;
import junit.framework.Assert;

public class SimpleServiceManagerTestCase
extends AbstractTestCase {
    private JposServiceManager manager = null;
    public static final int MAX_NEW_ENTRY = 10;

    public SimpleServiceManagerTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = JposServiceLoader.getManager();
        this.manager.reloadEntryRegistry();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected boolean useSimpleProfile() {
        return false;
    }

    public void testCreateConnection() throws JposException {
        JposEntryRegistry jposEntryRegistry = this.manager.getEntryRegistry();
        Enumeration enumeration = jposEntryRegistry.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            JposServiceConnection jposServiceConnection = this.manager.createConnection(jposEntry.getLogicalName());
            Assert.assertTrue((String)("Could not get connection for existing entry with logical name = " + jposEntry.getLogicalName()), (jposServiceConnection != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("JposServiceConnection.getLogicalName() == " + jposServiceConnection.getLogicalName() + " is different than the JposEntry.getLogicalName() == " + jposEntry.getLogicalName()), (boolean)jposServiceConnection.getLogicalName().equals(jposEntry.getLogicalName()));
        }
    }

    public void testGetEntryRegistry1() {
        JposEntryRegistry jposEntryRegistry = this.manager.getEntryRegistry();
        Assert.assertTrue((String)"Manager returned a null JposEntryRegistry", (jposEntryRegistry != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Registry does not contain all entries that are supposed to be loaded from the properties file", (boolean)JUnitUtility.isEquals((Enumeration)jposEntryRegistry.getEntries(), this.getEntriesList().iterator()));
    }

    public void testGetEntryRegistry2() {
        JposEntryRegistry jposEntryRegistry = this.manager.getEntryRegistry();
        Assert.assertTrue((String)"Manager returned a null JposEntryRegistry", (jposEntryRegistry != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Registry does not contain all entries that are supposed to be loaded from the properties file", (boolean)JUnitUtility.isEquals((Enumeration)jposEntryRegistry.getEntries(), this.getEntriesList().iterator()));
        List list = this.getEntriesList();
        int n = 0;
        while (n < 10) {
            JposEntry jposEntry = this.createDefaultJposEntry("SimpleServiceManagerTestCase" + n);
            list.add(jposEntry);
            jposEntryRegistry.addJposEntry(jposEntry);
            ++n;
        }
        Assert.assertTrue((String)"Registry does not contain the new entries that were added", (boolean)JUnitUtility.isEquals((Enumeration)jposEntryRegistry.getEntries(), list.iterator()));
    }

    public void testGetProperties() {
        JposProperties jposProperties = this.manager.getProperties();
        Assert.assertTrue((String)"Manager returned a null JposProperties", (jposProperties != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"manager.getProperties() returned different values than what is properties file", (boolean)JUnitUtility.isEquals((Hashtable)this.createHashtable(jposProperties), (HashMap)this.propertiesMap));
    }

    public void testGetRegPopulator() {
        JposRegPopulator jposRegPopulator = this.manager.getRegPopulator();
        Assert.assertTrue((String)"Manager returned a null JposRegPopulator", (jposRegPopulator != null ? 1 : 0) != 0);
    }

    public void testGetProfilePopulator() {
        ProfileRegistry profileRegistry = this.manager.getProfileRegistry();
        Assert.assertTrue((String)"Manager returned a null ProfileRegistry", (profileRegistry != null ? 1 : 0) != 0);
    }

    public void testLoadProfile() {
        this.emptyTest();
    }
}

