/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.ToneIndicatorControl15;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.ToneIndicatorService12;
import jpos.services.ToneIndicatorService13;
import jpos.services.ToneIndicatorService14;
import jpos.services.ToneIndicatorService15;

public class ToneIndicator
implements ToneIndicatorControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS ToneIndicator Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion12 = 1002000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected ToneIndicatorService12 service12 = null;
    protected ToneIndicatorService13 service13 = null;
    protected ToneIndicatorService14 service14 = null;
    protected ToneIndicatorService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected Vector outputCompleteListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public boolean getCapPitch() throws JposException {
        try {
            return this.service12.getCapPitch();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapVolume() throws JposException {
        try {
            return this.service12.getCapVolume();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapPowerReporting();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ToneIndicatorControl13 interface");
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service12.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service12.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service12.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service12.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service12.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service12.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service12.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service12.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service12.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service12.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service12.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public boolean getAsyncMode() throws JposException {
        try {
            return this.service12.getAsyncMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        try {
            this.service12.setAsyncMode(asyncMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getInterToneWait() throws JposException {
        try {
            return this.service12.getInterToneWait();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setInterToneWait(int interToneWait) throws JposException {
        try {
            this.service12.setInterToneWait(interToneWait);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getOutputID() throws JposException {
        try {
            return this.service12.getOutputID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getTone1Duration() throws JposException {
        try {
            return this.service12.getTone1Duration();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTone1Duration(int tone1Duration) throws JposException {
        try {
            this.service12.setTone1Duration(tone1Duration);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getTone1Pitch() throws JposException {
        try {
            return this.service12.getTone1Pitch();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTone1Pitch(int tone1Pitch) throws JposException {
        try {
            this.service12.setTone1Pitch(tone1Pitch);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getTone1Volume() throws JposException {
        try {
            return this.service12.getTone1Volume();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTone1Volume(int tone1Volume) throws JposException {
        try {
            this.service12.setTone1Volume(tone1Volume);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getTone2Duration() throws JposException {
        try {
            return this.service12.getTone2Duration();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTone2Duration(int tone2Duration) throws JposException {
        try {
            this.service12.setTone2Duration(tone2Duration);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getTone2Pitch() throws JposException {
        try {
            return this.service12.getTone2Pitch();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTone2Pitch(int tone2Pitch) throws JposException {
        try {
            this.service12.setTone2Pitch(tone2Pitch);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getTone2Volume() throws JposException {
        try {
            return this.service12.getTone2Volume();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTone2Volume(int tone2Volume) throws JposException {
        try {
            this.service12.setTone2Volume(tone2Volume);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerNotify();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ToneIndicatorControl13 interface");
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setPowerNotify(powerNotify);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the ToneIndicatorControl13 interface");
        }
    }

    public int getPowerState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the ToneIndicatorControl13 interface");
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service12.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service12.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service12 = null;
        this.service13 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service12.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service12.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service12 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service12 = (ToneIndicatorService12)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service12.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1003000) {
            try {
                this.service13 = (ToneIndicatorService13)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement ToneIndicatorDevice13 interface", e);
            }
        }
        if (this.serviceVersion >= 1004000) {
            try {
                this.service14 = (ToneIndicatorService14)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement ToneIndicatorDevice14 interface", e);
            }
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (ToneIndicatorService15)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement ToneIndicatorDevice15 interface", e);
            }
        }
        ToneIndicatorCallbacks callbacks = new ToneIndicatorCallbacks();
        this.service12.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service12.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearOutput() throws JposException {
        try {
            this.service12.clearOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void sound(int numberOfCycles, int interSoundWait) throws JposException {
        try {
            this.service12.sound(numberOfCycles, interSoundWait);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void soundImmediate() throws JposException {
        try {
            this.service12.soundImmediate();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    public void addOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(l);
        }
    }

    public void removeOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class ToneIndicatorCallbacks
    implements EventCallbacks {
        protected ToneIndicatorCallbacks() {
        }

        public BaseControl getEventSource() {
            return ToneIndicator.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = ToneIndicator.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < ToneIndicator.this.directIOListeners.size()) {
                    ((DirectIOListener)ToneIndicator.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = ToneIndicator.this.errorListeners;
            synchronized (vector) {
                int x = 0;
                while (x < ToneIndicator.this.errorListeners.size()) {
                    ((ErrorListener)ToneIndicator.this.errorListeners.elementAt(x)).errorOccurred(e);
                    ++x;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
            Vector vector = ToneIndicator.this.outputCompleteListeners;
            synchronized (vector) {
                int x = 0;
                while (x < ToneIndicator.this.outputCompleteListeners.size()) {
                    ((OutputCompleteListener)ToneIndicator.this.outputCompleteListeners.elementAt(x)).outputCompleteOccurred(e);
                    ++x;
                }
            }
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = ToneIndicator.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < ToneIndicator.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)ToneIndicator.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

