/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPowerControl15;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.POSPowerService15;

public class POSPower
implements POSPowerControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS POSPower Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected POSPowerService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public boolean getCapFanAlarm() throws JposException {
        try {
            return this.service15.getCapFanAlarm();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapHeatAlarm() throws JposException {
        try {
            return this.service15.getCapHeatAlarm();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        try {
            return this.service15.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapQuickCharge() throws JposException {
        try {
            return this.service15.getCapQuickCharge();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapShutdownPOS() throws JposException {
        try {
            return this.service15.getCapShutdownPOS();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapUPSChargeState() throws JposException {
        try {
            return this.service15.getCapUPSChargeState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service15.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service15.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service15.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service15.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service15.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service15.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service15.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service15.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service15.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service15.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service15.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int getEnforcedShutdownDelayTime() throws JposException {
        try {
            return this.service15.getEnforcedShutdownDelayTime();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setEnforcedShutdownDelayTime(int delay) throws JposException {
        try {
            this.service15.setEnforcedShutdownDelayTime(delay);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerFailDelayTime() throws JposException {
        try {
            return this.service15.getPowerFailDelayTime();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        try {
            return this.service15.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        try {
            this.service15.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerState() throws JposException {
        try {
            return this.service15.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getQuickChargeMode() throws JposException {
        try {
            return this.service15.getQuickChargeMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getQuickChargeTime() throws JposException {
        try {
            return this.service15.getQuickChargeTime();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getUPSChargeState() throws JposException {
        try {
            return this.service15.getUPSChargeState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service15.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service15.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service15.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service15.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service15 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service15 = (POSPowerService15)this.serviceConnection.getService();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service15.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        POSPowerCallbacks callbacks = new POSPowerCallbacks();
        this.service15.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service15.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void shutdownPOS() throws JposException {
        try {
            this.service15.shutdownPOS();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class POSPowerCallbacks
    implements EventCallbacks {
        protected POSPowerCallbacks() {
        }

        public BaseControl getEventSource() {
            return POSPower.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = POSPower.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < POSPower.this.directIOListeners.size()) {
                    ((DirectIOListener)POSPower.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = POSPower.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < POSPower.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)POSPower.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

