/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.PINPadControl15;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.PINPadService13;
import jpos.services.PINPadService14;
import jpos.services.PINPadService15;

public class PINPad
implements PINPadControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS PINPad Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected PINPadService13 service13 = null;
    protected PINPadService14 service14 = null;
    protected PINPadService15 service15 = null;
    protected Vector dataListeners = new Vector();
    protected Vector directIOListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public int getCapDisplay() throws JposException {
        try {
            return this.service13.getCapDisplay();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapLanguage() throws JposException {
        try {
            return this.service13.getCapLanguage();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapKeyboard() throws JposException {
        try {
            return this.service13.getCapKeyboard();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapMACCalculation() throws JposException {
        try {
            return this.service13.getCapMACCalculation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapTone() throws JposException {
        try {
            return this.service13.getCapTone();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service13.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service13.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service13.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service13.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service13.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service13.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service13.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service13.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service13.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service13.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service13.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public String getAccountNumber() throws JposException {
        try {
            return this.service13.getAccountNumber();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAccountNumber(String accountNumber) throws JposException {
        try {
            this.service13.setAccountNumber(accountNumber);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getAdditionalSecurityInformation() throws JposException {
        try {
            return this.service13.getAdditionalSecurityInformation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public long getAmount() throws JposException {
        try {
            return this.service13.getAmount();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAmount(long amount) throws JposException {
        try {
            this.service13.setAmount(amount);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getAvailableLanguagesList() throws JposException {
        try {
            return this.service13.getAvailableLanguagesList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getAvailablePromptsList() throws JposException {
        try {
            return this.service13.getAvailablePromptsList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDataCount() throws JposException {
        try {
            return this.service13.getDataCount();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getDataEventEnabled() throws JposException {
        try {
            return this.service13.getDataEventEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        try {
            this.service13.setDataEventEnabled(dataEventEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getEncryptedPIN() throws JposException {
        try {
            return this.service13.getEncryptedPIN();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMaximumPINLength() throws JposException {
        try {
            return this.service13.getMaximumPINLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMaximumPINLength(int maximumPINLength) throws JposException {
        try {
            this.service13.setMaximumPINLength(maximumPINLength);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getMerchantID() throws JposException {
        try {
            return this.service13.getMerchantID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMerchantID(String merchantID) throws JposException {
        try {
            this.service13.setMerchantID(merchantID);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMinimumPINLength() throws JposException {
        try {
            return this.service13.getMinimumPINLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMinimumPINLength(int minimumPINLength) throws JposException {
        try {
            this.service13.setMinimumPINLength(minimumPINLength);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getPINEntryEnabled() throws JposException {
        try {
            return this.service13.getPINEntryEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        try {
            this.service13.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerState() throws JposException {
        try {
            return this.service13.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPrompt() throws JposException {
        try {
            return this.service13.getPrompt();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setPrompt(int propmpt) throws JposException {
        try {
            this.service13.setPrompt(propmpt);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPromptLanguage() throws JposException {
        try {
            return this.service13.getPromptLanguage();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setPromptLanguage(String promptLanguage) throws JposException {
        try {
            this.service13.setPromptLanguage(promptLanguage);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getTerminalID() throws JposException {
        try {
            return this.service13.getTerminalID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTerminalID(String terminalID) throws JposException {
        try {
            this.service13.setTerminalID(terminalID);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public byte[] getTrack1Data() throws JposException {
        try {
            return this.service13.getTrack1Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTrack1Data(byte[] track1Data) throws JposException {
        try {
            this.service13.setTrack1Data(track1Data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public byte[] getTrack2Data() throws JposException {
        try {
            return this.service13.getTrack2Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTrack2Data(byte[] track2Data) throws JposException {
        try {
            this.service13.setTrack2Data(track2Data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public byte[] getTrack3Data() throws JposException {
        try {
            return this.service13.getTrack3Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTrack3Data(byte[] track3Data) throws JposException {
        try {
            this.service13.setTrack3Data(track3Data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getTransactionType() throws JposException {
        try {
            return this.service13.getTransactionType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTransactionType(int transactionType) throws JposException {
        try {
            this.service13.setTransactionType(transactionType);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public byte[] getTrack4Data() throws JposException {
        if (this.service13 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getTrack4Data();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the PINPadControl15 interface");
    }

    public void setTrack4Data(byte[] track4Data) throws JposException {
        if (this.service13 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.setTrack4Data(track4Data);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the PINPadControl15 interface");
        }
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service13.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service13.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service13 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service13.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service13.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service13 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service13 = (PINPadService13)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service13.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1004000) {
            try {
                this.service14 = (PINPadService14)this.service13;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement PINPadDevice14 interface", e);
            }
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (PINPadService15)this.service13;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement PINPadDevice15 interface", e);
            }
        }
        PINPadCallbacks callbacks = new PINPadCallbacks();
        this.service13.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service13.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginEFTTransaction(String PINPadSystem, int transactionHost) throws JposException {
        try {
            this.service13.beginEFTTransaction(PINPadSystem, transactionHost);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearInput() throws JposException {
        try {
            this.service13.clearInput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void computeMAC(String inMsg, String[] outMsg) throws JposException {
        try {
            this.service13.computeMAC(inMsg, outMsg);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void enablePINEntry() throws JposException {
        try {
            this.service13.enablePINEntry();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endEFTTransaction(int completionCode) throws JposException {
        try {
            this.service13.endEFTTransaction(completionCode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void updateKey(int keyNum, String key) throws JposException {
        try {
            this.service13.updateKey(keyNum, key);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void verifyMAC(String message) throws JposException {
        try {
            this.service13.verifyMAC(message);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void addDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(l);
        }
    }

    public void removeDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(l);
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class PINPadCallbacks
    implements EventCallbacks {
        protected PINPadCallbacks() {
        }

        public BaseControl getEventSource() {
            return PINPad.this;
        }

        public void fireDataEvent(DataEvent e) {
            Vector vector = PINPad.this.dataListeners;
            synchronized (vector) {
                int x = 0;
                while (x < PINPad.this.dataListeners.size()) {
                    ((DataListener)PINPad.this.dataListeners.elementAt(x)).dataOccurred(e);
                    ++x;
                }
            }
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = PINPad.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < PINPad.this.directIOListeners.size()) {
                    ((DirectIOListener)PINPad.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = PINPad.this.errorListeners;
            synchronized (vector) {
                int x = 0;
                while (x < PINPad.this.errorListeners.size()) {
                    ((ErrorListener)PINPad.this.errorListeners.elementAt(x)).errorOccurred(e);
                    ++x;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = PINPad.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < PINPad.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)PINPad.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

