/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.LineDisplayControl15;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.LineDisplayService12;
import jpos.services.LineDisplayService13;
import jpos.services.LineDisplayService14;
import jpos.services.LineDisplayService15;

public class LineDisplay
implements LineDisplayControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS LineDisplay Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion12 = 1002000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected LineDisplayService12 service12 = null;
    protected LineDisplayService13 service13 = null;
    protected LineDisplayService14 service14 = null;
    protected LineDisplayService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public int getCapBlink() throws JposException {
        try {
            return this.service12.getCapBlink();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapBrightness() throws JposException {
        try {
            return this.service12.getCapBrightness();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapCharacterSet() throws JposException {
        try {
            return this.service12.getCapCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapDescriptors() throws JposException {
        try {
            return this.service12.getCapDescriptors();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapHMarquee() throws JposException {
        try {
            return this.service12.getCapHMarquee();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapICharWait() throws JposException {
        try {
            return this.service12.getCapICharWait();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapVMarquee() throws JposException {
        try {
            return this.service12.getCapVMarquee();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapPowerReporting();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the LineDisplayControl13 interface");
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service12.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service12.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service12.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service12.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service12.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service12.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service12.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service12.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service12.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service12.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service12.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int getCharacterSet() throws JposException {
        try {
            return this.service12.getCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCharacterSet(int characterSet) throws JposException {
        try {
            this.service12.setCharacterSet(characterSet);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCharacterSetList() throws JposException {
        try {
            return this.service12.getCharacterSetList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getColumns() throws JposException {
        try {
            return this.service12.getColumns();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCurrentWindow() throws JposException {
        try {
            return this.service12.getCurrentWindow();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCurrentWindow(int currentWindow) throws JposException {
        try {
            this.service12.setCurrentWindow(currentWindow);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCursorColumn() throws JposException {
        try {
            return this.service12.getCursorColumn();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCursorColumn(int cursorColumn) throws JposException {
        try {
            this.service12.setCursorColumn(cursorColumn);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCursorRow() throws JposException {
        try {
            return this.service12.getCursorRow();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCursorRow(int cursorRow) throws JposException {
        try {
            this.service12.setCursorRow(cursorRow);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCursorUpdate() throws JposException {
        try {
            return this.service12.getCursorUpdate();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCursorUpdate(boolean cursorUpdate) throws JposException {
        try {
            this.service12.setCursorUpdate(cursorUpdate);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceBrightness() throws JposException {
        try {
            return this.service12.getDeviceBrightness();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceBrightness(int deviceBrightness) throws JposException {
        try {
            this.service12.setDeviceBrightness(deviceBrightness);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceColumns() throws JposException {
        try {
            return this.service12.getDeviceColumns();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceDescriptors() throws JposException {
        try {
            return this.service12.getDeviceDescriptors();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceRows() throws JposException {
        try {
            return this.service12.getDeviceRows();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceWindows() throws JposException {
        try {
            return this.service12.getDeviceWindows();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getInterCharacterWait() throws JposException {
        try {
            return this.service12.getInterCharacterWait();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setInterCharacterWait(int interCharacterWait) throws JposException {
        try {
            this.service12.setInterCharacterWait(interCharacterWait);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMarqueeFormat() throws JposException {
        try {
            return this.service12.getMarqueeFormat();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMarqueeFormat(int marqueeFormat) throws JposException {
        try {
            this.service12.setMarqueeFormat(marqueeFormat);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMarqueeRepeatWait() throws JposException {
        try {
            return this.service12.getMarqueeRepeatWait();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMarqueeRepeatWait(int marqueeRepeatWait) throws JposException {
        try {
            this.service12.setMarqueeRepeatWait(marqueeRepeatWait);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMarqueeType() throws JposException {
        try {
            return this.service12.getMarqueeType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMarqueeType(int marqueeType) throws JposException {
        try {
            this.service12.setMarqueeType(marqueeType);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMarqueeUnitWait() throws JposException {
        try {
            return this.service12.getMarqueeUnitWait();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMarqueeUnitWait(int marqueeUnitWait) throws JposException {
        try {
            this.service12.setMarqueeUnitWait(marqueeUnitWait);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRows() throws JposException {
        try {
            return this.service12.getRows();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerNotify();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the LineDisplayControl13 interface");
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setPowerNotify(powerNotify);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the LineDisplayControl13 interface");
        }
    }

    public int getPowerState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the LineDisplayControl13 interface");
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service12.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service12.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service12 = null;
        this.service13 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service12.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service12.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service12 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service12 = (LineDisplayService12)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service12.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1003000) {
            try {
                this.service13 = (LineDisplayService13)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement LineDisplayDevice13 interface", e);
            }
        }
        if (this.serviceVersion >= 1004000) {
            try {
                this.service14 = (LineDisplayService14)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement LineDisplayDevice14 interface", e);
            }
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (LineDisplayService15)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement LineDisplayDevice15 interface", e);
            }
        }
        LineDisplayCallbacks callbacks = new LineDisplayCallbacks();
        this.service12.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service12.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearDescriptors() throws JposException {
        try {
            this.service12.clearDescriptors();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearText() throws JposException {
        try {
            this.service12.clearText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void createWindow(int viewportRow, int viewportColumn, int viewportHeight, int viewportWidth, int windowHeight, int windowWidth) throws JposException {
        try {
            this.service12.createWindow(viewportRow, viewportColumn, viewportHeight, viewportWidth, windowHeight, windowWidth);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void destroyWindow() throws JposException {
        try {
            this.service12.destroyWindow();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void displayText(String data, int attribute) throws JposException {
        try {
            this.service12.displayText(data, attribute);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void displayTextAt(int row, int column, String data, int attribute) throws JposException {
        try {
            this.service12.displayTextAt(row, column, data, attribute);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void refreshWindow(int window) throws JposException {
        try {
            this.service12.refreshWindow(window);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void scrollText(int direction, int units) throws JposException {
        try {
            this.service12.scrollText(direction, units);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDescriptor(int descriptor, int attribute) throws JposException {
        try {
            this.service12.setDescriptor(descriptor, attribute);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class LineDisplayCallbacks
    implements EventCallbacks {
        protected LineDisplayCallbacks() {
        }

        public BaseControl getEventSource() {
            return LineDisplay.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = LineDisplay.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < LineDisplay.this.directIOListeners.size()) {
                    ((DirectIOListener)LineDisplay.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = LineDisplay.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < LineDisplay.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)LineDisplay.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

