/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.FiscalPrinterControl15;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.FiscalPrinterService13;
import jpos.services.FiscalPrinterService14;
import jpos.services.FiscalPrinterService15;

public class FiscalPrinter
implements FiscalPrinterControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS FiscalPrinter Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected FiscalPrinterService13 service13 = null;
    protected FiscalPrinterService14 service14 = null;
    protected FiscalPrinterService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected Vector outputCompleteListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public boolean getCapAdditionalLines() throws JposException {
        try {
            return this.service13.getCapAdditionalLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapAmountAdjustment() throws JposException {
        try {
            return this.service13.getCapAmountAdjustment();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapAmountNotPaid() throws JposException {
        try {
            return this.service13.getCapAmountNotPaid();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapCheckTotal() throws JposException {
        try {
            return this.service13.getCapCheckTotal();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapCoverSensor() throws JposException {
        try {
            return this.service13.getCapCoverSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapDoubleWidth() throws JposException {
        try {
            return this.service13.getCapDoubleWidth();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapDuplicateReceipt() throws JposException {
        try {
            return this.service13.getCapDuplicateReceipt();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapFixedOutput() throws JposException {
        try {
            return this.service13.getCapFixedOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapHasVatTable() throws JposException {
        try {
            return this.service13.getCapHasVatTable();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapIndependentHeader() throws JposException {
        try {
            return this.service13.getCapIndependentHeader();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapItemList() throws JposException {
        try {
            return this.service13.getCapItemList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnEmptySensor() throws JposException {
        try {
            return this.service13.getCapJrnEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnNearEndSensor() throws JposException {
        try {
            return this.service13.getCapJrnNearEndSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnPresent() throws JposException {
        try {
            return this.service13.getCapJrnPresent();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapNonFiscalMode() throws JposException {
        try {
            return this.service13.getCapNonFiscalMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapOrderAdjustmentFirst() throws JposException {
        try {
            return this.service13.getCapOrderAdjustmentFirst();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapPercentAdjustment() throws JposException {
        try {
            return this.service13.getCapPercentAdjustment();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapPositiveAdjustment() throws JposException {
        try {
            return this.service13.getCapPositiveAdjustment();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapPowerLossReport() throws JposException {
        try {
            return this.service13.getCapPowerLossReport();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapPredefinedPaymentLines() throws JposException {
        try {
            return this.service13.getCapPredefinedPaymentLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapReceiptNotPaid() throws JposException {
        try {
            return this.service13.getCapReceiptNotPaid();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecEmptySensor() throws JposException {
        try {
            return this.service13.getCapRecEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecNearEndSensor() throws JposException {
        try {
            return this.service13.getCapRecNearEndSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecPresent() throws JposException {
        try {
            return this.service13.getCapRecPresent();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRemainingFiscalMemory() throws JposException {
        try {
            return this.service13.getCapRemainingFiscalMemory();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapReservedWord() throws JposException {
        try {
            return this.service13.getCapReservedWord();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSetHeader() throws JposException {
        try {
            return this.service13.getCapSetHeader();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSetPOSID() throws JposException {
        try {
            return this.service13.getCapSetPOSID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSetStoreFiscalID() throws JposException {
        try {
            return this.service13.getCapSetStoreFiscalID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSetTrailer() throws JposException {
        try {
            return this.service13.getCapSetTrailer();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSetVatTable() throws JposException {
        try {
            return this.service13.getCapSetVatTable();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpEmptySensor() throws JposException {
        try {
            return this.service13.getCapSlpEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpFiscalDocument() throws JposException {
        try {
            return this.service13.getCapSlpFiscalDocument();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpFullSlip() throws JposException {
        try {
            return this.service13.getCapSlpFullSlip();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpNearEndSensor() throws JposException {
        try {
            return this.service13.getCapSlpNearEndSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpPresent() throws JposException {
        try {
            return this.service13.getCapSlpPresent();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpValidation() throws JposException {
        try {
            return this.service13.getCapSlpValidation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSubAmountAdjustment() throws JposException {
        try {
            return this.service13.getCapSubAmountAdjustment();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSubPercentAdjustment() throws JposException {
        try {
            return this.service13.getCapSubPercentAdjustment();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSubtotal() throws JposException {
        try {
            return this.service13.getCapSubtotal();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapTrainingMode() throws JposException {
        try {
            return this.service13.getCapTrainingMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapValidateJournal() throws JposException {
        try {
            return this.service13.getCapValidateJournal();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapXReport() throws JposException {
        try {
            return this.service13.getCapXReport();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service13.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service13.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service13.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service13.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service13.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service13.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service13.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service13.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service13.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service13.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service13.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int getAmountDecimalPlace() throws JposException {
        try {
            return this.service13.getAmountDecimalPlace();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getAsyncMode() throws JposException {
        try {
            return this.service13.getAsyncMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        try {
            this.service13.setAsyncMode(asyncMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCheckTotal() throws JposException {
        try {
            return this.service13.getCheckTotal();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCheckTotal(boolean checkTotal) throws JposException {
        try {
            this.service13.setCheckTotal(checkTotal);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCountryCode() throws JposException {
        try {
            return this.service13.getCountryCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCoverOpen() throws JposException {
        try {
            return this.service13.getCoverOpen();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getDayOpened() throws JposException {
        try {
            return this.service13.getDayOpened();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDescriptionLength() throws JposException {
        try {
            return this.service13.getDescriptionLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getDuplicateReceipt() throws JposException {
        try {
            return this.service13.getDuplicateReceipt();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDuplicateReceipt(boolean duplicateReceipt) throws JposException {
        try {
            this.service13.setDuplicateReceipt(duplicateReceipt);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getErrorLevel() throws JposException {
        try {
            return this.service13.getErrorLevel();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getErrorOutID() throws JposException {
        try {
            return this.service13.getErrorOutID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getErrorState() throws JposException {
        try {
            return this.service13.getErrorState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getErrorStation() throws JposException {
        try {
            return this.service13.getErrorStation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getErrorString() throws JposException {
        try {
            return this.service13.getErrorString();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFlagWhenIdle() throws JposException {
        try {
            return this.service13.getFlagWhenIdle();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFlagWhenIdle(boolean flagWhenIdle) throws JposException {
        try {
            this.service13.setFlagWhenIdle(flagWhenIdle);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getJrnEmpty() throws JposException {
        try {
            return this.service13.getJrnEmpty();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getJrnNearEnd() throws JposException {
        try {
            return this.service13.getJrnNearEnd();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMessageLength() throws JposException {
        try {
            return this.service13.getMessageLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getNumHeaderLines() throws JposException {
        try {
            return this.service13.getNumHeaderLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getNumTrailerLines() throws JposException {
        try {
            return this.service13.getNumTrailerLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getNumVatRates() throws JposException {
        try {
            return this.service13.getNumVatRates();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getOutputID() throws JposException {
        try {
            return this.service13.getOutputID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        try {
            this.service13.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerState() throws JposException {
        try {
            return this.service13.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPredefinedPaymentLines() throws JposException {
        try {
            return this.service13.getPredefinedPaymentLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPrinterState() throws JposException {
        try {
            return this.service13.getPrinterState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getQuantityDecimalPlaces() throws JposException {
        try {
            return this.service13.getQuantityDecimalPlaces();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getQuantityLength() throws JposException {
        try {
            return this.service13.getQuantityLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getRecEmpty() throws JposException {
        try {
            return this.service13.getRecEmpty();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getRecNearEnd() throws JposException {
        try {
            return this.service13.getRecNearEnd();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRemainingFiscalMemory() throws JposException {
        try {
            return this.service13.getRemainingFiscalMemory();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getReservedWord() throws JposException {
        try {
            return this.service13.getReservedWord();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getSlpEmpty() throws JposException {
        try {
            return this.service13.getSlpEmpty();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getSlpNearEnd() throws JposException {
        try {
            return this.service13.getSlpNearEnd();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlipSelection() throws JposException {
        try {
            return this.service13.getSlipSelection();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setSlipSelection(int slipSelection) throws JposException {
        try {
            this.service13.setSlipSelection(slipSelection);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getTrainingModeActive() throws JposException {
        try {
            return this.service13.getTrainingModeActive();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service13.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service13.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service13 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service13.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service13.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service13 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service13 = (FiscalPrinterService13)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service13.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1004000) {
            try {
                this.service14 = (FiscalPrinterService14)this.service13;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement FiscalPrinterDevice14 interface", e);
            }
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (FiscalPrinterService15)this.service13;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement FiscalPrinterDevice15 interface", e);
            }
        }
        FiscalPrinterCallbacks callbacks = new FiscalPrinterCallbacks();
        this.service13.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service13.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginFiscalDocument(int documentAmount) throws JposException {
        try {
            this.service13.beginFiscalDocument(documentAmount);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginFiscalReceipt(boolean printHeader) throws JposException {
        try {
            this.service13.beginFiscalReceipt(printHeader);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginFixedOutput(int station, int documentType) throws JposException {
        try {
            this.service13.beginFixedOutput(station, documentType);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginInsertion(int timeout) throws JposException {
        try {
            this.service13.beginInsertion(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginItemList(int vatID) throws JposException {
        try {
            this.service13.beginItemList(vatID);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginNonFiscal() throws JposException {
        try {
            this.service13.beginNonFiscal();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginRemoval(int timeout) throws JposException {
        try {
            this.service13.beginRemoval(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginTraining() throws JposException {
        try {
            this.service13.beginTraining();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearError() throws JposException {
        try {
            this.service13.clearError();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearOutput() throws JposException {
        try {
            this.service13.clearOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endFiscalDocument() throws JposException {
        try {
            this.service13.endFiscalDocument();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endFiscalReceipt(boolean printHeader) throws JposException {
        try {
            this.service13.endFiscalReceipt(printHeader);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endFixedOutput() throws JposException {
        try {
            this.service13.endFixedOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endInsertion() throws JposException {
        try {
            this.service13.endInsertion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endItemList() throws JposException {
        try {
            this.service13.endItemList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endNonFiscal() throws JposException {
        try {
            this.service13.endNonFiscal();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endRemoval() throws JposException {
        try {
            this.service13.endRemoval();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endTraining() throws JposException {
        try {
            this.service13.endTraining();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void getData(int dataItem, int[] optArgs, String[] data) throws JposException {
        try {
            this.service13.getData(dataItem, optArgs, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void getDate(String[] Date) throws JposException {
        try {
            this.service13.getDate(Date);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void getTotalizer(int vatID, int optArgs, String[] data) throws JposException {
        try {
            this.service13.getTotalizer(vatID, optArgs, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void getVatEntry(int vatID, int optArgs, int[] vatRate) throws JposException {
        try {
            this.service13.getVatEntry(vatID, optArgs, vatRate);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printDuplicateReceipt() throws JposException {
        try {
            this.service13.printDuplicateReceipt();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printFiscalDocumentLine(String documentLine) throws JposException {
        try {
            this.service13.printFiscalDocumentLine(documentLine);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printFixedOutput(int documentType, int lineNumber, String data) throws JposException {
        try {
            this.service13.printFixedOutput(documentType, lineNumber, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printNormal(int station, String data) throws JposException {
        try {
            this.service13.printNormal(station, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printPeriodicTotalsReport(String date1, String date2) throws JposException {
        try {
            this.service13.printPeriodicTotalsReport(date1, date2);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printPowerLossReport() throws JposException {
        try {
            this.service13.printPowerLossReport();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecItem(String description, long price, int quantity, int vatInfo, long unitPrice, String unitName) throws JposException {
        try {
            this.service13.printRecItem(description, price, quantity, vatInfo, unitPrice, unitName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecItemAdjustment(int adjustmentType, String description, long amount, int vatInfo) throws JposException {
        try {
            this.service13.printRecItemAdjustment(adjustmentType, description, amount, vatInfo);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecMessage(String message) throws JposException {
        try {
            this.service13.printRecMessage(message);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecNotPaid(String description, long amount) throws JposException {
        try {
            this.service13.printRecNotPaid(description, amount);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecRefund(String description, long amount, int vatInfo) throws JposException {
        try {
            this.service13.printRecRefund(description, amount, vatInfo);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecSubtotal(long amount) throws JposException {
        try {
            this.service13.printRecSubtotal(amount);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecSubtotalAdjustment(int adjustmentType, String description, long amount) throws JposException {
        try {
            this.service13.printRecSubtotalAdjustment(adjustmentType, description, amount);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecTotal(long total, long payment, String description) throws JposException {
        try {
            this.service13.printRecTotal(total, payment, description);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecVoid(String description) throws JposException {
        try {
            this.service13.printRecVoid(description);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printRecVoidItem(String description, long amount, int quantity, int adjustmentType, long adjustment, int vatInfo) throws JposException {
        try {
            this.service13.printRecVoidItem(description, amount, quantity, adjustmentType, adjustment, vatInfo);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printReport(int reportType, String startNum, String endNum) throws JposException {
        try {
            this.service13.printReport(reportType, startNum, endNum);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printXReport() throws JposException {
        try {
            this.service13.printXReport();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printZReport() throws JposException {
        try {
            this.service13.printZReport();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void resetPrinter() throws JposException {
        try {
            this.service13.resetPrinter();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDate(String date) throws JposException {
        try {
            this.service13.setDate(date);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setHeaderLine(int lineNumber, String text, boolean doubleWidth) throws JposException {
        try {
            this.service13.setHeaderLine(lineNumber, text, doubleWidth);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setPOSID(String POSID, String cashierID) throws JposException {
        try {
            this.service13.setPOSID(POSID, cashierID);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setStoreFiscalID(String ID) throws JposException {
        try {
            this.service13.setStoreFiscalID(ID);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setTrailerLine(int lineNumber, String text, boolean doubleWidth) throws JposException {
        try {
            this.service13.setTrailerLine(lineNumber, text, doubleWidth);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setVatTable() throws JposException {
        try {
            this.service13.setVatTable();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setVatValue(int vatID, String vatValue) throws JposException {
        try {
            this.service13.setVatValue(vatID, vatValue);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void verifyItem(String itemName, int vatID) throws JposException {
        try {
            this.service13.verifyItem(itemName, vatID);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    public void addOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(l);
        }
    }

    public void removeOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class FiscalPrinterCallbacks
    implements EventCallbacks {
        protected FiscalPrinterCallbacks() {
        }

        public BaseControl getEventSource() {
            return FiscalPrinter.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = FiscalPrinter.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < FiscalPrinter.this.directIOListeners.size()) {
                    ((DirectIOListener)FiscalPrinter.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = FiscalPrinter.this.errorListeners;
            synchronized (vector) {
                int x = 0;
                while (x < FiscalPrinter.this.errorListeners.size()) {
                    ((ErrorListener)FiscalPrinter.this.errorListeners.elementAt(x)).errorOccurred(e);
                    ++x;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
            Vector vector = FiscalPrinter.this.outputCompleteListeners;
            synchronized (vector) {
                int x = 0;
                while (x < FiscalPrinter.this.outputCompleteListeners.size()) {
                    ((OutputCompleteListener)FiscalPrinter.this.outputCompleteListeners.elementAt(x)).outputCompleteOccurred(e);
                    ++x;
                }
            }
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = FiscalPrinter.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < FiscalPrinter.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)FiscalPrinter.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

