/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.framework.socket;

import br.com.auttar.framework.socket.MessageSocketHandler;
import br.com.auttar.framework.socket.MonitorSocketHandler;
import java.lang.reflect.Constructor;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SocketHandler
extends Thread {
    protected Log log = LogFactory.getLog(SocketHandler.class);
    private Class<? extends MessageSocketHandler> messageSocketHandler;
    private MonitorSocketHandler monitorSocket;
    private SocketChannel socketChannel;

    public <T extends MessageSocketHandler> SocketHandler(Class<T> messageSocketHandeler, SocketChannel socketChannel, MonitorSocketHandler monitorSocket) {
        this.monitorSocket = monitorSocket;
        this.socketChannel = socketChannel;
        this.messageSocketHandler = messageSocketHandeler;
    }

    public abstract void send(byte[] var1);

    public abstract void close();

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public MonitorSocketHandler getMonitorSocket() {
        return this.monitorSocket;
    }

    public MessageSocketHandler createMessageSocketHandler(byte[] message) throws IllegalArgumentException {
        try {
            Class[] params = new Class[]{SocketHandler.class, byte[].class};
            Class<?> clazz = Class.forName(this.messageSocketHandler.getName());
            Constructor<?> cons = clazz.getConstructor(params);
            return (MessageSocketHandler)cons.newInstance(this, message);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

