/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.services.ampq;

import br.com.auttar.clientservices.builder.CheckoutBuilder;
import br.com.auttar.clientservices.model.CancelTransaction;
import br.com.auttar.clientservices.model.Checkout;
import br.com.auttar.clientservices.model.Payment;
import br.com.auttar.clientservices.model.PaymentResult;
import br.com.auttar.clientservices.model.ResultModel;
import br.com.auttar.clientservices.model.SearchCheckout;
import br.com.auttar.clientservices.model.StatusCheck;
import br.com.auttar.clientservices.model.TaxReceiptRequest;
import br.com.auttar.clientservices.services.BaseService;
import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.MessageService;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import br.com.auttar.clientservices.services.ampq.AMQPSessionMessage;
import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQPMessageService
extends BaseService
implements MessageService {
    private Log logger = LogFactory.getLog(MessageService.class);
    private final String AMQP_HOMOLOG = "mqueue-hom.auttar.com.br";
    private final String AMQP_PROD = "mqueue.auttar.com.br";
    private final String AMQP_DEV = "gncashdl01055";
    private boolean isRunning = false;
    private ConnectionFactory rabbitmqConnectionfactory;
    private Connection rabbitmqConnection;
    private Channel channel;

    public AMQPMessageService(Configuration configuration) {
        super(configuration);
    }

    private boolean configure() {
        String host;
        Configuration configuration = this.getConfiguration();
        String user = configuration.getUser();
        String password = configuration.getPassword();
        int port = 0;
        if (configuration.getHost() != null && !"".equals(configuration.getHost().trim())) {
            String[] hosts = configuration.getHost().split(":");
            host = hosts[0];
            if (hosts.length == 2) {
                try {
                    port = Integer.parseInt(hosts[1]);
                }
                catch (Exception e) {
                    this.logger.error((Object)"porta invalida para conexao com o host.");
                    return false;
                }
            } else {
                this.logger.info((Object)"utilizando porta defaut para conexao com o host.");
            }
        } else {
            this.logger.error((Object)"host invalido para conexao.");
            return false;
        }
        if ("mqueue-hom.auttar.com.br".equalsIgnoreCase(host)) {
            user = "svc_postef_nicho";
            password = "U6iz6PfrgIVWx2Ts35Ml";
            port = port == 0 ? 35000 : port;
        } else if ("mqueue.auttar.com.br".equalsIgnoreCase(host)) {
            user = "svc_postef_nicho";
            password = "<9d4<mNKfMtIt$L";
            port = port == 0 ? 35000 : port;
        } else if ("gncashdl01055".equalsIgnoreCase(host)) {
            user = "svc_postef_nicho";
            password = "T3rHnahPxUkNWNpWqrAJ";
            port = 5671;
        }
        SSLContext sslContext = null;
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            SSLContext.setDefault(sslContext);
            sslSocketFactory = sslContext.getSocketFactory();
            SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket();
            socket.getEnabledProtocols();
            socket.getEnabledCipherSuites();
        }
        catch (Exception e) {
            this.logger.error((Object)"nao foi possivel inicializar SSLContext TLSv1.2");
        }
        this.rabbitmqConnectionfactory = new ConnectionFactory();
        this.rabbitmqConnectionfactory.setSocketFactory((SocketFactory)sslSocketFactory);
        this.rabbitmqConnectionfactory.setHost(host);
        this.rabbitmqConnectionfactory.setUsername(user);
        this.rabbitmqConnectionfactory.setPassword(password);
        this.rabbitmqConnectionfactory.setPort(port);
        return true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public boolean connect() {
        if (!this.configure()) {
            this.logger.error((Object)"nao foi possivel configurar AMQPMessageService");
            return false;
        }
        try {
            try {
                this.rabbitmqConnection = this.rabbitmqConnectionfactory.newConnection();
                this.channel = this.rabbitmqConnection.createChannel();
            }
            catch (IOException e) {
                this.logger.error((Object)("nao foi possivel conectar no hub de servicos. " + e.getMessage()));
            }
            catch (TimeoutException e) {
                this.logger.error((Object)("timeout na conexao com hub de servicos. " + e.getMessage()));
            }
            if (this.getConfiguration().getMobilePosCode() != null) {
                this.subscribeGetPayment(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getMobilePosCode());
                this.subscribePaymentResult(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getMobilePosCode());
                this.subscribeStatusCheck(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getMobilePosCode());
            }
            if (this.getConfiguration().getExternalCode() != null && !"".equals(this.getConfiguration().getExternalCode())) {
                this.subscribeCheckoutRequest(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode());
                this.subscribeStartPayment(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribeCancelPayment(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribeTaxReceiptGenerate(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribeGetTaxReceipt(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribePostPayment(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribeCancelTransaction(this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode());
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("InterruptedException when setting up the broker client:" + e.getMessage()), (Throwable)e);
            return false;
        }
        catch (ExecutionException e) {
            this.logger.error((Object)("ExecutionException when setting up the broker client:" + e.getMessage()), (Throwable)e);
            return false;
        }
        this.isRunning = true;
        this.logger.info((Object)"conectado ao hub de servicos.");
        return this.isRunning;
    }

    @Override
    public void disconnect() {
        this.isRunning = false;
    }

    private SessionMessage createSession(Channel channel, AMQP.BasicProperties properties, SessionMessageType type) {
        String sessionId = UUID.randomUUID().toString();
        AMQPSessionMessage sessionMessage = new AMQPSessionMessage(sessionId, channel, properties, type);
        this.logger.info((Object)String.format("request -> type: %s, sessionId: %s", sessionMessage.getType().name(), sessionMessage.getSessionId()));
        return sessionMessage;
    }

    private void trace(SessionMessage sessionMessage, String json) {
        this.logger.trace((Object)String.format("request -> %s (%s): %s", sessionMessage.getType().name(), sessionMessage.getSessionId(), json));
    }

    private void subscribeGetPayment(String companyCode, String storeCode, String remotePOSTefCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.get.payment_request";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".payment_pos_code." + remotePOSTefCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.get_payment_request);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        Checkout checkout = (Checkout)gson.fromJson(json, Checkout.class);
                        checkout.setJsonRawValue(json);
                        AMQPMessageService.this.firePaymenteRequestListener(sessionMessage, checkout);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("channel " + exchangeName + " -> status: OK"));
    }

    private void subscribePaymentResult(String companyCode, String storeCode, String remotePOSTefCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.post.payment_result";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".payment_pos_code." + remotePOSTefCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.post_payment_result);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        PaymentResult paymentResult = (PaymentResult)gson.fromJson(json, PaymentResult.class);
                        paymentResult.setJsonRawValue(json);
                        AMQPMessageService.this.firePaymenteResultListener(sessionMessage, paymentResult);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    public void subscribeStatusCheck(String companyCode, String storeCode, String remotePOSTefCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.get.pinpad_movel_status_check";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".payment_pos_code." + remotePOSTefCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.get_pinpad_movel_status_check);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        gson.fromJson(json, StatusCheck.class);
                        ResultModel resultModel = new ResultModel();
                        resultModel.setSucess();
                        sessionMessage.send(resultModel);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private void subscribeCheckoutRequest(String companyCode, String storeCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.get.checkout";
        String routingKey = "company." + companyCode + ".store." + storeCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.get_checkout);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        SearchCheckout checkout = (SearchCheckout)gson.fromJson(json, SearchCheckout.class);
                        checkout.setJsonRawValue(json);
                        AMQPMessageService.this.fireCheckoutListener(sessionMessage, checkout);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private void subscribeStartPayment(String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.post.start_payment";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.post_checkout_start_payment);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Checkout checkout = CheckoutBuilder.buildFromJson(json);
                        AMQPMessageService.this.fireCheckoutStartPaymentListener(sessionMessage, checkout);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private void subscribeCancelPayment(String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.post.cancel_payment";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.post_checkout_cancel_payment);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Checkout checkout = CheckoutBuilder.buildFromJson(json);
                        AMQPMessageService.this.fireCheckoutCancelPaymentListener(sessionMessage, checkout);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private void subscribeTaxReceiptGenerate(String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.post.generate_tax_receipt";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.post_tax_receipt_generate);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        TaxReceiptRequest taxReceiptRequest = (TaxReceiptRequest)gson.fromJson(json, TaxReceiptRequest.class);
                        taxReceiptRequest.setJsonRawValue(json);
                        AMQPMessageService.this.fireTaxReceiptListener(sessionMessage, taxReceiptRequest);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private void subscribeGetTaxReceipt(String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.get.tax_receipt";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.get_tax_receipt);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        TaxReceiptRequest taxReceiptRequest = (TaxReceiptRequest)gson.fromJson(json, TaxReceiptRequest.class);
                        taxReceiptRequest.setJsonRawValue(json);
                        AMQPMessageService.this.fireTaxReceiptListener(sessionMessage, taxReceiptRequest);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private void subscribePostPayment(String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.post.payment";
        String routingKey = "company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.post_payment);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        Payment payment = new Payment(json);
                        AMQPMessageService.this.firePaymentListerner(sessionMessage, payment);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private void subscribeCancelTransaction(String companyCode, String storeCode) throws ExecutionException, InterruptedException {
        String exchangeName = "request.post.cancel_transaction";
        String routingKey = "company." + companyCode + ".store." + storeCode;
        String channelName = exchangeName + "/" + routingKey;
        this.logger.info((Object)("exchange: " + channelName));
        try {
            String queue = this.createQueue(this.channel);
            if (queue == null) {
                this.logger.error((Object)String.format("fila invalida para exchange '%s'", exchangeName));
                return;
            }
            this.channel.queueBind(queue, exchangeName, routingKey);
            this.channel.basicConsume(queue, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties.getReplyTo() != null && properties.getCorrelationId() != null) {
                        String json = new String(body);
                        SessionMessage sessionMessage = AMQPMessageService.this.createSession(AMQPMessageService.this.channel, properties, SessionMessageType.cancel_transaction);
                        AMQPMessageService.this.trace(sessionMessage, json);
                        CancelTransaction cancelTransaction = new CancelTransaction(json);
                        AMQPMessageService.this.fireCancelTransactionListerner(sessionMessage, cancelTransaction);
                    }
                }
            });
        }
        catch (IOException e) {
            this.logger.error((Object)(channelName + ". " + e.getMessage()));
        }
        this.logger.info((Object)("exchange " + exchangeName + " -> status: OK"));
    }

    private String createQueue(Channel channel) {
        String uuid = UUID.randomUUID().toString();
        String queue = "stomp-subscription-" + uuid;
        HashMap args = new HashMap();
        try {
            channel.queueDeclare(queue, false, false, true, args);
            return queue;
        }
        catch (IOException e) {
            this.logger.error((Object)(String.format("nao foi possivel criar fila '%s'. ", queue) + e.getMessage()));
            return null;
        }
    }
}

