/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.printer;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.DefaultPOSPrinterCmd;
import com.ibm.posj.Handle;
import com.ibm.posj.HandleCmd;
import com.ibm.posj.HandleException;
import com.ibm.posj.IBM4610PrinterCmd;
import com.ibm.posj.SystemCmd;
import com.ibm.posj.ToneIndicatorCmd;
import com.ibm.posj.bus.IBMPrinterComposite;
import com.ibm.posj.bus.printer.cmds.PrintCmd;
import com.ibm.posj.event.StatusEvent;
import com.ibm.posj.printer.DefaultDeviceInputQueue;
import com.ibm.posj.printer.DeviceInputQueue;
import com.ibm.posj.printer.IBMPrinterToneIndicatorImp;
import com.ibm.posj.printer.PrinterWriter;
import com.ibm.posj.printer.RetryInputQueue;
import com.ibm.posj.printer.event.PrintErrorEvent;
import com.ibm.posj.util.DevBuses;
import com.ibm.posj.util.DevCats;

public class IBM4610SSTToneIndicatorImp
implements IBMPrinterToneIndicatorImp {
    private DeviceInputQueue iQueue = null;
    private IBM4610PrinterCmd.Factory defFactory;
    private IBMPrinterComposite ipc = null;
    private Object lockobj = new Object();
    private Object lockUntilCmdReceived = new Object();
    private int toneDuration = 0;
    private Tracer tracer = TracerFactory.getInstance().createTracer(((Object)DevCats.TONEINDICATOR_DEVCAT).toString(), "IBM4610SSTToneIndicatorImp");
    public static final int WAIT_TIMEOUT_VALUE = 3000;
    private static final int IBM4610SSTTONEINDICATOR_MAX_DURATION = 25400;

    public IBM4610SSTToneIndicatorImp(IBMPrinterComposite ptrComposite) {
        this.ipc = ptrComposite;
    }

    public void init() throws HandleException {
        this.getIBMPrinterComposite().init();
        this.defFactory = (IBM4610PrinterCmd.Factory)this.getIBMPrinterComposite().getPrintCmdFactory();
    }

    public void submit(HandleCmd cmd) throws HandleException {
        block12: {
            if (this.tracer.isOn()) {
                this.tracer.println(2, "-->submit(" + cmd.getName() + ")");
            }
            if (null == this.iQueue) {
                this.iQueue = new DefaultDeviceInputQueue(this, "Tone");
                this.getPrinterWriter().registerDeviceQueue((RetryInputQueue)this.iQueue);
            }
            if (cmd == null) {
                throw new HandleException("Attempted to submit a null command to handle");
            }
            try {
                if (cmd.getCode() == 1000) {
                    PrintCmd tiCmd = this.createBeeperCmd(cmd);
                    ToneIndicatorCmd.ToneCmd sound = (ToneIndicatorCmd.ToneCmd)cmd;
                    this.toneDuration = sound.getDuration() <= 25400 ? sound.getDuration() : 25400;
                    Handle.EventHelper eventHelper = this.ipc.getHandle().getEventHelper();
                    this.iQueue.submit(tiCmd);
                    this.waitForCmdReceivedMsg();
                    eventHelper.fireStatusEvent(new StatusEvent(this, 0));
                    this.lockUntilSoundCompleted(this.toneDuration);
                    eventHelper.fireStatusEvent(new StatusEvent(this, 1));
                    break block12;
                }
                if (cmd instanceof SystemCmd) {
                    if (cmd.getCode() == 103) {
                        this.submitDevInfoCmd((SystemCmd.DeviceInfoRequestCmd)cmd);
                    }
                    break block12;
                }
                throw new HandleException("Invalid POSPrinterToneIndicatorCmd object submitted!");
            }
            catch (HandleException he) {
                cmd.getResult().setInError(true);
                throw he;
            }
            finally {
                cmd.setCompleted(true);
            }
        }
        if (this.tracer.isOn()) {
            this.tracer.println(2, "<--submit(" + cmd.getName() + ")");
        }
    }

    public PrintCmd createBeeperCmd(HandleCmd cmd) throws HandleException {
        DefaultPOSPrinterCmd ppc = null;
        PrintCmd ret = null;
        try {
            ToneIndicatorCmd.ToneCmd sound = (ToneIndicatorCmd.ToneCmd)cmd;
            ppc = (DefaultPOSPrinterCmd)this.defFactory.createBeeperCmd(sound.getOn(), sound.getTimed(), sound.getDuration(), sound.getFrequency(), sound.getVolume());
            ret = ppc.getPrintCmd();
            ret.setParent(this);
        }
        catch (Exception e) {
            throw new HandleException("Error while creating beeperCmd ");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCmdComplete(PrintCmd done) {
        if (done.getHandleCmd() instanceof IBM4610PrinterCmd.BeeperCmd) {
            Object object = this.lockUntilCmdReceived;
            synchronized (object) {
                this.lockUntilCmdReceived.notifyAll();
            }
            if (null != done.getHandleCmd()) {
                done.getHandleCmd().setCompleted(true);
            }
        }
    }

    public void handleError(PrintCmd err, PrintErrorEvent status) {
        err.getHandleCmd().getResult().setInError(true);
    }

    public boolean handleImmediateError(PrintCmd err, PrintErrorEvent event) {
        return false;
    }

    protected void submitDevInfoCmd(SystemCmd.DeviceInfoRequestCmd cmd) {
        cmd.setFirmwareLevel(this.getIBMPrinterComposite().getPrinterID_microcodeLevel() & 0xFF);
        cmd.setSerialNumber(this.getIBMPrinterComposite().getDeviceSerialNumber());
        if (this.getIBMPrinterComposite().getDevBus().equals(DevBuses.RS232_DEVBUS)) {
            cmd.setDeviceId(4446);
        } else if (this.getIBMPrinterComposite().getDevBus().equals(DevBuses.RS485_DEVBUS)) {
            cmd.setDeviceId(4445);
        } else {
            cmd.setDeviceId(4447);
        }
        if (this.tracer.isOn()) {
            this.tracer.println(2, "Using Device ID : " + cmd.getDeviceId());
        }
    }

    protected void submitSystemCmd(SystemCmd systemCmd) throws HandleException {
    }

    protected IBMPrinterComposite getIBMPrinterComposite() {
        return this.ipc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockUntilSoundCompleted(int msecs) {
        Object object = this.lockobj;
        synchronized (object) {
            try {
                this.lockobj.wait(msecs + 50);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCmdReceivedMsg() {
        Object object = this.lockUntilCmdReceived;
        synchronized (object) {
            try {
                this.lockUntilCmdReceived.wait(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected PrinterWriter getPrinterWriter() {
        return this.ipc.getWriter();
    }
}

