/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.flash;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.Handle;
import com.ibm.posj.bus.FlashHandleImp;
import com.ibm.posj.flash.DefaultFlashFileFactory;
import com.ibm.posj.flash.FlashException;
import com.ibm.posj.flash.FlashFile;
import com.ibm.posj.flash.FlashFileFactory;
import com.ibm.posj.flash.FlashPathFinder;
import com.ibm.posj.util.DevCats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FlashFilesRegistry {
    private Map registry = new HashMap();
    private Map flashFileNames;
    private FlashFileFactory flashFileFactory;
    private String[] buses = new String[]{"RS485", "RS232", "USB"};
    private String fs = System.getProperty("file.separator");
    private String flashFilesRootPath;
    private Tracer tracer = TracerFactory.getInstance().createTracer("FLASHING", "FlashFileRegistry");

    public FlashFilesRegistry() {
        this.flashFileFactory = new DefaultFlashFileFactory();
        this.flashFilesRootPath = FlashPathFinder.getInstance().getFilePath();
    }

    public List getFlashFiles(Handle handle) throws FlashException {
        if (!this.registry.containsKey(handle)) {
            FlashHandleImp flashHandleImp = handle.getHandleImp().getFlashHandleImp();
            this.registry.put(handle, this.createFiles(flashHandleImp.getFlashFileNames(handle), handle));
        }
        return (List)this.registry.get(handle);
    }

    private List createFiles(String[] flashFileNames, Handle handle) throws FlashException {
        Vector<FlashFile> files = new Vector<FlashFile>();
        for (int i = 0; i < flashFileNames.length; ++i) {
            String absolutePath = this.flashFilesRootPath + this.fs + this.getBusDirectory(handle, flashFileNames[i]) + this.fs + flashFileNames[i];
            try {
                files.add(this.flashFileFactory.createFlashFile(absolutePath));
                continue;
            }
            catch (Exception e) {
                if (!this.tracer.isOn()) continue;
                this.tracer.print(flashFileNames[i] + "not found");
            }
        }
        return files;
    }

    private String getBusDirectory(Handle handle, String flashFileName) {
        if (handle.getDevBus().getName().equalsIgnoreCase("usb")) {
            if (flashFileName.endsWith(".hex") && handle.getDevCat().equals(DevCats.POSPRINTER_DEVCAT)) {
                return "rs485";
            }
            return "usb";
        }
        return "rs485";
    }

    private Map getRegistry() {
        if (this.registry == null) {
            this.registry = new HashMap();
        }
        return this.registry;
    }

    private Object getFlashFileNames(Object[] flashFileNames) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.buses.length; ++i) {
            map.put(this.buses[i], flashFileNames[i]);
        }
        return map;
    }
}

