/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.printer.cmds;

import com.ibm.jutil.patterns.factory.RecyclableObject;
import com.ibm.jutil.patterns.factory.RecycleFactory;
import com.ibm.jutil.patterns.factory.RecycleFactoryException;
import com.ibm.posj.DefaultPOSPrinterCmd;
import com.ibm.posj.POSPrinterCmd;
import com.ibm.posj.bus.printer.cmds.AbstractByteCmd;
import com.ibm.posj.bus.printer.cmds.FontCmdFactory;
import com.ibm.posj.bus.printer.cmds.GeneralCmdFactory;
import com.ibm.posj.bus.printer.cmds.GraphicCmdFactory;
import com.ibm.posj.bus.printer.cmds.PrintCmd;
import com.ibm.posj.bus.printer.cmds.PrintCmdList;
import com.ibm.posj.bus.printer.cmds.PrinterRecycleFactory;
import java.util.ConcurrentModificationException;

public abstract class PrintCmdFactory {
    private int maxSize = 0;
    private static PrinterRecycleFactory rFactory = null;
    private byte id = 1;

    public PrintCmdFactory(int CommandCnt, int maxSize) {
        if (rFactory == null) {
            rFactory = new PrinterRecycleFactory(new Creator(this));
        }
        this.maxSize = maxSize;
    }

    public abstract PrintCmdList createPrintCmdList();

    public abstract AbstractByteCmd getCmdBytes();

    public int getMaxCmdLen() {
        return this.maxSize;
    }

    public PrinterRecycleFactory getBaseFactory() {
        return rFactory;
    }

    public abstract void setCmdsStation(PrintCmd var1, byte var2);

    public PrintCmd createCmd(POSPrinterCmd ocmd) {
        DefaultPOSPrinterCmd cmd = (DefaultPOSPrinterCmd)ocmd;
        if (cmd == null || cmd.isPrintCmdNull()) {
            return this.createCmd();
        }
        PrintCmd ret = cmd.getPrintCmd();
        ret.setBytes(cmd.getOutboundPacket());
        return ret;
    }

    public byte generateID() {
        if (this.id == 0) {
            this.id = (byte)(this.id + 1);
        }
        byte by = this.id;
        this.id = (byte)(by + 1);
        return by;
    }

    public PrintCmd createCmd() {
        PrintCmd ret = null;
        while (null == ret) {
            try {
                ret = rFactory.getNewPrintCmd();
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        ret.setMaxSize(this.maxSize);
        return ret;
    }

    public void recycle(RecyclableObject cmd) {
        if (cmd instanceof PrintCmd) {
            rFactory.recycle(cmd);
        }
    }

    public abstract GeneralCmdFactory getGeneralFactory();

    public abstract GraphicCmdFactory getGraphicFactory();

    public abstract FontCmdFactory getFontFactory();

    class Creator
    implements RecycleFactory.CreateMethod {
        PrintCmdFactory factory = null;

        Creator(PrintCmdFactory f) {
            this.factory = f;
        }

        public RecyclableObject newRecyclableObject(RecyclableObject.CtorArg[] ctorArgs, RecycleFactory recycleFactory) throws RecycleFactoryException {
            throw new RecycleFactoryException("Command not Supported");
        }

        public RecyclableObject newRecyclableObject(RecycleFactory recycleFactory) {
            return new PrintCmd(this.factory);
        }
    }
}

