/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid.javaxusbold;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.bus.hid.javaxusbold.IBM4610PrinterInitializer;
import com.ibm.posj.bus.hid.javaxusbold.IBM4689PrinterInitializer;
import com.ibm.posj.bus.hid.javaxusbold.POSKeyboardInitializer;
import com.ibm.posj.bus.hid.javaxusbold.ProtocolConverterInitializer;
import com.ibm.posj.bus.hid.javaxusbold.UsbHandlePopulator;
import com.ibm.posj.bus.hid.javaxusbold.UsbUtil;
import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;

public class UsbInitializationManager {
    private UsbHandlePopulator usbHandlePopulator = null;
    private UsbUtil usbUtil = UsbUtil.getInstance();
    private final Tracer tracer = TracerFactory.getInstance().createTracer("HID", "UsbInitializationManager");
    private List printers = null;
    private UsbDevice systemKeyboard = null;
    private final UsbDeviceListener sysKbdListener = new UsbDeviceListener(){

        public void usbDeviceDetached(UsbDeviceEvent udE) {
            UsbInitializationManager.this.systemKeyboard = null;
            udE.getUsbDevice().removeUsbDeviceListener((UsbDeviceListener)this);
        }

        public void errorEventOccurred(UsbDeviceErrorEvent udeE) {
        }

        public void dataEventOccurred(UsbDeviceDataEvent uddE) {
        }
    };

    UsbInitializationManager(UsbHandlePopulator populator) {
        this.usbHandlePopulator = populator;
    }

    public boolean initializeUsbDevice(UsbDevice device) {
        short pid;
        String serial;
        UsbDeviceDescriptor udd;
        boolean initialized = true;
        if (this.usbUtil.isKbdAsSystemKeyboard(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct())) {
            if (this.existSystemKeyboard() && !this.isSystemKeyboard(device)) {
                this.tracer.println("IBM keyboard : System keyboard already attached");
            } else {
                this.tracer.println("IBM keyboard : device will be used as system keyboard");
                if (!this.isSystemKeyboard(device)) {
                    this.systemKeyboard = device;
                    device.addUsbDeviceListener(this.sysKbdListener);
                }
            }
        }
        if (this.usbUtil.isKbdRenumerationRequired(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct())) {
            if (this.isSystemKeyboard(device)) {
                return true;
            }
            POSKeyboardInitializer initializer = new POSKeyboardInitializer();
            initializer.setUsbDevice(device);
            initializer.setUsbHandlePopulator(this.usbHandlePopulator);
            return initializer.initialize();
        }
        if (this.usbUtil.isOEMScannerRenumerationRequired(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct())) {
            ProtocolConverterInitializer initializer = new ProtocolConverterInitializer();
            initializer.setUsbDevice(device);
            initializer.setUsbHandlePopulator(this.usbHandlePopulator);
            initialized = initializer.initialize();
        }
        if (UsbUtil.isIBM4610((udd = device.getUsbDeviceDescriptor()).idVendor(), udd.idProduct()) && this.usbHandlePopulator.isIniting()) {
            try {
                serial = device.getSerialNumberString();
                pid = udd.idProduct();
                if (17717 == pid && null == this.printers) {
                    this.printers = new ArrayList(3);
                }
                if (!this.printers.contains(serial)) {
                    this.printers.add(serial);
                    this.usbHandlePopulator.confirmConnectedPrinter();
                    IBM4610PrinterInitializer initializer = new IBM4610PrinterInitializer();
                    initializer.setUsbDevice(device);
                    initializer.setUsbHandlePopulator(this.usbHandlePopulator);
                    return initializer.initialize();
                }
            }
            catch (Exception e) {
                this.tracer.print(e);
                return initialized;
            }
        }
        if (UsbUtil.isIBM4689(udd.idVendor(), udd.idProduct()) && this.usbHandlePopulator.isIniting()) {
            try {
                serial = device.getSerialNumberString();
                pid = udd.idProduct();
                if (17719 == pid && null == this.printers) {
                    this.printers = new ArrayList(3);
                }
                if (!this.printers.contains(serial)) {
                    this.printers.add(serial);
                    this.usbHandlePopulator.confirmConnectedPrinter();
                    IBM4689PrinterInitializer initializer = new IBM4689PrinterInitializer();
                    initializer.setUsbDevice(device);
                    initializer.setUsbHandlePopulator(this.usbHandlePopulator);
                    return initializer.initialize();
                }
            }
            catch (Exception e) {
                this.tracer.print(e);
                return initialized;
            }
        }
        return initialized;
    }

    protected boolean existSystemKeyboard() {
        return null != this.systemKeyboard;
    }

    protected boolean isSystemKeyboard(UsbDevice device) {
        try {
            if (this.systemKeyboard == null) {
                return false;
            }
            return this.systemKeyboard.getSerialNumberString().equalsIgnoreCase(device.getSerialNumberString());
        }
        catch (Exception uee) {
            this.tracer.print(uee);
            return false;
        }
    }
}

