/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poss;

import com.ibm.poss.Util;

public class PosQMsg {
    private int pid;
    private int msg;
    private int mp1;
    private int mp2;
    private static final int length = 16;

    PosQMsg() {
        this.pid = 0;
        this.msg = 0;
        this.mp1 = 0;
        this.mp2 = 0;
    }

    PosQMsg(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        this.init(byArray, n);
    }

    PosQMsg(int n, int n2, int n3) {
        this.pid = 0;
        this.msg = n;
        this.mp1 = n2;
        this.mp2 = n3;
    }

    PosQMsg(int n, int n2) {
        this.pid = 0;
        this.msg = n;
        this.mp1 = n2;
        this.mp2 = 0;
    }

    PosQMsg(int n) {
        this.pid = 0;
        this.msg = n;
        this.mp1 = 0;
        this.mp2 = 0;
    }

    PosQMsg(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this.init(byArray, 0);
    }

    void init(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        if (byArray.length - n < 16) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.pid = Util.bytesToInt(byArray, n);
        this.msg = Util.bytesToInt(byArray, n + 4);
        this.mp1 = Util.bytesToInt(byArray, n + 8);
        this.mp2 = Util.bytesToInt(byArray, n + 12);
    }

    int length() {
        return 16;
    }

    public int getPid() {
        return this.pid;
    }

    public int getMsg() {
        return this.msg;
    }

    void setMsg(int n) {
        this.msg = n;
    }

    public int getMp1() {
        return this.mp1;
    }

    public int getMp2() {
        return this.mp2;
    }

    byte getMp1TopByte() {
        return (byte)(this.mp1 >> 24 & 0xFF);
    }

    void setMp1TopByte(byte by) {
        this.mp1 &= 0xFFFFFF;
        this.mp1 |= (by & 0xFF) << 24;
    }

    byte getMp1MiddleTopByte() {
        return (byte)(this.mp1 >> 16 & 0xFF);
    }

    void setMp1MiddleTopByte(byte by) {
        this.mp1 &= 0xFF00FFFF;
        this.mp1 |= (by & 0xFF) << 16;
    }

    byte getMp1MiddleBottomByte() {
        return (byte)(this.mp1 >> 8 & 0xFF);
    }

    void setMp1MiddleBottomByte(byte by) {
        this.mp1 &= 0xFFFF00FF;
        this.mp1 |= (by & 0xFF) << 8;
    }

    byte getMp1BottomByte() {
        return (byte)(this.mp1 & 0xFF);
    }

    void setMp1BottomByte(byte by) {
        this.mp1 &= 0xFFFFFF00;
        this.mp1 |= by & 0xFF;
    }

    short getMp1TopShort() {
        return (short)(this.mp1 >> 16 & 0xFFFF);
    }

    void setMp1TopShort(short s) {
        this.mp1 &= 0xFFFF;
        this.mp1 |= (s & 0xFFFF) << 16;
    }

    short getMp1MiddleShort() {
        return (short)(this.mp1 >> 8 & 0xFFFF);
    }

    void setMp1MiddleShort(short s) {
        this.mp1 &= 0xFF0000FF;
        this.mp1 |= (s & 0xFFFF) << 8;
    }

    public short getMp1BottomShort() {
        return (short)(this.mp1 & 0xFFFF);
    }

    void setMp1BottomShort(short s) {
        this.mp1 &= 0xFFFF0000;
        this.mp1 |= s & 0xFFFF;
    }

    byte getMp2TopByte() {
        return (byte)(this.mp2 >> 24 & 0xFF);
    }

    void setMp2TopByte(byte by) {
        this.mp2 &= 0xFFFFFF;
        this.mp2 |= (by & 0xFF) << 24;
    }

    byte getMp2MiddleTopByte() {
        return (byte)(this.mp2 >> 16 & 0xFF);
    }

    void setMp2MiddleTopByte(byte by) {
        this.mp2 &= 0xFF00FFFF;
        this.mp2 |= (by & 0xFF) << 16;
    }

    byte getMp2MiddleBottomByte() {
        return (byte)(this.mp2 >> 8 & 0xFF);
    }

    void setMp2MiddleBottomByte(byte by) {
        this.mp2 &= 0xFFFF00FF;
        this.mp2 |= (by & 0xFF) << 8;
    }

    byte getMp2BottomByte() {
        return (byte)(this.mp2 & 0xFF);
    }

    void setMp2BottomByte(byte by) {
        this.mp2 &= 0xFFFFFF00;
        this.mp2 |= by & 0xFF;
    }

    short getMp2TopShort() {
        return (short)(this.mp2 >> 16 & 0xFFFF);
    }

    void setMp2TopShort(short s) {
        this.mp2 &= 0xFFFF;
        this.mp2 |= (s & 0xFFFF) << 16;
    }

    short getMp2MiddleShort() {
        return (short)(this.mp2 >> 8 & 0xFFFF);
    }

    void setMp2MiddleShort(short s) {
        this.mp2 &= 0xFF0000FF;
        this.mp2 |= (s & 0xFFFF) << 8;
    }

    short getMp2BottomShort() {
        return (short)(this.mp2 & 0xFFFF);
    }

    void setMp2BottomShort(short s) {
        this.mp2 &= 0xFFFF0000;
        this.mp2 |= s & 0xFFFF;
    }
}

