/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.AbstractLogger;
import com.ibm.jpos.util.DefaultLogEntry;
import com.ibm.jpos.util.LogStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class JDKLogStore
implements LogStore {
    private Vector entries = null;
    private int maxEntries = 100;
    private String logPathName = "." + File.separator;
    private String logFileName = "Log";
    public static final String NEW_LINE = "\n";
    public static final String DEFAULT_LOG_FILE_NAME = "Log";
    public static final String LOG_TEXT_FILE_NAME_EXT = ".log";
    public static final String LOG_SER_FILE_NAME_EXT = ".ser";

    public JDKLogStore() {
        try {
            this.entries = this.getSerializedEntries();
        }
        catch (Exception exception) {
            this.entries = new Vector();
        }
    }

    public String getLogPathName() {
        return this.logPathName;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogPathAndFileName() {
        return this.getLogPathName() + this.getLogFileName();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setLogPathName(String string) {
        this.logPathName = string.endsWith(File.separator) ? string : string + File.separator;
    }

    public void setLogFileName(String string) {
        this.logFileName = string.lastIndexOf(".") == -1 ? string : string.substring(0, string.lastIndexOf("."));
    }

    public void setMaxEntries(int n) {
        if (n <= 0) {
            return;
        }
        if (n < this.maxEntries) {
            int n2 = 0;
            while (n2 < n - this.maxEntries) {
                this.entries.removeElementAt(n2);
                ++n2;
            }
        }
        this.maxEntries = n;
    }

    public void add(DefaultLogEntry defaultLogEntry) {
        if (this.entries.size() >= this.maxEntries) {
            this.entries.removeElementAt(0);
        }
        this.entries.addElement(defaultLogEntry);
    }

    public void flush() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.getLogPathAndFileName() + LOG_SER_FILE_NAME_EXT);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeInt(DefaultLogEntry.getIDCount());
        objectOutputStream.writeObject(this.entries);
        FileOutputStream fileOutputStream2 = new FileOutputStream(this.getLogPathAndFileName() + LOG_TEXT_FILE_NAME_EXT);
        fileOutputStream2.write((AbstractLogger.getTerminalID() + NEW_LINE).getBytes());
        int n = 0;
        while (n < this.entries.size()) {
            fileOutputStream2.write((((DefaultLogEntry)this.entries.elementAt(n)).toString() + NEW_LINE).getBytes());
            ++n;
        }
        fileOutputStream.close();
        objectOutputStream.close();
        fileOutputStream2.close();
    }

    private Vector getSerializedEntries() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.getLogPathAndFileName() + LOG_SER_FILE_NAME_EXT);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        int n = objectInputStream.readInt();
        Vector vector = (Vector)objectInputStream.readObject();
        DefaultLogEntry.setIDCount(n);
        return vector;
    }
}

