/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.ToneIndicatorServiceImp;
import com.ibm.jpos.services.ToneIndicatorServiceState;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosException;
import java.util.Vector;
import jpos.JposException;
import jpos.ToneIndicatorConst;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.services.EventCallbacks;

public class POSSToneIndicatorServiceImp
extends POSSDeviceServiceImp
implements ToneIndicatorServiceImp,
ToneIndicatorConst {
    private static final String className = "POSSToneIndicatorServiceImp";
    protected ToneIndicatorServiceState serviceState = null;
    private Object eventSource = null;
    private ToneManager toneManager;
    private int outputIDCount = 0;
    private int posNdeviceNumber = -1;
    private Object errorFlag = new Object();
    private static final int TONE_DURATION_PAD = 100;

    protected POSSToneIndicatorServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor", "Entry");
        this.serviceState = (ToneIndicatorServiceState)this.getDeviceServiceState();
        this.toneManager = new ToneManager();
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    public void setAsyncMode(boolean bl) throws JposException {
    }

    public void setInterToneWait(int n) throws JposException {
    }

    public void setTone1Duration(int n) throws JposException {
    }

    public void setTone1Pitch(int n) throws JposException {
    }

    public void setTone1Volume(int n) throws JposException {
    }

    public void setTone2Duration(int n) throws JposException {
    }

    public void setTone2Pitch(int n) throws JposException {
    }

    public void setTone2Volume(int n) throws JposException {
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        String string2;
        Tracer.trace(4, className, "open()", "Entry");
        JposEntryInfo jposEntryInfo = this.getDeviceServiceState().getJposEntryInfo();
        if (jposEntryInfo.hasPropertyWithName("posNdeviceNumber") && (string2 = (String)jposEntryInfo.getPropertyValue("posNdeviceNumber")) != null) {
            this.posNdeviceNumber = Integer.decode(string2);
        }
        super.open(string, eventCallbacks);
        this.eventSource = eventCallbacks.getEventSource();
        Tracer.trace(4, className, "open()", "Exit");
    }

    public void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        this.toneManager.stop();
        super.close();
        Tracer.trace(4, className, "close()", "Exit");
    }

    public void clearOutput() throws JposException {
        Tracer.trace(4, className, "clearOutput()", "Entry");
        this.toneManager.clear();
        Tracer.trace(4, className, "clearOutput()", "Exit");
    }

    public void sound(int n, int n2) throws JposException {
        Tracer.trace(4, className, "sound()", "Entry");
        this.enqueueSound(n, n2, this.serviceState.getAsyncMode());
        Tracer.trace(4, className, "sound()", "Exit");
    }

    public void soundImmediate() throws JposException {
        Tracer.trace(4, className, "soundImmediate()", "Entry");
        this.clearOutput();
        this.enqueueSound(1, 0, false);
        Tracer.trace(4, className, "soundImmediate()", "Exit");
    }

    protected final String getPOSSDeviceClass() {
        if (this.posNdeviceNumber == 92 || this.posNdeviceNumber == 93) {
            return "PosTouch";
        }
        if (this.posNdeviceNumber == 53) {
            return "PosPrinter";
        }
        return "PosKeyboard";
    }

    protected final boolean isCompositeDevice() {
        return this.posNdeviceNumber != 92 && this.posNdeviceNumber != 93;
    }

    protected final boolean isShareableDevice() {
        return true;
    }

    protected void enqueueSound(int n, int n2, boolean bl) throws JposException {
        Tracer.trace(4, className, "enqueueSound()", "Entry");
        if (!bl && n == -1) {
            throw new JposException(106);
        }
        SoundRequest soundRequest = new SoundRequest(n, n2, bl, this.serviceState.getTone1Duration(), this.serviceState.getTone1Pitch(), this.serviceState.getTone1Volume(), this.serviceState.getTone2Duration(), this.serviceState.getTone2Pitch(), this.serviceState.getTone2Volume(), this.serviceState.getInterToneWait());
        if (bl) {
            this.serviceState.setOutputID(soundRequest.outputID);
            this.toneManager.add(soundRequest);
        } else {
            if (this.serviceState.getState() == 3) {
                throw new JposException(113);
            }
            SoundRequest soundRequest2 = soundRequest;
            synchronized (soundRequest2) {
                this.toneManager.add(soundRequest);
                try {
                    soundRequest.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (soundRequest.errorCode != 0) {
                throw new JposException(soundRequest.errorCode);
            }
        }
        Tracer.trace(4, className, "enqueueSound()", "Exit");
    }

    private class POSSToneIndicatorErrorEvent
    implements JposEventContainer {
        private ErrorEvent errorEvent;

        public POSSToneIndicatorErrorEvent(int n) {
            this.errorEvent = new ErrorEvent(POSSToneIndicatorServiceImp.this.eventSource, n, 0, 1, 11);
        }

        public JposEvent getJposEvent() {
            return this.errorEvent;
        }

        public void prepareToFire() {
        }

        public void doneFiring() {
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "POSSToneIndicatorErrorEvent.doneFiring()", "notifying errorFlag");
            Object object = POSSToneIndicatorServiceImp.this.errorFlag;
            synchronized (object) {
                POSSToneIndicatorServiceImp.this.errorFlag.notify();
                Tracer.trace(4, POSSToneIndicatorServiceImp.className, "POSSToneIndicatorErrorEvent.doneFiring()", "notification complete");
            }
        }
    }

    private class ToneManager
    implements Runnable {
        private Vector requestQueue = new Vector();
        private Thread toneThread = new Thread(this);
        private boolean clearProcessed = false;

        private ToneManager() {
            this.toneThread.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "Entry");
            while (true) {
                SoundRequest soundRequest;
                Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "reading request queue");
                Vector vector = this.requestQueue;
                synchronized (vector) {
                    while (this.requestQueue.isEmpty()) {
                        try {
                            POSSToneIndicatorServiceImp.this.serviceState.setState(2);
                        }
                        catch (JposException jposException) {
                            // empty catch block
                        }
                        try {
                            this.requestQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    soundRequest = (SoundRequest)this.requestQueue.elementAt(0);
                    this.requestQueue.removeElementAt(0);
                }
                Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "request was read from queue");
                Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "request.errorCode == " + soundRequest.errorCode);
                if (soundRequest.errorCode == 101) {
                    Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "request.errorCode == JPOS_E_CLOSED; returning from run()");
                    return;
                }
                try {
                    POSSToneIndicatorServiceImp.this.serviceState.setState(3);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                if (soundRequest.errorCode == 0) {
                    Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "request.errorCode == JPOS_SUCCESS; processing...");
                    try {
                        this.clearProcessed = false;
                        int n = 0;
                        while (!(soundRequest.cycles != -1 && n >= soundRequest.cycles || this.clearProcessed)) {
                            this.generateTone(soundRequest.tone1Duration, soundRequest.tone1Pitch, soundRequest.tone1Volume);
                            if (soundRequest.interToneWait > 0) {
                                Thread.sleep(soundRequest.interToneWait);
                            }
                            this.generateTone(soundRequest.tone2Duration, soundRequest.tone2Pitch, soundRequest.tone2Volume);
                            if ((soundRequest.cycles == -1 || n < soundRequest.cycles - 1) && soundRequest.interSoundWait > 0) {
                                Thread.sleep(soundRequest.interSoundWait);
                            }
                            ++n;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (JposException jposException) {
                        soundRequest.errorCode = jposException.getErrorCode();
                    }
                    catch (Exception exception) {
                        Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "unexpected exception: " + exception.getMessage());
                    }
                    if (this.clearProcessed) {
                        // empty if block
                    }
                }
                if (!soundRequest.async) {
                    if (soundRequest.errorCode == 114) {
                        soundRequest.errorCode = 111;
                    }
                    Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "notifying of synchronous request completion");
                    SoundRequest soundRequest2 = soundRequest;
                    synchronized (soundRequest2) {
                        soundRequest.notify();
                    }
                    Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "notification complete");
                    continue;
                }
                if (soundRequest.errorCode == 114) continue;
                if (soundRequest.errorCode == 0) {
                    Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "posting OutputCompleteEvent");
                    if (this.clearProcessed) continue;
                    OutputCompleteEvent outputCompleteEvent = new OutputCompleteEvent(POSSToneIndicatorServiceImp.this.eventSource, soundRequest.outputID);
                    try {
                        POSSToneIndicatorServiceImp.this.getEventQueueManager().postEvent((JposEvent)outputCompleteEvent);
                    }
                    catch (JposException jposException) {}
                    continue;
                }
                POSSToneIndicatorErrorEvent pOSSToneIndicatorErrorEvent = new POSSToneIndicatorErrorEvent(soundRequest.errorCode);
                Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "synchronizing on errorFlag");
                Object object = POSSToneIndicatorServiceImp.this.errorFlag;
                synchronized (object) {
                    Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "posting ErrorEvent");
                    try {
                        POSSToneIndicatorServiceImp.this.getEventQueueManager().postEvent(pOSSToneIndicatorErrorEvent);
                    }
                    catch (JposException jposException) {
                        // empty catch block
                    }
                    try {
                        Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "waiting on errorFlag notification");
                        POSSToneIndicatorServiceImp.this.errorFlag.wait();
                        Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "wait satisfied");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                int n = ((ErrorEvent)pOSSToneIndicatorErrorEvent.getJposEvent()).getErrorResponse();
                if (n == 12) {
                    Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "errorResponse == JPOS_ER_CLEAR");
                    try {
                        POSSToneIndicatorServiceImp.this.clearOutput();
                    }
                    catch (JposException jposException) {}
                    continue;
                }
                Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.run()", "errorResponse == JPOS_ER_RETRY");
                this.addToFront(soundRequest);
            }
        }

        void stop() {
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.stop()", "Entry");
            this.clear();
            SoundRequest soundRequest = new SoundRequest(0, 0, true, 0, 0, 0, 0, 0, 0, 0);
            soundRequest.errorCode = 101;
            this.addToFront(soundRequest);
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.stop()", "Exit");
        }

        void add(SoundRequest soundRequest) {
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.add()", "Entry");
            Vector vector = this.requestQueue;
            synchronized (vector) {
                this.requestQueue.addElement(soundRequest);
                this.requestQueue.notify();
            }
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.add()", "Exit");
        }

        void addToFront(SoundRequest soundRequest) {
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.addToFront()", "Entry");
            Vector vector = this.requestQueue;
            synchronized (vector) {
                this.requestQueue.insertElementAt(soundRequest, 0);
                this.requestQueue.notify();
            }
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.addToFront()", "Exit");
        }

        void clear() {
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.clear()", "Entry");
            Vector vector = this.requestQueue;
            synchronized (vector) {
                this.requestQueue.removeAllElements();
            }
            try {
                POSSToneIndicatorServiceImp.this.serviceState.setState(2);
            }
            catch (JposException jposException) {
                // empty catch block
            }
            this.clearProcessed = true;
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.clear()", "Exit");
        }

        private void generateTone(int n, int n2, int n3) throws JposException, InterruptedException {
            int n4;
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.generateTone()", "Entry");
            if (!POSSToneIndicatorServiceImp.this.isOnline()) {
                throw new JposException(108);
            }
            int n5 = n4 = POSSToneIndicatorServiceImp.this.posNdeviceNumber == 53 ? 25400 : 25500;
            if (n2 > 0 && n3 > 0) {
                int n6 = n;
                while (n6 > 0) {
                    int n7 = n6 > n4 ? n4 : n6;
                    int n8 = this.calcDuration(n7);
                    PosArg[] posArgArray = new PosArg[3];
                    try {
                        if (POSSToneIndicatorServiceImp.this.posNdeviceNumber == 92 || POSSToneIndicatorServiceImp.this.posNdeviceNumber == 93) {
                            posArgArray[0] = new PosArg("touchToneDuration", n8);
                            posArgArray[1] = new PosArg("touchToneFreq", this.calcFreq(n2));
                            posArgArray[2] = new PosArg("touchToneVolume", this.calcVolume(n3));
                            if (!POSSToneIndicatorServiceImp.this.isOnline()) {
                                throw new JposException(108);
                            }
                            POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(305, posArgArray);
                            if (!POSSToneIndicatorServiceImp.this.isOnline()) {
                                throw new JposException(108);
                            }
                            POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(6702);
                        } else if (POSSToneIndicatorServiceImp.this.posNdeviceNumber == 53) {
                            posArgArray[0] = new PosArg("printToneDuration", this.calcDurationSST(n7));
                            posArgArray[1] = new PosArg("printToneFrequency", this.calcFreqSST(n2));
                            posArgArray[2] = new PosArg("toneVolume", this.calcVolumeSST(n3));
                            if (!POSSToneIndicatorServiceImp.this.isOnline()) {
                                throw new JposException(108);
                            }
                            POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(305, posArgArray);
                            if (!POSSToneIndicatorServiceImp.this.isOnline()) {
                                throw new JposException(108);
                            }
                            POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(4914);
                        } else {
                            posArgArray[0] = new PosArg("toneDuration", n8);
                            posArgArray[1] = new PosArg("toneFreq", this.calcFreq(n2));
                            posArgArray[2] = new PosArg("toneVolume", this.calcVolume(n3));
                            if (!POSSToneIndicatorServiceImp.this.isOnline()) {
                                throw new JposException(108);
                            }
                            POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(305, posArgArray);
                            if (!POSSToneIndicatorServiceImp.this.isOnline()) {
                                throw new JposException(108);
                            }
                            POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(4705);
                            Thread.sleep(100L);
                        }
                    }
                    catch (PosException posException) {
                        if (posException.getErrorCode() == 317) {
                            throw new JposException(108, posException.getMessage(), (Exception)posException);
                        }
                        throw new JposException(111, posException.getMessage(), (Exception)posException);
                    }
                    Thread.sleep(n8 * 100 + 100);
                    n6 -= n4;
                }
            } else {
                Thread.sleep(n);
            }
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.generateTone()", "Exit");
        }

        private void stopTone() {
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.stopTone()", "Entry");
            try {
                if (POSSToneIndicatorServiceImp.this.posNdeviceNumber == 92 || POSSToneIndicatorServiceImp.this.posNdeviceNumber == 93) {
                    POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(6701);
                } else if (POSSToneIndicatorServiceImp.this.posNdeviceNumber == 53) {
                    POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(4915);
                } else {
                    POSSToneIndicatorServiceImp.this.getPosDevice().ioctl(4704);
                }
            }
            catch (PosException posException) {
                // empty catch block
            }
            Tracer.trace(4, POSSToneIndicatorServiceImp.className, "ToneManager.stopTone()", "Exit");
        }

        private int calcDuration(int n) {
            return n < 200 ? 2 : n / 100;
        }

        private int calcDurationSST(int n) {
            return n < 100 ? 1 : n / 100;
        }

        private int calcFreq(int n) {
            if (n < 1088) {
                return 1;
            }
            if (n < 1650) {
                return 2;
            }
            return 3;
        }

        private int calcFreqSST(int n) {
            int n2 = n;
            if (n < 261) {
                n2 = 261;
            } else if (n > 3953) {
                n2 = 3953;
            }
            return n2;
        }

        private int calcVolume(int n) {
            return n < 50 ? 1 : 3;
        }

        private int calcVolumeSST(int n) {
            return n < 50 ? 0 : 1;
        }
    }

    private class SoundRequest {
        int cycles;
        int interSoundWait;
        boolean async;
        int tone1Duration;
        int tone1Pitch;
        int tone1Volume;
        int tone2Duration;
        int tone2Pitch;
        int tone2Volume;
        int interToneWait;
        int outputID;
        int errorCode = 0;

        private SoundRequest(int n, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            this.cycles = n;
            this.interSoundWait = n2;
            this.async = bl;
            this.tone1Duration = n3;
            this.tone1Pitch = n4;
            this.tone1Volume = n5;
            this.tone2Duration = n6;
            this.tone2Pitch = n7;
            this.tone2Volume = n8;
            this.interToneWait = n9;
            this.outputID = ++POSSToneIndicatorServiceImp.this.outputIDCount;
        }
    }
}

