/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.ScaleServiceImp;
import com.ibm.jpos.services.ScaleServiceState;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.util.Debug;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Errno;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import com.ibm.poss.PosScaleData;
import com.ibm.poss.Scale;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public abstract class POSSScaleServiceImp
extends POSSDeviceServiceImp
implements ScaleServiceImp,
Errno,
PosDef,
Scale {
    private Exception posReadException = null;
    protected int posReadLen = -1;
    ScaleReader posReadThread = new ScaleReader();
    private int sleepRead = 1000;
    private PosScaleData scdata = new PosScaleData();
    private Debug debug = new Debug(false);
    private int errorNo = 0;
    private Object eventSource;
    private WaitObject[] wObj = new WaitObject[2];
    protected boolean aMode = false;
    private AsyncThread athread = new AsyncThread();
    private static final String className = "POSSScaleServiceImp";

    protected POSSScaleServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Object object;
        JposEntryInfo jposEntryInfo = this.getDeviceServiceState().getJposEntryInfo();
        super.open(string, eventCallbacks);
        this.eventSource = eventCallbacks.getEventSource();
        int n = 0;
        if (System.getProperty("debugScale") != null) {
            this.debug.on();
        }
        if (jposEntryInfo.hasPropertyWithName("posNweightMode") && (object = (String)jposEntryInfo.getPropertyValue("posNweightMode")) != null) {
            n = Integer.decode((String)object);
        }
        if (this.wObj[0] == null) {
            this.wObj[0] = new WaitObject("ASYNC");
            this.wObj[1] = new WaitObject("REG");
        }
        object = (ScaleServiceState)this.getDeviceServiceState();
        switch (n) {
            case 3: {
                ((ScaleServiceState)object).setWeightUnit(1);
                break;
            }
            case 1: {
                ((ScaleServiceState)object).setWeightUnit(2);
                break;
            }
            case 2: {
                ((ScaleServiceState)object).setWeightUnit(3);
                break;
            }
            case 0: {
                ((ScaleServiceState)object).setWeightUnit(4);
            }
        }
    }

    protected String getPOSSDeviceClass() {
        return "PosScale";
    }

    public void clearInput() throws JposException {
        this.athread.aStop();
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setAsyncMode(boolean bl) throws JposException {
        if (this.posReadThread != null) {
            this.aMode = bl;
        }
    }

    public void setTareWeight(int n) throws JposException {
    }

    public void setUnitPrice(long l) throws JposException {
    }

    protected void setWeightUnit() throws JposException {
        ScaleServiceState scaleServiceState = (ScaleServiceState)this.getDeviceServiceState();
        PosArg[] posArgArray = new PosArg[1];
        int n = 0;
        int n2 = scaleServiceState.getWeightUnit();
        posArgArray[0] = new PosArg("weightMode", 0);
        try {
            this.getPosDevice().ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            n = -1;
        }
        n = n == 0 ? (Integer)posArgArray[0].getValue() : n2;
        scaleServiceState.setWeightUnit(n);
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        if (bl) {
            if (this.posReadThread.started) {
                this.posReadThread.unpause();
            } else {
                this.startThread();
            }
        } else if (this.posReadThread != null) {
            this.posReadThread.pause();
        }
    }

    public void zeroScale() throws JposException {
        try {
            this.getPosDevice().ioctl(6101);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readWeight(int[] nArray, int n) throws JposException {
        if (this.athread.isRunning() && nArray != null) {
            if (this.aMode) {
                throw new JposException(106);
            }
            try {
                Tracer.trace(4, className, "readWeight", "1st wait " + String.valueOf(n));
                WaitObject waitObject = this.wObj[1];
                synchronized (waitObject) {
                    this.wObj[1].doWait(n);
                    Tracer.trace(4, className, "readWeight", "1st wait leaving doWait ");
                    if (!this.wObj[1].notified()) {
                        this.thrower(0, true);
                    }
                    n = this.wObj[1].getTimeLeft();
                }
            }
            catch (InterruptedException interruptedException) {
                Tracer.trace(4, className, "Readweight", "wait() exception 1");
            }
        }
        if (nArray == null) {
            this.athread.weight[0] = 0;
        } else {
            nArray[0] = 0;
        }
        if (!this.athread.isRunning()) {
            this.posReadException = null;
            this.posReadLen = 0;
            if (this.aMode) {
                if (this.errorNo != 0) {
                    this.thrower(0, false);
                }
                Tracer.trace(4, className, "readWeight", "Async Read");
                this.athread.aStart(n);
                return;
            }
        }
        this.posReadThread.setData();
        int n2 = nArray == null ? 0 : 1;
        WaitObject waitObject = this.wObj[n2];
        synchronized (waitObject) {
            this.wObj[n2].reset();
            try {
                Tracer.trace(4, className, "readWeight", "2nd wait " + String.valueOf(n));
                this.wObj[n2].doWait(n);
                if (!this.wObj[n2].notified()) {
                    this.thrower(0, true);
                }
            }
            catch (InterruptedException interruptedException) {
                Tracer.trace(4, className, "Readweight", "wait() exception 2");
            }
        }
        this.posReadThread.pause();
        if (nArray == null) {
            Tracer.trace(4, className, "readWeight", "ASYNC do notify");
            WaitObject waitObject2 = this.wObj[1];
            synchronized (waitObject2) {
                this.wObj[1].doNotify();
            }
            Thread.yield();
            this.athread.weight[0] = this.processRead(!this.wObj[0].notified());
        } else {
            nArray[0] = this.processRead(!this.wObj[1].notified());
        }
        this.wObj[n2].reset();
        this.posReadThread.unpause();
    }

    protected void startThread() {
        this.posReadThread.start();
    }

    private void thrower(int n, boolean bl) throws JposException {
        Tracer.trace(4, className, "thrower()", "flags timerExpired errorNo " + String.valueOf(n) + " " + String.valueOf(bl) + " " + String.valueOf(this.errorNo));
        if (n > 0) {
            switch (n == 1 ? 1 : n - 1) {
                case 1: {
                    throw new JposException(111, "POS_SCALE_IN_MOTION");
                }
                case 2: {
                    throw new JposException(111, "POS_SCALE_UNDER_ZERO");
                }
                case 4: {
                    throw new JposException(114, 201);
                }
                case 8: {
                    throw new JposException(111, "POS_SCALE_REQUIRES_ZEROING");
                }
                case 10: {
                    throw new JposException(111, "POS_SCALE_NOT_READY");
                }
                case 20: {
                    throw new JposException(111, "POS_SCALE_DUPLICATE_WEIGHT");
                }
                case 40: {
                    throw new JposException(111, "POS_SCALE_HW_ERROR");
                }
            }
            throw new JposException(111, n);
        }
        if (bl) {
            throw new JposException(112, "Timer expired");
        }
        if (this.errorNo <= 0) {
            return;
        }
        int n2 = this.errorNo;
        this.errorNo = 0;
        switch (n2) {
            case 6200: {
                throw new JposException(106);
            }
            case 6201: {
                throw new JposException(111, "POSERR_SCALE_INVALID_OPERATIONS_MODE");
            }
            case 6202: {
                throw new JposException(111, "POSERR_SCALE_INVALID_REMOTE_DISPLAY_STATE");
            }
            case 6203: {
                throw new JposException(111, "POSERR_SCALE_INVALID_VIBRATION_FILTER");
            }
            case 6204: {
                throw new JposException(111, "POSERR_SCALE_INVALID_WEIGHT_MODE");
            }
            case 6205: {
                throw new JposException(111, "POSERR_SCALE_INVALID_ZERO_INDICATOR_STATE");
            }
            case 6206: {
                throw new JposException(111, "POSERR_SCALE_INVALID_ZERO_RETURN_STATE");
            }
            case 6207: {
                throw new JposException(111, "POSERR_SCALE_ZERO_SCALE_FAILED");
            }
            case 6208: {
                throw new JposException(111, "POSERR_SCALE_INVALID_CLEAR_SCREEN_REQUEST");
            }
            case 6209: {
                throw new JposException(111, "POSERR_SCALE_CONFIGURATION_ERROR");
            }
            case 6210: {
                throw new JposException(111, "POSERR_SCALE_MSG_LENGTH_ERROR");
            }
            case 317: {
                throw new JposException(108);
            }
        }
        throw new JposException(111);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int processRead(boolean bl) throws JposException {
        Tracer.trace(4, className, "processRead()", "Entry");
        if (this.posReadLen <= 0) {
            this.thrower(-22, bl);
            return 0;
        }
        short s = this.scdata.getFlags();
        if (s >= 1) {
            this.thrower(s, false);
            return 0;
        }
        ScaleServiceState scaleServiceState = (ScaleServiceState)this.getDeviceServiceState();
        if (scaleServiceState.getWeightUnit() != 4) return this.scdata.getWtVal();
        return this.scdata.getWtVal() * 10;
    }

    class ScaleError
    implements JposEventContainer {
        ErrorEvent jpe;
        int stime;

        ScaleError(int n, int n2, int n3, int n4, int n5) {
            this.stime = n5;
            this.jpe = new ErrorEvent(POSSScaleServiceImp.this.eventSource, n, n2, n3, n4);
        }

        public void prepareToFire() {
        }

        public void doneFiring() {
            switch (this.jpe.getErrorResponse()) {
                case 11: {
                    boolean bl = POSSScaleServiceImp.this.aMode;
                    int[] nArray = new int[1];
                    try {
                        POSSScaleServiceImp.this.setAsyncMode(true);
                        POSSScaleServiceImp.this.readWeight(nArray, this.stime);
                        POSSScaleServiceImp.this.setAsyncMode(bl);
                    }
                    catch (JposException jposException) {
                        ScaleError scaleError = new ScaleError(jposException.getErrorCode(), jposException.getErrorCodeExtended(), 2, 12, this.stime);
                        Tracer.trace(4, POSSScaleServiceImp.className, "doneFiring", "Queueing up an ERROR ");
                        try {
                            POSSScaleServiceImp.this.getEventQueueManager().postEvent(scaleError);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case 13: {
                    if (this.jpe.getErrorLocus() != 2) break;
                    try {
                        POSSScaleServiceImp.this.clearInput();
                        POSSScaleServiceImp.this.getDeviceServiceState().setState(2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 12: {
                    try {
                        POSSScaleServiceImp.this.clearInput();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public JposEvent getJposEvent() {
            return this.jpe;
        }
    }

    protected class ScaleReader
    extends Thread {
        boolean started = false;
        private boolean inprocess = false;
        private Object tPause = new Object();
        private boolean froze = false;

        protected ScaleReader() {
        }

        public synchronized void start() {
            this.started = true;
            super.start();
        }

        public void pause() {
            this.froze = true;
        }

        public void unpause() {
            this.froze = false;
            Object object = this.tPause;
            synchronized (object) {
                this.tPause.notify();
            }
        }

        public void run() {
            int n = 0;
            while (true) {
                block16: {
                    try {
                        if (this.froze) {
                            try {
                                this.tPause.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        n = POSSScaleServiceImp.this.getPosDevice().read(POSSScaleServiceImp.this.scdata);
                        POSSScaleServiceImp.this.errorNo = 0;
                        if (n > 0 && this.inprocess) {
                            if (POSSScaleServiceImp.this.scdata.getFlags() == 1) {
                                n = -1;
                            } else if (POSSScaleServiceImp.this.scdata.getWtVal() == 0 && POSSScaleServiceImp.this.scdata.getFlags() <= 0) {
                                n = -1;
                            } else {
                                this.prepGoodRead(n);
                            }
                        }
                    }
                    catch (PosException posException) {
                        WaitObject waitObject;
                        POSSScaleServiceImp.this.errorNo = posException.getErrorCode();
                        if (!this.inprocess) break block16;
                        POSSScaleServiceImp.this.posReadException = posException;
                        this.inprocess = false;
                        Tracer.trace(4, POSSScaleServiceImp.className, "run", "Exception built in run  about to Notify " + posException.toString());
                        WaitObject waitObject2 = waitObject = POSSScaleServiceImp.this.athread.isRunning() ? POSSScaleServiceImp.this.wObj[0] : POSSScaleServiceImp.this.wObj[1];
                        synchronized (waitObject2) {
                            waitObject.doNotify();
                        }
                    }
                }
                try {
                    Thread.sleep(POSSScaleServiceImp.this.sleepRead);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                POSSScaleServiceImp.this.posReadLen = 0;
                POSSScaleServiceImp.this.posReadException = null;
            }
        }

        private void prepGoodRead(int n) {
            this.inprocess = false;
            POSSScaleServiceImp.this.posReadLen = n;
            Tracer.trace(4, POSSScaleServiceImp.className, "prepGood read", "about to Notify");
            WaitObject waitObject = POSSScaleServiceImp.this.athread.isRunning() ? POSSScaleServiceImp.this.wObj[0] : POSSScaleServiceImp.this.wObj[1];
            synchronized (waitObject) {
                (POSSScaleServiceImp.this.athread.isRunning() ? POSSScaleServiceImp.this.wObj[0] : POSSScaleServiceImp.this.wObj[1]).doNotify();
            }
        }

        public boolean inProcess() {
            return this.inprocess;
        }

        public void stopProcess() {
            this.inprocess = false;
        }

        public void setData() {
            this.inprocess = true;
        }
    }

    private class AsyncThread
    extends Thread {
        int[] weight = new int[1];
        int timeout;
        boolean running = false;
        Object waiter = new Object();
        boolean qIt = true;

        AsyncThread() {
            this.start();
        }

        void aStart(int n) {
            this.timeout = n;
            this.qIt = true;
            try {
                Object object = this.waiter;
                synchronized (object) {
                    this.waiter.notify();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void aStop() {
            POSSScaleServiceImp.this.posReadThread.stopProcess();
            this.qIt = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void run() {
            while (true) {
                block14: {
                    try {
                        Object object = this.waiter;
                        synchronized (object) {
                            this.waiter.wait();
                        }
                        this.running = true;
                        POSSScaleServiceImp.this.readWeight(null, this.timeout);
                        try {
                            if (this.qIt) {
                                Tracer.trace(4, POSSScaleServiceImp.className, "run", "Queueing up an event");
                                POSSScaleServiceImp.this.getEventQueueManager().postEvent((JposEvent)new DataEvent(POSSScaleServiceImp.this.eventSource, this.weight[0]));
                                if (((ScaleServiceState)POSSScaleServiceImp.this.getDeviceServiceState()).getAutoDisable()) {
                                    ((ScaleServiceState)POSSScaleServiceImp.this.getDeviceServiceState()).setDeviceEnabled(false);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (POSSScaleServiceImp.this.debug.isOn()) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (JposException jposException) {
                        block15: {
                            if (!this.qIt) break block14;
                            ScaleError scaleError = new ScaleError(jposException.getErrorCode(), jposException.getErrorCodeExtended(), 2, 12, this.timeout);
                            Tracer.trace(4, POSSScaleServiceImp.className, "run", "Queueing up an ERROR " + jposException.toString());
                            try {
                                POSSScaleServiceImp.this.getEventQueueManager().postEvent(scaleError);
                            }
                            catch (Exception exception) {
                                if (!POSSScaleServiceImp.this.debug.isOn()) break block15;
                                exception.printStackTrace();
                            }
                        }
                        if (!((ScaleServiceState)POSSScaleServiceImp.this.getDeviceServiceState()).getAutoDisable()) break block14;
                        ((ScaleServiceState)POSSScaleServiceImp.this.getDeviceServiceState()).setDeviceEnabled(false);
                    }
                }
                POSSScaleServiceImp.this.posReadException = null;
                POSSScaleServiceImp.this.posReadLen = 0;
                this.running = false;
            }
        }
    }

    private class WaitObject {
        private boolean wasNotified = false;
        private boolean waiting = false;
        private int timeleft = -1;
        private String tostring = null;

        WaitObject(String string) {
            this.tostring = string;
        }

        WaitObject() {
        }

        public String toString() {
            if (this.tostring != null) {
                return this.tostring;
            }
            return super.toString();
        }

        public void reset() {
            this.wasNotified = false;
            this.timeleft = -1;
        }

        public void doWait(int n) throws InterruptedException {
            this.waiting = true;
            long l = System.currentTimeMillis();
            if (n != -1) {
                super.wait(n > 0 ? (long)n : 1L);
                this.timeleft = (int)(System.currentTimeMillis() - l);
            } else {
                super.wait();
                this.timeleft = n;
            }
            if (this.timeleft > n) {
                this.timeleft = 0;
            }
        }

        public int getTimeLeft() {
            return this.timeleft;
        }

        public void doNotify() throws IllegalMonitorStateException {
            super.notifyAll();
            this.waiting = false;
            this.wasNotified = true;
            Tracer.trace(4, POSSScaleServiceImp.className, "doNotify", this.toString() + " notified ");
        }

        public boolean notified() {
            return this.wasNotified;
        }

        public boolean isWaiting() {
            return this.waiting;
        }
    }
}

