/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOData;
import com.ibm.jpos.services.ibmprinter.FiscalPrinterImp;
import com.ibm.jpos.services.ibmprinter.FiscalPrinterInformation;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.poss.POSPrinter3FPOSSPrintDataCompiler;
import com.ibm.jpos.services.poss.POSPrinter4Imp;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import com.ibm.poss.PosmPrnDataAvailListener;
import com.ibm.poss.PosmPrnFiscalErrorListener;
import com.ibm.poss.PosmPrnFiscalStatusListener;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.events.DirectIOEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public class POSPrinter3FImp
extends POSPrinter4Imp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst,
FiscalPrinterImp {
    private static final String className = "POSPrinter3FImp";
    private POSPrinter3FPOSSPrintDataCompiler printDataCompiler = null;
    POSFiscalPrinterListener fiscalPrinterListener = new POSFiscalPrinterListener();

    protected POSPrinter3FImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor()", "Entry");
        this.posDevice.setPosmPrnDataAvailListener(this.fiscalPrinterListener);
        this.posDevice.setPosmPrnFiscalErrorListener(this.fiscalPrinterListener);
        this.posDevice.setPosmPrnFiscalStatusListener(this.fiscalPrinterListener);
        Tracer.trace(4, className, "Constructor()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        this.printDataCompiler = new POSPrinter3FPOSSPrintDataCompiler((POSPrinterServiceState)this.getDeviceServiceState());
        Tracer.trace(4, className, "open()", "Exit");
    }

    public void claim(int n) throws JposException {
        Tracer.trace(4, className, "claim(" + n + ")", "Entry");
        super.claim(n);
        PosArg[] posArgArray = new PosArg[]{new PosArg("fiscalNotify", 1), new PosArg("printMode", 1)};
        try {
            this.posDevice.ioctl(305, posArgArray);
            this.posDevice.ioctl(4907);
        }
        catch (PosException posException) {
            // empty catch block
        }
        Tracer.trace(4, className, "claim()", "Exit");
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled()", "Entry");
        try {
            if (bl) {
                if (!this.isAcquired()) {
                    this.posDevice.ioctl(301);
                }
                this.posDevice.ioctl(306);
                this.posNprintStatus = 0;
                this.selectedStations = 2;
                this.printerErrorCause = 0;
                this.serviceState.setSlpEmpty(true);
                this.queryPrinterStatus(true);
                this.setCharacterSet(this.serviceState.getCharacterSet());
                this.setJrnLineSpacing(this.serviceState.getJrnLineSpacing());
                this.getPrintingMode(1).setPosNlineFeed(this.calculatePosNlineFeedSJ());
                this.setRecLineSpacing(this.serviceState.getRecLineSpacing());
                this.getPrintingMode(2).setPosNlineFeed(this.calculatePosNlineFeedCR());
                this.setSlpLineSpacing(this.serviceState.getSlpLineSpacing());
                this.getPrintingMode(4).setPosNlineFeed(this.calculatePosNlineFeedDI());
            } else if (this.serviceState.getDeviceEnabled()) {
                this.posDevice.ioctl(303);
                if (!this.serviceState.getClaimed()) {
                    this.posDevice.ioctl(304);
                }
            }
        }
        catch (PosException posException) {
            switch (posException.getErrorCode()) {
                case 307: 
                case 317: 
                case 326: 
                case 328: {
                    throw new JposException(108, posException.getMessage(), (Exception)posException);
                }
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        catch (Exception exception) {
            throw new JposException(111, "JPOS_E_FAILURE", exception);
        }
        Tracer.trace(4, className, "setDeviceEnabled()", "Entry");
    }

    protected PrintDataCompiler getPrintDataCompiler() {
        return this.printDataCompiler;
    }

    void doDirectIOPrintDownloadedBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
        throw new JposException(106);
    }

    public void processPrintBarCode(PrintBarCodeData printBarCodeData) throws JposException {
        throw new JposException(111);
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace(4, className, "getPrinterFonts()", "Entry");
        PrinterFont[] printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 380, 1, 0, 12), new PrinterFont(2, 30, 300, 2, 0, 12), new PrinterFont(1, 38, 380, 1, 0, 12), new PrinterFont(1, 30, 300, 2, 0, 12), new PrinterFont(4, 86, 860, 1, 0, 12), new PrinterFont(4, 68, 680, 2, 0, 12), new PrinterFont(4, 38, 380, 1, 1, 12), new PrinterFont(4, 30, 300, 2, 1, 12)};
        Tracer.trace(4, className, "getPrinterFonts()", "Exit");
        return printerFontArray;
    }

    public int getMicronsPerStep(int n) {
        return 353;
    }

    public int getDotsPerInchHigh(int n) {
        return 72;
    }

    public int getDotsPerInchWide(int n) throws JposException {
        return 150;
    }

    public int getMaxBytesPerWrite(int n) throws JposException {
        switch (n) {
            case 4: {
                return 880;
            }
        }
        return 380;
    }

    public int getWriteBufferSize() {
        return 1000;
    }

    public int getMaxSetBitmapSize(int n) throws JposException {
        return 0;
    }

    public int getMaxPrintBitmapSize() throws JposException {
        return this.getWriteBufferSize();
    }

    public boolean requiresLinefeed(int n) {
        return false;
    }

    public void checkMode(int n, int n2) throws JposException {
        if (n2 != 1) {
            throw new JposException(106);
        }
    }

    public int getStationMaxBitmapHeight(int n) {
        return 0;
    }

    public short getNextByteForStation(int n, PrintBitmapImageInfo printBitmapImageInfo) {
        return 0;
    }

    public byte[] getBitmapHeader(int n, int n2) {
        return null;
    }

    public void processDirectIO(DirectIOData directIOData) throws JposException {
        Tracer.trace(4, className, "processDirectIO()", "Entry");
        if (directIOData.getCommand() != 19) {
            super.processDirectIO(directIOData);
            return;
        }
        int[] nArray = directIOData.getData();
        if (nArray.length != 1 || directIOData.getObject() == null) {
            throw new JposException(106);
        }
        switch (nArray[0]) {
            case 1: {
                this.fiscalWrite((byte[])directIOData.getObject());
                try {
                    this.posDevice.ioctl(4903);
                }
                catch (PosException posException) {}
                break;
            }
            case 2: {
                this.fiscalRead((byte[])directIOData.getObject());
                break;
            }
            case 3: {
                this.getFiscalPrinterInformation((FiscalPrinterInformation)directIOData.getObject());
                break;
            }
            case 4: {
                this.setFiscalNotify((Integer)directIOData.getObject());
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        Tracer.trace(4, className, "processDirectIO()", "Exit");
    }

    public void fiscalWrite(byte[] byArray) throws JposException {
        Tracer.trace(4, className, "fiscalWrite()", "Entry");
        this.setFiscalMode(true);
        if (byArray == null) {
            throw new JposException(106);
        }
        try {
            this.posDevice.write(byArray);
        }
        catch (PosException posException) {
            throw new JposException(111, "", (Exception)posException);
        }
        this.setFiscalMode(false);
        Tracer.trace(4, className, "fiscalWrite()", "Exit");
    }

    public void fiscalRead(byte[] byArray) throws JposException {
        Tracer.trace(4, className, "fiscalRead()", "Entry");
        this.setFiscalMode(true);
        if (byArray == null) {
            throw new JposException(106);
        }
        try {
            this.posDevice.read(byArray);
        }
        catch (PosException posException) {
            throw new JposException(111, "", (Exception)posException);
        }
        this.setFiscalMode(false);
        Tracer.trace(4, className, "fiscalRead()", "Exit");
    }

    private void setFiscalMode(boolean bl) throws JposException {
        PosArg[] posArgArray = new PosArg[1];
        boolean bl2 = this.useChase;
        if (bl) {
            posArgArray[0] = new PosArg("printMode", 4);
            this.useChase = false;
        } else {
            posArgArray[0] = new PosArg("printMode", 1);
        }
        try {
            this.posDevice.ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            throw new JposException(111, "", (Exception)posException);
        }
        this.useChase = bl2;
    }

    public void getFiscalPrinterInformation(FiscalPrinterInformation fiscalPrinterInformation) throws JposException {
        Tracer.trace(4, className, "getFiscalPrinterInformation()", "Entry");
        PosArg[] posArgArray = new PosArg[]{new PosArg("fiscalCountry", 0), new PosArg("fiscalPLDStatus", 0), new PosArg("fiscalVersion", 0)};
        try {
            this.posDevice.ioctl(302, posArgArray);
        }
        catch (PosException posException) {
            // empty catch block
        }
        fiscalPrinterInformation.setFiscalCountry((Integer)posArgArray[0].getValue());
        fiscalPrinterInformation.setFiscalPowerInterrupted((Integer)posArgArray[1].getValue() == 1);
        fiscalPrinterInformation.setFiscalVersion((Integer)posArgArray[2].getValue());
        Tracer.trace(4, className, "getFiscalPrinterInformation()", "Exit");
    }

    public void setFiscalNotify(Integer n) throws JposException {
        Tracer.trace(4, className, "setFiscalNotify()", "Entry");
        PosArg[] posArgArray = new PosArg[]{new PosArg("fiscalNotify", n)};
        try {
            this.posDevice.ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            // empty catch block
        }
        Tracer.trace(4, className, "setFiscalNotify()", "Exit");
    }

    public void beginInsertion(int n) throws JposException {
        throw new JposException(106);
    }

    public void beginRemoval(int n) throws JposException {
        throw new JposException(106);
    }

    public void clearOutput() throws JposException {
        throw new JposException(106);
    }

    public void cutPaper(int n) throws JposException {
        throw new JposException(106);
    }

    public void endInsertion() throws JposException {
        throw new JposException(106);
    }

    public void endRemoval() throws JposException {
        throw new JposException(106);
    }

    public void printBitmap(int n, String string, int n2, int n3) throws JposException {
        throw new JposException(106);
    }

    public void printImmediate(int n, String string) throws JposException {
        throw new JposException(106);
    }

    public void printNormal(int n, String string) throws JposException {
        throw new JposException(106);
    }

    public void printTwoNormal(int n, String string, String string2) throws JposException {
        throw new JposException(106);
    }

    public void rotatePrint(int n, int n2) throws JposException {
        throw new JposException(106);
    }

    public void setBitmap(int n, int n2, String string, int n3, int n4) throws JposException {
        throw new JposException(106);
    }

    public void setLogo(int n, String string) throws JposException {
        throw new JposException(106);
    }

    public void transactionPrint(int n, int n2) throws JposException {
        throw new JposException(106);
    }

    public void validateData(int n, String string) throws JposException {
        throw new JposException(111);
    }

    private class POSFiscalPrinterListener
    implements PosmPrnDataAvailListener,
    PosmPrnFiscalErrorListener,
    PosmPrnFiscalStatusListener {
        private POSFiscalPrinterListener() {
        }

        public void posmPrnDataAvail(short s, short s2) {
            Tracer.trace(4, POSPrinter3FImp.className, "posmPrnDataAvail(" + Integer.toHexString(s2) + ")", "Entry");
            Integer n = new Integer(s2);
            DirectIOEvent directIOEvent = new DirectIOEvent(POSPrinter3FImp.this.eventSource, 23, 0, (Object)n);
            try {
                POSPrinter3FImp.this.getEventQueueManager().postEvent((JposEvent)directIOEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Tracer.trace(4, POSPrinter3FImp.className, "posmPrnDataAvail()", "Exit");
        }

        public void posmPrnFiscalStatus(int n) {
            Tracer.trace(4, POSPrinter3FImp.className, "posmPrnFiscalStatus(" + Integer.toHexString(n) + ")", "Entry");
            Integer n2 = new Integer(n);
            DirectIOEvent directIOEvent = new DirectIOEvent(POSPrinter3FImp.this.eventSource, 22, 0, (Object)n2);
            try {
                POSPrinter3FImp.this.getEventQueueManager().postEvent((JposEvent)directIOEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Tracer.trace(4, POSPrinter3FImp.className, "posmPrnFiscalStatus()", "Exit");
        }

        public void posmPrnFiscalError(short s, int n) {
            Tracer.trace(4, POSPrinter3FImp.className, "posmPrnFiscalError(" + Integer.toHexString(s) + ", " + Integer.toHexString(n) + ")", "Entry");
            POSPrinter3FImp.this.printerErrorCause = s;
            Integer n2 = new Integer(n);
            DirectIOEvent directIOEvent = new DirectIOEvent(POSPrinter3FImp.this.eventSource, 21, (int)s, (Object)n2);
            try {
                POSPrinter3FImp.this.getEventQueueManager().postEvent((JposEvent)directIOEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Tracer.trace(4, POSPrinter3FImp.className, "posmPrnFiscalError()", "Exit");
        }
    }
}

