/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.CashDrawerServiceImp;
import com.ibm.jpos.services.CashDrawerServiceState;
import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.jcomm.Serial4610DeviceServiceImp;
import com.ibm.jpos.services.jcomm.Serial4610ImpFactory;
import com.ibm.jpos.services.jcomm.Serial4610TillClosedListener;
import com.ibm.jpos.services.jcomm.Serial4610TillOpenedListener;
import java.awt.Toolkit;
import java.util.TooManyListenersException;
import jpos.JposException;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;

public abstract class Serial4610CashDrawerServiceImp
extends Serial4610DeviceServiceImp
implements CashDrawerServiceImp {
    public static final int DEFAULT_OPEN_DRAWER_WAIT_TIME = 300;
    public static final int DEFAULT_CLAIM_TIMEOUT = 250;
    public static final int DEFAULT_WAIT_DRAWER_CLOSE_WAIT_TIME = 300;

    protected Serial4610CashDrawerServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        try {
            this.getSerial4610Device().addSerial4610TillClosedListener(new Serial4610TillClosedListenerImpl());
            this.getSerial4610Device().addSerial4610TillOpenedListener(new Serial4610TillOpenedListenerImpl());
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new JposException(111, "Internal error: caught TooManyListenersException", (Exception)tooManyListenersException);
        }
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        this.getSerial4610Device().removeSerial4610TillClosedListener();
        this.getSerial4610Device().removeSerial4610TillOpenedListener();
    }

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        return Serial4610ImpFactory.createImp(deviceServiceAbstraction);
    }

    synchronized void serial4610TillClosedOccurred() {
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        cashDrawerServiceState.setDrawerOpened(false);
        try {
            StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 0);
            this.getDeviceServiceAbstraction().getEventQueueManager().postEvent((JposEvent)statusUpdateEvent);
        }
        catch (JposException jposException) {
            jposException.printStackTrace();
        }
    }

    synchronized void serial4610TillOpenedOccurred() {
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        cashDrawerServiceState.setDrawerOpened(true);
        try {
            StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 1);
            this.getDeviceServiceAbstraction().getEventQueueManager().postEvent((JposEvent)statusUpdateEvent);
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        if (bl) {
            this.initStatus();
        }
    }

    public void openDrawer() throws JposException {
        this.getSerial4610Device().openTill();
        try {
            Thread.currentThread();
            Thread.sleep(this.getOpenDrawerWaitTime());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitForDrawerClose(int n, int n2, int n3, int n4) throws JposException {
    }

    public void beep(int n, int n2, int n3) throws JposException {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Throwable throwable) {
            System.out.print("\u0007");
            System.out.flush();
        }
        try {
            Thread.currentThread();
            Thread.sleep(n3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getWaitDrawerCloseWaitTime() throws JposException {
        return 300;
    }

    protected int getOpenDrawerWaitTime() {
        return 300;
    }

    protected void initStatus() throws JposException {
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        cashDrawerServiceState.setDrawerOpened(this.getSerial4610Device().isTillOpen());
    }

    private class Serial4610TillOpenedListenerImpl
    implements Serial4610TillOpenedListener {
        private Serial4610TillOpenedListenerImpl() {
        }

        public void serial4610TillOpenedOccurred() {
            Serial4610CashDrawerServiceImp.this.serial4610TillOpenedOccurred();
        }
    }

    private class Serial4610TillClosedListenerImpl
    implements Serial4610TillClosedListener {
        private Serial4610TillClosedListenerImpl() {
        }

        public void serial4610TillClosedOccurred() {
            Serial4610CashDrawerServiceImp.this.serial4610TillClosedOccurred();
        }
    }
}

