/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.IBM4840CashDrawerEvent;
import com.ibm.jpos.services.jcomm.IBM4840CashDrawerEventListener;
import com.ibm.jpos.util.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import jpos.JposConst;
import jpos.JposException;

class CommApi4840LineDisplayConnection
extends CommApiDeviceConnection
implements SerialPortEventListener,
JposConst {
    private static Vector ibm4840CDEventListenerVector = new Vector();
    private byte statusByte;
    private static String className = "CommApi4840LineDisplayConnection";

    protected CommApi4840LineDisplayConnection(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        super(string, n, string2, n2, n3, n4);
        try {
            this.getSerialPort().addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new JposException(111, tooManyListenersException.getMessage(), (Exception)tooManyListenersException);
        }
        this.getSerialPort().notifyOnFramingError(true);
        this.getSerialPort().notifyOnOverrunError(true);
        this.getSerialPort().notifyOnParityError(true);
        this.getSerialPort().notifyOnDSR(true);
        this.getSerialPort().notifyOnCTS(true);
        this.getSerialPort().notifyOnDataAvailable(true);
    }

    public static synchronized CommApiDeviceConnection open(String string, int n, String string2, int n2, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "open( " + string + ", " + n + ", " + string2 + ", " + n2 + ", " + n3 + ", " + n4 + " )", "Entry");
        CommApiDeviceConnection commApiDeviceConnection = null;
        Vector vector = CommApiDeviceConnection.commApiDeviceConnectionVector;
        synchronized (vector) {
            Enumeration enumeration = CommApiDeviceConnection.commApiDeviceConnectionVector.elements();
            while (enumeration.hasMoreElements()) {
                commApiDeviceConnection = (CommApiDeviceConnection)enumeration.nextElement();
                if (commApiDeviceConnection.getPortName().equals(string)) {
                    if (commApiDeviceConnection instanceof CommApi4840LineDisplayConnection) {
                        commApiDeviceConnection.incrementOpenCount();
                        if (string2.equalsIgnoreCase("NONE")) break;
                        try {
                            if (string2.equalsIgnoreCase("XON/XOFF")) {
                                commApiDeviceConnection.getSerialPort().setFlowControlMode(12);
                                break;
                            }
                            if (!string2.equalsIgnoreCase("RTS/CTS")) break;
                            commApiDeviceConnection.getSerialPort().setFlowControlMode(3);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    throw new JposException(107);
                }
                commApiDeviceConnection = null;
            }
            if (commApiDeviceConnection == null) {
                commApiDeviceConnection = new CommApi4840LineDisplayConnection(string, n, string2, n2, n3, n4);
                CommApiDeviceConnection.commApiDeviceConnectionVector.addElement(commApiDeviceConnection);
            }
        }
        return commApiDeviceConnection;
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 1: {
                Tracer.trace(3, className, "serialEvent()", "DATA_AVAIL received");
                try {
                    if (this.getInputStream().available() <= 0) break;
                    this.processStatus();
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                Tracer.trace(3, className, "serialEvent()", "OUTBUF_EMPTY received");
                break;
            }
            case 3: {
                Tracer.trace(3, className, "serialEvent()", "CTS received");
                break;
            }
            case 4: {
                Tracer.trace(3, className, "serialEvent()", "DSR received");
                break;
            }
            case 5: {
                Tracer.trace(3, className, "serialEvent()", "RI received");
                break;
            }
            case 6: {
                Tracer.trace(3, className, "serialEvent()", "CD received");
                break;
            }
            case 8: {
                Tracer.trace(3, className, "serialEvent()", "PE received");
                break;
            }
            case 7: {
                Tracer.trace(3, className, "serialEvent()", "OE received");
                break;
            }
            case 9: {
                Tracer.trace(3, className, "serialEvent()", "FE received");
                break;
            }
            case 10: {
                Tracer.trace(3, className, "serialEvent()", "BI received");
            }
        }
    }

    private void processStatus() {
        Tracer.trace(4, className, "processStatus()", "Entry");
        InputStream inputStream = this.getInputStream();
        try {
            this.statusByte = (byte)inputStream.read();
            Tracer.trace(4, className, "processStatus()", "read" + Integer.toHexString(this.statusByte));
        }
        catch (IOException iOException) {
            Tracer.trace(1, className, "processStatus()", "processStatus:read exception");
        }
        IBM4840CashDrawerEvent iBM4840CashDrawerEvent = new IBM4840CashDrawerEvent(this, this.statusByte);
        this.fireEvent(iBM4840CashDrawerEvent);
        Tracer.trace(4, className, "processStatus()", "Exit");
    }

    static void addEventListener(IBM4840CashDrawerEventListener iBM4840CashDrawerEventListener) {
        Tracer.trace(4, className, "addEventListener", "Entry");
        ibm4840CDEventListenerVector.addElement(iBM4840CashDrawerEventListener);
        Tracer.trace(2, className, "addEventListener", "number of listeners = " + ibm4840CDEventListenerVector.size());
        Tracer.trace(4, className, "addEventListener", "Exit");
    }

    static void removeEventListener(IBM4840CashDrawerEventListener iBM4840CashDrawerEventListener) {
        Tracer.trace(4, className, "removeEventListener", "Entry");
        ibm4840CDEventListenerVector.removeElement(iBM4840CashDrawerEventListener);
        Tracer.trace(2, className, "removeEventListener", "number of listeners = " + ibm4840CDEventListenerVector.size());
        Tracer.trace(4, className, "removeEventListener", "Exit");
    }

    private void fireEvent(IBM4840CashDrawerEvent iBM4840CashDrawerEvent) {
        Tracer.trace(4, className, "fireevent", "Entry");
        Tracer.trace(2, className, "fireEvent", "data = " + iBM4840CashDrawerEvent.getEventData());
        Vector vector = ibm4840CDEventListenerVector;
        synchronized (vector) {
            Tracer.trace(2, className, "fireEvent", "number of listeners = " + ibm4840CDEventListenerVector.size());
            int n = 0;
            while (n < ibm4840CDEventListenerVector.size()) {
                IBM4840CashDrawerEventListener iBM4840CashDrawerEventListener = (IBM4840CashDrawerEventListener)ibm4840CDEventListenerVector.elementAt(n);
                Tracer.trace(2, className, "fireEvent", "this listener = " + iBM4840CashDrawerEventListener);
                iBM4840CashDrawerEventListener.IBM4840CashDrawerEventOccurred(iBM4840CashDrawerEvent);
                ++n;
            }
        }
        Tracer.trace(4, className, "fireevent", "Exit");
    }
}

