/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.FastHashMap;

public class PropertyUtils {
    public static final char INDEXED_DELIM = '[';
    public static final char INDEXED_DELIM2 = ']';
    public static final char MAPPED_DELIM = '(';
    public static final char MAPPED_DELIM2 = ')';
    public static final char NESTED_DELIM = '.';
    private static int debug = 0;
    private static FastHashMap descriptorsCache = null;
    private static FastHashMap mappedDescriptorsCache = null;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static void clearDescriptors() {
        descriptorsCache.clear();
        mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public static void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors(orig);
        int i = 0;
        while (i < origDescriptors.length) {
            String name = origDescriptors[i].getName();
            if (PropertyUtils.getPropertyDescriptor(dest, name) != null) {
                Object value = PropertyUtils.getSimpleProperty(orig, name);
                try {
                    PropertyUtils.setSimpleProperty(dest, name, value);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean);
        HashMap<String, Object> description = new HashMap<String, Object>(descriptors.length);
        int i = 0;
        while (i < descriptors.length) {
            String name = descriptors[i].getName();
            if (descriptors[i].getReadMethod() != null) {
                description.put(name, PropertyUtils.getProperty(bean, name));
            }
            ++i;
        }
        return description;
    }

    public static Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(91);
        int delim2 = name.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        int index = -1;
        try {
            String subscript = name.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        name = name.substring(0, delim);
        return PropertyUtils.getIndexedProperty(bean, name, index);
    }

    public static Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor && (readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod()) != null) {
            Object[] subscript = new Object[]{new Integer(index)};
            try {
                return readMethod.invoke(bean, subscript);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)e.getTargetException();
                }
                throw e;
            }
        }
        readMethod = PropertyUtils.getReadMethod(descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object value = readMethod.invoke(bean, new Object[0]);
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed");
        }
        return Array.get(value, index);
    }

    public static Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(40);
        int delim2 = name.indexOf(41);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "'");
        }
        String key = name.substring(delim + 1, delim2);
        name = name.substring(0, delim);
        return PropertyUtils.getMappedProperty(bean, name, key);
    }

    public static Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified");
        }
        Object result = null;
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor).getMappedReadMethod();
            if (readMethod != null) {
                Object[] keyArray = new Object[]{key};
                result = readMethod.invoke(bean, keyArray);
            } else {
                throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method");
            }
        }
        return result;
    }

    public static FastHashMap getMappedPropertyDescriptors(Object bean) {
        if (bean == null) {
            return null;
        }
        Class<?> beanClass = bean.getClass();
        return (FastHashMap)mappedDescriptorsCache.get(beanClass);
    }

    public static Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int period;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int indexOfINDEXED_DELIM = -1;
        int indexOfMAPPED_DELIM = -1;
        while ((period = name.indexOf(46)) >= 0) {
            String next = name.substring(0, period);
            indexOfINDEXED_DELIM = next.indexOf(91);
            indexOfMAPPED_DELIM = next.indexOf(40);
            bean = indexOfMAPPED_DELIM >= 0 && (indexOfINDEXED_DELIM < 0 || indexOfMAPPED_DELIM < indexOfINDEXED_DELIM) ? PropertyUtils.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? PropertyUtils.getIndexedProperty(bean, next) : PropertyUtils.getSimpleProperty(bean, next));
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, period) + "'");
            }
            name = name.substring(period + 1);
        }
        indexOfINDEXED_DELIM = name.indexOf(91);
        indexOfMAPPED_DELIM = name.indexOf(40);
        bean = indexOfMAPPED_DELIM >= 0 && (indexOfINDEXED_DELIM < 0 || indexOfMAPPED_DELIM < indexOfINDEXED_DELIM) ? PropertyUtils.getMappedProperty(bean, name) : (indexOfINDEXED_DELIM >= 0 ? PropertyUtils.getIndexedProperty(bean, name) : PropertyUtils.getSimpleProperty(bean, name));
        return bean;
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PropertyUtils.getNestedProperty(bean, name);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int period;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        while ((period = name.indexOf(46)) >= 0) {
            String next = name.substring(0, period);
            int indexOfINDEXED_DELIM = next.indexOf(91);
            int indexOfMAPPED_DELIM = next.indexOf(40);
            bean = indexOfMAPPED_DELIM >= 0 && (indexOfINDEXED_DELIM < 0 || indexOfMAPPED_DELIM < indexOfINDEXED_DELIM) ? PropertyUtils.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? PropertyUtils.getIndexedProperty(bean, next) : PropertyUtils.getSimpleProperty(bean, next));
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, period) + "'");
            }
            name = name.substring(period + 1);
        }
        int left = name.indexOf(91);
        if (left >= 0) {
            name = name.substring(0, left);
        }
        if ((left = name.indexOf(40)) >= 0) {
            name = name.substring(0, left);
        }
        if (bean == null || name == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean);
        if (descriptors != null) {
            int i = 0;
            while (i < descriptors.length) {
                if (name.equals(descriptors[i].getName())) {
                    return descriptors[i];
                }
                ++i;
            }
        }
        PropertyDescriptor result = null;
        FastHashMap mappedDescriptors = PropertyUtils.getMappedPropertyDescriptors(bean);
        if (mappedDescriptors != null) {
            result = (PropertyDescriptor)mappedDescriptors.get(name);
        }
        if (result == null) {
            try {
                result = new MappedPropertyDescriptor(name, (Class)bean.getClass());
            }
            catch (IntrospectionException ie) {
                // empty catch block
            }
        }
        if (result != null) {
            if (mappedDescriptors == null) {
                mappedDescriptors = new FastHashMap();
                mappedDescriptors.setFast(true);
                mappedDescriptorsCache.put(bean.getClass(), mappedDescriptors);
            }
            mappedDescriptors.put(name, result);
        }
        return result;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        Class<?> beanClass = bean.getClass();
        PropertyDescriptor[] descriptors = null;
        descriptors = (PropertyDescriptor[])descriptorsCache.get(beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(beanClass, descriptors);
        return descriptors;
    }

    public static Class getPropertyEditorClass(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor != null) {
            return descriptor.getPropertyEditorClass();
        }
        return null;
    }

    public static Class getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
        }
        return descriptor.getPropertyType();
    }

    public static Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    public static Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (name.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (name.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method readMethod = PropertyUtils.getReadMethod(descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object value = readMethod.invoke(bean, new Object[0]);
        return value;
    }

    public static Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    public static void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(91);
        int delim2 = name.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        int index = -1;
        try {
            String subscript = name.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "'");
        }
        name = name.substring(0, delim);
        PropertyUtils.setIndexedProperty(bean, name, index, value);
    }

    public static void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method writeMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor && (writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod()) != null) {
            Object[] subscript = new Object[]{new Integer(index), value};
            try {
                writeMethod.invoke(bean, subscript);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof ArrayIndexOutOfBoundsException) {
                    throw (ArrayIndexOutOfBoundsException)e.getTargetException();
                }
                throw e;
            }
            return;
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method");
        }
        Object array = readMethod.invoke(bean, new Object[0]);
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Property '" + name + "' is not indexed");
        }
        Array.set(array, index, value);
    }

    public static void setMappedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int delim = name.indexOf(40);
        int delim2 = name.indexOf(41);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "'");
        }
        String key = name.substring(delim + 1, delim2);
        name = name.substring(0, delim);
        PropertyUtils.setMappedProperty(bean, name, key, value);
    }

    public static void setMappedProperty(Object bean, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            if (mappedWriteMethod != null) {
                Object[] params = new Object[]{key, value};
                mappedWriteMethod.invoke(bean, params);
            } else {
                throw new NoSuchMethodException("Property '" + name + "' has no mapped setter method");
            }
        }
    }

    public static void setNestedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int delim;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int indexOfINDEXED_DELIM = -1;
        int indexOfMAPPED_DELIM = -1;
        while ((delim = name.indexOf(46)) >= 0) {
            String next = name.substring(0, delim);
            indexOfINDEXED_DELIM = next.indexOf(91);
            indexOfMAPPED_DELIM = next.indexOf(40);
            bean = indexOfMAPPED_DELIM >= 0 && (indexOfINDEXED_DELIM < 0 || indexOfMAPPED_DELIM < indexOfINDEXED_DELIM) ? PropertyUtils.getMappedProperty(bean, next) : (indexOfINDEXED_DELIM >= 0 ? PropertyUtils.getIndexedProperty(bean, next) : PropertyUtils.getSimpleProperty(bean, next));
            if (bean == null) {
                throw new IllegalArgumentException("Null property value for '" + name.substring(0, delim) + "'");
            }
            name = name.substring(delim + 1);
        }
        indexOfINDEXED_DELIM = name.indexOf(91);
        indexOfMAPPED_DELIM = name.indexOf(40);
        if (indexOfMAPPED_DELIM >= 0 && (indexOfINDEXED_DELIM < 0 || indexOfMAPPED_DELIM < indexOfINDEXED_DELIM)) {
            PropertyUtils.setMappedProperty(bean, name, value);
        } else if (indexOfINDEXED_DELIM >= 0) {
            PropertyUtils.setIndexedProperty(bean, name, value);
        } else {
            PropertyUtils.setSimpleProperty(bean, name, value);
        }
    }

    public static void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtils.setNestedProperty(bean, name, value);
    }

    public static void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (name.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (name.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        Method writeMethod = PropertyUtils.getWriteMethod(descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method");
        }
        Object[] values = new Object[]{value};
        writeMethod.invoke(bean, values);
    }

    static {
        descriptorsCache = new FastHashMap();
        descriptorsCache.setFast(true);
        mappedDescriptorsCache = new FastHashMap();
        mappedDescriptorsCache.setFast(true);
    }
}

