/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.javase;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.glxn.qrgen.core.AbstractQRCode;
import net.glxn.qrgen.core.exception.QRGenerationException;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.core.scheme.Schema;

public class QRCode
extends AbstractQRCode {
    public static final MatrixToImageConfig DEFAULT_CONFIG = new MatrixToImageConfig();
    protected final String text;
    protected MatrixToImageConfig matrixToImageConfig = DEFAULT_CONFIG;

    protected QRCode(String text) {
        this.text = text;
        this.qrWriter = new QRCodeWriter();
    }

    public static QRCode from(String text) {
        return new QRCode(text);
    }

    public static QRCode from(Schema schema) {
        return new QRCode(schema.generateString());
    }

    public QRCode to(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public QRCode withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public QRCode withCharset(String charset) {
        return this.withHint(EncodeHintType.CHARACTER_SET, charset);
    }

    public QRCode withErrorCorrection(ErrorCorrectionLevel level) {
        return this.withHint(EncodeHintType.ERROR_CORRECTION, (Object)level);
    }

    public QRCode withHint(EncodeHintType hintType, Object value) {
        this.hints.put(hintType, value);
        return this;
    }

    @Override
    public File file() {
        File file;
        try {
            file = this.createTempFile();
            MatrixToImageWriter.writeToPath(this.createMatrix(this.text), this.imageType.toString(), file.toPath(), this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e);
        }
        return file;
    }

    @Override
    public File file(String name) {
        File file;
        try {
            file = this.createTempFile(name);
            MatrixToImageWriter.writeToPath(this.createMatrix(this.text), this.imageType.toString(), file.toPath(), this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e);
        }
        return file;
    }

    @Override
    protected void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream(this.createMatrix(this.text), this.imageType.toString(), stream, this.matrixToImageConfig);
    }

    public QRCode withColor(int onColor, int offColor) {
        this.matrixToImageConfig = new MatrixToImageConfig(onColor, offColor);
        return this;
    }
}

