/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core.scheme;

import java.util.Map;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.core.scheme.SchemeUtil;

public class YouTube
extends Schema {
    public static final String YOUTUBE = "youtube";
    private String videoId;

    public YouTube() {
    }

    public YouTube(String videoId) {
        this.videoId = videoId;
    }

    public String getVideoId() {
        return this.videoId;
    }

    public void setVideoId(String videoId) {
        this.videoId = videoId;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.toLowerCase().startsWith(YOUTUBE)) {
            throw new IllegalArgumentException("this is not a valid you tube code: " + code);
        }
        Map<String, String> parameters = SchemeUtil.getParameters(code);
        if (parameters.containsKey(YOUTUBE)) {
            this.setVideoId(parameters.get(YOUTUBE));
        }
        return this;
    }

    @Override
    public String generateString() {
        return "youtube:" + this.videoId;
    }

    public String toString() {
        return this.generateString();
    }

    public static YouTube parse(String code) {
        YouTube youTube = new YouTube();
        youTube.parseSchema(code);
        return youTube;
    }
}

