/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.core;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.glxn.qrgen.core.exception.QRGenerationException;
import net.glxn.qrgen.core.image.ImageType;

public abstract class AbstractQRCode {
    protected final HashMap<EncodeHintType, Object> hints = new HashMap();
    protected Writer qrWriter;
    protected int width = 125;
    protected int height = 125;
    protected ImageType imageType = ImageType.PNG;

    public abstract File file();

    public abstract File file(String var1);

    public ByteArrayOutputStream stream() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.writeToStream(stream);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e);
        }
        return stream;
    }

    public void writeTo(OutputStream stream) {
        try {
            this.writeToStream(stream);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", e);
        }
    }

    protected abstract void writeToStream(OutputStream var1) throws IOException, WriterException;

    public BitMatrix createMatrix(String text) throws WriterException {
        return this.qrWriter.encode(text, BarcodeFormat.QR_CODE, this.width, this.height, this.hints);
    }

    protected File createTempFile() throws IOException {
        File file = File.createTempFile("QRCode", "." + this.imageType.toString().toLowerCase());
        file.deleteOnExit();
        return file;
    }

    protected File createTempFile(String name) throws IOException {
        File file = File.createTempFile(name, "." + this.imageType.toString().toLowerCase());
        file.deleteOnExit();
        return file;
    }

    public Writer getQrWriter() {
        return this.qrWriter;
    }

    public void setQrWriter(Writer qrWriter) {
        this.qrWriter = qrWriter;
    }
}

