/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import jpos.JposTestCase;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.JposEntryConst;
import jpos.config.RS232Const;
import jpos.config.simple.SimpleEntry;
import jpos.test.JUnitUtility;
import jpos.util.JposEntryUtility;
import junit.framework.Assert;

public class JposEntryUtilityTestCase
extends JposTestCase {
    private JposEntry entryProto = null;
    public static final String VENDOR_PROP_NAME = "vendor.prop.name";
    public static final String VENDOR_PROP_VALUE = "vendor.prop.value";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$jpos$config$JposEntry;
    static /* synthetic */ Class class$java$lang$Short;

    public JposEntryUtilityTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.entryProto = JposEntryUtility.getEntryPrototype();
    }

    protected void tearDown() {
        this.entryProto = null;
    }

    public void testGetEntryPrototype() {
        JposEntry jposEntry = JposEntryUtility.getEntryPrototype();
        Assert.assertTrue((String)"JposEntryUtility.getEntryPrototype() return null", (jposEntry != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"JposEntryUtility.getEntryPrototype() return invalid entry", (boolean)JposEntryUtility.isValidJposEntry(jposEntry));
        JposEntry jposEntry2 = JposEntryUtility.getEntryPrototype();
        Assert.assertTrue((String)"JposEntryUtility.getEntryPrototype() return null", (jposEntry2 != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"JposEntryUtility.getEntryPrototype() return same entry", (jposEntry != jposEntry2 ? 1 : 0) != 0);
    }

    public void testIsValidJposEntry() {
        SimpleEntry simpleEntry = new SimpleEntry();
        Assert.assertTrue((String)"Expected INVALID entry for new SimpleEntry()", (!JposEntryUtility.isValidJposEntry(simpleEntry) ? 1 : 0) != 0);
        simpleEntry.addProperty("logicalName", "logicalName");
        simpleEntry.addProperty("factoryClass", "factoryClass");
        simpleEntry.addProperty("serviceClass", "serviceClass");
        Assert.assertTrue((String)"Expected INVALID entry for new SimpleEntry()", (!JposEntryUtility.isValidJposEntry(simpleEntry) ? 1 : 0) != 0);
        JposEntry jposEntry = JposEntryUtility.getEntryPrototype();
        Assert.assertTrue((String)"Expected VALID entry for JposEntryUtility.getEntryPrototype()", (JposEntryUtility.isValidJposEntry(jposEntry) ? 1 : 0) != 0);
        JposEntryUtility.addMissingRequiredProps(simpleEntry);
        Assert.assertTrue((String)"Expected VALID entry for JposEntryUtility.addMissingRequiredPropNames( entry )", (JposEntryUtility.isValidJposEntry(simpleEntry) ? 1 : 0) != 0);
        JposEntry jposEntry2 = this.createJposEntry("logicalName", "factoryClass", "serviceClass", "vendorName", "vendorUrl", "deviceCategory", "jposVersion", "productName", "productDescription", "productUrl", null);
        Assert.assertTrue((String)"Expected VALID entry for createJposEntry( ... )", (JposEntryUtility.isValidJposEntry(jposEntry2) ? 1 : 0) != 0);
    }

    public void testIsRequiredProp() {
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("serviceInstanceFactoryClass"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("logicalName"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("serviceClass"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("vendorName"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("vendorURL"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("deviceCategory"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("jposVersion"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("productName"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("productDescription"));
        Assert.assertTrue((String)"Expected string passed to be a REQUIRED property", (boolean)JposEntryUtility.isRequiredPropName("productURL"));
        Assert.assertTrue((String)"DO NOT expect string passed to be a REQUIRED property", (!JposEntryUtility.isRequiredPropName("") ? 1 : 0) != 0);
        Assert.assertTrue((String)"DO NOT expect string passed to be a REQUIRED property", (!JposEntryUtility.isRequiredPropName("1234") ? 1 : 0) != 0);
        Assert.assertTrue((String)"DO NOT expect string passed to be a REQUIRED property", (!JposEntryUtility.isRequiredPropName("abc") ? 1 : 0) != 0);
    }

    public void testGetMissingRequiredPropNames() {
        SimpleEntry simpleEntry = new SimpleEntry();
        Enumeration enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Assert.assertTrue((String)"new SimpleEntry() should be missing all required properties", (JUnitUtility.isEquals((Object[])JposEntryConst.REQUIRED_PROPS, (Enumeration)enumeration) ? 1 : 0) != 0);
        JposEntryUtility.addMissingRequiredProps(simpleEntry);
        enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Assert.assertTrue((String)"All required properties should be there", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
        simpleEntry.removeProperty("serviceClass");
        enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Object[] objectArray = new String[]{"serviceClass"};
        Assert.assertTrue((String)"{ serviceClass } is the only missong property", (JUnitUtility.isEquals((Object[])objectArray, (Enumeration)enumeration) ? 1 : 0) != 0);
        simpleEntry.removeProperty("deviceCategory");
        simpleEntry.removeProperty("serviceInstanceFactoryClass");
        enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Object[] objectArray2 = new String[]{"serviceClass", "deviceCategory", "serviceInstanceFactoryClass"};
        Assert.assertTrue((String)"{ serviceClass } is the only missong property", (JUnitUtility.isEquals((Object[])objectArray2, (Enumeration)enumeration) ? 1 : 0) != 0);
        JposEntryUtility.addMissingRequiredProps(simpleEntry);
        enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Assert.assertTrue((String)"All required properties should be there", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    public void testAddMissingRequiredProps() {
        SimpleEntry simpleEntry = new SimpleEntry();
        JposEntryUtility.addMissingRequiredProps(simpleEntry);
        Enumeration enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Assert.assertTrue((String)"All required properties should be there", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
        JposEntryUtility.addMissingRequiredProps(simpleEntry);
        enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Assert.assertTrue((String)"All required properties should be there", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
        simpleEntry.removeProperty("deviceCategory");
        simpleEntry.removeProperty("serviceInstanceFactoryClass");
        simpleEntry.removeProperty("jposVersion");
        enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Assert.assertTrue((String)"There should be some missing properties", (enumeration.hasMoreElements() ? 1 : 0) != 0);
        JposEntryUtility.addMissingRequiredProps(simpleEntry);
        enumeration = JposEntryUtility.getMissingRequiredPropNames(simpleEntry);
        Assert.assertTrue((String)"All required properties should be there", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    public void testGetMissingRS232PropNames() {
        SimpleEntry simpleEntry = new SimpleEntry();
        Enumeration enumeration = JposEntryUtility.getMissingRS232PropNames(simpleEntry);
        Assert.assertTrue((String)"new SimpleEntry() should be missing all RS232 properties", (JUnitUtility.isEquals((Object[])RS232Const.RS232_PROPS, (Enumeration)enumeration) ? 1 : 0) != 0);
        simpleEntry.addProperty("portName", "COM1");
        simpleEntry.addProperty("baudRate", RS232Const.RS232_BAUD_RATE_VALUES[0]);
        simpleEntry.addProperty("dataBits", RS232Const.RS232_DATA_BITS_VALUES[0]);
        simpleEntry.addProperty("parity", "Mark");
        simpleEntry.addProperty("stopBits", "1.5");
        simpleEntry.addProperty("flowControl", RS232Const.RS232_FLOW_CONTROL_VALUES[1]);
        enumeration = JposEntryUtility.getMissingRS232PropNames(simpleEntry);
        Assert.assertTrue((String)"All RS232 properties should be present", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    public void testGetVendorPropNames() {
        Object object;
        Assert.assertTrue((String)"Expected VALID entry for JposEntryUtility.getEntryPrototype()", (JposEntryUtility.isValidJposEntry(this.entryProto) ? 1 : 0) != 0);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        while (n < 10) {
            object = VENDOR_PROP_NAME + n;
            String string = VENDOR_PROP_VALUE + n;
            arrayList.add(object);
            arrayList2.add(string);
            this.entryProto.addProperty((String)object, string);
            ++n;
        }
        object = JposEntryUtility.getVendorPropNames(this.entryProto);
        Assert.assertTrue((String)"Added vendor property names do not match JposEntryUtility.getVendorPropNames( entryProto )", (boolean)JUnitUtility.isEquals((Enumeration)object, arrayList.iterator()));
    }

    public void testGetStandardPropNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < JposEntryConst.REQUIRED_PROPS.length) {
            arrayList.add(JposEntryConst.REQUIRED_PROPS[n]);
            ++n;
        }
        arrayList.add("deviceBus");
        int n2 = 0;
        while (n2 < RS232Const.RS232_PROPS.length) {
            arrayList.add(RS232Const.RS232_PROPS[n2]);
            ++n2;
        }
        Assert.assertTrue((String)"List of standard property names does not match JposEntryUtility.getStandardPropNames()", (boolean)JUnitUtility.isEquals((Iterator)JposEntryUtility.getStandardPropNames(), arrayList.iterator()));
    }

    public void testIsRS232PropName() {
        this.emptyTest();
    }

    public void testRemoveAllRS232Props() {
        this.emptyTest();
    }

    public void testGetNonRequiredPropNames() {
        this.emptyTest();
    }

    public void testShortClassName() {
        Assert.assertTrue((String)"JposEntryUtility.shortClassName( String.class ) did not return String", (boolean)"String".equals(JposEntryUtility.shortClassName(class$java$lang$String == null ? (class$java$lang$String = JposEntryUtilityTestCase.class$("java.lang.String")) : class$java$lang$String)));
        Assert.assertTrue((String)"JposEntryUtility.shortClassName( Long.class ) did not return Long", (boolean)"Long".equals(JposEntryUtility.shortClassName(class$java$lang$Long == null ? (class$java$lang$Long = JposEntryUtilityTestCase.class$("java.lang.Long")) : class$java$lang$Long)));
        Assert.assertTrue((String)"JposEntryUtility.shortClassName( JposEntry.class ) did not return JposEntry", (boolean)"JposEntry".equals(JposEntryUtility.shortClassName(class$jpos$config$JposEntry == null ? (class$jpos$config$JposEntry = JposEntryUtilityTestCase.class$("jpos.config.JposEntry")) : class$jpos$config$JposEntry)));
    }

    public void testValidatePropValue() {
        this.emptyTest();
    }

    public void testIsValidPropType() {
        this.emptyTest();
    }

    public void testParsePropValue() {
        this.emptyTest();
    }

    public void testPropTypeFromString() throws JposConfigException {
        Class clazz;
        String string = "java.lang.String";
        String string2 = "Short";
        String string3 = "integer";
        String string4 = "java.util.Long";
        Assert.assertTrue((String)"Should return a non-null Class object", (JposEntryUtility.propTypeFromString(string) != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should return the String.class object", (boolean)JposEntryUtility.propTypeFromString(string).equals(class$java$lang$String == null ? (class$java$lang$String = JposEntryUtilityTestCase.class$("java.lang.String")) : class$java$lang$String));
        Assert.assertTrue((String)"Should return a non-null Class object", (JposEntryUtility.propTypeFromString(string2) != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should return the String.class object", (boolean)JposEntryUtility.propTypeFromString(string2).equals(class$java$lang$Short == null ? (class$java$lang$Short = JposEntryUtilityTestCase.class$("java.lang.Short")) : class$java$lang$Short));
        try {
            clazz = JposEntryUtility.propTypeFromString(string3);
            Assert.fail((String)"Should have thrown a JposConfigException");
        }
        catch (JposConfigException jposConfigException) {
            // empty catch block
        }
        try {
            clazz = JposEntryUtility.propTypeFromString(string4);
            Assert.fail((String)"Should have thrown a JposConfigException");
        }
        catch (JposConfigException jposConfigException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

