/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class FileUtil {
    private static Tracer tracer = TracerFactory.getInstance().createTracer("FileUtil");

    protected FileUtil() {
    }

    protected static synchronized List getCpDirList() {
        String string = System.getProperty("java.class.path");
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.toLowerCase().endsWith("jar") || string2.toLowerCase().endsWith("zip")) {
                linkedList.add(string2.substring(0, string2.lastIndexOf(File.separator)));
                continue;
            }
            linkedList.add(string2);
        }
        return linkedList;
    }

    protected static synchronized List getJarList() {
        String string = System.getProperty("java.class.path");
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.toLowerCase().endsWith("jar") && !string2.toLowerCase().endsWith("zip")) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    protected static synchronized JarEntry getJarEntry(JarFile jarFile, String string) {
        tracer.println("<getJarEntry jarFile=" + jarFile + " fileName=" + string + ">");
        if (jarFile == null) {
            return null;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().equals(string)) continue;
            tracer.println("jarEntry.getName()=" + jarEntry.getName());
            return jarEntry;
        }
        tracer.println("<message>Could not find JarEntry with fileName=" + string + "</message>");
        tracer.println("</getJarEntry>");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static synchronized JarFile lookForFileInJars(String string) {
        String string2;
        try {
            try {
                tracer.println("<lookForFileInJars fileName=" + string + ">");
                String string3 = System.getProperty("java.class.path");
                tracer.println("classpath=" + string3);
                List list = FileUtil.getJarList();
                List list2 = FileUtil.getCpDirList();
                int n = 0;
                while (true) {
                    if (n >= list.size()) {
                        string2 = null;
                        break;
                    }
                    string2 = (String)list.get(n);
                    tracer.println("jarFileName=" + string2);
                    JarFile jarFile = new JarFile(new File(string2));
                    JarEntry jarEntry = FileUtil.getJarEntry(jarFile, string);
                    if (jarEntry != null) {
                        JarFile jarFile2 = jarFile;
                        Object var10_11 = null;
                        tracer.println("</lookForFileInJars>");
                        return jarFile2;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                JarFile jarFile = null;
                Object var10_13 = null;
                tracer.println("</lookForFileInJars>");
                return jarFile;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            tracer.println("</lookForFileInJars>");
            throw throwable;
        }
        Object var10_12 = null;
        tracer.println("</lookForFileInJars>");
        return string2;
    }

    public static synchronized boolean locateFile(String string, boolean bl, boolean bl2) {
        JarFile jarFile;
        File file = FileUtil.findFile(string, bl);
        if (file != null) {
            return true;
        }
        return bl2 && (jarFile = FileUtil.lookForFileInJars(string)) != null;
    }

    public static synchronized File findFile(String string, boolean bl) {
        try {
            File file = new File(string);
            if (file.exists()) {
                return file;
            }
            List list = FileUtil.getJarList();
            List list2 = FileUtil.getCpDirList();
            if (bl) {
                int n = 0;
                while (n < list2.size()) {
                    String string2 = (String)list2.get(n);
                    File file2 = new File(string2 + File.separator + string);
                    if (file2.exists()) {
                        return file2;
                    }
                    ++n;
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized InputStream loadFile(String string, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        tracer.println("<loadFile fileName=" + string + " searchInClassPath=" + bl + " searchInJarFile=" + bl2 + ">");
        File file = FileUtil.findFile(string, bl);
        if (file != null) {
            return new FileInputStream(file);
        }
        if (file == null && !bl2) {
            throw new FileNotFoundException("Could not find file: " + string);
        }
        JarFile jarFile = FileUtil.lookForFileInJars(string);
        if (jarFile == null) {
            throw new FileNotFoundException("Could not find file: " + string);
        }
        JarEntry jarEntry = FileUtil.getJarEntry(jarFile, string);
        if (jarEntry != null) {
            return jarFile.getInputStream(jarEntry);
        }
        throw new FileNotFoundException("Could not find file: " + string);
    }
}

