/*
 * Decompiled with CFR 0.152.
 */
package jpos.profile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import jpos.JposTestCase;
import jpos.profile.Profile;
import jpos.profile.ProfileException;
import jpos.profile.XercesProfileFactory;
import junit.framework.Assert;
import org.w3c.dom.Document;

public class XercesProfileFactoryTestCase
extends JposTestCase {
    private XercesProfileFactory xProfFactory = null;
    private String profileFileName = "";
    private String schemaProfileFileName = "";
    private static final String PROFILE_FILE_NAME = JposTestCase.TEST_DATA_PATH + "jcl_junit_profile.xml";
    private static final String SCHEMA_PROFILE_FILE_NAME = JposTestCase.TEST_DATA_PATH + "jcl_junit_schema_profile.xml";
    private static final String PROFILE_NAME = "JCL JUnit Corp. JavaPOS Profile";
    private static final String PROFILE_VERSION = "1.0";
    private static final String PROFILE_VENDOR_NAME = "JCL JUnit, Corp.";
    private static final String PROFILE_VENDOR_URL = "http://www.jcl-junit.com";
    private static final String PROFILE_DESCRIPTION = "Simple JCL profile XML file for JUnit testing";

    public XercesProfileFactoryTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.xProfFactory = new XercesProfileFactory();
        this.profileFileName = PROFILE_FILE_NAME;
        this.schemaProfileFileName = SCHEMA_PROFILE_FILE_NAME;
    }

    protected void tearDown() {
        this.xProfFactory = null;
        this.profileFileName = "";
        this.schemaProfileFileName = "";
    }

    public void testParse() throws ProfileException, IOException {
        File file = new File(this.profileFileName);
        Assert.assertTrue((String)("JCL JUnit Profile file named = " + this.profileFileName + ", does not exist"), (boolean)file.exists());
    }

    public void _testParseSchema() throws ProfileException, IOException {
        File file = new File(this.profileFileName);
        Assert.assertTrue((String)("JCL JUnit Schema Profile file named = " + this.schemaProfileFileName + ", does not exist"), (boolean)file.exists());
        Document document = this.xProfFactory.parseSchema(this.schemaProfileFileName);
        Assert.assertTrue((String)"XercesProfileFactory.parseSchema returned a null object", (document != null ? 1 : 0) != 0);
    }

    public void _testCreateProfile() throws ProfileException, IOException {
        File file = new File(this.profileFileName);
        Assert.assertTrue((String)("JCL JUnit Profile file named = " + this.profileFileName + ", does not exist"), (boolean)file.exists());
        Profile profile = this.xProfFactory.createProfile(this.profileFileName);
        Assert.assertTrue((String)"XercesProfileFactory.createProfile returned a null object", (profile != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Profile.name != JCL JUnit Corp. JavaPOS Profile", (boolean)profile.getName().equals(PROFILE_NAME));
        Assert.assertTrue((String)"Profile.version != 1.0", (boolean)profile.getVersion().equals(PROFILE_VERSION));
        Assert.assertTrue((String)"Profile.vendorName != JCL JUnit, Corp.", (boolean)profile.getVendorName().equals(PROFILE_VENDOR_NAME));
        Assert.assertTrue((String)"Profile.vendorUrl != http://www.jcl-junit.com", (boolean)profile.getVendorUrl().toString().equals(PROFILE_VENDOR_URL));
        Assert.assertTrue((String)"Profile.description != Simple JCL profile XML file for JUnit testing", (boolean)profile.getDescription().equals(PROFILE_DESCRIPTION));
        this.println(profile);
    }

    private File copyFile(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        String string = file2.getAbsolutePath() + File.separator + file.getName();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        while (bufferedInputStream.available() > 0) {
            int n = bufferedInputStream.available();
            byte[] byArray = new byte[n];
            bufferedInputStream.read(byArray);
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
        return new File(string);
    }
}

