/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import jpos.JposTestCase;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;
import jpos.test.JUnitUtility;
import jpos.util.JposEntryUtility;
import junit.framework.Assert;

public class SimpleEntryTestCase
extends JposTestCase {
    private JposEntry entry = null;
    private List propNameList = new ArrayList();
    private List propValueList = new ArrayList();
    private int maxVendorPropNameIndex = 0;
    public static final String VENDOR_PROP_NAME = "vendor.prop.name";
    public static final String VENDOR_PROP_VALUE = "vendor.prop.value";

    public SimpleEntryTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.entry = this.createJposEntry();
    }

    protected void tearDown() {
        this.entry = null;
        this.propNameList.clear();
        this.propValueList.clear();
        this.maxVendorPropNameIndex = 0;
    }

    private JposEntry createJposEntry() {
        String string;
        Object object;
        JposEntry jposEntry = this.createJposEntry("logicalName", "serviceInstanceFactoryClass", "serviceClass", "vendorName", "vendorURL", "deviceCategory", "jposVersion", "productName", "productDescription", "productURL", null);
        this.propNameList.add("logicalName");
        this.propNameList.add("serviceInstanceFactoryClass");
        this.propNameList.add("serviceClass");
        this.propNameList.add("vendorName");
        this.propNameList.add("vendorURL");
        this.propNameList.add("deviceCategory");
        this.propNameList.add("jposVersion");
        this.propNameList.add("productName");
        this.propNameList.add("productDescription");
        this.propNameList.add("productURL");
        this.propValueList.add("logicalName");
        this.propValueList.add("serviceInstanceFactoryClass");
        this.propValueList.add("serviceClass");
        this.propValueList.add("vendorName");
        this.propValueList.add("vendorURL");
        this.propValueList.add("deviceCategory");
        this.propValueList.add("jposVersion");
        this.propValueList.add("productName");
        this.propValueList.add("productDescription");
        this.propValueList.add("productURL");
        int n = 0;
        while (n < 5) {
            String string2 = VENDOR_PROP_NAME + n;
            object = new Integer(n);
            jposEntry.addProperty(string2, object);
            this.propNameList.add(string2);
            this.propValueList.add(object);
            ++n;
        }
        int n2 = 5;
        while (n2 < 10) {
            object = VENDOR_PROP_NAME + n2;
            string = VENDOR_PROP_VALUE + n2;
            jposEntry.addProperty((String)object, string);
            this.propNameList.add(object);
            this.propValueList.add(string);
            ++n2;
        }
        int n3 = 10;
        while (n3 < 15) {
            string = VENDOR_PROP_NAME + n3;
            Boolean bl = new Boolean(n3 % 2 == 1);
            jposEntry.addProperty(string, bl);
            this.propNameList.add(string);
            this.propValueList.add(bl);
            ++n3;
        }
        this.maxVendorPropNameIndex = 15;
        return jposEntry;
    }

    public void tesGetPropertyCount() {
        Assert.assertEquals((String)"entry.getPropertyCount() does not match propNameList.size()", (int)this.propNameList.size(), (int)this.entry.getPropertyCount());
    }

    public void testGetPropertyNames() {
        Assert.assertTrue((String)"entry.getPropertyNames() does not match propNameList.iterator()", (boolean)JUnitUtility.isEquals((Enumeration)this.entry.getPropertyNames(), this.propNameList.iterator()));
    }

    public void testHasPropertyWithName() {
        Iterator iterator = this.propNameList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Assert.assertTrue((String)("Expect entry to have property with name: " + string), (boolean)this.entry.hasPropertyWithName(string));
        }
    }

    public void testHasPropertyWithValue() {
        Iterator iterator = this.propValueList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Assert.assertTrue((String)("Expect entry to have property with value: " + e), (boolean)this.entry.hasPropertyWithValue(e));
        }
    }

    public void testGetPropertyValue() {
        Iterator iterator = this.propNameList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.entry.getPropertyValue(string);
            Assert.assertTrue((String)("Expect entry to have property value: " + object), (boolean)JUnitUtility.isInList((Object)object, (List)this.propValueList));
        }
    }

    public void testGetPropertyType() throws JposConfigException {
        Iterator iterator = this.propNameList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.entry.getPropertyValue(string);
            Class clazz = this.entry.getPropertyType(string);
            Assert.assertTrue((String)"Expect entry to have a type != null", (clazz != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Expect <value, type> to be a valid property <type, value>", (boolean)JposEntryUtility.validatePropValue(object, clazz));
        }
    }

    public void testModifyPropertyValue() {
        String string = "vendorName";
        Assert.assertTrue((String)("entry should have property by name: " + string), (boolean)this.entry.hasPropertyWithName(string));
        String string2 = (String)this.entry.getPropertyValue(string);
        this.entry.modifyPropertyValue(string, "newValue");
        Assert.assertTrue((String)"entry.getPropertyValue( propName ) should be: newValue", (boolean)this.entry.getPropertyValue(string).equals("newValue"));
    }

    public void testAddProperty() {
        String string = "propName";
        String string2 = "propValue";
        Assert.assertTrue((String)("entry should NOT have property by name: " + string), (!this.entry.hasPropertyWithName(string) ? 1 : 0) != 0);
        this.entry.addProperty(string, string2);
        Assert.assertTrue((String)("entry SHOULD have property by name: " + string), (this.entry.hasPropertyWithName(string) ? 1 : 0) != 0);
    }

    public void testRemoveProperty() {
        String string = "vendorName";
        Assert.assertTrue((String)("entry should have property by name: " + string), (boolean)this.entry.hasPropertyWithName(string));
        this.entry.removeProperty(string);
        Assert.assertTrue((String)("entry should no longer have property by name: " + string), (!this.entry.hasPropertyWithName(string) ? 1 : 0) != 0);
    }

    public void testEquals() {
        JposEntry jposEntry = ((SimpleEntry)this.entry).copy();
        Assert.assertTrue((String)"entry.copy() should be equal to entry", (boolean)this.entry.equals(jposEntry));
        jposEntry.addProperty("myProp", "myValue");
        Assert.assertTrue((String)"modified entry.copy() should NOT be equal to entry", (!this.entry.equals(jposEntry) ? 1 : 0) != 0);
        jposEntry.removeProperty("myProp");
        Assert.assertTrue((String)"entry.copy() should be equal to entry", (boolean)this.entry.equals(jposEntry));
    }

    public void testGetRegPopulator() {
        Assert.assertTrue((String)"entry.getRegPopulator() should be null", (this.entry.getRegPopulator() == null ? 1 : 0) != 0);
    }

    public void testGetLogicalName() {
        Assert.assertTrue((String)"entry MUST have a logicalName property != null", (this.entry.getLogicalName() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"entry logicalName must be: logicalName", (boolean)this.entry.getLogicalName().equals("logicalName"));
        Assert.assertTrue((String)"entry logicalName must be: logicalName", (boolean)this.entry.getLogicalName().equals(this.entry.getPropertyValue("logicalName")));
    }

    public void testGetProp() {
        Assert.assertTrue((String)"entry MUST have a logicalName property != null", (this.entry.getLogicalName() != null ? 1 : 0) != 0);
        JposEntry.Prop prop = this.entry.getProp("thisIsAFakePropName");
        Assert.assertTrue((String)"nullProp should be null", (prop == null ? 1 : 0) != 0);
        int n = 0;
        while (n < this.maxVendorPropNameIndex) {
            String string = VENDOR_PROP_NAME + n;
            JposEntry.Prop prop2 = this.entry.getProp(string);
            Assert.assertTrue((String)"prop should NOT be null", (prop2 != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("prop.getName() should ==  " + string), (boolean)prop2.getName().equals(string));
            Assert.assertTrue((String)"prop.getValue() should be != null", (prop2.getValue() != null ? 1 : 0) != 0);
            ++n;
        }
    }

    public void testGetProps() {
        ArrayList<SimpleEntry.Prop> arrayList = new ArrayList<SimpleEntry.Prop>();
        int n = 0;
        while (n < this.propNameList.size()) {
            arrayList.add(new SimpleEntry.Prop((String)this.propNameList.get(n), this.propValueList.get(n)));
            ++n;
        }
        Assert.assertTrue((String)"entry.getProps() matches the list of <value, pair> properties", (boolean)JUnitUtility.isEquals(arrayList.iterator(), (Iterator)this.entry.getProps()));
    }

    public void testAddProp() {
        int n = this.entry.getPropertyCount();
        SimpleEntry.Prop prop = new SimpleEntry.Prop("longProp", new Long(12345L));
        this.entry.add(prop);
        Assert.assertTrue((String)"new size should be one more", (this.entry.getPropertyCount() == n + 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"did not find added property", (boolean)this.entry.hasPropertyWithName(prop.getName()));
        Assert.assertTrue((String)"did not find added property", (boolean)this.entry.hasPropertyWithValue(prop.getValue()));
    }

    public void testRemoveProp() {
        int n = this.entry.getPropertyCount();
        SimpleEntry.Prop prop = new SimpleEntry.Prop("longProp", new Long(12345L));
        this.entry.add(prop);
        Assert.assertTrue((String)"new size should be one more", (this.entry.getPropertyCount() == n + 1 ? 1 : 0) != 0);
        this.entry.remove(prop);
        Assert.assertTrue((String)"new size should be old size", (this.entry.getPropertyCount() == n ? 1 : 0) != 0);
    }

    public void testHasProp() {
        Assert.assertTrue((String)"Property testHasProp should not exist", (!this.entry.hasPropertyWithName("testHasProp") ? 1 : 0) != 0);
        SimpleEntry.Prop prop = new SimpleEntry.Prop("testHasProp", Boolean.TRUE);
        this.entry.add(prop);
        Assert.assertTrue((String)"Property testHasProp should exist", (this.entry.hasPropertyWithName("testHasProp") ? 1 : 0) != 0);
        this.entry.remove(prop);
        Assert.assertTrue((String)"Property testHasProp should not exist", (!this.entry.hasPropertyWithName("testHasProp") ? 1 : 0) != 0);
    }

    public void testModifyProp() {
        Assert.assertTrue((String)"Property testModifyProp should not exist", (!this.entry.hasPropertyWithName("testModifyProp") ? 1 : 0) != 0);
        SimpleEntry.Prop prop = new SimpleEntry.Prop("testModifyProp", "");
        this.entry.add(prop);
        Assert.assertTrue((String)"Property testModifyProp should exist", (this.entry.hasPropertyWithName("testModifyProp") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Property testModifyProp.getValue() should be empty string", (boolean)"".equals(prop.getValue()));
        prop.setValue("testModifyProp");
        this.entry.modify(prop);
        Assert.assertTrue((String)"Property testModifyProp.getValue() should be empty string", (boolean)"testModifyProp".equals(prop.getValue()));
    }

    public void testCreateProp() {
        this.emptyTest();
    }

    public void testCompareTo() {
        SimpleEntry simpleEntry = new SimpleEntry("aaa");
        SimpleEntry simpleEntry2 = new SimpleEntry("zzz");
        Assert.assertTrue((String)"aaaEntry.compareTo( aaaEntry ) should == 0", (simpleEntry.compareTo(simpleEntry) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"zzzEntry.compareTo( zzzEntry ) should == 0", (simpleEntry2.compareTo(simpleEntry2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"zzzEntry.compareTo( aaaEntry ) should < 0", (simpleEntry2.compareTo(simpleEntry) > 0 ? 1 : 0) != 0);
    }
}

