/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.util.TouchKeyboardKeyControlUtil;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamUtil;
import com.linx.touchkeyboard.util.ValidateFieldUtil;
import com.linx.touchkeyboard.util.configuration.AlertDialog;
import com.linx.touchkeyboard.util.configuration.TouchKeyboardKeyEventHandler;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationToolController
implements Initializable {
    Logger logger = LoggerFactory.getLogger(ConfigurationToolController.class);
    private KeyboardConfiguration configuration;
    private ObservableList<String> layouts = FXCollections.observableArrayList();
    private File savedFile;
    @FXML
    private BorderPane mainBorderPane;
    @FXML
    private BorderPane centerBorderPane;
    @FXML
    private TextField tfLayoutId;
    @FXML
    private TextField tfWidth;
    @FXML
    private TextField tfHeight;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private TextField tfRows;
    @FXML
    private TextField tfColumns;
    @FXML
    private TextField tfVisibleRows;
    @FXML
    private TextField tfVisibleColumns;
    @FXML
    private ListView<String> lvLayouts;
    @FXML
    private MenuItem miAddLayout;
    @FXML
    private MenuItem miRemoveLayout;
    @FXML
    private MenuItem miCopyLayout;
    @FXML
    private HBox hbInputs;
    @FXML
    private Label lbWarn;
    @FXML
    private TextField txtMinWidthButtons;
    @FXML
    private TextField txtMinHeightButtons;

    public void initialize(URL url, ResourceBundle bundle) {
        this.lvLayouts.setItems(this.layouts);
    }

    @FXML
    public void handleMiQuitAction(ActionEvent event) {
        Platform.exit();
    }

    @FXML
    public void handleCmLayoutListShowing(WindowEvent event) {
        this.miAddLayout.setDisable(this.configuration == null);
        this.miRemoveLayout.setDisable(this.lvLayouts.getSelectionModel().getSelectedIndex() <= -1);
        this.miCopyLayout.setDisable(this.lvLayouts.getSelectionModel().getSelectedIndex() <= -1);
    }

    @FXML
    public void handleMiAddLayoutAction(ActionEvent event) {
        this.logger.debug("Iniciando tratador de evento para adicionar layout de configura\u00e7\u00e3o.");
        String layoutId = "LAYOUT_" + (this.configuration.getLayouts().size() + 1);
        Layout layout = new Layout();
        layout.setId(layoutId);
        this.configuration.getLayouts().put(layoutId, layout);
        this.layouts.add((Object)layoutId);
        this.hbInputs.setDisable(false);
        this.drawLayout(layout);
        this.logger.debug("Finalizando tratador de evento para adicionar layout de configura\u00e7\u00e3o.");
    }

    @FXML
    public void handleMiRemoveLayoutAction(ActionEvent event) {
        this.logger.debug("Iniciando tratador de evento para remover layout de configura\u00e7\u00e3o.");
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        this.lvLayouts.getItems().remove(this.lvLayouts.getSelectionModel().getSelectedIndex());
        this.configuration.getLayouts().remove(layoutId);
        this.clear();
        if (this.layouts.size() == 0) {
            this.hbInputs.setDisable(true);
        }
        this.logger.debug("Finalizando tratador de evento para remover layout de configura\u00e7\u00e3o.");
    }

    @FXML
    public void handleMiCopyLayoutAction(ActionEvent event) {
        this.logger.debug("Iniciando tratador de evento para copiar layout de configura\u00e7\u00e3o.");
        String layoutId = "COPIA_DE_" + (String)this.lvLayouts.getSelectionModel().getSelectedItem() + "_" + this.configuration.getLayouts().size();
        Layout sourceLayout = this.configuration.getLayouts().get(this.lvLayouts.getSelectionModel().getSelectedItem());
        Layout layout = new Layout();
        layout.setId(layoutId);
        layout.setWidth(sourceLayout.getWidth());
        layout.setHeight(sourceLayout.getHeight());
        layout.setPosX(sourceLayout.getPosX());
        layout.setPosY(sourceLayout.getPosY());
        layout.setColumns(sourceLayout.getColumns());
        layout.setRows(sourceLayout.getRows());
        layout.setVisibleColumns(sourceLayout.getVisibleColumns());
        layout.setVisibleRows(sourceLayout.getVisibleRows());
        layout.setMinWidthButtons(sourceLayout.getMinWidthButtons());
        layout.setMinHeightButtons(sourceLayout.getMinHeightButtons());
        ArrayList<Key> layoutKeys = new ArrayList<Key>();
        for (Key key : sourceLayout.getKeys()) {
            layoutKeys.add(key.clone());
        }
        layout.setKeys(layoutKeys);
        this.configuration.getLayouts().put(layoutId, layout);
        this.layouts.add((Object)layoutId);
        this.drawLayout(layout);
        this.logger.debug("Finalizando tratador de evento para copiar layout de configura\u00e7\u00e3o.");
    }

    @FXML
    public void handleTfLayoutIdKeyReleased(KeyEvent event) {
        if (this.lvLayouts.getSelectionModel().getSelectedIndex() > -1) {
            String listId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
            int layoutIndex = this.layouts.indexOf((Object)listId);
            this.layouts.set(layoutIndex, (Object)this.tfLayoutId.getText());
            this.lvLayouts.getSelectionModel().select(layoutIndex);
            Layout layout = this.configuration.getLayouts().remove(listId);
            layout.setId(this.tfLayoutId.getText());
            this.configuration.getLayouts().put(this.tfLayoutId.getText(), layout);
        }
    }

    @FXML
    public void handleTfWidthKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfWidth.getText().equals("")) {
            layout.setWidth(Integer.parseInt(this.tfWidth.getText()));
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfHeightKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfHeight.getText().equals("")) {
            layout.setHeight(Integer.parseInt(this.tfHeight.getText()));
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfPosXKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfPosX.getText().equals("")) {
            layout.setPosX(Integer.parseInt(this.tfPosX.getText()));
        }
    }

    @FXML
    public void handleTfPosYKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfPosY.getText().equals("")) {
            layout.setPosY(Integer.parseInt(this.tfPosY.getText()));
        }
    }

    @FXML
    public void handleTfRowsKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfRows.getText().equals("")) {
            layout.setRows(Integer.parseInt(this.tfRows.getText()));
            ArrayList<Key> keysToRemove = new ArrayList<Key>();
            for (Key key : layout.getKeys()) {
                if (key.getRow() <= layout.getRows() - 1) continue;
                keysToRemove.add(key);
            }
            layout.getKeys().removeAll(keysToRemove);
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfColumnsKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfColumns.getText().equals("")) {
            layout.setColumns(Integer.parseInt(this.tfColumns.getText()));
            ArrayList<Key> keysToRemove = new ArrayList<Key>();
            for (Key key : layout.getKeys()) {
                if (key.getColumn() <= layout.getColumns() - 1) continue;
                keysToRemove.add(key);
            }
            layout.getKeys().removeAll(keysToRemove);
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfVisibleRowsKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfVisibleRows.getText().equals("")) {
            layout.setVisibleRows(Integer.parseInt(this.tfVisibleRows.getText()));
        }
    }

    @FXML
    public void handleTxtMinWidthButtonsKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.txtMinWidthButtons.getText().equals("") && ValidateFieldUtil.isDigit(this.txtMinWidthButtons.getText())) {
            layout.setMinWidthButtons(Double.parseDouble(this.txtMinWidthButtons.getText()));
        }
    }

    @FXML
    public void handleTxtMinHeightButtonsKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.txtMinHeightButtons.getText().equals("") && ValidateFieldUtil.isDigit(this.txtMinHeightButtons.getText())) {
            layout.setMinHeightButtons(Double.parseDouble(this.txtMinHeightButtons.getText()));
        }
    }

    @FXML
    public void handleTfVisibleColumnsKeyReleased(KeyEvent event) {
        String layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(layoutId);
        if (!this.tfVisibleColumns.getText().equals("")) {
            layout.setVisibleColumns(Integer.parseInt(this.tfVisibleColumns.getText()));
        }
    }

    private void drawLayout(Layout layout) {
        GridPane pane = new GridPane();
        pane.setPrefSize((double)layout.getWidth(), (double)layout.getHeight());
        pane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        pane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (int column = 0; column < layout.getColumns(); ++column) {
            for (int row = 0; row < layout.getRows(); ++row) {
                TouchKeyboardKey keyboardKey = new TouchKeyboardKey();
                Key key = new Key(row, column);
                if (layout.getKeys().contains(key)) {
                    int indexKey = layout.getKeys().indexOf(key);
                    key = layout.getKeys().get(indexKey);
                    keyboardKey.setKey(key);
                    keyboardKey.setText(key.getLabel());
                    if (!key.isVisible()) {
                        keyboardKey.setOpacity(0.3);
                    }
                } else {
                    layout.getKeys().add(key);
                    keyboardKey.setKey(new Key(row, column));
                }
                keyboardKey.getKey().setDisable(key.isDisable());
                this.configureKeyboardKey(keyboardKey, layout);
                keyboardKey.addEventHandler(ActionEvent.ACTION, new TouchKeyboardKeyEventHandler(layout, keyboardKey));
                pane.add((Node)keyboardKey, column, row);
            }
        }
        this.centerBorderPane.setCenter((Node)pane);
    }

    private void configureKeyboardKey(TouchKeyboardKey key, Layout layout) {
        GridPane.setMargin((Node)key, (Insets)new Insets(3.0, 3.0, 3.0, 3.0));
        key.setTextAlignment(TextAlignment.CENTER);
        key.setWrapText(true);
        key.setTextOverrun(OverrunStyle.CLIP);
        key.setFocusTraversable(false);
        if (key.getKey().getWidth() != null && key.getKey().getHeight() != null) {
            key.setPrefSize(key.getKey().getWidth(), key.getKey().getHeight());
        } else {
            key.setPrefSize(layout.getWidth() / layout.getColumns(), layout.getHeight() / layout.getRows());
        }
        if (!key.getKey().isValid()) {
            key.setStyle("-fx-background-color: #FF3333; -fx-background-insets: 0, 0, 1, 2;");
        } else {
            key.setStyle(null);
        }
    }

    @FXML
    public void handleLvLayoutsMouseClick(MouseEvent event) {
        String layoutId;
        if (this.configuration != null && (layoutId = (String)this.lvLayouts.getSelectionModel().getSelectedItem()) != null && this.configuration.getLayouts().get(layoutId) != null) {
            Layout layout = this.configuration.getLayout(layoutId);
            this.drawLayout(layout);
            this.tfLayoutId.setText(layout.getId());
            this.tfWidth.setText(Integer.toString(layout.getWidth()));
            this.tfHeight.setText(Integer.toString(layout.getHeight()));
            this.tfPosX.setText(Integer.toString(layout.getPosX()));
            this.tfPosY.setText(Integer.toString(layout.getPosY()));
            this.tfRows.setText(Integer.toString(layout.getRows()));
            this.tfColumns.setText(Integer.toString(layout.getColumns()));
            this.tfVisibleRows.setText(Integer.toString(layout.getVisibleRows()));
            this.tfVisibleColumns.setText(Integer.toString(layout.getVisibleColumns()));
            this.txtMinHeightButtons.setText(layout.getMinHeightButtons() != null ? Double.toString(layout.getMinHeightButtons()) : "");
            this.txtMinWidthButtons.setText(layout.getMinWidthButtons() != null ? Double.toString(layout.getMinWidthButtons()) : "");
        }
    }

    @FXML
    public void handleMiLoadFileAction(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        File configFile = fileChooser.showOpenDialog(this.mainBorderPane.getScene().getWindow());
        if (configFile != null && configFile.exists()) {
            try {
                this.configuration = TouchKeyboardXstreamUtil.loadKeyboardConfiguration(configFile);
                TouchKeyboardKeyControlUtil.loadHashControl(this.configuration);
                this.savedFile = configFile;
                Set<String> keySet = this.configuration.getLayouts().keySet();
                this.layouts.clear();
                this.layouts.addAll(keySet);
                FXCollections.sort(this.layouts);
                this.hbInputs.setDisable(false);
                this.lvLayouts.setDisable(false);
                this.setLbWarn();
            }
            catch (KeyboardConfigException e) {
                new AlertDialog(this.getPrimaryStage(), e.getMessage()).showAndWait();
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @FXML
    public void handleMiSaveFileAction(ActionEvent event) {
        if (this.savedFile != null) {
            try {
                TouchKeyboardXstreamUtil.saveKeyboardConfiguration(this.configuration, this.savedFile);
                TouchKeyboardKeyControlUtil.reLoadHashControl(this.configuration);
            }
            catch (KeyboardConfigException e) {
                new AlertDialog(this.getPrimaryStage(), e.getMessage()).showAndWait();
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            this.handleMiSaveAsFileAction(event);
        }
        this.setLbWarn();
    }

    @FXML
    public void handleMiSaveAsFileAction(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        this.savedFile = fileChooser.showSaveDialog(this.mainBorderPane.getScene().getWindow());
        if (this.savedFile != null) {
            try {
                TouchKeyboardXstreamUtil.saveKeyboardConfiguration(this.configuration, this.savedFile);
            }
            catch (KeyboardConfigException e) {
                new AlertDialog(this.getPrimaryStage(), e.getMessage());
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.setLbWarn();
    }

    @FXML
    public void handleMiNewFileAction(ActionEvent event) {
        this.configuration = new KeyboardConfiguration();
        this.layouts = FXCollections.observableArrayList();
        this.lvLayouts.setItems(this.layouts);
        this.clear();
        this.tfLayoutId.requestFocus();
        this.lvLayouts.setDisable(false);
    }

    private void clear() {
        this.tfLayoutId.setText("");
        this.tfWidth.setText("");
        this.tfHeight.setText("");
        this.tfPosX.setText("");
        this.tfPosY.setText("");
        this.tfRows.setText("");
        this.tfColumns.setText("");
        this.tfVisibleRows.setText("");
        this.tfVisibleColumns.setText("");
        this.centerBorderPane.setCenter(null);
    }

    private Stage getPrimaryStage() {
        return (Stage)this.mainBorderPane.getScene().getWindow();
    }

    private void setLbWarn() {
        this.lbWarn.setText("Teclas Inv\u00e1lidas (" + this.configuration.amountInvalidKeys() + " items)");
    }

    @FXML
    public void help() {
        String linhasSeparadora = "----------------------------------------------------------------------------\n";
        String messageHelp = "";
        messageHelp = messageHelp + "Ajuda da Ferramente de Configura\u00e7\u00e3o do Touch Keyboard\n\n";
        messageHelp = messageHelp + "Menu 'Arquivo'\n";
        messageHelp = messageHelp + linhasSeparadora + "\n";
        messageHelp = messageHelp + "1. Nova Configura\u00e7\u00e3o: Habilita ferramenta para cria\u00e7\u00e3o de novos Layouts de Teclado.\n";
        messageHelp = messageHelp + "2. Abrir: Carrega uma configura\u00e7\u00e3o existente, exibindo os respectivos layouts na \u00e1rea de listagem.\n";
        messageHelp = messageHelp + "3. Salvar: Salva as modifica\u00e7\u00f5es realizadas na configura\u00e7\u00e3o de layouts carregada pela ferramenta. \n";
        messageHelp = messageHelp + "4. Salvar Como: Cria nova configura\u00e7\u00e3o a partir das modifica\u00e7\u00f5es realizadas na configura\u00e7\u00e3o de layouts carregada pela ferramenta.\n\n";
        messageHelp = messageHelp + "Passos para Criar Layout\n";
        messageHelp = messageHelp + linhasSeparadora + "\n";
        messageHelp = messageHelp + "Passo 1. Ap\u00f3s iniciar 'Nova Configura\u00e7\u00e3o', clicar com bot\u00e3o direito do mouse na \u00e1rea de listagem da tela e selecionar op\u00e7\u00e3o 'Novo Layout'\n";
        messageHelp = messageHelp + "Passo 2. Infomar as configura\u00e7\u00f5es do teclado na parte superior da tela (Largura, altura, posicionamento, etc).\n\n";
        messageHelp = messageHelp + "Passos para Editar Layout\n";
        messageHelp = messageHelp + linhasSeparadora + "\n";
        messageHelp = messageHelp + "Passo 1. Ap\u00f3s 'Abrir' configura\u00e7\u00e3o, selecionar layout na listagem exibida na parte lateral esquerda da tela.\n";
        messageHelp = messageHelp + "Passo 2. Alterar configura\u00e7\u00f5es do teclado na parte superior da tela (Largura, altura, posicionamento, etc).\n\n";
        messageHelp = messageHelp + "Observa\u00e7\u00e3o. Para criar um layout baseado em outro como modelo,  basta selecion\u00e1-lo na \u00e1rea de listagem, clicar com o bot\u00e3o direito \n";
        messageHelp = messageHelp + "do mouse e selecionar a op\u00e7\u00e3o 'Copiar Layout'.\n\n";
        messageHelp = messageHelp + "Passos para Editar Teclas\n";
        messageHelp = messageHelp + linhasSeparadora + "\n";
        messageHelp = messageHelp + "Passo 1. Ap\u00f3s a cria\u00e7\u00e3o ou escolha do layout desejado, um teclado ser\u00e1 exibido pela ferramenta.\n";
        messageHelp = messageHelp + "Passo 2. Clicar na tecla desejada e alterar propriedades na tela popup exibida.\n\n";
        messageHelp = messageHelp + "Detalhamento dos campos da 'Tela de Edi\u00e7\u00e3o de Teclas':\n";
        messageHelp = messageHelp + "\t- ID Tecla: Define identificador da tecla. Este valor deve ser \u00fanico em todos os layouts da configura\u00e7\u00e3o.\n";
        messageHelp = messageHelp + "\t- Desabilitado: Define se bot\u00e3o, quando renderizado, n\u00e3o ser\u00e1 habilitado, n\u00e3o podendo ter nenhuma a\u00e7\u00e3o associada.\n";
        messageHelp = messageHelp + "\t- Vis\u00edvel: Define se bot\u00e3o ser\u00e1 ou n\u00e3o exibido na tela. Mesmo n\u00e3o renderizado, poder\u00e1 ter a\u00e7\u00f5es associadas.\n";
        messageHelp = messageHelp + "\t- R\u00f3tulo: Define o Label da tela a ser exibido no Teclado Touch. Ex.: VENDA, CANCELAMENTO.\n";
        messageHelp = messageHelp + "\t- C\u00f3digo ASC: Define o c\u00f3digo ASC que o Teclado Touch deve enviar \u00e0s aplica\u00e7\u00f5es. Ex.: Tecla VENDA vai repassa valor 10.\n";
        messageHelp = messageHelp + "\t- Caracter: Define a tecla que o Teclado Touch deve enviar \u00e0s aplica\u00e7\u00f5es. Ex.: Teclado Num\u00e9rico deve enviar os n\u00fameros.\n";
        messageHelp = messageHelp + "\t- ID Estilo (CSS): Identificador do estilo definido em arquivo CSS para alterar apresenta\u00e7\u00e3o da tecla.\n";
        messageHelp = messageHelp + "\t- Tipo: Define comportamento da tecla no Teclado Touch, conforme detalhamento abaixo:\n";
        messageHelp = messageHelp + "\t        CHAR - Repassam o caracter configurado para aplica\u00e7\u00e3o. Ex.: Teclas Num\u00e9ricas.\n";
        messageHelp = messageHelp + "\t        FUNCTION - Repassam um valor l\u00f3gico para a aplica\u00e7\u00e3o executar uma a\u00e7\u00e3o. Ex.: Executar um fluxo de opera\u00e7\u00f5es.\n";
        messageHelp = messageHelp + "\t        BACKWARD - Tecla de navega\u00e7\u00e3o da ferramenta utilizada para retroceder a pagina\u00e7\u00e3o do teclado touch.\n";
        messageHelp = messageHelp + "\t        FORWARD - Tecla de navega\u00e7\u00e3o da ferramenta utilizada para avan\u00e7ar a pagina\u00e7\u00e3o do teclado touch.\n";
        new AlertDialog(this.getPrimaryStage(), messageHelp, AlertDialog.OPERATION_MODE_TEXT_AREA).showAndWait();
    }
}

