/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextAreaBuilder;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class AlertDialog
extends Stage {
    final Stage self = this;
    List<Node> childrenNodes = new ArrayList<Node>();
    public static int OPERATION_MODE_LABEL = 1;
    public static int OPERATION_MODE_TEXT_AREA = 2;
    private int operationMode = OPERATION_MODE_LABEL;
    private final String LABEL_DEFAULT_CONFIRMATION_BUTTON = "Ok";
    private final String LABEL_DEFAULT_WARNING_MESSAGE = "Por favor, adicione uma mensagem de aviso.";

    public AlertDialog(Stage primaryStage, String warningMessage) {
        super(StageStyle.TRANSPARENT);
        this.initialize(primaryStage, warningMessage, "Ok");
    }

    public AlertDialog(Stage primaryStage, String warningMessage, int operationMode) {
        super(StageStyle.TRANSPARENT);
        this.operationMode = operationMode;
        this.initialize(primaryStage, warningMessage, "Ok");
    }

    public AlertDialog(Stage primaryStage, String warningMessage, String labelButton) {
        super(StageStyle.TRANSPARENT);
        this.initialize(primaryStage, warningMessage, labelButton);
    }

    public AlertDialog(Stage primaryStage, ArrayList<String> warningMessages, String labelButton) {
        super(StageStyle.TRANSPARENT);
        String warningMessage = "";
        for (String string : warningMessages) {
            warningMessage = warningMessage + string + "\n\n";
        }
        this.initialize(primaryStage, warningMessage, labelButton);
    }

    private void initialize(Stage primaryStage, String warningMessage, String labelButton) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner((Window)primaryStage);
        primaryStage.getScene().getRoot().setEffect((Effect)new GaussianBlur());
        if (this.operationMode == OPERATION_MODE_LABEL) {
            this.childrenNodes.add((Node)this.configureWarningMessagingAsLabel(warningMessage));
        } else if (this.operationMode == OPERATION_MODE_TEXT_AREA) {
            this.childrenNodes.add((Node)this.configureWarningMessagingAsTextArea(warningMessage));
        }
        this.childrenNodes.add((Node)this.configureConfirmButton(labelButton));
    }

    private Label configureWarningMessagingAsLabel(String warningMessage) {
        if (warningMessage == null) {
            warningMessage = "Por favor, adicione uma mensagem de aviso.";
        }
        return ((LabelBuilder)LabelBuilder.create().text(warningMessage)).build();
    }

    private TextArea configureWarningMessagingAsTextArea(String warningMessage) {
        if (warningMessage == null) {
            warningMessage = "Por favor, adicione uma mensagem de aviso.";
        }
        TextArea textArea = TextAreaBuilder.create().build();
        textArea.setPrefSize(650.0, 450.0);
        textArea.setText(warningMessage);
        return textArea;
    }

    private Button configureConfirmButton(String label) {
        if (label == null || label.trim().equalsIgnoreCase("")) {
            label = "Ok";
        }
        Button acceptBtn = ((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text(label)).defaultButton(true).onAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                AlertDialog.this.getOwner().getScene().getRoot().setEffect(null);
                AlertDialog.this.self.close();
            }
        })).build();
        return acceptBtn;
    }

    private void configureAlertDialog() {
        this.setScene(new Scene((Parent)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().styleClass(new String[]{"modal-dialog"})).children(this.childrenNodes)).build(), (Paint)Color.TRANSPARENT));
        this.getScene().getStylesheets().add((Object)ClassLoader.getSystemClassLoader().getResource("resource/alertdialog.css").toExternalForm());
        Parent root = this.getScene().getRoot();
        final PositionControl dragDelta = new PositionControl();
        root.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                dragDelta.x = AlertDialog.this.self.getX() - mouseEvent.getScreenX();
                dragDelta.y = AlertDialog.this.self.getY() - mouseEvent.getScreenY();
            }
        });
        root.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                AlertDialog.this.self.setX(mouseEvent.getScreenX() + dragDelta.x);
                AlertDialog.this.self.setY(mouseEvent.getScreenY() + dragDelta.y);
            }
        });
    }

    public void showAndWait() {
        this.configureAlertDialog();
        super.showAndWait();
    }

    class PositionControl {
        double x;
        double y;

        PositionControl() {
        }
    }
}

