/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateFieldUtil {
    public static boolean isCpf(String cpf) {
        cpf = cpf.replace(".", "");
        cpf = cpf.replace("-", "");
        try {
            Long.parseLong(cpf);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int d2 = 0;
        int d1 = 0;
        int resto = 0;
        int digito2 = 0;
        int digito1 = 0;
        for (int nCount = 1; nCount < cpf.length() - 1; ++nCount) {
            int digitoCPF = Integer.valueOf(cpf.substring(nCount - 1, nCount));
            d1 += (11 - nCount) * digitoCPF;
            d2 += (12 - nCount) * digitoCPF;
        }
        resto = d1 % 11;
        digito1 = resto < 2 ? 0 : 11 - resto;
        resto = (d2 += 2 * digito1) % 11;
        digito2 = resto < 2 ? 0 : 11 - resto;
        String nDigVerific = cpf.substring(cpf.length() - 2, cpf.length());
        String nDigResult = String.valueOf(digito1) + String.valueOf(digito2);
        return nDigVerific.equals(nDigResult);
    }

    public static boolean isCnpj(String cnpj) {
        cnpj = cnpj.replace(".", "");
        cnpj = cnpj.replace("-", "");
        cnpj = cnpj.replace("/", "");
        try {
            Long.parseLong(cnpj);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (cnpj.equals("00000000000000") || cnpj.equals("11111111111111") || cnpj.equals("22222222222222") || cnpj.equals("33333333333333") || cnpj.equals("44444444444444") || cnpj.equals("55555555555555") || cnpj.equals("66666666666666") || cnpj.equals("77777777777777") || cnpj.equals("88888888888888") || cnpj.equals("99999999999999") || cnpj.length() != 14) {
            return false;
        }
        try {
            int num;
            int i;
            int sm = 0;
            int peso = 2;
            for (i = 11; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int r = sm % 11;
            char dig13 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            sm = 0;
            peso = 2;
            for (i = 12; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            r = sm % 11;
            char dig14 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            return dig13 == cnpj.charAt(12) && dig14 == cnpj.charAt(13);
        }
        catch (Throwable erro) {
            return false;
        }
    }

    public static boolean isDateValid(String date) {
        String DATE_PATTERN = "(0?[1-9]|[12][0-9]|3[01])/(0?[1-9]|1[012])/((19|20)\\d\\d)";
        Pattern pattern = Pattern.compile(DATE_PATTERN);
        Matcher matcher = pattern.matcher(date);
        if (matcher.matches()) {
            matcher.reset();
            if (matcher.find()) {
                String day = matcher.group(1);
                String month = matcher.group(2);
                int year = Integer.parseInt(matcher.group(3));
                if (day.equals("31") && (month.equals("4") || month.equals("6") || month.equals("9") || month.equals("11") || month.equals("04") || month.equals("06") || month.equals("09"))) {
                    return false;
                }
                if (month.equals("2") || month.equals("02")) {
                    if (year % 4 == 0) {
                        return !day.equals("30") && !day.equals("31");
                    }
                    return !day.equals("29") && !day.equals("30") && !day.equals("31");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isDigit(String s) {
        return s.matches("[0-9]*");
    }
}

