/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util;

import com.linx.touchkeyboard.util.ValidateFieldUtil;
import java.util.HashSet;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class MaskFieldUtil {
    public static void addMask(final TextField tf, final String mask) {
        tf.setText(mask);
        MaskFieldUtil.addTextLimiter(tf, mask.length());
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                String value = MaskFieldUtil.stripMask(tf.getText(), mask);
                tf.setText(MaskFieldUtil.merge(value, mask));
            }
        });
        tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                int caretPosition = tf.getCaretPosition();
                if (caretPosition < mask.length() - 1 && mask.charAt(caretPosition) != ' ' && e.getCode() != KeyCode.BACK_SPACE && e.getCode() != KeyCode.LEFT) {
                    tf.positionCaret(caretPosition + 1);
                }
            }
        });
    }

    public static void addMaskCPF(final TextField tf, final String mask) {
        tf.setText(mask);
        MaskFieldUtil.addTextLimiter(tf, mask.length());
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                String value = MaskFieldUtil.stripMask(tf.getText(), mask);
                tf.setText(MaskFieldUtil.merge(value, mask));
                if (value.replaceAll(" ", "").length() >= 11 && !ValidateFieldUtil.isCpf(tf.getText())) {
                    System.out.println("CPF Inv\u00e1lido. Tecle [VOLTA]");
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            tf.requestFocus();
                        }
                    });
                }
            }
        });
        tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                int caretPosition = tf.getCaretPosition();
                if (caretPosition < mask.length() - 1 && mask.charAt(caretPosition) != ' ' && e.getCode() != KeyCode.BACK_SPACE && e.getCode() != KeyCode.LEFT) {
                    tf.positionCaret(caretPosition + 1);
                }
            }
        });
    }

    public static void addMaskCNPJ(final TextField tf, final String mask) {
        tf.setText(mask);
        MaskFieldUtil.addTextLimiter(tf, mask.length());
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                String value = MaskFieldUtil.stripMask(tf.getText(), mask);
                tf.setText(MaskFieldUtil.merge(value, mask));
                if (value.replaceAll(" ", "").length() >= 14 && !ValidateFieldUtil.isCnpj(tf.getText())) {
                    System.out.println("CNPJ Inv\u00e1lido. Tecle [VOLTA]");
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            tf.requestFocus();
                        }
                    });
                }
            }
        });
        tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                int caretPosition = tf.getCaretPosition();
                if (caretPosition < mask.length() - 1 && mask.charAt(caretPosition) != ' ' && e.getCode() != KeyCode.BACK_SPACE && e.getCode() != KeyCode.LEFT) {
                    tf.positionCaret(caretPosition + 1);
                }
            }
        });
    }

    public static void addMaskDate(final TextField tf, final String mask) {
        tf.setText(mask);
        MaskFieldUtil.addTextLimiter(tf, mask.length());
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                String value = MaskFieldUtil.stripMask(tf.getText(), mask);
                tf.setText(MaskFieldUtil.merge(value, mask));
                if (value.replaceAll(" ", "").length() >= 8 && !ValidateFieldUtil.isDateValid(tf.getText())) {
                    System.out.println("Data Inv\u00e1lida! Favor informar data corretamente.  Tecle [VOLTA]");
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            tf.requestFocus();
                        }
                    });
                }
            }
        });
        tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                int caretPosition = tf.getCaretPosition();
                if (caretPosition < mask.length() - 1 && mask.charAt(caretPosition) != ' ' && e.getCode() != KeyCode.BACK_SPACE && e.getCode() != KeyCode.LEFT) {
                    tf.positionCaret(caretPosition + 1);
                }
            }
        });
    }

    public static void addMaskInteiro(final TextField tf, int tamanho) {
        MaskFieldUtil.addTextLimiter(tf, tamanho);
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                if (!newValue.equals("") && ValidateFieldUtil.isDigit(newValue)) {
                    tf.setText(tf.getText());
                } else if (tf.getText().length() > 0) {
                    tf.setText(tf.getText().substring(0, tf.getText().length() - 1));
                }
            }
        });
    }

    static String merge(String value, String mask) {
        StringBuilder sb = new StringBuilder(mask);
        int k = 0;
        for (int i = 0; i < mask.length(); ++i) {
            if (mask.charAt(i) != ' ' || k >= value.length()) continue;
            sb.setCharAt(i, value.charAt(k));
            ++k;
        }
        return sb.toString();
    }

    static String stripMask(String text, String mask) {
        HashSet<String> maskChars = new HashSet<String>();
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            if (c == ' ') continue;
            maskChars.add(String.valueOf(c));
        }
        for (String c : maskChars) {
            text = text.replace(c, "");
        }
        return text;
    }

    public static void addTextLimiter(final TextField tf, final int maxLength) {
        tf.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                if (tf.getText().length() > maxLength) {
                    String s = tf.getText().substring(0, maxLength);
                    tf.setText(s);
                }
            }
        });
    }

    public static void dateField(final TextField textField) {
        MaskFieldUtil.addTextLimiter(textField, 10);
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue.intValue() < 11) {
                    String value = textField.getText();
                    value = value.replaceAll("[^0-9]", "");
                    value = value.replaceFirst("(\\d{2})(\\d)", "$1/$2");
                    value = value.replaceFirst("(\\d{2})\\/(\\d{2})(\\d)", "$1/$2/$3");
                    textField.setText(value);
                }
            }
        });
    }

    public static void monetaryField(final TextField textField) {
        textField.lengthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                String value = textField.getText();
                value = value.replaceAll("[^0-9]", "");
                value = value.replaceAll("([0-9]{1})([0-9]{14})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{11})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{8})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{5})$", "$1.$2");
                value = value.replaceAll("([0-9]{1})([0-9]{2})$", "$1,$2");
                textField.setText(value);
                textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observableValue, String oldValue, String newValue) {
                        if (newValue.length() > 17) {
                            textField.setText(oldValue);
                        }
                    }
                });
            }
        });
        textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean fieldChange) {
                int length;
                if (!fieldChange.booleanValue() && (length = textField.getText().length()) > 0 && length < 3) {
                    textField.setText(textField.getText() + "00");
                }
            }
        });
    }
}

