/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util;

import java.lang.reflect.Field;
import javafx.scene.input.KeyCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCodeASCIIUtil {
    private static Field codeField = null;
    private static String CODE_FIELD_NAME = "code";
    private static Logger logger = LoggerFactory.getLogger((String)KeyCodeASCIIUtil.class.getName());

    public static int getASCII(KeyCode keyCode) {
        int asc = 0;
        try {
            if (codeField == null) {
                codeField = keyCode.getClass().getDeclaredField(CODE_FIELD_NAME);
                codeField.setAccessible(true);
            }
            asc = codeField.getInt(keyCode);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.error("Erro tentando recuperar o c\u00f3digo ASC da tecla pressionada!", (Throwable)e);
        }
        return asc;
    }

    public static KeyCode getKeyCode(int asc) {
        KeyCode result = null;
        KeyCode[] keyCodeValues = KeyCode.values();
        for (int i = 0; i < keyCodeValues.length; ++i) {
            KeyCode keyCode = keyCodeValues[i];
            if (KeyCodeASCIIUtil.getASCII(keyCode) != asc) continue;
            result = keyCode;
            break;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println("C\u00f3digo ASC II para " + KeyCode.A + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.A));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.E + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.E));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.SCROLL_LOCK + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.SCROLL_LOCK));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.ALT + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.ALT));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.ENTER + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.ENTER));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.ESCAPE + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.ESCAPE));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.CONTROL + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.CONTROL));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.AT + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.AT));
        System.out.println("C\u00f3digo ASC II para " + KeyCode.BACK_SPACE + " \u00e9 " + KeyCodeASCIIUtil.getASCII(KeyCode.BACK_SPACE));
    }
}

