/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.renderer;

import com.linx.touchkeyboard.PopupKeyboard;
import com.linx.touchkeyboard.TouchKeyboard;
import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyType;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.OverrunStyle;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.StageBuilder;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardRenderer
implements Runnable {
    Stage primaryStage;
    private KeyboardConfiguration configuration;
    private JFXPanel fxPanel = new JFXPanel();
    private String currentLayoutId;
    private Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);
    private final TouchKeyboard keyboard;
    private int currentPageIndex = 0;
    private Pane keyboardArea;
    private static boolean popupNewStageMode = false;
    private int coordenadaX = 0;
    private int coordenadaY = 0;

    public TouchKeyboardRenderer(KeyboardConfiguration configuration, TouchKeyboard keyboard, boolean popupNewStageModeValue) {
        this.configuration = configuration;
        this.keyboard = keyboard;
        popupNewStageMode = popupNewStageModeValue;
    }

    public TouchKeyboardRenderer(KeyboardConfiguration configuration) {
        this.configuration = configuration;
        this.keyboard = null;
    }

    @Override
    public void run() {
        this.primaryStage = StageBuilder.create().build();
        this.drawLayout(this.getCoordenadaX(), this.getCoordenadaY());
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public Stage getPrimaryStage(int x, int y) {
        this.primaryStage.setX((double)x);
        this.primaryStage.setY((double)y);
        return this.primaryStage;
    }

    public void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    public KeyboardConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KeyboardConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setLayout(String layoutId) {
        if (layoutId != null) {
            this.currentLayoutId = layoutId;
        }
    }

    public String getLayout() {
        return this.currentLayoutId;
    }

    public void drawLayout(int x, int y) {
        Layout layout = this.configuration.getLayout(this.currentLayoutId);
        if (layout != null) {
            this.fxPanel.setSize(layout.getWidth(), layout.getHeight());
            this.fxPanel.setLocation(0, 0);
            Pane keyboardPages = this.getLayoutAsGridPane();
            if (keyboardPages != null && keyboardPages.getChildren() != null && keyboardPages.getChildren().size() > 0) {
                GridPane[] layoutPages = new GridPane[keyboardPages.getChildren().size()];
                Iterator it = keyboardPages.getChildren().iterator();
                int posicao = 0;
                while (it.hasNext()) {
                    Node node = (Node)it.next();
                    layoutPages[posicao] = (GridPane)node;
                    ++posicao;
                }
                layoutPages[this.currentPageIndex].toFront();
                Scene scene = new Scene((Parent)keyboardPages, (double)layout.getWidth(), (double)layout.getHeight(), (Paint)Color.TRANSPARENT);
                scene.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        TouchKeyboardRenderer.this.keyboard.handleKeyEvent(event);
                    }
                });
                boolean cssParamOK = false;
                try {
                    if (this.configuration.getStyleFilePath() != null && !this.configuration.getStyleFilePath().trim().equalsIgnoreCase("")) {
                        this.logger.debug("Utilizando CSS parametrizado...");
                        scene.getStylesheets().add((Object)ClassLoader.getSystemResource(this.configuration.getStyleFilePath()).toExternalForm());
                        cssParamOK = true;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Erro carregando arquivo de estilo!");
                }
                if (!cssParamOK) {
                    this.logger.debug("Nenhum estilo foi definido, utilizando CSS padro.");
                    URL url = this.getClass().getClassLoader().getResource("resource/stylesheet.css");
                    if (url != null) {
                        scene.getStylesheets().add((Object)url.toString());
                    }
                }
                if (this.primaryStage != null) {
                    if (this.keyboard.isMousePointerVisible()) {
                        scene.setCursor(Cursor.DEFAULT);
                    } else {
                        scene.setCursor(Cursor.NONE);
                    }
                    this.primaryStage.setScene(scene);
                    if (x > 0 || y > 0) {
                        this.primaryStage.setX((double)x);
                        this.primaryStage.setY((double)y);
                    } else if (this.getCoordenadaX() > 0 || this.getCoordenadaY() > 0) {
                        this.primaryStage.setX((double)this.getCoordenadaX());
                        this.primaryStage.setY((double)this.getCoordenadaY());
                    }
                    this.primaryStage.initStyle(StageStyle.TRANSPARENT);
                    this.primaryStage.show();
                }
            }
        } else {
            this.logger.debug("Nenhum elemento ser renderizado. Layout atual: " + layout);
        }
    }

    public Pane getLayoutAsPane(String layoutId) {
        VBox keyboardArea = null;
        Layout layout = this.configuration.getLayout(layoutId);
        if (layout != null) {
            keyboardArea = new VBox();
            keyboardArea.setPrefWidth(-1.0);
            keyboardArea.setPrefHeight(-1.0);
            keyboardArea.setFillWidth(true);
            keyboardArea.setAlignment(Pos.CENTER);
            keyboardArea.setSpacing(7.0);
            TouchKeyboardKey[][] keyboardKeys = new TouchKeyboardKey[layout.getRows()][layout.getColumns()];
            for (int row = 0; row < layout.getRows(); ++row) {
                HBox keyboardRow = new HBox();
                keyboardRow.setSpacing(7.0);
                keyboardRow.setPrefWidth(-1.0);
                keyboardRow.setPrefHeight(-1.0);
                keyboardRow.setFillHeight(true);
                keyboardRow.setAlignment(Pos.CENTER);
                for (int column = 0; column < layout.getColumns(); ++column) {
                    TouchKeyboardKey keyboardKey = new TouchKeyboardKey(this.keyboard);
                    keyboardKey.setTextAlignment(TextAlignment.CENTER);
                    keyboardKey.setWrapText(true);
                    keyboardKey.setTextOverrun(OverrunStyle.CLIP);
                    keyboardKey.setFocusTraversable(false);
                    keyboardKey.setAlignment(Pos.CENTER);
                    if (!keyboardKey.isVisible()) continue;
                    keyboardRow.getChildren().add((Object)keyboardKey);
                    keyboardKeys[row][column] = keyboardKey;
                }
                keyboardArea.getChildren().add((Object)keyboardRow);
            }
            block8: for (Key key : layout.getKeys()) {
                final TouchKeyboardKey keyboardKey = keyboardKeys[key.getRow()][key.getColumn()];
                if (!key.isVisible()) continue;
                keyboardKey.setKey(key);
                keyboardKey.setId(key.getId());
                keyboardKey.setStyle("-fx-background-color: #FFFFFF; -fx-border-width: 1px; -fx-border-radius: 5; -fx-border-style: solid; -fx-border-color: #ffffff; -fx-font-family: Arial; -fx-font-size: 14px; -fx-text-fill: #000000; -fx-font-weight: normal; -fx-effect: null;");
                keyboardKey.setText(key.getLabel());
                keyboardKey.setVisible(key.isVisible());
                keyboardKey.setDisable(key.isDisable());
                if (keyboardKey.getKey().getWidth() != null && keyboardKey.getKey().getHeight() != null) {
                    keyboardKey.setMinSize(keyboardKey.getKey().getWidth(), keyboardKey.getKey().getHeight());
                } else if (layout.getMinHeightButtons() != null && layout.getMinWidthButtons() != null) {
                    keyboardKey.setMinSize(layout.getMinWidthButtons(), layout.getMinHeightButtons());
                } else {
                    keyboardKey.setPrefSize(-1.0, -1.0);
                }
                keyboardKey.addEventHandler(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent mouseEvent) {
                        if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                            keyboardKey.setStyle("-fx-background-color: #acb3bd; -fx-border-width: 1px; -fx-border-radius: 5; -fx-border-style: solid; -fx-border-color: #acb3bd; -fx-font-family: Arial; -fx-font-size: 14px; -fx-text-fill: #000000; -fx-font-weight: normal; -fx-effect: null;");
                        } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                            keyboardKey.setStyle("-fx-background-color: #FFFFFF; -fx-border-width: 1px; -fx-border-radius: 5; -fx-border-style: solid; -fx-border-color: #ffffff; -fx-font-family: Arial; -fx-font-size: 14px; -fx-text-fill: #000000; -fx-font-weight: normal; -fx-effect: null;");
                        }
                        TouchKeyboardRenderer.this.logger.debug("Key: " + ((TouchKeyboardKey)((Object)mouseEvent.getSource())).getText() + " touched...");
                        mouseEvent.consume();
                    }
                });
                switch (key.getType()) {
                    case CAPSLOCK: {
                        keyboardKey.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        TouchKeyboardRenderer.this.changeLayoutAlfaNumeric(TouchKeyboardRenderer.this.currentLayoutId);
                                    }
                                });
                            }
                        });
                        continue block8;
                    }
                    case SWITCH: {
                        keyboardKey.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        TouchKeyboardRenderer.this.switchLayoutAlfaNumeric(TouchKeyboardRenderer.this.currentLayoutId);
                                    }
                                });
                            }
                        });
                        continue block8;
                    }
                    case CLOSE: {
                        keyboardKey.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (popupNewStageMode) {
                                            PopupKeyboard.closePopupKeyboard();
                                        } else {
                                            TouchKeyboard.closePopupKeyboard();
                                        }
                                    }
                                });
                            }
                        });
                        continue block8;
                    }
                    case ENTER: {
                        keyboardKey.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent event) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (popupNewStageMode) {
                                            PopupKeyboard.closePopupKeyboard();
                                        } else {
                                            TouchKeyboard.closePopupKeyboard();
                                            keyboardKey.initializeEventHandlers();
                                        }
                                    }
                                });
                            }
                        });
                    }
                }
                if (popupNewStageMode) continue;
                keyboardKey.initializeEventHandlers();
            }
        } else {
            this.logger.debug("Nenhum elemento ser recuperado. Layout atual: " + layout);
        }
        this.removeTrashButtonsLayout(keyboardArea);
        return keyboardArea;
    }

    private void removeTrashButtonsLayout(VBox keyboardArea) {
        for (Node hbox : keyboardArea.getChildren()) {
            final HBox hboxRow = (HBox)hbox;
            for (final Node keyButton : hboxRow.getChildren()) {
                if (((TouchKeyboardKey)keyButton).getKey() != null && ((TouchKeyboardKey)keyButton).isVisible()) continue;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        hboxRow.getChildren().remove((Object)keyButton);
                    }
                });
            }
        }
    }

    public Pane getLayoutAsGridPane(String layoutId) {
        Layout layout = this.configuration.getLayout(layoutId);
        this.keyboardArea = null;
        if (layout != null) {
            if (this.keyboardArea == null) {
                this.keyboardArea = new Pane();
                this.keyboardArea.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        TouchKeyboardRenderer.this.keyboard.handleKeyEvent(event);
                    }
                });
            } else {
                this.keyboardArea.getChildren().clear();
            }
            RowConstraints rowConstraint = new RowConstraints();
            rowConstraint.setVgrow(Priority.SOMETIMES);
            ColumnConstraints columnConstraint = new ColumnConstraints();
            columnConstraint.setHgrow(Priority.SOMETIMES);
            int pages = 1;
            pages = new BigDecimal(layout.getColumns() / layout.getVisibleColumns(), new MathContext(2, RoundingMode.UP)).intValue();
            final GridPane[] layoutPages = new GridPane[pages];
            TouchKeyboardKey[][] keyboardKeys = new TouchKeyboardKey[layout.getRows()][layout.getColumns()];
            for (int column = 0; column < layout.getColumns(); ++column) {
                GridPane keyboardPage = null;
                int pageIndex = new BigDecimal(column / layout.getVisibleColumns(), new MathContext(2, RoundingMode.UP)).intValue();
                if (pageIndex < this.keyboardArea.getChildren().size()) {
                    keyboardPage = (GridPane)this.keyboardArea.getChildren().get(pageIndex);
                } else {
                    keyboardPage = new GridPane();
                    keyboardPage.setGridLinesVisible(false);
                    keyboardPage.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                    keyboardPage.setPrefSize((double)layout.getWidth(), (double)layout.getHeight());
                    keyboardPage.getRowConstraints().add((Object)rowConstraint);
                    keyboardPage.getColumnConstraints().add((Object)columnConstraint);
                    this.keyboardArea.getChildren().add((Object)keyboardPage);
                    layoutPages[pageIndex] = keyboardPage;
                }
                for (int row = 0; row < layout.getRows(); ++row) {
                    TouchKeyboardKey keyboardKey = new TouchKeyboardKey(this.keyboard);
                    keyboardKey.setTextAlignment(TextAlignment.CENTER);
                    keyboardKey.setWrapText(true);
                    keyboardKey.setTextOverrun(OverrunStyle.CLIP);
                    keyboardKey.setFocusTraversable(false);
                    keyboardKey.setPrefSize(layout.getWidth() / layout.getVisibleColumns(), layout.getHeight() / layout.getVisibleRows());
                    keyboardPage.add((Node)keyboardKey, column, row);
                    GridPane.setMargin((Node)keyboardKey, (Insets)new Insets(3.0, 3.0, 3.0, 3.0));
                    keyboardKeys[row][column] = keyboardKey;
                }
            }
            block6: for (Key key : layout.getKeys()) {
                final TouchKeyboardKey keyboardKey = keyboardKeys[key.getRow()][key.getColumn()];
                keyboardKey.setKey(key);
                keyboardKey.setId(key.getId());
                keyboardKey.setStyle(key.getStyleId());
                keyboardKey.setText(key.getLabel());
                keyboardKey.setVisible(key.isVisible());
                keyboardKey.setDisable(key.isDisable());
                if (key.isDisable()) continue;
                switch (key.getType()) {
                    case FORWARD: {
                        keyboardKey.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                TouchKeyboardRenderer.this.navigateToPage(keyboardKey.getKey().getType(), layoutPages);
                            }
                        });
                        continue block6;
                    }
                    case BACKWARD: {
                        keyboardKey.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                TouchKeyboardRenderer.this.navigateToPage(keyboardKey.getKey().getType(), layoutPages);
                            }
                        });
                        continue block6;
                    }
                }
                keyboardKey.initializeEventHandlers();
            }
            layoutPages[0].toFront();
            this.currentPageIndex = 0;
        } else {
            this.logger.debug("Nenhum elemento ser recuperado. Layout atual: " + layout);
        }
        return this.keyboardArea;
    }

    public Pane getLayoutAsGridPane() {
        return this.getLayoutAsGridPane(this.currentLayoutId);
    }

    public Pane getLayoutAsPane() {
        return this.getLayoutAsPane(this.currentLayoutId);
    }

    public Button getKeyAsButton(String layoutId, String keyId) {
        TouchKeyboardKey button = null;
        Layout layout = this.configuration.getLayout(layoutId);
        if (layout != null) {
            for (Key key : layout.getKeys()) {
                if (key != null && key.getId() != null && key.getId().equalsIgnoreCase(keyId)) {
                    TouchKeyboardKey keyboardKey = new TouchKeyboardKey(this.keyboard);
                    keyboardKey.setWrapText(true);
                    keyboardKey.setTextAlignment(TextAlignment.CENTER);
                    keyboardKey.setTextOverrun(OverrunStyle.CLIP);
                    keyboardKey.setFocusTraversable(false);
                    keyboardKey.setPrefSize(layout.getWidth() / layout.getVisibleColumns(), layout.getHeight() / layout.getVisibleRows());
                    keyboardKey.setKey(key);
                    keyboardKey.setId(key.getId());
                    keyboardKey.setStyle(key.getStyleId());
                    keyboardKey.setText(key.getLabel());
                    keyboardKey.setDisable(key.isDisable());
                    keyboardKey.setVisible(key.isVisible());
                    keyboardKey.addEventHandler(ActionEvent.ACTION, this.keyboard);
                    button = keyboardKey;
                    continue;
                }
                this.logger.debug("Button no ser retornado. KeyId " + keyId);
            }
        } else {
            this.logger.debug("Button no ser retornado. Layout atual: " + layout);
        }
        return button;
    }

    private void navigateToPage(KeyType keyType, GridPane[] layoutPages) {
        switch (keyType) {
            case FORWARD: {
                if (this.currentPageIndex >= layoutPages.length - 1) break;
                ++this.currentPageIndex;
                layoutPages[this.currentPageIndex].toFront();
                break;
            }
            case BACKWARD: {
                if (this.currentPageIndex <= 0) break;
                --this.currentPageIndex;
                layoutPages[this.currentPageIndex].toFront();
                break;
            }
        }
    }

    private void changeLayoutAlfaNumeric(String currentLayout) {
        if (currentLayout.contains("UPPERCASE")) {
            this.keyboard.setLayout("QWERTY_LOWERCASE");
        } else {
            this.keyboard.setLayout("QWERTY_UPPERCASE");
        }
        this.keyboard.showForInputControl();
    }

    private void switchLayoutAlfaNumeric(String currentLayout) {
        if (currentLayout.contains("NUMERIC")) {
            this.keyboard.setLayout("QWERTY_LOWERCASE");
        } else {
            this.keyboard.setLayout("QWERTY_NUMERIC");
        }
        this.keyboard.showForInputControl();
    }

    public int getCoordenadaX() {
        return this.coordenadaX;
    }

    public void setCoordenadaX(int coordenadaX) {
        this.coordenadaX = coordenadaX;
    }

    public int getCoordenadaY() {
        return this.coordenadaY;
    }

    public void setCoordenadaY(int coordenadaY) {
        this.coordenadaY = coordenadaY;
    }

    public boolean isPopupNewStageMode() {
        return popupNewStageMode;
    }
}

