/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard;

import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.event.PopupKeyboardListener;
import com.linx.touchkeyboard.event.TouchKeyEvent;
import com.linx.touchkeyboard.event.TouchKeyboardListener;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.exception.TouchKeyboardExceptionMessages;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.renderer.TouchKeyboardRenderer;
import com.linx.touchkeyboard.util.KeyCodeASCIIUtil;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboard
implements EventHandler<ActionEvent>,
TouchKeyboardExceptionMessages {
    private static final int INITIAL_MODE = -1;
    public static final int GRAPHICAL_MODE = 0;
    public static final int COMPONENT_MODE = 1;
    private int operationMode = -1;
    private TouchKeyboardRenderer renderer;
    private List<TouchKeyboardListener> listeners = new ArrayList<TouchKeyboardListener>();
    private Component componentFocus;
    private Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);
    public static TextInputControl targetInputControl;
    private boolean mousePointerVisible;
    private static List<PopupKeyboardListener> popupKeyboardListeners;
    private static Popup popup;

    public void setComponentFocus(Component componentFocus) {
        this.componentFocus = componentFocus;
    }

    public void configure(File layouts, String styleRelativePath, String layoutId, int operationMode) throws KeyboardConfigException {
        if (this.renderer != null) {
            throw new KeyboardConfigException("N\u00e3o \u00e9 permitido alterar configura\u00e7\u00e3o para a atual inst\u00e2ncia do Touchkeyboard.");
        }
        if (layouts == null || !layouts.exists()) {
            throw new KeyboardConfigException("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!");
        }
        if (operationMode != 0 && operationMode != 1) {
            throw new KeyboardConfigException("Modo de configura\u00e7\u00e3o do framewrok inv\u00e1lido. Valores v\u00e1lidos: 0 - Modo Gr\u00e1fico, 1 - Modo Componente");
        }
        this.logger.debug("Carregando configuraes do arquivo (" + layouts.getAbsolutePath() + ") ...");
        KeyboardConfiguration configuration = TouchKeyboardXstreamUtil.loadKeyboardConfigurationWithValidation(layouts);
        this.logger.debug("Configuraes carregadas.");
        if (styleRelativePath != null && new File(styleRelativePath).exists()) {
            this.logger.debug("Definindo estilo do teclado...");
            configuration.setStyleFilePath(styleRelativePath);
            this.logger.debug("Estilo do teclado definido.");
        }
        boolean popupNewStageMode = false;
        String param = System.getProperty("TipoPopupTouchKeyboard", "normal");
        this.logger.debug("Configuracao do tipo de popup = " + param);
        if ("newStage".equals(param)) {
            popupNewStageMode = true;
        }
        this.logger.debug("Instanciando renderizador do teclado...");
        this.renderer = new TouchKeyboardRenderer(configuration, this, popupNewStageMode);
        this.logger.debug("Renderizador do teclado inicado.");
        if (operationMode == 0) {
            this.operationMode = 0;
            this.logger.debug("TouchKeyboard configurado para modo grfico.");
            Platform.runLater((Runnable)this.renderer);
        } else {
            this.logger.debug("TouchKeyboard configurado para modo componente.");
            this.operationMode = 1;
        }
        this.logger.debug("Definindo layout " + layoutId + " como padro...");
        this.renderer.setLayout(layoutId);
        this.logger.debug("Layout definido.");
    }

    public boolean isGraphicsMode() {
        return this.operationMode == 0;
    }

    public void show() {
        if (this.isGraphicsMode()) {
            if (this.renderer.getPrimaryStage() != null && this.renderer.getLayout() != null) {
                this.renderer.getPrimaryStage().show();
            } else {
                this.logger.debug("Stage ou Layout no definidos para renderizao. Layout atual: " + this.renderer.getLayout() + " Stage Atual: " + this.renderer.getPrimaryStage());
            }
        } else {
            this.logger.debug("Touchkeyboard configurado como modo de operao. Operao no permitida.");
        }
    }

    public void show(int x, int y) {
        if (this.isGraphicsMode()) {
            if (this.renderer.getPrimaryStage() != null && this.renderer.getLayout() != null) {
                this.renderer.getPrimaryStage().show();
            } else if (x > 0 || y > 0) {
                this.renderer.setCoordenadaX(x);
                this.renderer.setCoordenadaY(y);
                this.logger.debug("Stage ou Layout no definidos para renderizao. Layout atual: " + this.renderer.getLayout() + " Stage Atual: " + this.renderer.getPrimaryStage(x, y));
            } else {
                this.logger.debug("Stage ou Layout no definidos para renderizao. Layout atual: " + this.renderer.getLayout() + " Stage Atual: " + this.renderer.getPrimaryStage());
            }
        } else {
            this.logger.debug("Touchkeyboard configurado como modo de operao. Operao no permitida.");
        }
    }

    public void showForInputControl(TextInputControl control) {
        this.showControl(control);
    }

    public void showForInputControl() {
        this.showControl(targetInputControl);
    }

    private void showControl(TextInputControl control) {
        if (!this.renderer.isPopupNewStageMode()) {
            targetInputControl = control;
        }
        this.logger.debug("Exibindo teclado...");
        if (popup == null) {
            popup = new Popup();
        } else {
            popup.getContent().clear();
        }
        Pane keyboardPane = this.renderer.getLayoutAsPane();
        keyboardPane.setStyle("-fx-background-color: #d5d8dd; -fx-padding: 7; -fx-border-width: 1px; -fx-border-style: solid; -fx-border-color: #0093ff;");
        popup.getContent().add((Object)keyboardPane);
        if (targetInputControl != control || !this.renderer.isPopupNewStageMode()) {
            this.logger.debug("TargetInput foi alterado ou no existia...");
            Rectangle2D textNodeBounds = new Rectangle2D(control.getScene().getWindow().getX() + control.getLocalToSceneTransform().getTx(), control.getScene().getWindow().getY() + control.getLocalToSceneTransform().getTy(), control.getWidth(), control.getHeight());
            Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
            control.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                    if (!newValue.booleanValue()) {
                        TouchKeyboard.closePopupKeyboard();
                    }
                }
            });
            if (popup.getOnShown() == null && popup.getOnHidden() == null) {
                popup.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        for (PopupKeyboardListener listener : popupKeyboardListeners) {
                            listener.popupKeyboardActivated();
                        }
                    }
                });
                popup.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        for (PopupKeyboardListener listener : popupKeyboardListeners) {
                            listener.popupKeyboardDeactivated();
                        }
                    }
                });
            }
            popup.show(control.getScene().getWindow());
            if (textNodeBounds.getMinX() + popup.getWidth() > screenBounds.getMaxX()) {
                popup.setX(screenBounds.getMaxX() - popup.getWidth());
            } else {
                popup.setX(textNodeBounds.getMinX());
            }
            if (textNodeBounds.getMaxY() + popup.getHeight() > screenBounds.getMaxY()) {
                popup.setY(textNodeBounds.getMinY() - popup.getHeight() - 20.0);
            } else {
                popup.setY(textNodeBounds.getMaxY());
            }
        }
    }

    public static void closePopupKeyboard() {
        TouchKeyboard.closePopupKeyboard(true);
    }

    public static void closePopupKeyboard(boolean clearTarget) {
        if (popup != null) {
            if (clearTarget) {
                targetInputControl = null;
            }
            popup.hide();
        }
    }

    public TextInputControl getTargetInputControl() {
        return targetInputControl;
    }

    public void hide() {
        if (this.isGraphicsMode()) {
            if (this.renderer.getPrimaryStage() != null) {
                this.renderer.getPrimaryStage().hide();
            } else {
                this.logger.debug("Stage no definido para renderizao. Layout atual: " + this.renderer.getLayout());
            }
        } else {
            this.logger.debug("Touchkeyboard configurado como modo de operao. Operao no permitida.");
        }
    }

    public boolean isVisible() {
        if (this.isGraphicsMode()) {
            if (this.renderer.getPrimaryStage() != null) {
                return this.renderer.getPrimaryStage().isShowing();
            }
            return false;
        }
        return false;
    }

    public Pane getKeyboardAsComponent(String layoutId) {
        return this.renderer.getLayoutAsGridPane(layoutId);
    }

    public Pane getKeyboardAsComponent() {
        return this.renderer.getLayoutAsGridPane();
    }

    public Button getKeyAsButton(String layoutId, String keyId) {
        return this.renderer.getKeyAsButton(layoutId, keyId);
    }

    public void setLayout(String layoutId) {
        this.renderer.setLayout(layoutId);
        if (this.isGraphicsMode()) {
            this.renderer.drawLayout(0, 0);
        }
    }

    public void setLayout(String layoutId, int x, int y) {
        this.renderer.setLayout(layoutId);
        if (this.isGraphicsMode()) {
            this.renderer.drawLayout(x, y);
        }
    }

    public void addListener(TouchKeyboardListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TouchKeyboardListener listener) {
        this.listeners.remove(listener);
    }

    public void setFocusTarget() {
        if (this.componentFocus != null) {
            this.componentFocus.requestFocus();
        }
    }

    public static void addPopupKeyboardListener(PopupKeyboardListener popupKeyboardListener) {
        if (popupKeyboardListener != null && !popupKeyboardListeners.contains(popupKeyboardListener)) {
            popupKeyboardListeners.add(popupKeyboardListener);
        }
    }

    public static void removePopupKeyboardListener(PopupKeyboardListener popupKeyboardListener) {
        popupKeyboardListeners.remove(popupKeyboardListener);
    }

    public void handle(ActionEvent event) {
        boolean telaAlwaysOnTop = false;
        TouchKeyboardKey keyboardKey = (TouchKeyboardKey)((Object)event.getSource());
        Window[] windows = Window.getWindows();
        for (int i = 0; i < windows.length; ++i) {
            Window currentWindow = windows[i];
            if (!currentWindow.isAlwaysOnTop() || !currentWindow.isVisible()) continue;
            currentWindow.requestFocus();
            try {
                java.awt.event.KeyEvent swingEvent = new java.awt.event.KeyEvent(currentWindow, 1, System.currentTimeMillis(), 0, keyboardKey.getKey().getKeyCode(), keyboardKey.getKey().getKeyChar());
                currentWindow.getKeyListeners()[0].keyPressed(swingEvent);
                telaAlwaysOnTop = true;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!telaAlwaysOnTop) {
            this.logger.debug("Evento recebido da tecla " + keyboardKey.getText());
            TouchKeyEvent evt = new TouchKeyEvent();
            evt.setKeyCode(keyboardKey.getKey().getKeyCode());
            evt.setCharCode(keyboardKey.getKey().getKeyChar());
            evt.setModifiers(0);
            this.logger.debug("Key code: " + keyboardKey.getKey().getKeyCode());
            this.logger.debug("Key char: " + keyboardKey.getKey().getKeyChar());
            this.logger.debug("Key type: " + (Object)((Object)keyboardKey.getKey().getType()));
            for (TouchKeyboardListener listener : this.listeners) {
                this.logger.debug("Notificando ouvindo do evento: " + listener.getClass().getName());
                listener.keyTouched(evt);
            }
            this.logger.debug("Definindo foco no componente.");
            this.setFocusTarget();
        }
    }

    public void dispatchKeyEvent(Key key) {
        if (targetInputControl == null) {
            return;
        }
        String characters = String.valueOf(key.getKeyChar());
        switch (key.getType()) {
            case ENTER: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.ENTER));
                this.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED, KeyEvent.KEY_RELEASED);
                break;
            }
            case BACKSPACE: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.BACK_SPACE));
                this.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            case TAB: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.TAB));
                this.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            case ARROW_LEFT: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.LEFT));
                this.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            case ARROW_RIGHT: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.RIGHT));
                this.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            default: {
                this.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED, KeyEvent.KEY_RELEASED, KeyEvent.KEY_TYPED);
            }
        }
    }

    private void fireOrdinalSequenceEvent(Key key, String characters, EventType<KeyEvent> ... evtTypesSequencial) {
        for (EventType<KeyEvent> keyEvent : evtTypesSequencial) {
            if (keyEvent == KeyEvent.KEY_PRESSED) {
                this.fireEvent(key, characters, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED);
                continue;
            }
            if (keyEvent == KeyEvent.KEY_RELEASED) {
                this.fireEvent(key, characters, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED);
                continue;
            }
            if (keyEvent != KeyEvent.KEY_TYPED) continue;
            this.fireEvent(key, characters, (EventType<KeyEvent>)KeyEvent.KEY_TYPED);
        }
        if (key.getKeyCode() == KeyCodeASCIIUtil.getASCII(KeyCode.ENTER) && !(targetInputControl instanceof TextArea)) {
            targetInputControl = null;
        }
    }

    private void fireEvent(Key key, String characters, EventType<KeyEvent> evtType) {
        KeyEvent keyEvent = KeyEvent.impl_keyEvent((EventTarget)targetInputControl, (String)characters, (String)String.valueOf(key.getKeyChar()), (int)key.getKeyCode(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, evtType);
        if (key.getKeyCode() == KeyCodeASCIIUtil.getASCII(KeyCode.ENTER) && !(targetInputControl instanceof TextArea)) {
            TouchKeyboard.closePopupKeyboard(false);
        }
        targetInputControl.fireEvent((Event)keyEvent);
        keyEvent = null;
        if (targetInputControl == null) {
            this.setFocusTarget();
        }
    }

    public void handleKeyEvent(KeyEvent event) {
        TouchKeyEvent evt = new TouchKeyEvent();
        evt.setKeyCode(KeyCodeASCIIUtil.getASCII(event.getCode()));
        evt.setCharCode(event.getCharacter().charAt(0));
        evt.setModifiers(0);
        for (TouchKeyboardListener listener : this.listeners) {
            this.logger.debug("Notificando ouvinte do evento: " + listener.getClass().getName());
            listener.keyTouched(evt);
        }
        this.logger.debug("Definindo foco no componente.");
        this.setFocusTarget();
    }

    public void setMousePointerVisible(boolean visible) {
        this.mousePointerVisible = visible;
    }

    public boolean isMousePointerVisible() {
        return this.mousePointerVisible;
    }

    static {
        popupKeyboardListeners = new ArrayList<PopupKeyboardListener>();
    }
}

