/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard;

import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.exception.TouchKeyboardExceptionMessages;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.util.KeyCodeASCIIUtil;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamUtil;
import java.io.File;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Parent;
import javafx.scene.SceneBuilder;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageBuilder;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopupKeyboard
implements TouchKeyboardExceptionMessages {
    private static KeyboardConfiguration configuration;
    private static Logger LOGGER;
    private static Stage popup;
    public static TextInputControl targetInputControl;
    private static String currentLayoutId;

    public static void configure(File layoutsFile, String styleRelativePath, String layoutId) throws KeyboardConfigException {
        if (configuration != null) {
            return;
        }
        if (layoutsFile == null || !layoutsFile.exists()) {
            throw new KeyboardConfigException("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!");
        }
        LOGGER.debug("Carregando configuraes do arquivo (" + layoutsFile.getAbsolutePath() + ") ...");
        configuration = TouchKeyboardXstreamUtil.loadKeyboardConfigurationWithValidation(layoutsFile);
        LOGGER.debug("Configuraes carregadas.");
        if (styleRelativePath != null && new File(styleRelativePath).exists()) {
            LOGGER.debug("Definindo estilo do teclado popup...");
            configuration.setStyleFilePath(styleRelativePath);
            LOGGER.debug("Estilo do teclado popup definido.");
        }
        LOGGER.debug("Definindo layout " + layoutId + " como padro...");
        currentLayoutId = layoutId;
        LOGGER.debug("Layout definido.");
    }

    public static void showForInputControl(TextInputControl control, String layoutId) {
        PopupKeyboard.showControl(control, layoutId);
    }

    public static void showForInputControl(TextInputControl control) {
        PopupKeyboard.showControl(control, currentLayoutId);
    }

    public static void showForInputControl() {
        PopupKeyboard.showControl(targetInputControl, currentLayoutId);
    }

    private static void showControl(TextInputControl control, String layoutId) {
        LOGGER.debug("Exibindo teclado...");
        if (popup == null) {
            popup = StageBuilder.create().build();
            popup.initStyle(StageStyle.UNDECORATED);
            popup.initModality(Modality.WINDOW_MODAL);
            popup.initOwner(control.getScene().getWindow());
        }
        if (targetInputControl == null || targetInputControl != control || layoutId != null && !currentLayoutId.equals(layoutId) || !popup.isShowing()) {
            targetInputControl = control;
            currentLayoutId = layoutId;
            Pane keyboardPane = PopupKeyboard.getLayoutAsPane(currentLayoutId);
            keyboardPane.setStyle("-fx-background-color: #d5d8dd; -fx-padding: 7; -fx-border-width: 1px; -fx-border-style: solid; -fx-border-color: #0093ff;");
            popup.setScene(SceneBuilder.create().root((Parent)keyboardPane).build());
            popup.sizeToScene();
            popup.getScene().addEventHandler(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (targetInputControl != null) {
                        if (event.getEventType() == KeyEvent.KEY_RELEASED && (event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.ESCAPE)) {
                            PopupKeyboard.closePopupKeyboard();
                        } else {
                            targetInputControl.fireEvent((Event)event);
                        }
                    }
                }
            });
            Rectangle2D textNodeBounds = new Rectangle2D(control.getScene().getWindow().getX() + control.getLocalToSceneTransform().getTx(), control.getScene().getWindow().getY() + control.getLocalToSceneTransform().getTy(), control.getWidth(), control.getHeight());
            Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
            popup.getScene().setCursor(Cursor.NONE);
            popup.show();
            if (textNodeBounds.getMinX() + popup.getWidth() < screenBounds.getMaxX()) {
                popup.setX(textNodeBounds.getMinX());
            } else if (textNodeBounds.getMinX() + popup.getWidth() > screenBounds.getMaxX() && !(textNodeBounds.getMaxX() - popup.getWidth() < screenBounds.getMinX())) {
                popup.setX(textNodeBounds.getMaxX() - popup.getWidth());
            } else {
                popup.setX(textNodeBounds.getMaxX() - textNodeBounds.getWidth() / 2.0 - popup.getWidth() / 2.0);
            }
            if (textNodeBounds.getMaxY() + popup.getHeight() > screenBounds.getMaxY()) {
                popup.setY(textNodeBounds.getMinY() - popup.getHeight());
            } else {
                popup.setY(textNodeBounds.getMaxY());
            }
        }
    }

    public static void closePopupKeyboard() {
        if (popup != null) {
            popup.hide();
            popup = null;
        }
    }

    public static Pane getLayoutAsPane(String layoutId) {
        VBox keyboardArea = null;
        Layout layout = configuration.getLayout(layoutId);
        if (layout != null) {
            keyboardArea = new VBox();
            keyboardArea.setPrefWidth(-1.0);
            keyboardArea.setPrefHeight(-1.0);
            keyboardArea.setFillWidth(true);
            keyboardArea.setAlignment(Pos.CENTER);
            keyboardArea.setSpacing(7.0);
            TouchKeyboardKey[][] keyboardKeys = new TouchKeyboardKey[layout.getRows()][layout.getColumns()];
            for (int row = 0; row < layout.getRows(); ++row) {
                HBox keyboardRow = new HBox();
                keyboardRow.setSpacing(7.0);
                keyboardRow.setPrefWidth(-1.0);
                keyboardRow.setPrefHeight(-1.0);
                keyboardRow.setFillHeight(true);
                keyboardRow.setAlignment(Pos.CENTER);
                for (int column = 0; column < layout.getColumns(); ++column) {
                    TouchKeyboardKey keyboardKey = new TouchKeyboardKey(null);
                    keyboardKey.setTextAlignment(TextAlignment.CENTER);
                    keyboardKey.setWrapText(true);
                    keyboardKey.setTextOverrun(OverrunStyle.CLIP);
                    keyboardKey.setFocusTraversable(false);
                    keyboardKey.setAlignment(Pos.CENTER);
                    keyboardRow.getChildren().add((Object)keyboardKey);
                    keyboardKeys[row][column] = keyboardKey;
                }
                keyboardArea.getChildren().add((Object)keyboardRow);
            }
            block9: for (Key key : layout.getKeys()) {
                TouchKeyboardKey keyboardKey = keyboardKeys[key.getRow()][key.getColumn()];
                if (key.isVisible()) {
                    keyboardKey.setKey(key);
                    keyboardKey.setId(key.getId());
                    keyboardKey.setStyle("-fx-background-color: #FFFFFF; -fx-border-width: 1px; -fx-border-radius: 5; -fx-border-style: solid; -fx-border-color: #ffffff; -fx-font-family: Arial; -fx-font-size: 14px; -fx-text-fill: #000000; -fx-font-weight: normal; -fx-effect: null;");
                    keyboardKey.setText(key.getLabel());
                    keyboardKey.setVisible(key.isVisible());
                    keyboardKey.setDisable(key.isDisable());
                    if (keyboardKey.getKey().getWidth() != null && keyboardKey.getKey().getHeight() != null) {
                        keyboardKey.setMinSize(keyboardKey.getKey().getWidth(), keyboardKey.getKey().getHeight());
                    } else if (layout.getMinHeightButtons() != null && layout.getMinWidthButtons() != null) {
                        keyboardKey.setMinSize(layout.getMinWidthButtons(), layout.getMinHeightButtons());
                    } else {
                        keyboardKey.setPrefSize(-1.0, -1.0);
                    }
                    switch (key.getType()) {
                        case CAPSLOCK: {
                            keyboardKey.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    LOGGER.debug("Tecla caps acionada...");
                                    PopupKeyboard.changeLayoutAlfaNumeric(currentLayoutId);
                                }
                            });
                            continue block9;
                        }
                        case SWITCH: {
                            keyboardKey.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    LOGGER.debug("Tecla switch acionada...");
                                    PopupKeyboard.switchLayoutAlfaNumeric(currentLayoutId);
                                }
                            });
                            continue block9;
                        }
                        case CLOSE: {
                            keyboardKey.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    LOGGER.debug("Tecla close acionada...");
                                    PopupKeyboard.closePopupKeyboard();
                                    if (targetInputControl != null) {
                                        targetInputControl.requestFocus();
                                    }
                                }
                            });
                            continue block9;
                        }
                        case BACKSPACE: {
                            keyboardKey.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    TouchKeyboardKey key = (TouchKeyboardKey)((Object)event.getSource());
                                    PopupKeyboard.dispatchKeyEvent(key.getKey());
                                }
                            });
                            continue block9;
                        }
                        case ENTER: {
                            keyboardKey.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    TouchKeyboardKey key = (TouchKeyboardKey)((Object)event.getSource());
                                    PopupKeyboard.dispatchKeyEvent(key.getKey());
                                }
                            });
                            continue block9;
                        }
                    }
                    keyboardKey.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                        public void handle(MouseEvent event) {
                            TouchKeyboardKey key = (TouchKeyboardKey)((Object)event.getSource());
                            PopupKeyboard.dispatchKeyEvent(key.getKey());
                        }
                    });
                    continue;
                }
                if (keyboardKey.getKey() != null && keyboardKey.getKey().getLabel() != null && !keyboardKey.getKey().getLabel().equals("")) continue;
                ((HBox)keyboardKey.getParent()).getChildren().remove((Object)keyboardKey);
            }
        } else {
            LOGGER.debug("Nenhum elemento ser recuperado. Layout atual: " + layout);
        }
        return keyboardArea;
    }

    private static void changeLayoutAlfaNumeric(String currentLayout) {
        if (currentLayoutId.contains("UPPERCASE")) {
            PopupKeyboard.showForInputControl(targetInputControl, "QWERTY_LOWERCASE");
        } else {
            PopupKeyboard.showForInputControl(targetInputControl, "QWERTY_UPPERCASE");
        }
    }

    private static void switchLayoutAlfaNumeric(String currentLayout) {
        if (currentLayoutId.contains("NUMERIC")) {
            PopupKeyboard.showForInputControl(targetInputControl, "QWERTY_LOWERCASE");
        } else {
            PopupKeyboard.showForInputControl(targetInputControl, "QWERTY_NUMERIC");
        }
    }

    private static void dispatchKeyEvent(Key key) {
        if (targetInputControl == null) {
            return;
        }
        String characters = String.valueOf(key.getKeyChar());
        switch (key.getType()) {
            case ENTER: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.ENTER));
                PopupKeyboard.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED, KeyEvent.KEY_RELEASED);
                break;
            }
            case BACKSPACE: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.BACK_SPACE));
                PopupKeyboard.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            case TAB: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.TAB));
                PopupKeyboard.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            case ARROW_LEFT: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.LEFT));
                PopupKeyboard.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            case ARROW_RIGHT: {
                key.setKeyCode(KeyCodeASCIIUtil.getASCII(KeyCode.RIGHT));
                PopupKeyboard.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED);
                break;
            }
            default: {
                PopupKeyboard.fireOrdinalSequenceEvent(key, characters, KeyEvent.KEY_PRESSED, KeyEvent.KEY_RELEASED, KeyEvent.KEY_TYPED);
            }
        }
    }

    private static void fireOrdinalSequenceEvent(Key key, String characters, EventType<KeyEvent> ... evtTypesSequencial) {
        for (EventType<KeyEvent> keyEvent : evtTypesSequencial) {
            if (keyEvent == KeyEvent.KEY_PRESSED) {
                PopupKeyboard.fireEvent(key, characters, (EventType<KeyEvent>)KeyEvent.KEY_PRESSED);
                continue;
            }
            if (keyEvent == KeyEvent.KEY_RELEASED) {
                PopupKeyboard.fireEvent(key, characters, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED);
                continue;
            }
            if (keyEvent != KeyEvent.KEY_TYPED) continue;
            PopupKeyboard.fireEvent(key, characters, (EventType<KeyEvent>)KeyEvent.KEY_TYPED);
        }
    }

    private static void fireEvent(Key key, String characters, EventType<KeyEvent> evtType) {
        KeyEvent keyEvent = KeyEvent.impl_keyEvent((EventTarget)targetInputControl, (String)characters, (String)String.valueOf(key.getKeyChar()), (int)key.getKeyCode(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, evtType);
        if (key.getKeyCode() == KeyCodeASCIIUtil.getASCII(KeyCode.ENTER) && !(targetInputControl instanceof TextArea)) {
            PopupKeyboard.closePopupKeyboard();
        }
        targetInputControl.fireEvent((Event)keyEvent);
        if (!(targetInputControl.getScene().getFocusOwner() instanceof TextInputControl)) {
            PopupKeyboard.closePopupKeyboard();
        }
        keyEvent.consume();
    }

    static {
        LOGGER = LoggerFactory.getLogger(PopupKeyboard.class);
    }
}

