/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.PropertyValueSpecification;
import com.ibm.uvm.abt.edit.ResourceBundleManager;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TranslatableString
implements PropertyValueSpecification,
Serializable,
Cloneable {
    private String fieldResourceBundleName;
    private String fieldResourceKey;
    private String fieldResourceString = "";
    public static final int NONTRANSLATED = 0;
    public static final int LISTBUNDLE = 1;
    public static final int PROPERTYBUNDLE = 2;
    private int fieldResourceType = 0;
    private boolean fieldNeverTranslate = false;
    private static final long serialVersionUID = 1L;

    public TranslatableString() {
    }

    public TranslatableString(String unTranslatedString) {
        this.setResourceString(unTranslatedString);
        this.setResourceType(0);
    }

    public TranslatableString(String bundle, String key, int type) {
        this.setResourceBundleName(bundle);
        this.setResourceKey(key);
        this.setResourceType(type);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object getAsPropertyValue() {
        switch (this.getResourceType()) {
            case 1: {
                String ls = "";
                try {
                    ls = ResourceBundle.getBundle(this.getResourceBundleName()).getString(this.getResourceKey());
                }
                catch (MissingResourceException missingResourceException) {}
                return ls;
            }
            case 2: {
                String ps = "";
                try {
                    ps = ResourceBundle.getBundle(ResourceBundleManager.propertyBundleNameFromFilename(this.getResourceBundleName())).getString(this.getResourceKey());
                }
                catch (MissingResourceException missingResourceException) {}
                return ps;
            }
            case 0: {
                return this.getResourceString();
            }
        }
        return null;
    }

    public String getJavaInitializationString() {
        String s = "";
        switch (this.getResourceType()) {
            case 2: {
                s = "java.util.ResourceBundle.getBundle(\"" + ResourceBundleManager.propertyBundleNameFromFilename(this.getResourceBundleName()) + "\"" + ").getString(" + "\"" + this.getResourceKey() + "\"" + ")";
                break;
            }
            case 1: {
                s = "java.util.ResourceBundle.getBundle(\"" + this.getResourceBundleName() + "\"" + ").getString(" + "\"" + this.getResourceKey() + "\"" + ")";
                break;
            }
            case 0: {
                s = "\"" + ResourceBundleManager.translateDisplayStringToCodeString(this.getResourceString()) + "\"";
            }
        }
        return s;
    }

    public Enumeration getKeys() {
        Enumeration<String> enumeration = null;
        try {
            enumeration = ResourceBundle.getBundle(this.getResourceBundleName()).getKeys();
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("VI: Resource Bundle lookup failed");
        }
        return enumeration;
    }

    public String getResourceBundleName() {
        return this.fieldResourceBundleName;
    }

    public String getResourceKey() {
        return this.fieldResourceKey;
    }

    public String getResourceString() {
        return this.fieldResourceString;
    }

    public int getResourceType() {
        return this.fieldResourceType;
    }

    public boolean isNeverTranslate() {
        return this.fieldNeverTranslate;
    }

    public boolean isTranslated() {
        return this.getResourceType() != 0;
    }

    public void setNeverTranslate(boolean neverTranslate) {
        this.fieldNeverTranslate = neverTranslate;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.fieldResourceBundleName = resourceBundleName;
    }

    public void setResourceKey(String resourceKey) {
        this.fieldResourceKey = resourceKey;
    }

    public void setResourceString(String resourceString) {
        this.fieldResourceString = resourceString;
    }

    public void setResourceType(int resourceType) {
        this.fieldResourceType = resourceType;
    }
}

