/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.ColorCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Panel;
import java.awt.SystemColor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SystemColorPropertyPage
extends Panel
implements ListSelectionListener {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");
    static String[] colorNames = new String[]{resabtedit.getString("activeCaption"), resabtedit.getString("activeCaptionBorder"), resabtedit.getString("activeCaptionText"), resabtedit.getString("control"), resabtedit.getString("controlDkShadow"), resabtedit.getString("controlHighlight"), resabtedit.getString("controlLtHighlight"), resabtedit.getString("controlShadow"), resabtedit.getString("controlText"), resabtedit.getString("desktop"), resabtedit.getString("inactiveCaption"), resabtedit.getString("inactiveCaptionBord"), resabtedit.getString("inactiveCaptionText"), resabtedit.getString("info"), resabtedit.getString("infoText"), resabtedit.getString("menu"), resabtedit.getString("menuText"), resabtedit.getString("scrollbar"), resabtedit.getString("text"), resabtedit.getString("textHighlight"), resabtedit.getString("textHighlightText"), resabtedit.getString("textInactiveText"), resabtedit.getString("textText"), resabtedit.getString("window"), resabtedit.getString("windowBorder"), resabtedit.getString("windowText")};
    static SystemColor[] colorValues = new SystemColor[]{SystemColor.activeCaption, SystemColor.activeCaptionBorder, SystemColor.activeCaptionText, SystemColor.control, SystemColor.controlDkShadow, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlText, SystemColor.desktop, SystemColor.inactiveCaption, SystemColor.inactiveCaptionBorder, SystemColor.inactiveCaptionText, SystemColor.info, SystemColor.infoText, SystemColor.menu, SystemColor.menuText, SystemColor.scrollbar, SystemColor.text, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.textText, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText};
    static String[] initStrings = new String[]{"activeCaption", "activeCaptionBorder", "activeCaptionText", "control", "controlDkShadow", "controlHighlight", "controlLtHighlight", "controlShadow", "controlText", "desktop", "inactiveCaption", "inactiveCaptionBorder", "inactiveCaptionText", "info", "infoText", "menu", "menuText", "scrollbar", "text", "textHighlight", "textHighlightText", "textInactiveText", "textText", "window", "windowBorder", "windowText"};
    private JScrollPane scrollPane = null;
    private JList systemColorsList = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public SystemColorPropertyPage() {
        this.initialize();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    private void fillColorList() {
        DefaultListModel model = (DefaultListModel)this.getSystemColorsList().getModel();
        int i = 0;
        while (i < colorNames.length) {
            model.addElement(new Integer(i));
            ++i;
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChange.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Color getColorValue() {
        return (Color)this.getValue();
    }

    String getJavaInitializationString() {
        int index = this.indexOfSelectedColor();
        return "java.awt.SystemColor." + initStrings[index];
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            try {
                this.scrollPane = new JScrollPane();
                this.scrollPane.setName("ScrollPanel");
                this.scrollPane.setViewportView(this.getSystemColorsList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.scrollPane;
    }

    private JList getSystemColorsList() {
        if (this.systemColorsList == null) {
            try {
                this.systemColorsList = new JList();
                this.systemColorsList.setName("SystemColorsList");
                this.systemColorsList.setModel(new DefaultListModel());
                this.systemColorsList.setSelectionMode(0);
                this.systemColorsList.setCellRenderer(new ColorCellRenderer(colorNames, colorValues));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.systemColorsList;
    }

    Object getValue() {
        int index = this.indexOfSelectedColor();
        if (index < 0) {
            return null;
        }
        return colorValues[index];
    }

    private void handleException(Throwable exception) {
    }

    private int indexOfSelectedColor() {
        return this.getSystemColorsList().getSelectedIndex();
    }

    private void initConnections() {
        this.getSystemColorsList().addListSelectionListener(this);
    }

    private void initialize() {
        this.setName("SystemColorPropertyPage");
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.window);
        this.setSize(179, 181);
        this.add(this.getScrollPane());
        this.fillColorList();
        this.initConnections();
    }

    public void preselectColor(Color aColor) {
        int i = 0;
        while (i < colorValues.length) {
            if (aColor.equals(colorValues[i])) {
                this.getSystemColorsList().setSelectedIndex(i);
                this.getSystemColorsList().ensureIndexIsVisible(i);
                return;
            }
            ++i;
        }
        this.getSystemColorsList().setSelectedIndex(0);
        this.getSystemColorsList().ensureIndexIsVisible(0);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void setColorValue(Color colorValue) {
    }

    private void systemColorsListValueChanged(ListSelectionEvent arg1) {
        this.firePropertyChange("colorValue", null, this.getColorValue());
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.getSystemColorsList()) {
            this.systemColorsListValueChanged(e);
        }
    }
}

