/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.IconEditor;
import com.ibm.uvm.abt.edit.NamedImageIcon;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class IconCustomEditor
extends JPanel {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");
    private String savedFilename = null;
    private String savedURL = null;
    private static String savedDirectory = null;
    private IconEditor propertyEditor = null;
    private ItemListener choiceListener = null;
    private DocumentListener documentListener = null;
    private FocusListener focusListener = null;
    private ActionListener genericActionListener = null;
    private PropertyChangeListener valueListener = null;
    private ButtonGroup ivjChoiceGroup = null;
    private JButton ivjFileBrowseButton = null;
    private JRadioButton ivjFileChoice = null;
    private FileDialog ivjFileDialog = null;
    private JPanel ivjJPanel1 = null;
    private FlowLayout ivjJPanel1FlowLayout = null;
    private CardLayout ivjPreviewPanelCardLayout = null;
    private JRadioButton ivjNoneChoice = null;
    private JLabel ivjPreviewLabel = null;
    private JPanel ivjPreviewPanel = null;
    private JTextField ivjSourceNameField = null;
    private JTextArea ivjWarningMessageArea = null;
    private JRadioButton ivjURLChoice = null;
    private boolean URLChoiceEnabled;
    private boolean sourceNameFieldChanged = false;
    private static final boolean DEBUG_LISTENERS = false;

    public IconCustomEditor(IconEditor valueSource) {
        this.propertyEditor = valueSource;
        if (this.propertyEditor != null) {
            this.setURLChoiceEnabled(this.propertyEditor.getCustomEditorURLChoiceEnabled());
            Icon edValue = (Icon)this.propertyEditor.getValue();
            this.propertyEditor.addPropertyChangeListener(this.getValueListener());
            this.getPreviewLabel().setIcon(edValue);
            if (edValue == null) {
                this.getNoneChoice().setSelected(true);
            } else if (edValue instanceof NamedImageIcon) {
                NamedImageIcon nImageIcon = (NamedImageIcon)edValue;
                if (nImageIcon.getSource() == 1) {
                    this.savedFilename = nImageIcon.getSourceName();
                    this.getFileChoice().setSelected(true);
                } else if (nImageIcon.getSource() == 2) {
                    this.savedURL = nImageIcon.getSourceName();
                    this.getURLChoice().setSelected(true);
                }
            } else {
                this.getFileChoice().setSelected(false);
                this.getURLChoice().setSelected(false);
                this.getNoneChoice().setSelected(false);
                this.getSourceNameField().setEnabled(false);
                this.getFileBrowseButton().setEnabled(false);
            }
        }
        this.initialize();
    }

    private ButtonGroup getChoiceGroup() {
        if (this.ivjChoiceGroup == null) {
            try {
                this.ivjChoiceGroup = new ButtonGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjChoiceGroup;
    }

    private ItemListener getChoiceListener() {
        if (this.choiceListener == null) {
            this.choiceListener = new ItemListener(this){
                /* synthetic */ IconCustomEditor this$0;

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        IconCustomEditor.access$setUserState(this.this$0);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
        return this.choiceListener;
    }

    private DocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new DocumentListener(this){
                /* synthetic */ IconCustomEditor this$0;

                public void changedUpdate(DocumentEvent e) {
                    IconCustomEditor.access$sourceNameFieldChanged(this.this$0, true);
                }

                public void removeUpdate(DocumentEvent e) {
                    IconCustomEditor.access$sourceNameFieldChanged(this.this$0, true);
                }

                public void insertUpdate(DocumentEvent e) {
                    IconCustomEditor.access$sourceNameFieldChanged(this.this$0, true);
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
        return this.documentListener;
    }

    private JButton getFileBrowseButton() {
        if (this.ivjFileBrowseButton == null) {
            try {
                this.ivjFileBrowseButton = new JButton();
                this.ivjFileBrowseButton.setName("FileBrowseButton");
                this.ivjFileBrowseButton.setText(resabtedit.getString("FileBrowseButton_text"));
                this.ivjFileBrowseButton.setBackground(SystemColor.control);
                this.ivjFileBrowseButton.setEnabled(true);
                this.ivjFileBrowseButton.addActionListener(this.getGenericActionListener());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileBrowseButton;
    }

    private JRadioButton getFileChoice() {
        if (this.ivjFileChoice == null) {
            try {
                this.ivjFileChoice = new JRadioButton();
                this.ivjFileChoice.setName("FileChoice");
                this.ivjFileChoice.setText(resabtedit.getString("FileChoice_text"));
                this.ivjFileChoice.setEnabled(true);
                this.ivjFileChoice.addItemListener(this.getChoiceListener());
                this.getChoiceGroup().add(this.ivjFileChoice);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileChoice;
    }

    private FileDialog getFileDialog() {
        if (this.ivjFileDialog == null) {
            try {
                this.ivjFileDialog = new FileDialog(new Frame());
                this.ivjFileDialog.setName("FileDialog");
                this.addNotify();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileDialog;
    }

    private String getFilenameFromDialog() {
        String dialogFile;
        FileDialog dialog = this.getFileDialog();
        String filename = null;
        String sep = File.separator;
        String prDir = String.valueOf(sep) + "project_resources" + sep;
        String userDir = System.getProperty("user.dir", ".");
        if (savedDirectory == null) {
            savedDirectory = userDir;
        }
        String defaultDir = savedDirectory;
        if (this.savedFilename != null && this.savedFilename.length() > 0) {
            defaultDir = this.savedFilename;
            int prInUser = userDir.indexOf(prDir);
            if (defaultDir.startsWith(".." + sep) && prInUser > 0) {
                int prInDefault = defaultDir.indexOf(prDir);
                defaultDir = prInDefault > 0 ? String.valueOf(userDir.substring(0, prInUser + prDir.length())) + defaultDir.substring(prInDefault + prDir.length()) : String.valueOf(userDir.substring(0, prInUser + prDir.length())) + defaultDir.substring(3);
            }
            if (defaultDir.lastIndexOf(sep) > 0) {
                defaultDir = defaultDir.substring(0, defaultDir.lastIndexOf(sep));
            }
        }
        if (defaultDir.indexOf(prDir) > 0) {
            try {
                File testDir = new File(defaultDir);
                if (!testDir.isDirectory()) {
                    defaultDir = savedDirectory;
                }
            }
            catch (Exception exception) {
                defaultDir = savedDirectory;
            }
        } else {
            defaultDir = savedDirectory;
        }
        dialog.setDirectory(defaultDir);
        this.getParent().setEnabled(false);
        ((Component)dialog).setVisible(true);
        this.getParent().setEnabled(true);
        String specifiedDir = dialog.getDirectory();
        if (specifiedDir != null && specifiedDir.indexOf(prDir) > 0) {
            savedDirectory = specifiedDir;
        }
        if ((dialogFile = dialog.getFile()) != null && dialogFile.length() > 0) {
            filename = String.valueOf(dialog.getDirectory()) + dialogFile;
            if (this.propertyEditor != null && this.propertyEditor.getMakeFilePathRelative()) {
                filename = this.validateFilename(filename);
            }
        }
        dialog.dispose();
        return filename;
    }

    private FocusListener getFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = new FocusListener(this){
                /* synthetic */ IconCustomEditor this$0;

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (e.getSource().equals(IconCustomEditor.access$getSourceNameField(this.this$0)) && IconCustomEditor.access$sourceNameFieldChanged(this.this$0)) {
                        IconCustomEditor.access$getSourceNameField(this.this$0).postActionEvent();
                    }
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
        return this.focusListener;
    }

    private ActionListener getGenericActionListener() {
        if (this.genericActionListener == null) {
            this.genericActionListener = new ActionListener(this){
                /* synthetic */ IconCustomEditor this$0;

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == IconCustomEditor.access$getFileBrowseButton(this.this$0)) {
                        String newFilename = IconCustomEditor.access$getFilenameFromDialog(this.this$0);
                        if (newFilename != null) {
                            IconCustomEditor.access$getSourceNameField(this.this$0).setText(newFilename);
                            IconCustomEditor.access$getSourceNameField(this.this$0).postActionEvent();
                        }
                    } else if (e.getSource() == IconCustomEditor.access$getSourceNameField(this.this$0) && IconCustomEditor.access$getFileChoice(this.this$0).isSelected()) {
                        IconCustomEditor.access$savedFilename(this.this$0, IconCustomEditor.access$getSourceNameField(this.this$0).getText());
                        IconCustomEditor.access$setValue(this.this$0, IconCustomEditor.access$savedFilename(this.this$0));
                        IconCustomEditor.access$sourceNameFieldChanged(this.this$0, false);
                    } else if (e.getSource() == IconCustomEditor.access$getSourceNameField(this.this$0) && IconCustomEditor.access$getURLChoice(this.this$0).isSelected()) {
                        try {
                            IconCustomEditor.access$savedURL(this.this$0, IconCustomEditor.access$getSourceNameField(this.this$0).getText());
                            IconCustomEditor.access$setValue(this.this$0, new URL(IconCustomEditor.access$savedURL(this.this$0)));
                        }
                        catch (Throwable ivjExc) {
                            IconCustomEditor.access$handleException(this.this$0, ivjExc);
                        }
                    }
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
        return this.genericActionListener;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(this.getJPanel1FlowLayout());
                this.ivjJPanel1.setBackground(SystemColor.control);
                this.getJPanel1().add((Component)this.getFileChoice(), this.getFileChoice().getName());
                this.getJPanel1().add((Component)this.getURLChoice(), this.getURLChoice().getName());
                this.getJPanel1().add((Component)this.getNoneChoice(), this.getNoneChoice().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private FlowLayout getJPanel1FlowLayout() {
        FlowLayout ivjJPanel1FlowLayout = null;
        try {
            ivjJPanel1FlowLayout = new FlowLayout();
            ivjJPanel1FlowLayout.setAlignment(0);
            ivjJPanel1FlowLayout.setVgap(0);
            ivjJPanel1FlowLayout.setHgap(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1FlowLayout;
    }

    private JRadioButton getNoneChoice() {
        if (this.ivjNoneChoice == null) {
            try {
                this.ivjNoneChoice = new JRadioButton();
                this.ivjNoneChoice.setName("NoneChoice");
                this.ivjNoneChoice.setText(resabtedit.getString("NoneChoice_text"));
                this.ivjNoneChoice.setEnabled(true);
                this.ivjNoneChoice.addItemListener(this.getChoiceListener());
                this.getChoiceGroup().add(this.ivjNoneChoice);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNoneChoice;
    }

    private JLabel getPreviewLabel() {
        if (this.ivjPreviewLabel == null) {
            try {
                this.ivjPreviewLabel = new JLabel();
                this.ivjPreviewLabel.setName("PreviewLabel");
                this.ivjPreviewLabel.setText("");
                this.ivjPreviewLabel.setHorizontalTextPosition(0);
                this.ivjPreviewLabel.setHorizontalAlignment(0);
                this.ivjPreviewLabel.setVerticalTextPosition(0);
                this.ivjPreviewLabel.setOpaque(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreviewLabel;
    }

    private JPanel getPreviewPanel() {
        if (this.ivjPreviewPanel == null) {
            try {
                this.ivjPreviewPanel = new JPanel();
                this.ivjPreviewPanel.setName("PreviewPanel");
                this.ivjPreviewPanel.setLayout(this.getPreviewPanelCardLayout());
                this.ivjPreviewPanel.setBackground(SystemColor.control);
                this.ivjPreviewPanel.add((Component)this.getWarningMessageArea(), this.getWarningMessageArea().getName());
                this.ivjPreviewPanel.add((Component)this.getPreviewLabel(), this.getPreviewLabel().getName());
                this.ivjPreviewPanel.setBorder(new EtchedBorder(0, SystemColor.controlShadow, SystemColor.controlLtHighlight));
                this.showPreviewPanel();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreviewPanel;
    }

    private CardLayout getPreviewPanelCardLayout() {
        if (this.ivjPreviewPanelCardLayout == null) {
            try {
                this.ivjPreviewPanelCardLayout = new CardLayout();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPreviewPanelCardLayout;
    }

    private IconEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    private JTextField getSourceNameField() {
        if (this.ivjSourceNameField == null) {
            try {
                this.ivjSourceNameField = new JTextField();
                this.ivjSourceNameField.setName("SourceNameField");
                this.ivjSourceNameField.setBackground(SystemColor.textHighlightText);
                this.ivjSourceNameField.setEnabled(true);
                this.ivjSourceNameField.setColumns(30);
                this.ivjSourceNameField.addActionListener(this.getGenericActionListener());
                this.ivjSourceNameField.getDocument().addDocumentListener(this.getDocumentListener());
                this.ivjSourceNameField.addFocusListener(this.getFocusListener());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSourceNameField;
    }

    private JRadioButton getURLChoice() {
        if (this.ivjURLChoice == null) {
            try {
                this.ivjURLChoice = new JRadioButton();
                this.ivjURLChoice.setName("URLChoice");
                this.ivjURLChoice.setText(resabtedit.getString("URLChoice_text"));
                this.ivjURLChoice.setEnabled(true);
                this.ivjURLChoice.addItemListener(this.getChoiceListener());
                this.getChoiceGroup().add(this.ivjURLChoice);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjURLChoice;
    }

    public boolean getURLChoiceEnabled() {
        return this.URLChoiceEnabled;
    }

    private Object getValue() {
        Object result = null;
        if (this.propertyEditor != null) {
            result = this.propertyEditor.getValue();
        }
        return result;
    }

    private PropertyChangeListener getValueListener() {
        if (this.valueListener == null) {
            this.valueListener = new PropertyChangeListener(this){
                /* synthetic */ IconCustomEditor this$0;

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getSource() == IconCustomEditor.access$getPropertyEditor(this.this$0) && e.getPropertyName() == "value") {
                        Icon icon = (Icon)IconCustomEditor.access$getPropertyEditor(this.this$0).getValue();
                        IconCustomEditor.access$getPreviewLabel(this.this$0).setIcon(icon);
                        IconCustomEditor.access$showPreviewPanel(this.this$0);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
        return this.valueListener;
    }

    private JTextArea getWarningMessageArea() {
        if (this.ivjWarningMessageArea == null) {
            try {
                this.ivjWarningMessageArea = new JTextArea();
                this.ivjWarningMessageArea.setName("WarningMessageArea");
                this.ivjWarningMessageArea.setText(resabtedit.getString("IconEditorWarningMessage"));
                this.ivjWarningMessageArea.setBackground(SystemColor.info);
                this.ivjWarningMessageArea.setVisible(false);
                this.ivjWarningMessageArea.setFont(new Font("dialog", 1, 12));
                this.ivjWarningMessageArea.setMargin(new Insets(10, 10, 10, 10));
                this.ivjWarningMessageArea.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjWarningMessageArea;
    }

    private void handleException(Throwable exception) {
        System.out.println(resabtedit.getString("UNCAUGHTEXC"));
        exception.printStackTrace(System.out);
    }

    private void initialize() {
        GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
        GridBagConstraints constraintsSourceNameField = new GridBagConstraints();
        GridBagConstraints constraintsFileBrowseButton = new GridBagConstraints();
        GridBagConstraints constraintsPreviewPanel = new GridBagConstraints();
        this.setName("IconCustomEditor");
        this.setLayout(new GridBagLayout());
        this.setBackground(SystemColor.control);
        this.setSize(400, 250);
        constraintsJPanel1.gridx = 0;
        constraintsJPanel1.gridy = 0;
        constraintsJPanel1.gridwidth = 2;
        constraintsJPanel1.gridheight = 1;
        constraintsJPanel1.fill = 2;
        constraintsJPanel1.anchor = 17;
        constraintsJPanel1.weightx = 0.0;
        constraintsJPanel1.weighty = 0.0;
        constraintsJPanel1.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.getJPanel1(), constraintsJPanel1);
        constraintsSourceNameField.gridx = 0;
        constraintsSourceNameField.gridy = 1;
        constraintsSourceNameField.gridwidth = 1;
        constraintsSourceNameField.gridheight = 1;
        constraintsSourceNameField.fill = 1;
        constraintsSourceNameField.anchor = 10;
        constraintsSourceNameField.weightx = 1.0;
        constraintsSourceNameField.weighty = 0.0;
        constraintsSourceNameField.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.getSourceNameField(), constraintsSourceNameField);
        constraintsFileBrowseButton.gridx = 1;
        constraintsFileBrowseButton.gridy = 1;
        constraintsFileBrowseButton.gridwidth = 1;
        constraintsFileBrowseButton.gridheight = 1;
        constraintsFileBrowseButton.anchor = 17;
        constraintsFileBrowseButton.weightx = 0.0;
        constraintsFileBrowseButton.weighty = 0.0;
        constraintsFileBrowseButton.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.getFileBrowseButton(), constraintsFileBrowseButton);
        constraintsPreviewPanel.gridx = 0;
        constraintsPreviewPanel.gridy = 2;
        constraintsPreviewPanel.gridwidth = 2;
        constraintsPreviewPanel.gridheight = 1;
        constraintsPreviewPanel.fill = 1;
        constraintsPreviewPanel.anchor = 10;
        constraintsPreviewPanel.weightx = 1.0;
        constraintsPreviewPanel.weighty = 1.0;
        constraintsPreviewPanel.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.getPreviewPanel(), constraintsPreviewPanel);
    }

    private boolean isIconInvalid() {
        boolean result = false;
        Object iconValue = this.getValue();
        if (iconValue instanceof NamedImageIcon) {
            NamedImageIcon namedIcon = (NamedImageIcon)iconValue;
            if (namedIcon.getSource() == 1 && this.getClass().getResource(namedIcon.getResourceName()) == null) {
                result = true;
            } else if (namedIcon.getIconWidth() < 0 || namedIcon.getIconHeight() < 0) {
                result = true;
            }
        }
        return result;
    }

    public void setURLChoiceEnabled(boolean newValue) {
        this.URLChoiceEnabled = newValue;
        this.getURLChoice().setVisible(this.URLChoiceEnabled);
    }

    private void setUserState() {
        boolean isFileState = this.getFileChoice().isSelected();
        boolean isURLState = this.getURLChoice().isSelected();
        boolean isNoneState = this.getNoneChoice().isSelected();
        JButton fileBrowse = this.getFileBrowseButton();
        JTextField sourceName = this.getSourceNameField();
        if (isFileState) {
            fileBrowse.setEnabled(true);
            sourceName.setEnabled(true);
            sourceName.setText(this.savedFilename);
            if (sourceName.getText() == null || sourceName.getText().equals("")) {
                this.setValue(null);
            } else {
                sourceName.postActionEvent();
            }
        } else if (isURLState) {
            fileBrowse.setEnabled(false);
            sourceName.setEnabled(true);
            sourceName.setText(this.savedURL);
            if (sourceName.getText() == null || sourceName.getText().equals("")) {
                this.setValue(null);
            } else {
                sourceName.postActionEvent();
            }
        } else if (isNoneState) {
            fileBrowse.setEnabled(false);
            sourceName.setEnabled(false);
            this.setValue(null);
        } else {
            fileBrowse.setEnabled(false);
            sourceName.setEnabled(false);
        }
    }

    private void setValue(Object value) {
        if (this.propertyEditor != null) {
            this.propertyEditor.setValue(value);
        }
    }

    private void showPreviewPanel() {
        this.getWarningMessageArea().setVisible(this.isIconInvalid());
        this.getPreviewLabel().setVisible(!this.isIconInvalid());
        this.getPreviewPanel().invalidate();
        this.getPreviewPanel().validate();
    }

    public String validateFilename(String inFileName) {
        int prLoc;
        String filename = inFileName;
        String sep = File.separator;
        String prDir = String.valueOf(sep) + "project_resources" + sep;
        if (filename != null && !filename.equals("") && (prLoc = filename.indexOf(prDir)) >= 0) {
            filename = ".." + filename.substring(prLoc + prDir.length() - 1);
        }
        return filename;
    }

    static boolean access$sourceNameFieldChanged(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.sourceNameFieldChanged;
    }

    static String access$savedURL(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.savedURL;
    }

    static String access$savedFilename(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.savedFilename;
    }

    static void access$sourceNameFieldChanged(IconCustomEditor iconCustomEditor, boolean bl) {
        iconCustomEditor.sourceNameFieldChanged = bl;
    }

    static void access$savedURL(IconCustomEditor iconCustomEditor, String string) {
        iconCustomEditor.savedURL = string;
    }

    static void access$savedFilename(IconCustomEditor iconCustomEditor, String string) {
        iconCustomEditor.savedFilename = string;
    }

    static JTextField access$getSourceNameField(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.getSourceNameField();
    }

    static JRadioButton access$getURLChoice(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.getURLChoice();
    }

    static void access$setValue(IconCustomEditor iconCustomEditor, Object object) {
        iconCustomEditor.setValue(object);
    }

    static JRadioButton access$getFileChoice(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.getFileChoice();
    }

    static boolean access$isIconInvalid(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.isIconInvalid();
    }

    static void access$handleException(IconCustomEditor iconCustomEditor, Throwable throwable) {
        iconCustomEditor.handleException(throwable);
    }

    static JLabel access$getPreviewLabel(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.getPreviewLabel();
    }

    static IconEditor access$getPropertyEditor(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.getPropertyEditor();
    }

    static String access$getFilenameFromDialog(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.getFilenameFromDialog();
    }

    static void access$setUserState(IconCustomEditor iconCustomEditor) {
        iconCustomEditor.setUserState();
    }

    static JButton access$getFileBrowseButton(IconCustomEditor iconCustomEditor) {
        return iconCustomEditor.getFileBrowseButton();
    }

    static void access$showPreviewPanel(IconCustomEditor iconCustomEditor) {
        iconCustomEditor.showPreviewPanel();
    }
}

