/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import java.awt.Dimension;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;

public class DimensionPropertyEditor
extends PropertyEditorSupport {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");

    public String getAsText() {
        if (this.getValue() instanceof String) {
            return (String)this.getValue();
        }
        return ((Dimension)this.getValue()).width + ", " + ((Dimension)this.getValue()).height;
    }

    public String getJavaInitializationString() {
        Dimension val = (Dimension)this.getValue();
        if (val == null) {
            return "new java.awt.Dimension(0,0)";
        }
        return "new java.awt.Dimension(" + val.width + ", " + val.height + ")";
    }

    private Dimension parseForDimension(String text) throws Exception, NumberFormatException {
        int w = text.indexOf(",");
        if (w < 0) {
            throw new Exception(resabtedit.getString("MustUseComma"));
        }
        String heightText = text.substring(w + ",".length());
        String widthText = text.substring(0, w);
        return new Dimension(Integer.valueOf(widthText.trim()), Integer.valueOf(heightText.trim()));
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text instanceof String) {
            try {
                this.setValue(this.parseForDimension(text));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
            return;
        }
        throw new IllegalArgumentException(text);
    }
}

