/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mask.imask;

import com.ibm.mask.imask.EditableCharacter;
import com.ibm.mask.imask.IMaskInvalidInputException;
import com.ibm.mask.imask.InvalidInputEvent;
import com.ibm.mask.imask.InvalidInputListener;
import com.ibm.mask.imask.MaskString;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IMask
extends JTextField
implements KeyListener,
FocusListener,
Serializable {
    public static final EditableCharacter BLANK = EditableCharacter.BLANK;
    public static final EditableCharacter UNDERSCORE = EditableCharacter.UNDERSCORE;
    private boolean beepStatus = true;
    private StringBuffer template;
    private MaskString maskString;
    private StringBuffer editablePortion;
    private String mask;
    private char maskCharacter = (char)95;
    private EditableCharacter oType = UNDERSCORE;
    private Vector listeners = new Vector();
    private String actualMask;
    private boolean selectOn = true;
    private Color background;
    boolean insertStringValid = false;
    private Document defaultModel;
    private boolean actingAsJTextField = true;
    private Vector textListeners = new Vector(5);
    private transient TextEventFirer firer;
    private boolean overrideMatching = false;
    private boolean reduceCaretPosition = false;
    private String oldData;
    private boolean shouldFireTextEvent = true;

    public IMask() {
        this("", 10);
    }

    public IMask(int n) {
        this("", n);
    }

    public IMask(String string) {
        this(string, 10);
    }

    public IMask(String string, int n) {
        this(null, string, n);
    }

    public IMask(Document document, String string, int n) {
        super(n);
        if (document != null) {
            this.setDocument(document);
        }
        if (string != null) {
            this.setMask(string);
        }
        this.setBackground(Color.white);
        this.setMaskCharacter(UNDERSCORE);
        if (this.actingAsJTextField) {
            this.insertStringValid = true;
        }
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.enableEvents(16L);
        this.firer = new TextEventFirer(this);
        this.oldData = this.getData();
    }

    public synchronized void addInvalidInputListener(InvalidInputListener invalidInputListener) {
        if (invalidInputListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(invalidInputListener)) {
            this.listeners.addElement(invalidInputListener);
        }
    }

    private void blankCharacters(int n, int n2) {
        try {
            int n3 = n;
            while (n3 < n2) {
                if (this.maskString.isEditable(n3)) {
                    this.template.setCharAt(n3, this.maskCharacter);
                }
                ++n3;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void error(char c) {
        if (this.isBeepOnError() && c != '\r' && c != '\n') {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.maskString != null) {
            InvalidInputEvent invalidInputEvent = new InvalidInputEvent(this, c);
            if (c != '\r' && c != '\n') {
                this.shouldFireTextEvent = false;
                this.throwEvent(invalidInputEvent);
            }
            int n = super.getCaretPosition();
            super.setText(this.template.toString());
            super.setCaretPosition(n);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.selectOn) {
            super.setCaretPosition(this.getText().length());
            super.moveCaretPosition(0);
            return;
        }
        int n = super.getCaretPosition();
        this.select(n, n);
    }

    public void focusLost(FocusEvent focusEvent) {
        int n = super.getCaretPosition();
        this.select(n, n);
    }

    public Color getBackground() {
        return this.background;
    }

    public boolean isBeepOnError() {
        return this.beepStatus;
    }

    public String getData() {
        if (Beans.isDesignTime()) {
            return " ";
        }
        if (this.maskString == null) {
            return super.getText();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.maskString.toString().length()) {
            if (this.maskString.isEditable(n)) {
                if (this.template.charAt(n) == this.maskCharacter) {
                    stringBuffer.append(' ');
                } else {
                    stringBuffer.append(this.template.charAt(n));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getMask() {
        if (this.actualMask == null) {
            return new String("");
        }
        return this.actualMask;
    }

    public EditableCharacter getMaskCharacter() {
        return this.oType;
    }

    public boolean isSelectOnFocus() {
        return this.selectOn;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.insertStringValid = true;
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        if (this.maskString == null || this.maskString.toString().length() == 0) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        if (keyEvent.getModifiers() == 8 || keyEvent.getModifiers() == 2 || keyEvent.getModifiers() == 4) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (c == '\n' || c == '\r') {
            this.shouldFireTextEvent = false;
            return;
        }
        this.getCaretPosition();
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        if (n == 127) {
            int n4;
            boolean bl = false;
            String string = this.getData();
            if (string != null) {
                n4 = 0;
                int n5 = 0;
                while (n5 < string.length()) {
                    if (string.charAt(n5) == ' ') {
                        ++n4;
                    }
                    ++n5;
                }
                if (n4 == string.length()) {
                    bl = true;
                }
            }
            this.blankCharacters(n2, n3);
            this.firePropertyChangeEvents();
            try {
                if (n2 == n3 && this.maskString.toString().length() != n2) {
                    if (this.maskString.isEditable(n2)) {
                        this.template.setCharAt(n2, this.maskCharacter);
                        this.firePropertyChangeEvents();
                    } else if (this.isBeepOnError()) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                super.setText(this.template.toString());
                n4 = 0;
                if (n4 != 0) {
                    String string2 = this.getData();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n6 = 0;
                    while (n6 < string2.length()) {
                        if (string2.charAt(n6) != ' ') {
                            stringBuffer.append(string2.charAt(n6));
                        }
                        ++n6;
                    }
                    this.setData(stringBuffer.toString());
                    this.setNextCaretPosition(n2);
                } else if (n2 == n3 && !bl) {
                    this.setNextCaretPosition(n2 + 1);
                } else {
                    this.setNextCaretPosition(n3);
                }
            }
            catch (Exception exception) {}
            keyEvent.consume();
        } else if (n == 8) {
            keyEvent.consume();
            return;
        }
        this.handleKeyPress(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n;
        this.insertStringValid = true;
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        if (this.maskString == null || this.maskString.toString().length() == 0) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        int n2 = keyEvent.getKeyCode();
        if (n2 == 37 || n2 == 39 || n2 == 36 || n2 == 16 || n2 == 35) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        if (n2 == 127) {
            keyEvent.consume();
            return;
        }
        if (keyEvent.getModifiers() == 2 || keyEvent.getModifiers() == 4) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        char c = keyEvent.getKeyChar();
        int n3 = n = this.getCaretPosition();
        if (this.template.length() == n && c != '\b') {
            this.error(c);
            keyEvent.consume();
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        int n4 = this.getSelectionStart();
        int n5 = this.getSelectionEnd();
        keyEvent.consume();
        this.setNextCaretPosition(n);
        n = this.getCaretPosition();
        this.blankCharacters(n4, n5);
        if (c == '\b') {
            try {
                n3 = n5;
                while (!this.maskString.isEditable(--n3)) {
                }
                this.template.setCharAt(n3, this.maskCharacter);
                super.setText(this.template.toString());
                String string = this.getMask();
                char c2 = string.charAt(0);
                boolean bl = true;
                int n6 = 1;
                while (n6 < string.length()) {
                    char c3 = string.charAt(n6);
                    if (c3 != c2) {
                        bl = false;
                        break;
                    }
                    ++n6;
                }
                if (bl) {
                    String string2 = this.getData();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n7 = 0;
                    while (n7 < string2.length()) {
                        if (string2.charAt(n7) != ' ') {
                            stringBuffer.append(string2.charAt(n7));
                        }
                        ++n7;
                    }
                    this.setData(stringBuffer.toString());
                }
                if (n4 == n5) {
                    this.setNextCaretPosition(n3);
                } else {
                    this.setNextCaretPosition(n4);
                }
            }
            catch (Exception exception) {
                this.error(c);
                super.setText(this.template.toString());
                this.setNextCaretPosition(n);
            }
            keyEvent.consume();
        }
    }

    private void handleKeyPress(KeyEvent keyEvent) {
        this.insertStringValid = true;
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        if (this.maskString == null || this.maskString.toString().length() == 0) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 37 || n == 39 || n == 36 || n == 16 || n == 35) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        if (n == 127 || n == 8) {
            keyEvent.consume();
            return;
        }
        if (keyEvent.getModifiers() == 2 || keyEvent.getModifiers() == 4) {
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        char c = keyEvent.getKeyChar();
        int n2 = this.getCaretPosition();
        if (this.template.length() == n2 && c != '\b') {
            this.error(c);
            keyEvent.consume();
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        int n3 = this.getSelectionStart();
        int n4 = this.getSelectionEnd();
        keyEvent.consume();
        this.setNextCaretPosition(n2);
        n2 = this.getCaretPosition();
        this.blankCharacters(n3, n4);
        try {
            if (n3 != n4 && n4 != this.getData().length() && n3 != 0) {
                this.reduceCaretPosition = true;
            }
            if (!this.validateInput(c)) {
                this.error(c);
            }
            this.reduceCaretPosition = false;
        }
        catch (Exception exception) {
            this.error(c);
        }
        String string = this.getMask();
        char c2 = string.charAt(0);
        boolean bl = true;
        int n5 = 1;
        while (n5 < string.length()) {
            char c3 = string.charAt(n5);
            if (c3 != c2) {
                bl = false;
                break;
            }
            ++n5;
        }
        if (bl && n3 != n4 && n4 != this.getData().length() && n3 != 0) {
            String string2 = this.getData();
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            while (n6 < string2.length()) {
                if (string2.charAt(n6) != ' ') {
                    stringBuffer.append(string2.charAt(n6));
                }
                ++n6;
            }
            try {
                this.setData(stringBuffer.toString());
                this.setCaretPosition(n3);
            }
            catch (IMaskInvalidInputException iMaskInvalidInputException) {}
        }
        if (!this.actingAsJTextField) {
            this.insertStringValid = false;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    public synchronized void removeInvalidInputListener(InvalidInputListener invalidInputListener) {
        if (invalidInputListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.contains(invalidInputListener)) {
            this.listeners.removeElement(invalidInputListener);
        }
    }

    public void setBeepOnError(boolean bl) {
        boolean bl2 = this.beepStatus;
        this.beepStatus = bl;
        this.firePropertyChange("beepOnError", new Boolean(bl2), new Boolean(this.beepStatus));
    }

    public void setData(String string) throws IMaskInvalidInputException {
        if (Beans.isDesignTime()) {
            return;
        }
        if (string == null) {
            throw new IllegalArgumentException("Null Positive Prefix!");
        }
        this.insertStringValid = true;
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        int n = this.getCaretPosition();
        if (this.maskString == null || this.maskString.toString().length() == 0) {
            super.setText(string);
            n = this.getCaretPosition();
            super.setCaretPosition(n);
            super.selectAll();
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        this.blankCharacters(0, this.getText().length());
        this.setNextCaretPosition(0);
        if (string == null || string.length() == 0) {
            super.setText(this.template.toString());
            if (!this.actingAsJTextField) {
                this.insertStringValid = false;
            }
            return;
        }
        if (string.length() > this.maskString.toString().length()) {
            throw new IMaskInvalidInputException("Data length is greater than the mask length!");
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (!this.validateInput(string.charAt(n2))) {
                throw new IMaskInvalidInputException("Character doesnot match Input");
            }
            ++n2;
        }
        if (!this.actingAsJTextField) {
            this.insertStringValid = false;
        }
    }

    public void setMask(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null Mask!");
        }
        this.insertStringValid = true;
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        String string2 = this.actualMask;
        this.actualMask = string;
        if (string == null || string.equals("")) {
            this.template = new StringBuffer();
            this.editablePortion = new StringBuffer();
            this.maskString = null;
            super.setText("");
            this.insertStringValid = true;
            this.actingAsJTextField = true;
            return;
        }
        this.actingAsJTextField = false;
        this.maskString = new MaskString(string, this.maskCharacter);
        string = new String(this.maskString.toString());
        this.template = new StringBuffer(string);
        super.setText(string);
        this.editablePortion = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (this.maskString.isEditable(n)) {
                this.editablePortion.append(this.maskCharacter);
            }
            ++n;
        }
        this.firePropertyChange("mask", string2, this.actualMask);
        if (!this.actingAsJTextField) {
            this.insertStringValid = false;
        }
    }

    public void setMaskCharacter(EditableCharacter editableCharacter) {
        if (editableCharacter == null) {
            throw new IllegalArgumentException("Null MaskCharacter passed!");
        }
        this.insertStringValid = true;
        EditableCharacter editableCharacter2 = this.oType;
        if (this.oType != editableCharacter) {
            this.oType = editableCharacter;
            this.maskCharacter = editableCharacter == BLANK ? (char)32 : (char)95;
            if (this.template == null) {
                if (!this.actingAsJTextField) {
                    this.insertStringValid = false;
                }
                return;
            }
            int n = 0;
            while (n < this.template.toString().length()) {
                if (this.maskString.isEditable(n) && (this.template.charAt(n) == ' ' || this.template.charAt(n) == '_')) {
                    this.template.setCharAt(n, this.maskCharacter);
                }
                ++n;
            }
            super.setText(this.template.toString());
            this.firePropertyChange("MaskCharacter", editableCharacter2, this.oType);
        }
        if (!this.actingAsJTextField) {
            this.insertStringValid = false;
        }
    }

    private void setNextCaretPosition(int n) {
        int n2 = n;
        try {
            while (!this.maskString.isEditable(n2)) {
                ++n2;
            }
        }
        catch (Exception exception) {}
        super.setCaretPosition(n2);
    }

    public void setSelectOnFocus(boolean bl) {
        boolean bl2 = this.selectOn;
        this.selectOn = bl;
        this.firePropertyChange("selectOnFocus", new Boolean(bl2), new Boolean(this.selectOn));
    }

    public void setText(String string) {
    }

    private void throwEvent(InvalidInputEvent invalidInputEvent) {
        Vector vector;
        IMask iMask = this;
        synchronized (iMask) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((InvalidInputListener)vector.elementAt(n)).invalidCharacterEntered(invalidInputEvent);
            ++n;
        }
    }

    private boolean validateInput(char c) {
        int n = this.getCaretPosition();
        if (this.maskString.matchType('U', n)) {
            c = Character.toUpperCase(c);
        }
        if (this.maskString.matchType('L', n)) {
            c = Character.toLowerCase(c);
        }
        if (!this.maskString.matches(c, n)) {
            if (this.overrideMatching) {
                this.template.setCharAt(n, this.getMaskCharacter().charValue());
                super.setText(this.template.toString());
                this.setNextCaretPosition(n + 1);
                return true;
            }
            return false;
        }
        this.template.setCharAt(n, c);
        super.setText(this.template.toString());
        this.setNextCaretPosition(n + 1);
        return true;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Null color passed!");
        }
        Color color2 = this.background;
        this.background = color;
        super.setBackground(this.background);
        this.firePropertyChange("Background", color2, this.background);
    }

    public void setSelectedTextColor(Color color) {
        super.setSelectedTextColor(color);
    }

    public void setSelectionStart(int n) {
        super.setSelectionStart(n);
    }

    boolean getShouldFireTextEvent() {
        return this.shouldFireTextEvent;
    }

    void setShouldFireTextEvent(boolean bl) {
        this.shouldFireTextEvent = bl;
    }

    public void setSelectionEnd(int n) {
        super.setSelectionEnd(n);
    }

    protected Document createDefaultModel() {
        return new InternalDocument();
    }

    public Document getDocument() {
        Document document = super.getDocument();
        if (document != null) {
            return document;
        }
        if (this.defaultModel == null) {
            this.defaultModel = this.createDefaultModel();
        }
        return this.defaultModel;
    }

    public void setDocument(Document document) {
        if (document != null && document instanceof InternalDocument) {
            super.setDocument(document);
            return;
        }
        throw new IllegalArgumentException("Only InternalDocument can be set!");
    }

    public synchronized void addTextListener(TextListener textListener) {
        if (this.textListeners == null) {
            this.textListeners = new Vector(5);
        }
        if (this.textListeners.contains(textListener)) {
            return;
        }
        this.textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        if (this.textListeners == null) {
            return;
        }
        if (!this.textListeners.contains(textListener)) {
            return;
        }
        this.textListeners.removeElement(textListener);
    }

    Vector getTextListeners() {
        return (Vector)this.textListeners.clone();
    }

    private void firePropertyChangeEvents() {
        String string;
        if (this.oldData == null) {
            this.oldData = new String(" ");
        }
        if (!this.oldData.equals(string = this.getData())) {
            this.firePropertyChange("data", this.oldData, string);
            this.oldData = new String(string);
        }
    }

    class InternalDocument
    extends PlainDocument {
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (IMask.this.insertStringValid) {
                super.insertString(n, string, attributeSet);
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (IMask.this.insertStringValid) {
                super.remove(n, n2);
            }
        }

        InternalDocument() {
            IMask.this = IMask.this;
        }
    }

    class TextEventFirer
    implements DocumentListener {
        IMask source;

        TextEventFirer(IMask iMask2) {
            IMask.this = IMask.this;
            this.source = iMask2;
            this.source.getDocument().addDocumentListener(this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!this.source.getShouldFireTextEvent()) {
                this.source.setShouldFireTextEvent(true);
                return;
            }
            TextEvent textEvent = new TextEvent(this.source, 900);
            Vector vector = this.source.getTextListeners();
            TextEventFirer textEventFirer = this;
            synchronized (textEventFirer) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    TextListener textListener = (TextListener)enumeration.nextElement();
                    textListener.textValueChanged(textEvent);
                }
                return;
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!this.source.getShouldFireTextEvent()) {
                this.source.setShouldFireTextEvent(true);
                return;
            }
            TextEvent textEvent = new TextEvent(this.source, 900);
            Vector vector = this.source.getTextListeners();
            TextEventFirer textEventFirer = this;
            synchronized (textEventFirer) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    TextListener textListener = (TextListener)enumeration.nextElement();
                    textListener.textValueChanged(textEvent);
                }
                return;
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }
    }
}

