/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.BeginInsertionData;
import com.ibm.jpos.services.ibmprinter.BeginRemovalData;
import com.ibm.jpos.services.ibmprinter.CutPaperData;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOData;
import com.ibm.jpos.services.ibmprinter.DirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrintRawModeInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrinterRead;
import com.ibm.jpos.services.ibmprinter.EndInsertionData;
import com.ibm.jpos.services.ibmprinter.EndRemovalData;
import com.ibm.jpos.services.ibmprinter.MapModeCalculator;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtilImplementor;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrintGetDirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.PrintImmediateData;
import com.ibm.jpos.services.ibmprinter.PrintNormalData;
import com.ibm.jpos.services.ibmprinter.PrintNormalDataVector;
import com.ibm.jpos.services.ibmprinter.PrintQueueData;
import com.ibm.jpos.services.ibmprinter.PrintQueueElement;
import com.ibm.jpos.services.ibmprinter.PrintQueueManager;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerCallback;
import com.ibm.jpos.services.ibmprinter.PrintTwoNormalData;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.ibmprinter.SetCharacterSetData;
import com.ibm.jpos.services.ibmprinter.SetLogoData;
import com.ibm.jpos.services.ibmprinter.TransactionPrintData;
import com.ibm.jpos.services.ibmprinter.ValidateDataData;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.services.poss.POSSPrintDataCompiler;
import com.ibm.jpos.services.poss.POSSPrintImmediateData;
import com.ibm.jpos.services.poss.POSSPrintNormalData;
import com.ibm.jpos.services.poss.POSSPrintTwoNormalData;
import com.ibm.jpos.util.BooleanMonitor;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.Debug;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import com.ibm.poss.PosmPrnChaseCompleteListener;
import com.ibm.poss.PosmPrnPrinterErrorListener;
import com.ibm.poss.PosmPrnStatusChangeListener;
import com.ibm.poss.Printer;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.config.JposEntry;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public abstract class POSSPOSPrinterServiceImp
extends POSSDeviceServiceImp
implements POSPrinterServiceImp,
PosDef,
Printer,
POSPrinterConst,
PrintBitmapUtilImplementor,
PrintQueueManagerCallback {
    private static final boolean debug = true;
    MapModeCalculator mapModeCalc = new MapModeCalculator();
    protected PosDevice posDevice = this.getPosDevice();
    POSPrinterListener printerListener = new POSPrinterListener();
    protected static Debug debugPrintBitmap = new Debug(false);
    private static final String className = "POSSPOSPrinterServiceImp";
    protected EventCallbacks eventCallbacks = null;
    protected Object eventSource = null;
    protected POSPrinterServiceState serviceState = null;
    protected PrintBitmapUtil printBitmapUtil = null;
    protected boolean useChase = true;
    protected boolean keepInRawMode = false;
    protected BooleanMonitor documentInserted = null;
    protected BooleanMonitor documentRegistered = null;
    protected BooleanMonitor chaseCompleted = null;
    protected EventQueueManager eventQueueManager = null;
    protected PrintQueueManager printQueueManager = null;
    private PrintingMode[] printingModes = null;
    protected int posNprintStatus = 0;
    private int posNprintStatus2 = 0;
    protected int selectedStations = 2;
    protected int printerErrorCause = 0;

    protected POSSPOSPrinterServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor", "Entry");
        this.posDevice.setPosmPrnChaseCompleteListener(this.printerListener);
        this.posDevice.setPosmPrnPrinterErrorListener(this.printerListener);
        this.posDevice.setPosmPrnStatusChangeListener(this.printerListener);
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        Tracer.trace(4, className, "deleteImp()", "Entry");
        this.posDevice.setPosmPrnChaseCompleteListener(null);
        this.posDevice.setPosmPrnPrinterErrorListener(null);
        this.posDevice.setPosmPrnStatusChangeListener(null);
        Tracer.trace(4, className, "deleteImp()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        this.eventCallbacks = eventCallbacks;
        this.eventSource = this.eventCallbacks.getEventSource();
        this.serviceState = (POSPrinterServiceState)this.getDeviceServiceState();
        this.printBitmapUtil = new PrintBitmapUtil(this.getDeviceServiceAbstraction(), this);
        this.keepInRawMode = false;
        this.documentInserted = new BooleanMonitor(false);
        this.documentRegistered = new BooleanMonitor(false);
        this.chaseCompleted = new BooleanMonitor(false);
        this.documentInserted.set(false);
        this.documentRegistered.set(false);
        this.chaseCompleted.set(false);
        try {
            this.useChase = true;
            JposEntry jposEntry = this.getJposEntry();
            Enumeration enumeration = jposEntry.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                if (!string3.equalsIgnoreCase("chaseModeEnabled") || (string2 = jposEntry.getPropertyValue(string3).toString()).equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("on")) continue;
                this.useChase = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "open()", "chasing is " + (this.useChase ? "enabled" : "disabled"));
        this.setupCodePages();
        this.processDynamicCapabilities();
        Tracer.trace(4, className, "open()", "Exit");
    }

    protected final String getPOSSDeviceClass() {
        return "PosPrinter";
    }

    protected final boolean isCompositeDevice() {
        return true;
    }

    public void claim(int n) throws JposException {
        PosArg[] posArgArray;
        block4: {
            Tracer.trace(4, className, "claim(" + n + ")", "Entry");
            super.claim(n);
            this.eventQueueManager = this.getDeviceServiceAbstraction().getEventQueueManager();
            this.printQueueManager = new PrintQueueManager(this.serviceState, this.eventQueueManager, this.eventCallbacks.getEventSource(), this);
            try {
                posArgArray = new PosArg[]{new PosArg("printStatus", 0), new PosArg("printStatus2", 0)};
                this.posDevice.ioctl(302, posArgArray);
                this.posDevice.ioctl(4905);
                this.posDevice.ioctl(4903);
            }
            catch (Exception exception) {
                Tracer.trace(4, className, "claim(" + n + ")", "Exception during discard-resume");
                if (Tracer.getTraceLevel() < 3) break block4;
                exception.printStackTrace();
            }
        }
        posArgArray = new PosArg[]{new PosArg("leftMarginCR", 0)};
        try {
            this.posDevice.ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            // empty catch block
        }
        this.printingModes = new PrintingMode[5];
        this.printingModes[1] = new PrintingMode(1);
        this.printingModes[2] = new PrintingMode(2);
        this.printingModes[4] = new PrintingMode(4);
        Tracer.trace(4, className, "claim()", "Exit");
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled(" + bl + ")", "Entry");
        super.setDeviceEnabled(bl);
        if (bl) {
            this.posNprintStatus = 0;
            this.selectedStations = 2;
            this.printerErrorCause = 0;
            this.serviceState.setSlpEmpty(true);
            this.queryPrinterStatus(true);
            this.setCharacterSet(this.serviceState.getCharacterSet());
            this.setJrnLineSpacing(this.serviceState.getJrnLineSpacing());
            this.getPrintingMode(1).setPosNlineFeed(this.calculatePosNlineFeedSJ());
            this.setRecLineSpacing(this.serviceState.getRecLineSpacing());
            this.getPrintingMode(2).setPosNlineFeed(this.calculatePosNlineFeedCR());
            this.setSlpLineSpacing(this.serviceState.getSlpLineSpacing());
            this.getPrintingMode(4).setPosNlineFeed(this.calculatePosNlineFeedDI());
        }
        this.clearOutput();
        Tracer.trace(4, className, "setDeviceEnabled()", "Exit");
    }

    private void setupCodePages() throws JposException {
        int n = -1;
        int n2 = -1;
        try {
            n = this.posDevice.getDefaultCodePage();
            if (n == -1) {
                n = 437;
            }
            n2 = ByteEncoder.getCharacterSet(n);
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(this.serviceState.getCharacterSetList(), ",");
            while (stringTokenizer.hasMoreElements()) {
                if (!stringTokenizer.nextToken().equals(Integer.toString(n2))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.serviceState.setCharacterSetList(this.serviceState.getCharacterSetList() + "," + n2);
            }
            this.serviceState.setCharacterSet(n2);
            this.serviceState.setCapCharacterSet(ByteEncoder.getCapCharacterSet(n2));
            PrinterFont[] printerFontArray = this.getPrinterFonts();
            int n3 = 1000;
            int n4 = 1000;
            int n5 = 1000;
            String string = "";
            String string2 = "";
            String string3 = "";
            int n6 = 0;
            while (n6 < printerFontArray.length) {
                switch (printerFontArray[n6].station) {
                    case 1: {
                        if (string.length() > 0) {
                            string = string + ",";
                        }
                        string = string + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n3) break;
                        n3 = printerFontArray[n6].lineChars;
                        break;
                    }
                    case 2: {
                        if (string2.length() > 0) {
                            string2 = string2 + ",";
                        }
                        string2 = string2 + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n4) break;
                        n4 = printerFontArray[n6].lineChars;
                        break;
                    }
                    case 4: {
                        if (string3.length() > 0) {
                            string3 = string3 + ",";
                        }
                        string3 = string3 + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n5) break;
                        n5 = printerFontArray[n6].lineChars;
                    }
                }
                ++n6;
            }
            if (this.serviceState.getCapSlpPresent()) {
                this.serviceState.setSlpLineCharsList(string3);
            }
            if (this.serviceState.getCapRecPresent()) {
                this.serviceState.setRecLineCharsList(string2);
            }
            if (this.serviceState.getCapJrnPresent()) {
                this.serviceState.setJrnLineCharsList(string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JposException(111, "JPOS_E_FAILURE: Unsupported code page: " + n);
        }
        catch (PosException posException) {
            throw new JposException(111, "JPOS_E_FAILURE: PosException: " + posException.getMessage(), posException);
        }
    }

    public void beginInsertion(int n) throws JposException {
        Tracer.trace(4, className, "beginInsertion(" + n + ")", "Entry");
        this.printQueueManager.post(new BeginInsertionData(n));
        Tracer.trace(4, className, "beginInsertion()", "Exit");
    }

    public void processBeginInsertion(BeginInsertionData beginInsertionData) throws JposException {
        Tracer.trace(4, className, "processBeginInsertion()", "Entry");
        if (beginInsertionData.getTimeout() != 0) {
            this.documentInserted.waitForTrue(beginInsertionData.getTimeout());
        }
        Tracer.trace(4, className, "processBeginInsertion()", "Exit");
    }

    public void beginRemoval(int n) throws JposException {
        Tracer.trace(4, className, "beginRemoval(" + n + ")", "Entry");
        this.printQueueManager.post(new BeginRemovalData(n));
        Tracer.trace(4, className, "beginRemoval()", "Exit");
    }

    public void processBeginRemoval(BeginRemovalData beginRemovalData) throws JposException {
        Tracer.trace(4, className, "processBeginRemoval()", "Entry");
        this.checkStations(4);
        if (this.documentRegistered.isTrue()) {
            this.selectStations(4);
            try {
                this.posDevice.write(new byte[]{27, 77});
            }
            catch (PosException posException) {
                throw this.createJposException(posException);
            }
        }
        if (beginRemovalData.getTimeout() != 0) {
            this.documentInserted.waitForFalse(beginRemovalData.getTimeout());
        }
        Tracer.trace(4, className, "processBeginRemoval()", "Exit");
    }

    public void clearOutput() throws JposException {
        Tracer.trace(4, className, "clearOutput()", "Entry");
        this.printQueueManager.clearOutput();
        this.chaseCompleted.forceTimeout();
        this.documentInserted.forceTimeout();
        this.documentRegistered.forceTimeout();
        this.getPrintingMode(2).setRotation(1);
        this.getPrintingMode(4).setRotation(1);
        this.getPrintingMode(1).clearTransaction();
        this.getPrintingMode(1).clearSideways();
        this.getPrintingMode(2).clearTransaction();
        this.getPrintingMode(2).clearSideways();
        this.getPrintingMode(4).clearTransaction();
        this.getPrintingMode(4).clearSideways();
        this.eventQueueManager.removeAllErrorEvent();
        Tracer.trace(4, className, "clearOutput()", "Exit");
    }

    public void cutPaper(int n) throws JposException {
        Tracer.trace(4, className, "cutPaper(" + n + ")", "Entry");
        if (this.printQueueManager.getPostingRotation(2) != 1) {
            throw new JposException(106);
        }
        this.printQueueManager.post(new CutPaperData(n, this.serviceState.getAsyncMode()));
        Tracer.trace(4, className, "cutPaper()", "Exit");
    }

    public void processCutPaper(CutPaperData cutPaperData) throws JposException {
        PrintingMode printingMode = this.getPrintingMode(2);
        this.checkStations(2);
        try {
            if (!printingMode.isTransaction()) {
                this.selectStations(2);
                this.chaseCompleted.set(false);
            }
            this.posDevice.write(new byte[]{27, 80});
            if (!printingMode.isTransaction()) {
                this.chase();
            }
        }
        catch (Exception exception) {
            printingMode.clearTransaction();
            throw this.createJposException(exception);
        }
    }

    public void endInsertion() throws JposException {
        Tracer.trace(4, className, "endInsertion()", "Entry");
        this.printQueueManager.post(new EndInsertionData());
        Tracer.trace(4, className, "endInsertion()", "Entry");
    }

    public void processEndInsertion(EndInsertionData endInsertionData) throws JposException {
        Tracer.trace(4, className, "processEndInsertion()", "Entry");
        if (this.documentInserted.isFalse()) {
            throw new JposException(114, 204);
        }
        this.checkStations(4);
        this.selectStations(4);
        if (this.documentRegistered.isFalse()) {
            try {
                this.posDevice.write(new byte[]{27, 76});
                this.documentRegistered.waitForTrue(3000);
            }
            catch (JposException jposException) {
                this.checkPrinterErrorCause(endInsertionData);
                throw new JposException(111);
            }
            catch (PosException posException) {
                this.checkPrinterErrorCause(endInsertionData);
                throw this.createJposException(posException);
            }
        }
        Tracer.trace(4, className, "processEndInsertion()", "Exit");
    }

    public void endRemoval() throws JposException {
        Tracer.trace(4, className, "endRemoval()", "Entry");
        this.printQueueManager.post(new EndRemovalData());
        Tracer.trace(4, className, "endRemoval()", "Exit");
    }

    public void processEndRemoval(EndRemovalData endRemovalData) throws JposException {
        Tracer.trace(4, className, "processEndRemoval()", "Entry");
        if (this.documentInserted.isTrue()) {
            throw new JposException(114, 205);
        }
        this.selectStations(2);
        Tracer.trace(4, className, "processEndRemoval()", "Exit");
    }

    public void printBarCode(int n, String string, int n2, int n3, int n4, int n5, int n6) throws JposException {
        Tracer.trace(4, className, "PrintBarCode()", "Entry");
        if (this.printQueueManager.getPostingRotation(n) != 1) {
            throw new JposException(106);
        }
        switch (n2) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 201: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal symbology: " + n2);
            }
        }
        switch (n5) {
            case -3: 
            case -2: 
            case -1: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal alignment: " + n5);
            }
        }
        switch (n6) {
            case -13: 
            case -12: 
            case -11: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal textPosition: " + n6);
            }
        }
        this.printQueueManager.post(new PrintBarCodeData(n, string, n2, n3, n4, n5, n6, this.serviceState.getAsyncMode()));
        Tracer.trace(4, className, "PrintBarCode()", "Exit");
    }

    public void printBitmap(int n, String string, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "printBitmap(" + n + ", " + string + ", " + n2 + ", " + n3 + ")", "Entry");
        if (this.printQueueManager.getPostingRotation(n) != 1) {
            throw new JposException(106);
        }
        int n4 = this.calcStationWidth(n);
        if (n2 != -11 && n2 > n4) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1) {
            n4 = this.convertToDots(n4, n);
            if (n2 != -11) {
                n2 = this.convertToDots(n2, n);
            }
        }
        PrintBitmapData printBitmapData = new PrintBitmapData(n, string, n2, n3, this.serviceState.getAsyncMode(), null);
        this.printBitmapUtil.validateBitmap(printBitmapData, 2, n4);
        this.printQueueManager.post(printBitmapData);
        Tracer.trace(4, className, "printBitmap()", "Exit");
    }

    public void processPrintBitmap(PrintBitmapData printBitmapData) throws JposException {
        Tracer.trace(4, className, "processPrintBitmap()", "Entry");
        int n = printBitmapData.getStation();
        PrintingMode printingMode = this.getPrintingMode(n);
        this.checkStations(n);
        try {
            if (!printingMode.isTransaction()) {
                this.selectStations(n);
                this.chaseCompleted.set(false);
            }
            this.doPrinting(printBitmapData.getStation(), printBitmapData.getBitmapStream(), printBitmapData.getAlignment(), 2);
            if (!printingMode.isTransaction()) {
                this.chase();
            }
        }
        catch (Exception exception) {
            printingMode.clearTransaction();
            this.checkPrinterErrorCause(printBitmapData);
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "processPrintBitmap()", "Exit");
    }

    public void printNormal(int n, String string) throws JposException {
        Tracer.trace(4, className, "printNormal()", "Entry");
        byte[] byArray = null;
        POSSPrintDataCompiler pOSSPrintDataCompiler = (POSSPrintDataCompiler)this.getPrintDataCompiler();
        PrintingMode printingMode = this.getPrintingMode(n);
        if (!printingMode.isTransaction()) {
            byArray = pOSSPrintDataCompiler.compile(n, string, this.printQueueManager.getPostingRotation(n), this.printBitmapUtil, this.getPrinterFonts());
        }
        this.printQueueManager.post(new POSSPrintNormalData(n, string, this.serviceState.getAsyncMode(), pOSSPrintDataCompiler.hasReversedLines(), this.printQueueManager.getPostingRotation(n), byArray, pOSSPrintDataCompiler.getSelectedPrinterFont()));
        Tracer.trace(4, className, "printNormal()", "Exit");
    }

    public void processPrintNormalDataVector(PrintNormalDataVector printNormalDataVector) throws JposException {
        POSSPrintNormalData pOSSPrintNormalData;
        byte[] byArray;
        Tracer.trace(4, className, "processPrintNormalDataVector()", "Entry");
        PrintQueueData printQueueData = null;
        StringBuffer stringBuffer = new StringBuffer("");
        POSSPrintDataCompiler pOSSPrintDataCompiler = (POSSPrintDataCompiler)this.getPrintDataCompiler();
        int n = 0;
        while (n < printNormalDataVector.size()) {
            printQueueData = (POSSPrintNormalData)printNormalDataVector.elementAt(n);
            if (stringBuffer.length() + ((PrintNormalData)printQueueData).getData().length() + 100 > this.getMaxBytesPerWrite(printQueueData.getStation())) {
                byArray = pOSSPrintDataCompiler.compile(printQueueData.getStation(), stringBuffer.toString(), ((POSSPrintNormalData)printQueueData).getRotation(), this.printBitmapUtil, this.getPrinterFonts());
                pOSSPrintNormalData = new POSSPrintNormalData(printQueueData.getStation(), "", printQueueData.isAsyncMode(), printQueueData.hasReversedLines(), ((POSSPrintNormalData)printQueueData).getRotation(), byArray, ((POSSPrintNormalData)printQueueData).getPrinterFont());
                this.processPrintNormal(pOSSPrintNormalData);
                stringBuffer = new StringBuffer("");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\u001b|N");
            }
            stringBuffer.append(((PrintNormalData)printQueueData).getData());
            ++n;
        }
        byArray = pOSSPrintDataCompiler.compile(printQueueData.getStation(), stringBuffer.toString(), ((POSSPrintNormalData)printQueueData).getRotation(), this.printBitmapUtil, this.getPrinterFonts());
        pOSSPrintNormalData = new POSSPrintNormalData(printQueueData.getStation(), "", printQueueData.isAsyncMode(), printQueueData.hasReversedLines(), ((POSSPrintNormalData)printQueueData).getRotation(), byArray, ((POSSPrintNormalData)printQueueData).getPrinterFont());
        this.processPrintNormal(pOSSPrintNormalData);
        Tracer.trace(4, className, "processPrintNormalDataVector()", "Exit");
    }

    public void processPrintNormal(PrintNormalData printNormalData) throws JposException {
        Tracer.trace(4, className, "processPrintNormal()", "Entry");
        POSSPrintNormalData pOSSPrintNormalData = (POSSPrintNormalData)printNormalData;
        int n = pOSSPrintNormalData.getStation();
        PrintingMode printingMode = this.getPrintingMode(n);
        Tracer.trace(4, className, "processPrintNormal()", "data: \n   " + printNormalData.getData() + "\n" + PrintDataCompiler.getByteDump(pOSSPrintNormalData.getCompiledData()));
        try {
            this.checkStations(n);
            if (n == 4 && this.documentInserted.isFalse()) {
                throw new JposException(114, 204);
            }
            Tracer.trace(4, className, "processPrintNormal()", "selecting stations");
            if (!printingMode.isTransaction() && !printingMode.isSideways()) {
                this.selectStations(n);
            }
            Tracer.trace(4, className, "processPrintNormal()", "writing data");
            this.chaseCompleted.set(false);
            this.posDevice.write(pOSSPrintNormalData.getCompiledData());
            Tracer.trace(4, className, "processPrintNormal()", "done writing");
            if (!printingMode.isTransaction() && !printingMode.isSideways()) {
                Tracer.trace(4, className, "processPrintNormal()", "waiting on chase");
                this.chase(30000);
                Tracer.trace(4, className, "processPrintNormal()", "chase complete");
            }
        }
        catch (Exception exception) {
            if (printingMode.isSideways()) {
                printingMode.setRotation(1);
            }
            printingMode.clearTransaction();
            printingMode.clearSideways();
            this.checkPrinterErrorCause(printNormalData);
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "processPrintNormal()", "Exit");
    }

    public void printImmediate(int n, String string) throws JposException {
        Tracer.trace(4, className, "printImmediate()", "Entry");
        int n2 = this.printQueueManager.getPostingRotation(n) == 259 ? 259 : 1;
        POSSPrintDataCompiler pOSSPrintDataCompiler = (POSSPrintDataCompiler)this.getPrintDataCompiler();
        byte[] byArray = pOSSPrintDataCompiler.compile(n, string, n2, this.printBitmapUtil, this.getPrinterFonts());
        this.printQueueManager.post(new POSSPrintImmediateData(n, string, this.serviceState.getAsyncMode(), byArray, pOSSPrintDataCompiler.getSelectedPrinterFont()));
        Tracer.trace(4, className, "printImmediate()", "Exit");
    }

    public void processPrintImmediate(PrintImmediateData printImmediateData) throws JposException {
        Tracer.trace(4, className, "processPrintImmediate()", "Entry");
        POSSPrintImmediateData pOSSPrintImmediateData = (POSSPrintImmediateData)printImmediateData;
        try {
            this.checkStations(pOSSPrintImmediateData.getStation());
            this.selectStations(pOSSPrintImmediateData.getStation());
            this.chaseCompleted.set(false);
            this.posDevice.write(pOSSPrintImmediateData.getCompiledData());
            this.chase();
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause(printImmediateData);
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "processPrintImmediate()", "Exit");
    }

    public void printTwoNormal(int n, String string, String string2) throws JposException {
        PrinterFont printerFont;
        byte[] byArray;
        PrinterFont printerFont2;
        byte[] byArray2;
        int n2;
        int n3;
        Tracer.trace(4, className, "printNormal()", "Entry");
        if (string2.length() == 0) {
            string2 = string;
        }
        POSSPrintDataCompiler pOSSPrintDataCompiler = (POSSPrintDataCompiler)this.getPrintDataCompiler();
        switch (n) {
            case 3: 
            case 32771: {
                if (!this.serviceState.getCapConcurrentJrnRec()) {
                    throw new JposException(106);
                }
                n3 = 2;
                n2 = 1;
                byArray2 = pOSSPrintDataCompiler.compile(n3, string, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont2 = pOSSPrintDataCompiler.getSelectedPrinterFont();
                byArray = pOSSPrintDataCompiler.compile(n2, string2, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont = pOSSPrintDataCompiler.getSelectedPrinterFont();
                break;
            }
            case 5: 
            case 32773: {
                if (!this.serviceState.getCapConcurrentJrnSlp()) {
                    throw new JposException(106);
                }
                n3 = 4;
                n2 = 1;
                byArray2 = pOSSPrintDataCompiler.compile(n3, string, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont2 = pOSSPrintDataCompiler.getSelectedPrinterFont();
                byArray = pOSSPrintDataCompiler.compile(n2, string2, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont = pOSSPrintDataCompiler.getSelectedPrinterFont();
                break;
            }
            case 6: 
            case 32774: {
                if (!this.serviceState.getCapConcurrentRecSlp()) {
                    throw new JposException(106);
                }
                n3 = 4;
                n2 = 2;
                byArray2 = pOSSPrintDataCompiler.compile(n3, string, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont2 = pOSSPrintDataCompiler.getSelectedPrinterFont();
                byArray = pOSSPrintDataCompiler.compile(n2, string2, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont = pOSSPrintDataCompiler.getSelectedPrinterFont();
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        this.printQueueManager.post(new POSSPrintTwoNormalData(n, string, string2, this.serviceState.getAsyncMode(), n3, n2, byArray2, byArray, printerFont2, printerFont));
        Tracer.trace(4, className, "printNormal()", "Exit");
    }

    public void processPrintTwoNormal(PrintTwoNormalData printTwoNormalData) throws JposException {
        POSSPrintTwoNormalData pOSSPrintTwoNormalData = (POSSPrintTwoNormalData)printTwoNormalData;
        int n = pOSSPrintTwoNormalData.getStations();
        PrintingMode printingMode = this.getPrintingMode(pOSSPrintTwoNormalData.getStation1());
        PrintingMode printingMode2 = this.getPrintingMode(pOSSPrintTwoNormalData.getStation2());
        this.checkStations(n);
        if (printingMode.isTransaction() || printingMode.isSideways() || printingMode2.isTransaction() || printingMode2.isSideways()) {
            throw new JposException(106);
        }
        try {
            if ((n == 32773 || n == 5 || n == 32774 || n == 6) && this.documentInserted.isFalse()) {
                throw new JposException(114, 204);
            }
            this.chaseCompleted.set(false);
            if (pOSSPrintTwoNormalData.getCompiledData1() == pOSSPrintTwoNormalData.getCompiledData2() && (n == 32771 || n == 3)) {
                this.selectStations(pOSSPrintTwoNormalData.getStations());
                this.posDevice.write(pOSSPrintTwoNormalData.getCompiledData1());
            } else {
                this.selectStations(pOSSPrintTwoNormalData.getStation1());
                this.posDevice.write(pOSSPrintTwoNormalData.getCompiledData1());
                this.chase();
                this.chaseCompleted.set(false);
                this.selectStations(pOSSPrintTwoNormalData.getStation2());
                this.posDevice.write(pOSSPrintTwoNormalData.getCompiledData2());
            }
            this.chase();
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause(printTwoNormalData);
            throw this.createJposException(exception);
        }
    }

    public void rotatePrint(int n, int n2) throws JposException {
        Tracer.trace(4, className, "rotatePrint(" + n + ", " + n2 + ")", "Entry");
        this.printQueueManager.post(new RotatePrintData(n, n2, this.serviceState.getAsyncMode()));
        Tracer.trace(4, className, "rotatePrint()", "Exit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRotatePrint(RotatePrintData rotatePrintData) throws JposException {
        Tracer.trace(4, className, "processRotatePrintData(" + rotatePrintData.getStation() + rotatePrintData.getRotation() + ")", "Entry");
        int n = rotatePrintData.getStation();
        int n2 = rotatePrintData.getRotation();
        PrintingMode printingMode = this.getPrintingMode(n);
        try {
            switch (n2) {
                case 257: 
                case 258: 
                case 259: {
                    printingMode.setRotation(rotatePrintData.getRotation());
                    this.selectStations(n);
                    this.chaseCompleted.set(false);
                    break;
                }
                case 1: {
                    printingMode.setRotation(1);
                    switch (printingMode.getRotation()) {
                        case 257: 
                        case 258: {
                            if (printingMode.isTransaction()) break;
                            this.chase();
                        }
                    }
                    break;
                }
            }
            printingMode.setRotation(rotatePrintData.getRotation());
        }
        catch (Exception exception) {
            printingMode.setRotation(1);
            this.checkPrinterErrorCause(rotatePrintData);
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "processRotatePrintData()", "Exit");
    }

    public void setBitmap(int n, int n2, String string, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "setBitmap(" + n + ", " + n2 + ", " + string + ", " + n3 + ", " + n4 + ")", "Entry");
        this.printQueueManager.post(new SetBitmapData(n, n2, string, n3, n4, null));
        Tracer.trace(4, className, "setBitmap()", "Exit");
    }

    public void processSetBitmap(SetBitmapData setBitmapData) throws JposException {
        Tracer.trace(4, className, "processSetBitmap()", "Entry");
        int n = setBitmapData.getStation();
        int n2 = setBitmapData.getWidth();
        int n3 = this.calcStationWidth(n);
        if (n2 != -11 && n2 > n3) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1) {
            n3 = this.convertToDots(n3, n);
            if (n2 != -11) {
                n2 = this.convertToDots(n2, n);
            }
        }
        this.printBitmapUtil.validateBitmap(setBitmapData, 16, n3);
        try {
            if (setBitmapData.getFileName() != "") {
                this.selectStations(n);
                this.printBitmapUtil.doSetBitmap(setBitmapData);
                this.chase();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ((POSSPrintDataCompiler)this.getPrintDataCompiler()).updateSetBitmapData(setBitmapData);
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause(setBitmapData);
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "processSetBitmapData()", "Exit");
    }

    public void setLogo(int n, String string) throws JposException {
        Tracer.trace(4, className, "setLogo(" + n + ", " + string + ")", "Entry");
        this.getPrintDataCompiler().setLogo(n, string);
        Tracer.trace(4, className, "setLogo(" + n + ", " + string + ")", "Entry");
    }

    public void processSetLogo(SetLogoData setLogoData) {
    }

    public void transactionPrint(int n, int n2) throws JposException {
        this.printQueueManager.post(new TransactionPrintData(n, n2, this.serviceState.getAsyncMode()));
    }

    public void processTransactionPrint(TransactionPrintData transactionPrintData) throws JposException {
        Tracer.trace(4, className, "processTransactionPrint()", "Entry");
        int n = transactionPrintData.getStation();
        PrintingMode printingMode = this.getPrintingMode(n);
        try {
            switch (transactionPrintData.getControl()) {
                case 11: {
                    this.checkStations(n);
                    this.selectStations(n);
                    this.chaseCompleted.set(false);
                    printingMode.beginTransaction();
                    break;
                }
                case 12: {
                    printingMode.endTransaction();
                    this.chase();
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause(transactionPrintData);
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "processTransactionPrint()", "Exit");
    }

    public void validateData(int n, String string) throws JposException {
        Tracer.trace(4, className, "validateData(" + n + ", " + string + ")", "Entry");
        this.printQueueManager.post(new ValidateDataData(n, string));
        Tracer.trace(4, className, "validateData()", "Exit");
    }

    public void processValidateData(ValidateDataData validateDataData) throws JposException {
        Tracer.trace(4, className, "processValidateData()", "Entry");
        int n = validateDataData.getStation();
        String string = validateDataData.getData();
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                ((POSSPrintDataCompiler)this.getPrintDataCompiler()).validate(n, string, this.printQueueManager.getPostingRotation(n), this.printBitmapUtil, this.getPrinterFonts());
                break;
            }
            default: {
                throw new JposException(106, "JPOS_E_ILLEGAL: Illegal station: " + n);
            }
        }
        Tracer.trace(4, className, "processValidateData()", "Exit");
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        Tracer.trace(4, className, "directIO(" + n + ")", "Entry");
        this.serviceState.isOpenClaimEnable();
        this.printQueueManager.post(new DirectIOData(n, nArray, object));
        Tracer.trace(4, className, "directIO()", "Exit");
    }

    public void processDirectIO(DirectIOData directIOData) throws JposException {
        Tracer.trace(4, className, "processDirectIO()", "Entry");
        int n = directIOData.getCommand();
        int[] nArray = directIOData.getData();
        Object object = directIOData.getObject();
        this.serviceState.isOpenClaimEnable();
        switch (n) {
            case 0: {
                this.doDirectIOFlipCheck();
                break;
            }
            case 1: {
                this.doDirectIODownloadBitmap(nArray[0], (DirectIOBitmapInfo)object);
                break;
            }
            case 20: {
                this.doDirectIOSetStamp((String)object);
                break;
            }
            case 2: {
                this.doDirectIOPrintDownloadedBitmap(nArray[0], (DirectIOBitmapInfo)object);
                break;
            }
            case 3: {
                this.doDirectIODownloadMessage(nArray[0], (String)object);
                break;
            }
            case 4: {
                this.doDirectIOPrintDownloadedMessage(nArray[0]);
                break;
            }
            case 5: {
                this.doDirectIOResetPrinter();
                break;
            }
            case 6: {
                this.doDirectIOSetChaseMode((Boolean)object);
                break;
            }
            case 7: {
                if (nArray == null || object == null) {
                    throw new JposException(106);
                }
                this.doDirectIOPrintUnvalidated(nArray[0], (String)object);
                break;
            }
            case 21: {
                this.doReadMCT(nArray);
                break;
            }
            case 22: {
                this.doDirectIOGetFontInfo((PrintGetDirectIOFontInfo)object);
                break;
            }
            case 8: {
                this.doDirectIODownloadPropFont((DirectIOFontInfo)object);
                break;
            }
            case 9: {
                this.doDirectIODownloadNonPropFont((DirectIOFontInfo)object);
                break;
            }
            case 10: {
                this.doDirectIOHeadMovement((Integer)object);
                break;
            }
            case 11: {
                this.doSelectResidentCharacterSet();
                break;
            }
            case 12: {
                this.doSelectUserDefinedCharacterSet();
                break;
            }
            case 13: {
                this.doSelectCodePage((Integer)object);
                break;
            }
            case 14: {
                this.doEraseUserDefinedCharacterSet((Integer)object);
                break;
            }
            case 15: {
                this.doPrintInRawMode((DirectIOPrintRawModeInfo)object);
                break;
            }
            case 16: {
                this.doPrinterRead((DirectIOPrinterRead)object);
                break;
            }
            case 17: {
                this.doMICRPresent(object);
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        Tracer.trace(4, className, "processDirectIO()", "Exit");
    }

    public int getCurrentStation() throws PosException {
        Tracer.trace(4, className, "getCurrentStation()", "Entry");
        PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", 0)};
        this.posDevice.ioctl(302, posArgArray);
        int n = (Integer)posArgArray[0].getValue();
        Tracer.trace(4, className, "getCurrentStation() = " + n, "Exit");
        return n;
    }

    void processDynamicCapabilities() throws JposException {
    }

    abstract void doDirectIOFlipCheck() throws JposException;

    abstract void doDirectIOPrintDownloadedBitmap(int var1, DirectIOBitmapInfo var2) throws JposException;

    abstract void doDirectIOPrintDownloadedMessage(int var1) throws JposException;

    void doDirectIODownloadBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
        Tracer.trace(4, className, "doDirectIODownloadBitmap(" + n + ")", "Entry");
        if (n == 0 || n > 40) {
            throw new JposException(106);
        }
        int n2 = directIOBitmapInfo.station;
        int n3 = directIOBitmapInfo.width;
        int n4 = this.calcStationWidth(n2);
        if (n3 != -11 && n3 > n4) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1) {
            n4 = this.convertToDots(n4, n2);
            if (n3 != -11) {
                n3 = this.convertToDots(n3, n2);
            }
        }
        SetBitmapData setBitmapData = new SetBitmapData(n, directIOBitmapInfo.station, directIOBitmapInfo.fileName, directIOBitmapInfo.width, directIOBitmapInfo.alignment, null);
        this.printBitmapUtil.validateBitmap(setBitmapData, 2, n4);
        this.processSetBitmap(setBitmapData);
        Tracer.trace(4, className, "doDirectIODownloadBitmap()", "Exit");
    }

    void doDirectIODownloadMessage(int n, String string) throws JposException {
        Tracer.trace(4, className, "doDirectIODownloadMessage(" + n + ", " + string + ")", "Entry");
        if (n == 0 || n > 25) {
            throw new JposException(106);
        }
        this.printBitmapUtil.doSetLogo(n, string);
        Tracer.trace(4, className, "doDirectIODownloadMessage()", "Exit");
    }

    void doDirectIOResetPrinter() {
        Tracer.trace(4, className, "doDirectIOResetPrinter()", "Entry");
        try {
            this.posDevice.ioctl(4908);
        }
        catch (PosException posException) {
            Tracer.trace(1, className, "doDirectIOResetPrinter()", "POSS Exception = " + posException.getErrorCode());
        }
        Tracer.trace(4, className, "doDirectIOResetPrinter()", "Exit");
    }

    void doDirectIOSetChaseMode(boolean bl) {
        Tracer.trace(4, className, "doDirectIOSetChaseMode(" + bl + ")", "Entry");
        this.useChase = bl;
        Tracer.trace(4, className, "doDirectIOSetChaseMode()", "Exit");
    }

    void doDirectIOSetStamp(String string) throws JposException {
        throw new JposException(106);
    }

    void doDirectIOPrintUnvalidated(int n, String string) throws JposException {
        Tracer.trace(4, className, "doDirectIOPrintUnvalidated(" + n + ")", "Entry");
        try {
            byte[] byArray = string.getBytes();
            this.selectStations(n);
            PosArg[] posArgArray = new PosArg[]{new PosArg("printMode", 1)};
            this.posDevice.ioctl(305, posArgArray);
            this.posDevice.write(byArray);
        }
        catch (Exception exception) {
            throw new JposException(111, exception.getMessage(), exception);
        }
        Tracer.trace(4, className, "doDirectIOPrintUnvalidated()", "Exit");
    }

    abstract void doDirectIODownloadPropFont(DirectIOFontInfo var1) throws JposException;

    abstract void doDirectIODownloadNonPropFont(DirectIOFontInfo var1) throws JposException;

    abstract void doDirectIOHeadMovement(int var1) throws JposException;

    abstract void doSelectResidentCharacterSet() throws JposException;

    abstract void doSelectUserDefinedCharacterSet() throws JposException;

    abstract void doSelectCodePage(int var1) throws JposException;

    abstract void doEraseUserDefinedCharacterSet(int var1) throws JposException;

    abstract void doPrintInRawMode(DirectIOPrintRawModeInfo var1) throws JposException;

    abstract void doPrinterRead(DirectIOPrinterRead var1) throws JposException;

    void doMICRPresent(Object object) throws JposException {
        throw new JposException(106);
    }

    void doReadMCT(int[] nArray) throws JposException {
        throw new JposException(106);
    }

    void doDirectIOGetFontInfo(PrintGetDirectIOFontInfo printGetDirectIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    public abstract void checkMode(int var1, int var2) throws JposException;

    public abstract void clearBitmaps() throws JposException;

    public abstract void clearMessages() throws JposException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPrinting(int n, byte[] byArray, int n2, int n3) throws JposException {
        int n4;
        String string;
        int n5;
        int n6 = 0;
        Tracer.trace(4, className, "doPrinting(station, bitmap[], align, mode)", "Entry");
        switch (n) {
            case 1: {
                n5 = 2;
                string = "lineFeedSJ";
                break;
            }
            case 2: {
                n5 = 1;
                string = "lineFeedCR";
                break;
            }
            case 4: {
                n5 = 4;
                string = "lineFeedDI";
                break;
            }
            default: {
                throw new JposException(106, "Illegal station for printBitmap");
            }
        }
        switch (n2) {
            case -1: {
                n6 = 0;
                break;
            }
            case -2: {
                n6 = 1;
                break;
            }
            case -3: {
                n6 = 2;
                break;
            }
        }
        switch (n3) {
            case 16: {
                n4 = n3;
                break;
            }
            case 2: {
                n4 = n3;
                break;
            }
            default: {
                throw new JposException(111, "Internal Error: Illegal mode for printBitmap: " + n3);
            }
        }
        PosArg[] posArgArray = null;
        try {
            posArgArray = new PosArg[]{new PosArg("printStation", 0), new PosArg("printMode", 0), new PosArg(string, 0), new PosArg("printAlignment", 0)};
            this.posDevice.ioctl(302, posArgArray);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() != 317) throw new JposException(111, posException.getMessage(), posException);
            throw new JposException(108);
        }
        PosArg[] posArgArray2 = null;
        try {
            try {
                switch (n4) {
                    case 16: {
                        posArgArray2 = new PosArg[]{new PosArg("printStation", n5), new PosArg("printMode", n4)};
                        this.posDevice.ioctl(305, posArgArray2);
                        int n7 = byArray[1] & 0xFF;
                        int n8 = byArray[2] & 0xFF;
                        this.posDevice.write(byArray, n7 * 8 * n8 + 3);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 2: {
                        byte[] byArray2;
                        this.posDevice.write(new byte[]{27, 70});
                        posArgArray2 = new PosArg[]{new PosArg("printStation", n5), new PosArg("printMode", n4), new PosArg(string, this.getMicronsPerStep(n) * this.getMultiplier()), new PosArg("printAlignment", n6)};
                        this.posDevice.ioctl(305, posArgArray2);
                        int n9 = byArray[1] & 0xFF;
                        int n10 = byArray[2] & 0xFF;
                        int n11 = this.getMaxPrintBitmapSize() - 3;
                        int n12 = n11 / (n9 * 8) - 2;
                        int n13 = 0;
                        if (n12 > this.getMaxBitmapHeight(n) / 8) {
                            n12 = this.getMaxBitmapHeight(n) / 8;
                        }
                        if (n12 < 1) {
                            n12 = 1;
                        }
                        if ((byArray2 = this.getBitmapHeader(1, 1)) == null) {
                            n12 = 1;
                        }
                        byte[] byArray3 = new byte[n9 * 9 * n12 + 1];
                        int n14 = 0;
                        block29: while (n14 < n10) {
                            int n15;
                            int n16 = n14 * n9 * 8 + 3;
                            int n17 = n16 + n9 * 8 * n12;
                            if (n17 > n9 * n10 * 8) {
                                n17 = n9 * n10 * 8 + 3;
                            }
                            if (n14 + (n13 = n12) > n10) {
                                n13 = n10 - n14;
                            }
                            if ((byArray2 = this.getBitmapHeader(n9, n13)) != null) {
                                n15 = 0;
                                while (n15 < byArray2.length) {
                                    byArray3[n15] = byArray2[n15];
                                    ++n15;
                                }
                            }
                            n15 = 3;
                            int n18 = n16;
                            while (true) {
                                if (n18 >= n17) {
                                    this.posDevice.write(byArray3, n15);
                                    if (this.requiresLinefeed(n)) {
                                        this.sendLinefeed();
                                    }
                                    n14 += n12;
                                    continue block29;
                                }
                                byArray3[n15] = byArray[n18];
                                ++n18;
                                ++n15;
                            }
                        }
                    }
                }
            }
            catch (PosException posException) {
                this.checkPrinterErrorCause(new PrintNormalData(0, null, false, false));
                throw this.createJposException(posException);
            }
            Object var26_28 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var26_29 = null;
            try {
                if (n4 == 16) {
                    this.posDevice.ioctl(305, posArgArray, 2);
                    throw throwable;
                }
                this.posDevice.ioctl(305, posArgArray);
                throw throwable;
            }
            catch (PosException posException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (PosException posException) {}
        if (n4 == 16) {
            this.posDevice.ioctl(305, posArgArray, 2);
        } else {
            this.posDevice.ioctl(305, posArgArray);
        }
        Tracer.trace(4, className, "doPrinting(station, bitmap[], align, mode)", "Exit");
    }

    public void doPrinting(int n, String string, String string2, byte[] byArray, int n2, int n3, boolean bl, boolean bl2, int n4) throws JposException {
    }

    public abstract void downloadData(int var1, String var2, int var3, int var4) throws JposException;

    public abstract void downloadData(int var1, byte[] var2, int var3, int var4) throws JposException;

    public abstract int getStationMaxBitmapHeight(int var1);

    public abstract short getNextByteForStation(int var1, PrintBitmapImageInfo var2);

    public boolean isSlipReady() throws JposException {
        return this.documentInserted.isTrue();
    }

    public void clearPrinterError() {
        block33: {
            Tracer.trace(4, className, "clearPrinterError()", "Entry");
            boolean bl = false;
            if (this.isOnline() && this.printerErrorCause != 0) {
                try {
                    PosArg[] posArgArray = new PosArg[]{new PosArg("printStatus", 0), new PosArg("printStatus2", 0)};
                    this.posDevice.ioctl(302, posArgArray);
                    if (((Integer)posArgArray[0].getValue() & 0x100) != 0) {
                        this.posDevice.ioctl(4905);
                        this.posDevice.ioctl(4903);
                    }
                    if (this.printerErrorCause == 1) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_COVER_OPEN");
                    } else if (this.printerErrorCause == 2) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_TRANSPORT_ERROR");
                        this.posDevice.ioctl(4908);
                        Thread.sleep(3000L);
                    } else if (this.printerErrorCause == 4) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_SJ_PAPER_ERROR");
                    } else if (this.printerErrorCause == 8) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_DOCUMENT_INSERTED");
                    } else if (this.printerErrorCause == 16) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_DOCUMENT_NOT_INSERTED");
                    } else if (this.printerErrorCause == 32) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_DOCUMENT_NOT_READY");
                    } else if (this.printerErrorCause == 64) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_DOCUMENT_NOT_EJECTED");
                    } else if (this.printerErrorCause == 128) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_MICR_ERROR");
                    } else if (this.printerErrorCause == 512) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_EEPROM_LOAD_ERROR");
                    } else if (this.printerErrorCause == 1024) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_EEPROM_FULL");
                    } else if (this.printerErrorCause == 4096) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_COMMUNICATION_ERROR");
                    } else if (this.printerErrorCause == 8192) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_DI_FEED_ERROR");
                    } else if (this.printerErrorCause == 16384) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_STARTUP_ERROR");
                    } else if (this.printerErrorCause == 16385) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_UNRECOVERABLE_ERROR");
                    } else if (this.printerErrorCause == Short.MIN_VALUE) {
                        Tracer.trace(4, className, "clearPrinterError()", "PosERROR_COMMAND_REJECTED");
                        this.posDevice.ioctl(4908);
                        Thread.sleep(3000L);
                    }
                    this.printerErrorCause = 0;
                }
                catch (Exception exception) {
                    Tracer.trace(4, className, "clearPrinterError()", "exception occurred");
                    if (Tracer.getTraceLevel() < 3) break block33;
                    exception.printStackTrace();
                }
            }
        }
        Tracer.trace(4, className, "clearPrinterError()", "Exit");
    }

    public synchronized void setAsyncMode(boolean bl) throws JposException {
        Tracer.trace(4, className, "setAsncMode(" + bl + ")", "Entry");
        Tracer.trace(4, className, "setAsncMode()", "Exit");
    }

    public synchronized void setCharacterSet(int n) throws JposException {
        Tracer.trace(4, className, "setCharacterSet(" + n + ")", "Entry");
        try {
            int n2 = ByteEncoder.getCodePage(n);
            if (n2 != this.posDevice.getCodePage()) {
                this.posDevice.setCodePage(n2);
            }
            this.serviceState.setCapCharacterSet(ByteEncoder.getCapCharacterSet(n));
            this.serviceState.setCharacterSet(n);
            PrinterFont[] printerFontArray = this.getPrinterFonts();
            int n3 = 1000;
            int n4 = 1000;
            int n5 = 1000;
            String string = "";
            String string2 = "";
            String string3 = "";
            int n6 = 0;
            while (n6 < printerFontArray.length) {
                switch (printerFontArray[n6].station) {
                    case 1: {
                        if (string.length() > 0) {
                            string = string + ",";
                        }
                        string = string + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n3) break;
                        n3 = printerFontArray[n6].lineChars;
                        break;
                    }
                    case 2: {
                        if (string2.length() > 0) {
                            string2 = string2 + ",";
                        }
                        string2 = string2 + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n5) break;
                        n5 = printerFontArray[n6].lineChars;
                        break;
                    }
                    case 4: {
                        if (string3.length() > 0) {
                            string3 = string3 + ",";
                        }
                        string3 = string3 + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n4) break;
                        n4 = printerFontArray[n6].lineChars;
                    }
                }
                ++n6;
            }
            if (this.serviceState.getCapRecPresent()) {
                this.serviceState.setRecLineCharsList(string2);
            }
            if (this.serviceState.getCapSlpPresent()) {
                this.serviceState.setSlpLineCharsList(string3);
            }
            if (this.serviceState.getCapJrnPresent()) {
                this.serviceState.setJrnLineCharsList(string);
            }
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111, posException.getMessage(), posException);
        }
        catch (Exception exception) {
            throw new JposException(106, exception.getMessage(), exception);
        }
        Tracer.trace(4, className, "setCharacterSet()", "Exit");
    }

    public void processSetCharacterSet(SetCharacterSetData setCharacterSetData) throws JposException {
    }

    public synchronized void setFlagWhenIdle(boolean bl) throws JposException {
        Tracer.trace(4, className, "setFlagWhenIdle(" + bl + ")", "Entry");
        try {
            if (bl) {
                if (this.serviceState.getState() == 2) {
                    this.serviceState.setFlagWhenIdle(false);
                    this.eventQueueManager.postEvent(new StatusUpdateEvent(this.eventSource, 1001));
                } else {
                    this.serviceState.setFlagWhenIdle(true);
                }
            } else {
                this.serviceState.setFlagWhenIdle(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "setFlagWhenIdle()", "Exit");
    }

    public synchronized void setMapMode(int n) throws JposException {
        int n2;
        int n3;
        int n4;
        int n5;
        Tracer.trace(4, className, "setMapMode(" + n + ")", "Entry");
        int n6 = this.serviceState.getMapMode();
        if (n6 == n) {
            return;
        }
        if (this.serviceState.getCapRecPresent()) {
            n5 = this.serviceState.getRecLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineSpacing(n5);
            n3 = this.serviceState.getRecLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineHeight(n3);
            n2 = this.serviceState.getRecLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(2), this.getMicronsPerStep(2));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineWidth(n2);
        }
        if (this.serviceState.getCapJrnPresent()) {
            n5 = this.serviceState.getJrnLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineSpacing(n5);
            n3 = this.serviceState.getJrnLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineHeight(n3);
            n2 = this.serviceState.getJrnLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(1), this.getMicronsPerStep(1));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineWidth(n2);
        }
        if (this.serviceState.getCapSlpPresent()) {
            n5 = this.serviceState.getSlpLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineSpacing(n5);
            n3 = this.serviceState.getSlpLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineHeight(n3);
            n2 = this.serviceState.getSlpLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(4), this.getMicronsPerStep(4));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineWidth(n2);
        }
        Tracer.trace(4, className, "setMapMode()", "Exit");
    }

    public synchronized void setRotateSpecial(int n) throws JposException {
        Tracer.trace(4, className, "setRotateSpecial(" + n + ")", "Entry");
        Tracer.trace(4, className, "setRotateSpecial()", "Exit");
    }

    public synchronized void setJrnLetterQuality(boolean bl) throws JposException {
        Tracer.trace(4, className, "setJrnLetterQuality(" + bl + ")", "Entry");
        if (bl) {
            throw new JposException(106);
        }
        Tracer.trace(4, className, "setJrnLetterQuality()", "Exit");
    }

    public synchronized void setJrnLineChars(int n) throws JposException {
        Tracer.trace(4, className, "setJrnLineChars(" + n + ")", "Entry");
        this.setStateLineChars(n, 1);
        Tracer.trace(4, className, "setJrnLineChars()", "Exit");
    }

    public synchronized void setJrnLineHeight(int n) throws JposException {
    }

    public synchronized void setJrnLineSpacing(int n) throws JposException {
        Tracer.trace(4, className, "setJrnLineSpacing(" + n + ")", "Entry");
        int n2 = this.setStationLineSpacing(1, n, this.serviceState.getJrnLineSpacing(), "lineFeedSJ");
        this.serviceState.setJrnLineSpacing(n2);
        Tracer.trace(4, className, "setJrnLineSpacing()", "Exit");
    }

    public synchronized void setRecLetterQuality(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106);
        }
    }

    public synchronized void setRecLineChars(int n) throws JposException {
        Tracer.trace(4, className, "setRecLineChars(" + n + ")", "Entry");
        this.setStateLineChars(n, 2);
        Tracer.trace(4, className, "setRecLineChars()", "Exit");
    }

    public synchronized void setRecLineHeight(int n) throws JposException {
    }

    public synchronized void setRecLineSpacing(int n) throws JposException {
        Tracer.trace(4, className, "setRecLineSpacing(" + n + ")", "Entry");
        int n2 = this.serviceState.getMapMode();
        int n3 = this.getDotsPerInchHigh(2);
        int n4 = this.getMicronsPerStep(2);
        int n5 = this.mapModeCalc.convertFromMapModeToMicrons(n2, this.serviceState.getRecLineSpacing(), n3, n4);
        int n6 = this.setStationLineSpacing(2, n, this.serviceState.getRecLineSpacing(), "lineFeedCR");
        if (n6 != this.serviceState.getRecLineSpacing()) {
            this.serviceState.setRecLineSpacing(n6);
            if (n6 == 0) {
                n6 = 1;
            }
            int n7 = this.mapModeCalc.convertFromMapModeToMicrons(n2, n6, n3, n4);
            int n8 = n5 * this.serviceState.getRecLinesToPaperCut();
            int n9 = n8 / n7 + 1;
            this.serviceState.setRecLinesToPaperCut(n9);
        }
        Tracer.trace(4, className, "setRecLineSpacing()", "Exit");
    }

    public synchronized int setStationLineSpacing(int n, int n2, int n3, String string) throws JposException {
        Tracer.trace(4, className, "setStationLineSpacing(" + n + ", " + n2 + ", " + n3 + ", " + string + ")", "Entry");
        long l = 0L;
        if (n2 != n3) {
            if (n2 < 1) {
                n2 = 1;
            }
            int n4 = this.getDotsPerInchHigh(n);
            int n5 = this.getMicronsPerStep(n);
            int n6 = this.serviceState.getMapMode();
            int n7 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, n4, n5);
            int n8 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, n4, n5);
            if (n8 > this.getMaxMicronsPerFeed()) {
                n8 = this.getMaxMicronsPerFeed();
                n2 = this.mapModeCalc.convertFromMicronsToMapMode(n6, n8, n4, n5);
            }
            this.getPrintingMode(n).setPosNlineFeed(n8);
            Tracer.trace(4, className, "setStationLineSpacing() ", "microns == " + n8);
        }
        Tracer.trace(4, className, "setStationLineSpacing() = " + n2, "Exit");
        return n2;
    }

    int getMaxMicronsPerFeed() {
        return 90000;
    }

    public synchronized void setSlpLetterQuality(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106);
        }
    }

    public synchronized void setSlpLineChars(int n) throws JposException {
        Tracer.trace(4, className, "setSlpLineChars(" + n + ")", "Entry");
        this.setStateLineChars(n, 4);
        Tracer.trace(4, className, "setSlpLineChars()", "Exit");
    }

    public synchronized void setSlpLineHeight(int n) throws JposException {
    }

    public synchronized void setSlpLineSpacing(int n) throws JposException {
        Tracer.trace(4, className, "setSlpLineSpacing(" + n + ")", "Entry");
        int n2 = this.setStationLineSpacing(4, n, this.serviceState.getSlpLineSpacing(), "lineFeedDI");
        this.serviceState.setSlpLineSpacing(n2);
        Tracer.trace(4, className, "setSlpLineSpacing()", "Exit");
    }

    public void setCartridgeNotify(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setJrnCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void setRecCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void setSlpCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void changePrintSide(int n) throws JposException {
        throw new JposException(106);
    }

    public void markFeed(int n) throws JposException {
        throw new JposException(106);
    }

    protected abstract PrinterFont[] getPrinterFonts() throws JposException;

    protected abstract PrintDataCompiler getPrintDataCompiler();

    protected int calcStationWidth(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = this.serviceState.getRecLineWidth();
                break;
            }
            case 4: {
                n2 = this.serviceState.getSlpLineWidth();
            }
        }
        return n2;
    }

    protected int convertToDots(int n, int n2) throws JposException {
        int n3 = this.serviceState.getMapMode();
        int n4 = this.mapModeCalc.convertFromMapModeToMicrons(n3, n, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        return this.mapModeCalc.convertFromMicronsToMapMode(1, n4, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
    }

    protected int getSelectedStations() {
        return this.selectedStations;
    }

    protected void selectStations(int n) throws JposException {
        Tracer.trace(4, className, "selectStations(" + n + ")", "Entry");
        PosArg[] posArgArray = null;
        try {
            switch (n) {
                case 1: {
                    posArgArray = new PosArg[]{new PosArg("printStation", 2), new PosArg("printMode", 1), new PosArg("printAlignment", 0), new PosArg("lineFeedSJ", this.getPrintingMode(1).getPosNlineFeed())};
                    if (this.serviceState.getCapSlpPresent()) {
                        this.posDevice.ioctl(4901);
                    }
                    this.posDevice.ioctl(305, posArgArray);
                    this.selectedStations = 1;
                    break;
                }
                case 2: {
                    posArgArray = new PosArg[]{new PosArg("printStation", 1), new PosArg("printMode", 1), new PosArg("printAlignment", 0), new PosArg("lineFeedCR", this.getPrintingMode(2).getPosNlineFeed()), new PosArg("printUpsideDown", this.getPrintingMode(2).getRotation() == 1 ? 0 : 1)};
                    if (this.serviceState.getCapSlpPresent()) {
                        this.posDevice.ioctl(4901);
                    }
                    this.posDevice.ioctl(305, posArgArray);
                    this.selectedStations = 2;
                    break;
                }
                case 3: 
                case 32771: {
                    posArgArray = new PosArg[]{new PosArg("printStation", 3), new PosArg("printMode", 1), new PosArg("printAlignment", 0), new PosArg("lineFeedCR", this.getPrintingMode(2).getPosNlineFeed()), new PosArg("lineFeedSJ", this.getPrintingMode(1).getPosNlineFeed())};
                    if (this.serviceState.getCapSlpPresent()) {
                        this.posDevice.ioctl(4901);
                    }
                    this.posDevice.ioctl(305, posArgArray);
                    this.selectedStations = 32771;
                    break;
                }
                case 4: {
                    int n2 = 0;
                    if (this.getPrintingMode(4).isSideways()) {
                        n2 = 1;
                    }
                    posArgArray = new PosArg[]{new PosArg("printStation", 4), new PosArg("printMode", 1), new PosArg("printAlignment", 0), new PosArg("lineFeedDI", this.getPrintingMode(4).getPosNlineFeed()), new PosArg("diWidth", this.getDiWidth()), new PosArg("diOrientation", n2)};
                    this.posDevice.ioctl(4902);
                    this.posDevice.ioctl(305, posArgArray);
                    this.selectedStations = 4;
                    break;
                }
                default: {
                    throw new JposException(111, "Internal Error: POSSPOSPrinterServiceImp.printProlog(): bad station: " + n);
                }
            }
        }
        catch (PosException posException) {
            throw this.createJposException(posException);
        }
        Tracer.trace(4, className, "selectStations()", "Exit");
    }

    protected PrintingMode getPrintingMode(int n) {
        return this.printingModes[n];
    }

    protected void checkPrinterErrorCause() throws JposException {
        this.checkPrinterErrorCause(new PrintNormalData(0, null, false, false));
    }

    protected void checkPrinterErrorCause(PrintQueueElement printQueueElement) throws JposException {
        Tracer.trace(4, className, "checkPrinterErrorCause()", "Entry");
        POSSPrintDataCompiler pOSSPrintDataCompiler = (POSSPrintDataCompiler)this.getPrintDataCompiler();
        this.queryPrinterStatus();
        try {
            if (!this.isOnline()) {
                throw new JposException(108);
            }
            if (this.serviceState.getCapJrnPresent() && this.serviceState.getJrnEmpty()) {
                printQueueElement.setErrorLevel(2);
                throw new JposException(114, 202);
            }
            switch (this.selectedStations) {
                case 1: 
                case 5: 
                case 32773: {
                    if (!this.serviceState.getJrnEmpty()) break;
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 202);
                }
                case 2: 
                case 6: 
                case 32774: {
                    if (!this.serviceState.getRecEmpty()) break;
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 203);
                }
            }
            if (this.serviceState.getCoverOpen()) {
                printQueueElement.setErrorLevel(2);
                throw new JposException(114, 201);
            }
            if (this.printerErrorCause != 0) {
                if (this.printerErrorCause == 1) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_COVER_OPEN");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 201);
                }
                if (this.printerErrorCause == 2) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_TRANSPORT_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 4) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_SJ_PAPER_ERROR");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 202);
                }
                if (this.printerErrorCause == 8) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_INSERTED");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 205);
                }
                if (this.printerErrorCause == 16) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_NOT_INSERTED");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 204);
                }
                if (this.printerErrorCause == 32) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_NOT_READY");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 204);
                }
                if (this.printerErrorCause == 64) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_NOT_EJECTED");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 204);
                }
                if (this.printerErrorCause == 128) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_MICR_ERROR");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 512) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_EEPROM_LOAD_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 1024) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_EEPROM_FULL");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(114, 206);
                }
                if (this.printerErrorCause == 4096) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_COMMUNICATION_ERROR");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(111, "PosERROR_COMMUNICATION_ERROR");
                }
                if (this.printerErrorCause == 8192) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DI_FEED_ERROR");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 16384) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_STARTUP_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 16385) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_UNRECOVERABLE_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == Short.MIN_VALUE) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_COMMAND_REJECTED");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
            }
        }
        catch (JposException jposException) {
            pOSSPrintDataCompiler.resetCellsBuffered();
            try {
                if (this.serviceState.getCapJrnPresent() && this.serviceState.getCapSlpPresent()) {
                    this.posDevice.write(new byte[]{13, 10});
                }
                this.posDevice.ioctl(4905);
                this.posDevice.ioctl(4903);
            }
            catch (PosException posException) {
                // empty catch block
            }
            throw jposException;
        }
        Tracer.trace(4, className, "checkPrinterErrorCause()", "Exit");
    }

    public void chase(int n) throws JposException {
        Tracer.trace(4, className, "chase(" + n + ")", "Entry");
        if (this.useChase && !this.getPrintingMode(this.selectedStations).isTransaction()) {
            try {
                this.chaseCompleted.set(false);
                this.posDevice.write(new byte[]{27, 71});
                this.chaseCompleted.waitForTrue(n);
            }
            catch (PosException posException) {
                posException.printStackTrace();
                throw this.createJposException(posException);
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause(new PrintNormalData(0, null, false, false));
                throw this.createJposException(exception);
            }
        }
        Tracer.trace(4, className, "chase()", "Exit");
    }

    public void chase() throws JposException {
        this.chase(30000);
    }

    int computeLineChars(int n, int n2) throws JposException {
        int n3;
        Tracer.trace(4, className, "computeLineChars(" + n + ", " + n2 + ")", "Entry");
        int n4 = 1000;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        if (n < 1) {
            throw new JposException(106);
        }
        int n7 = 0;
        while (n7 < printerFontArray.length) {
            if (printerFontArray[n7].station == n2 && printerFontArray[n7].lineChars == n) {
                bl = true;
                break;
            }
            ++n7;
        }
        if (n7 >= printerFontArray.length) {
            n7 = 0;
            while (n7 < printerFontArray.length) {
                if (printerFontArray[n7].station == n2) {
                    int n8;
                    if (printerFontArray[n7].lineChars > n6) {
                        n6 = printerFontArray[n7].lineChars;
                    }
                    if (printerFontArray[n7].lineChars > n && (n8 = Math.abs(printerFontArray[n7].lineChars - n)) < n4) {
                        n4 = n8;
                        n5 = n7;
                    }
                }
                ++n7;
            }
            if (n > n6) {
                throw new JposException(106);
            }
            if (n5 == -1) {
                throw new JposException(106);
            }
            n3 = printerFontArray[n5].lineChars;
            n7 = n5;
        } else {
            n3 = n;
        }
        Tracer.trace(4, className, "computeLineChars() =  " + n3, "Entry");
        return n7;
    }

    public void setStateLineChars(int n, int n2) throws JposException {
        Tracer.trace(4, className, "setStateLineChars(" + n + ", " + n2 + ")", "Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        int n3 = this.computeLineChars(n, n2);
        int n4 = printerFontArray[n3].lineChars;
        int n5 = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), printerFontArray[n3].lineDots, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        int n6 = this.mapModeCalc.convertFromMicronsToMapMode(this.serviceState.getMapMode(), n5, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        n5 = this.mapModeCalc.convertFromMapModeToMicrons(1, printerFontArray[n3].lineSpacing, this.getDotsPerInchHigh(n2), this.getMicronsPerStep(n2));
        int n7 = this.mapModeCalc.convertFromMicronsToMapMode(this.serviceState.getMapMode(), n5, this.getDotsPerInchHigh(n2), this.getMicronsPerStep(n2));
        switch (n2) {
            case 2: {
                this.serviceState.setRecLineWidth(n6);
                this.serviceState.setRecLineChars(n);
                this.setRecLineSpacing(n7);
                break;
            }
            case 4: {
                this.serviceState.setSlpLineWidth(n6);
                this.serviceState.setSlpLineChars(n);
                break;
            }
            case 1: {
                this.serviceState.setJrnLineWidth(n6);
                this.serviceState.setJrnLineChars(n);
            }
        }
        Tracer.trace(4, className, "setStateLineChars()", "Exit");
    }

    protected void queryPrinterStatus() {
        this.queryPrinterStatus(false);
    }

    protected void queryPrinterStatus(boolean bl) {
        block52: {
            Tracer.trace(4, className, "queryPrinterStatus(" + bl + ")", "Entry");
            try {
                StatusUpdateEvent statusUpdateEvent;
                PosArg[] posArgArray = new PosArg[]{new PosArg("printStatus", 0), new PosArg("printStatus2", 0)};
                this.posDevice.ioctl(302, posArgArray);
                this.posNprintStatus = (Integer)posArgArray[0].getValue();
                this.posNprintStatus2 = (Integer)posArgArray[1].getValue();
                Tracer.trace(4, className, "queryPrinterStatus()", "selectedStations: " + this.selectedStations);
                Tracer.trace(4, className, "queryPrinterStatus()", "posNprintStatus : 0x" + Integer.toHexString(this.posNprintStatus));
                Tracer.trace(4, className, "queryPrinterStatus()", "posNprintStatus2: 0x" + Integer.toHexString(this.posNprintStatus2));
                if ((this.selectedStations == 1 || bl) && this.serviceState.getCapJrnPresent()) {
                    Tracer.trace(4, className, "queryPrinterStatus()", "Journal is present");
                    boolean bl2 = false;
                    if (this.serviceState.getCapJrnEmptySensor()) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Journal has empty sensor");
                        if ((this.posNprintStatus & 4) != 0 || (this.posNprintStatus2 & 0x4001) == 16385) {
                            Tracer.trace(4, className, "queryPrinterStatus()", "Journal is empty");
                            this.printerErrorCause = 4;
                            if (!this.serviceState.getJrnEmpty()) {
                                this.serviceState.setJrnEmpty(true);
                                if (this.serviceState.getDeviceEnabled()) {
                                    statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 21);
                                    this.eventQueueManager.postEvent(statusUpdateEvent);
                                }
                            }
                        } else if (this.serviceState.getJrnEmpty()) {
                            this.serviceState.setJrnEmpty(false);
                            bl2 = true;
                        }
                    }
                    if (this.serviceState.getCapJrnNearEndSensor()) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Journal has low sensor");
                        if ((this.posNprintStatus & 0x8000) != 0) {
                            Tracer.trace(4, className, "queryPrinterStatus()", "Journal paper is low");
                            if (!this.serviceState.getJrnNearEnd()) {
                                this.serviceState.setJrnNearEnd(true);
                                if (this.serviceState.getDeviceEnabled()) {
                                    statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 22);
                                    this.eventQueueManager.postEvent(statusUpdateEvent);
                                }
                            }
                        } else if (this.serviceState.getJrnNearEnd()) {
                            this.serviceState.setJrnNearEnd(false);
                            bl2 = true;
                        }
                    }
                    if (bl2 && this.serviceState.getDeviceEnabled()) {
                        statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 23);
                        this.eventQueueManager.postEvent(statusUpdateEvent);
                    }
                }
                if ((this.selectedStations == 4 || bl) && this.serviceState.getCapSlpPresent()) {
                    Tracer.trace(4, className, "queryPrinterStatus()", "Slip station is present");
                    if (this.serviceState.getCapSlpEmptySensor()) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Slip station has empty sensor");
                        if ((this.posNprintStatus & 0x20) != 0) {
                            this.documentRegistered.set(true);
                        } else {
                            this.documentRegistered.set(false);
                        }
                        if ((this.posNprintStatus & 0x38) != 0) {
                            if ((this.posNprintStatus & 0x18) != 0) {
                                if (this.serviceState.getSlpEmpty()) {
                                    this.printerErrorCause = 32;
                                }
                                this.documentInserted.set(true);
                                Tracer.trace(4, className, "queryPrinterStatus()", "DOC_AT_FRONT/TOP");
                            }
                            if ((this.posNprintStatus & 0x20) != 0) {
                                Tracer.trace(4, className, "queryPrinterStatus()", "DOC_READY");
                                if (this.printerErrorCause == 32) {
                                    this.printerErrorCause = 0;
                                }
                                if (this.serviceState.getSlpEmpty()) {
                                    this.serviceState.setSlpEmpty(false);
                                    this.serviceState.setSlpPrintSide(1);
                                    if (this.serviceState.getDeviceEnabled()) {
                                        StatusUpdateEvent statusUpdateEvent2 = new StatusUpdateEvent(this.eventSource, 29);
                                        this.eventQueueManager.postEvent(statusUpdateEvent2);
                                    }
                                }
                            }
                        } else {
                            Tracer.trace(4, className, "queryPrinterStatus()", "Slip station is empty");
                            this.printerErrorCause = 16;
                            this.documentInserted.set(false);
                            if (!this.serviceState.getSlpEmpty()) {
                                this.serviceState.setSlpEmpty(true);
                                if (this.serviceState.getCapSlpBothSidesPrint()) {
                                    this.serviceState.setSlpPrintSide(0);
                                }
                                if (this.serviceState.getDeviceEnabled()) {
                                    StatusUpdateEvent statusUpdateEvent3 = new StatusUpdateEvent(this.eventSource, 27);
                                    this.eventQueueManager.postEvent(statusUpdateEvent3);
                                }
                            }
                        }
                    }
                }
                if ((this.selectedStations == 2 || bl) && this.serviceState.getCapRecPresent()) {
                    Tracer.trace(4, className, "queryPrinterStatus()", "Receipt station is present");
                    boolean bl3 = false;
                    if (this.serviceState.getCapRecEmptySensor()) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Receipt has empty sensor");
                        if ((this.posNprintStatus2 & 0x1001) == 4097) {
                            Tracer.trace(4, className, "queryPrinterStatus()", "Receipt is empty");
                            if (!this.serviceState.getRecEmpty()) {
                                this.serviceState.setRecEmpty(true);
                                if (this.serviceState.getDeviceEnabled()) {
                                    statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 24);
                                    this.eventQueueManager.postEvent(statusUpdateEvent);
                                }
                            }
                        } else if (this.serviceState.getRecEmpty()) {
                            this.serviceState.setRecEmpty(false);
                            bl3 = true;
                        }
                    }
                    if (this.serviceState.getCapRecNearEndSensor()) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Receipt has low sensor");
                        if ((this.posNprintStatus & 0x4000) != 0) {
                            Tracer.trace(4, className, "queryPrinterStatus()", "Receipt is low");
                            if (!this.serviceState.getRecNearEnd()) {
                                this.serviceState.setRecNearEnd(true);
                                if (this.serviceState.getDeviceEnabled()) {
                                    statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 25);
                                    this.eventQueueManager.postEvent(statusUpdateEvent);
                                }
                            }
                        } else if (this.serviceState.getRecNearEnd()) {
                            this.serviceState.setRecNearEnd(false);
                            bl3 = true;
                        }
                    }
                    if (bl3 && this.serviceState.getDeviceEnabled()) {
                        statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 26);
                        this.eventQueueManager.postEvent(statusUpdateEvent);
                    }
                }
                if ((this.posNprintStatus & 1) != 0) {
                    Tracer.trace(4, className, "queryPrinterStatus()", "Cover is open");
                    this.printerErrorCause = 1;
                    if (!this.serviceState.getCoverOpen()) {
                        this.serviceState.setCoverOpen(true);
                        if (this.serviceState.getDeviceEnabled()) {
                            StatusUpdateEvent statusUpdateEvent4 = new StatusUpdateEvent(this.eventSource, 11);
                            this.eventQueueManager.postEvent(statusUpdateEvent4);
                        }
                    }
                } else if (this.serviceState.getCoverOpen()) {
                    this.serviceState.setCoverOpen(false);
                    if (this.serviceState.getDeviceEnabled()) {
                        StatusUpdateEvent statusUpdateEvent5 = new StatusUpdateEvent(this.eventSource, 12);
                        if ((this.posNprintStatus & 0x100) == 0) {
                            this.printerErrorCause = 0;
                        }
                        this.eventQueueManager.postEvent(statusUpdateEvent5);
                    }
                }
            }
            catch (Exception exception) {
                Tracer.trace(4, className, "queryPrinterStatus()", "caught exception: " + exception.getMessage());
                if (Tracer.getTraceLevel() < 4) break block52;
                exception.printStackTrace();
            }
        }
        Tracer.trace(4, className, "queryPrinterStatus()", "Exit");
    }

    int getPosNprintStation(int n) throws JposException {
        switch (n) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 4;
            }
        }
        throw new JposException(106, "Illegal station");
    }

    private int getDiWidth() throws JposException {
        Tracer.trace(4, className, "getDiWidth()", "Entry");
        int n = this.computeLineChars(this.serviceState.getSlpLineChars(), 4);
        int n2 = this.getPrinterFonts()[n].diWidth;
        Tracer.trace(4, className, "getDiWidth() = " + n2, "Exit");
        return n2;
    }

    protected int calculatePosNlineFeedCR() throws JposException {
        Tracer.trace(4, className, "calculatePosNlineFeedCR()", "Entry");
        int n = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), this.serviceState.getRecLineSpacing(), this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
        Tracer.trace(4, className, "calculatePosNlineFeedCR()", "Exit (" + n + ")");
        return n;
    }

    protected int calculatePosNlineFeedDI() throws JposException {
        Tracer.trace(4, className, "getDiLineFeed()", "Entry");
        int n = 0;
        n = this.serviceState.getSlpLineSpacing();
        n = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), n, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
        Tracer.trace(4, className, "getDiLineFeed() = " + n, "Exit");
        return n;
    }

    protected int calculatePosNlineFeedSJ() throws JposException {
        Tracer.trace(4, className, "getSjLineFeed()", "Entry");
        int n = 0;
        n = this.serviceState.getJrnLineSpacing();
        n = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), n, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
        Tracer.trace(4, className, "getSjLineFeed() = " + n, "Exit");
        return n;
    }

    public abstract int getDotsPerInchHigh(int var1) throws JposException;

    public abstract int getDotsPerInchWide(int var1) throws JposException;

    public abstract int getMicronsPerStep(int var1) throws JposException;

    public int getMultiplier() throws JposException {
        return 4;
    }

    public abstract int getMaxBytesPerWrite(int var1) throws JposException;

    public abstract int getWriteBufferSize();

    public int getMaxBitmapWidth(int n) throws JposException {
        return Integer.MAX_VALUE;
    }

    public int getMaxBitmapHeight(int n) throws JposException {
        return Integer.MAX_VALUE;
    }

    public int getForcedBitmapHeight() {
        return -1;
    }

    public int getForcedBitmapWidth() {
        return -1;
    }

    public abstract byte[] getBitmapHeader(int var1, int var2) throws JposException;

    public abstract boolean requiresLinefeed(int var1);

    private void sendLinefeed() throws PosException {
        Tracer.trace(4, className, "sendLineFeed()", "Entry");
        PosArg[] posArgArray = new PosArg[]{new PosArg("printMode", 1)};
        this.posDevice.ioctl(305, posArgArray);
        this.posDevice.write(new byte[]{13, 10});
        posArgArray[0].setValue(2);
        this.posDevice.ioctl(305, posArgArray);
        Tracer.trace(4, className, "sendLineFeed()", "Exit");
    }

    public void handleDeviceOnlineMessage() {
    }

    public JposException createJposException(Exception exception) throws JposException {
        if (exception instanceof JposException) {
            return (JposException)exception;
        }
        if (exception instanceof PosException) {
            switch (((PosException)exception).getErrorCode()) {
                case 317: {
                    return new JposException(108);
                }
                case 318: {
                    return new JposException(114, 206);
                }
            }
            return new JposException(111, exception.getMessage(), exception);
        }
        return new JposException(111, exception.getMessage(), exception);
    }

    public void checkStations(int n) throws JposException {
        this.selectedStations = n;
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        if (this.serviceState.getCapJrnPresent() && this.serviceState.getJrnEmpty()) {
            throw new JposException(114, 202);
        }
        if ((this.posNprintStatus & 1) != 0) {
            throw new JposException(114, 201);
        }
        switch (n) {
            case 1: 
            case 5: 
            case 32773: {
                if (!this.serviceState.getJrnEmpty()) break;
                throw new JposException(114, 202);
            }
            case 2: 
            case 6: 
            case 32774: {
                if (!this.serviceState.getRecEmpty()) break;
                throw new JposException(114, 203);
            }
            case 3: 
            case 32771: {
                if (this.serviceState.getJrnEmpty()) {
                    throw new JposException(114, 202);
                }
                if (!this.serviceState.getRecEmpty()) break;
                throw new JposException(114, 203);
            }
        }
        this.clearPrinterError();
    }

    private void setKeepInRawMode(boolean bl) {
        this.keepInRawMode = bl;
    }

    public abstract int getMaxPrintBitmapSize() throws JposException;

    public abstract int getMaxSetBitmapSize(int var1) throws JposException;

    public abstract void processPrintBarCode(PrintBarCodeData var1) throws JposException;

    protected class PrintingMode {
        int station;
        int posNprintStation;
        String PosNlineFeed;
        int posNlineFeed = -1;
        int rotation = 1;
        boolean transaction = false;
        boolean sideways = false;

        public PrintingMode(int n) throws JposException {
            this.station = n;
            switch (n) {
                case 1: {
                    this.posNprintStation = 2;
                    this.PosNlineFeed = "lineFeedSJ";
                    break;
                }
                case 2: {
                    this.posNprintStation = 1;
                    this.PosNlineFeed = "lineFeedCR";
                    break;
                }
                case 4: {
                    this.posNprintStation = 4;
                    this.PosNlineFeed = "lineFeedDI";
                    break;
                }
                default: {
                    throw new JposException(111);
                }
            }
        }

        public int getPosNlineFeed() throws JposException {
            if (this.posNlineFeed == -1) {
                try {
                    PosArg[] posArgArray = new PosArg[]{new PosArg(this.PosNlineFeed, 0)};
                    POSSPOSPrinterServiceImp.this.posDevice.ioctl(302, posArgArray);
                    this.posNlineFeed = (Integer)posArgArray[0].getValue();
                }
                catch (PosException posException) {
                    throw POSSPOSPrinterServiceImp.this.createJposException(posException);
                }
            }
            return this.posNlineFeed;
        }

        public void setPosNlineFeed(int n) throws JposException {
            try {
                PosArg[] posArgArray = new PosArg[]{new PosArg(this.PosNlineFeed, n)};
                POSSPOSPrinterServiceImp.this.posDevice.ioctl(305, posArgArray);
                this.posNlineFeed = n;
            }
            catch (PosException posException) {
                throw POSSPOSPrinterServiceImp.this.createJposException(posException);
            }
        }

        public int getRotation() {
            return this.rotation;
        }

        public void setRotation(int n) throws JposException {
            Tracer.trace(4, "PrintingMode", "setRotation(" + n + ")", "Entry");
            block2 : switch (n) {
                case 1: {
                    try {
                        if (this.rotation == 258 || this.rotation == 257) {
                            try {
                                POSSPOSPrinterServiceImp.this.chase(200000);
                            }
                            catch (Exception exception) {
                                POSSPOSPrinterServiceImp.this.checkStations(this.station);
                                throw new JposException(111);
                            }
                        }
                        Object var4_3 = null;
                        this.rotation = 1;
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.rotation = 1;
                        throw throwable;
                    }
                }
                case 258: {
                    switch (this.rotation) {
                        case 1: {
                            POSSPOSPrinterServiceImp.this.selectStations(this.station);
                            POSSPOSPrinterServiceImp.this.chase(10000);
                            this.rotation = n;
                            break block2;
                        }
                        case 258: {
                            break block2;
                        }
                        case 257: 
                        case 259: {
                            throw new JposException(106);
                        }
                    }
                    break;
                }
                case 257: {
                    switch (this.rotation) {
                        case 1: {
                            POSSPOSPrinterServiceImp.this.selectStations(this.station);
                            POSSPOSPrinterServiceImp.this.chase(10000);
                            this.rotation = n;
                            break block2;
                        }
                        case 257: {
                            break block2;
                        }
                        case 258: 
                        case 259: {
                            throw new JposException(106);
                        }
                    }
                    break;
                }
                case 259: {
                    switch (this.rotation) {
                        case 1: {
                            this.rotation = 259;
                            break block2;
                        }
                        case 259: {
                            break block2;
                        }
                        case 257: 
                        case 258: {
                            throw new JposException(106);
                        }
                    }
                    break;
                }
                default: {
                    throw new JposException(106);
                }
            }
            Tracer.trace(4, "PrintingMode", "setRotation() = " + this.rotation, "Entry");
        }

        public boolean isSideways() {
            return this.rotation == 258 || this.rotation == 257;
        }

        public void clearSideways() {
            this.sideways = false;
        }

        public void beginTransaction() throws JposException {
            POSSPOSPrinterServiceImp.this.selectStations(this.station);
            this.transaction = true;
        }

        public void endTransaction() throws JposException {
            try {
                try {
                    POSSPOSPrinterServiceImp.this.chase();
                }
                catch (Exception exception) {
                    POSSPOSPrinterServiceImp.this.checkStations(this.station);
                    throw new JposException(111);
                }
                Object var3_1 = null;
                this.transaction = false;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.transaction = false;
                throw throwable;
            }
        }

        public void clearTransaction() {
            this.transaction = false;
        }

        public boolean isTransaction() {
            return this.transaction;
        }
    }

    private class POSPrinterListener
    implements PosmPrnChaseCompleteListener,
    PosmPrnPrinterErrorListener,
    PosmPrnStatusChangeListener {
        private POSPrinterListener() {
        }

        public void posmPrnChaseComplete(short s, int n) {
            Tracer.trace(3, POSSPOSPrinterServiceImp.className, "posmPrnChaseComplete()", "Station = " + s + ", status = 0x" + Integer.toHexString(n));
            POSSPOSPrinterServiceImp.this.chaseCompleted.set(true);
        }

        public void posmPrnPrinterError(short s, int n) {
            Tracer.trace(4, POSSPOSPrinterServiceImp.className, "posmPrnPrinterError(" + Integer.toHexString(s) + ", " + Integer.toHexString(n) + ")", "Entry");
            POSSPOSPrinterServiceImp.this.queryPrinterStatus();
            if (s != 16385) {
                POSSPOSPrinterServiceImp.this.printerErrorCause = s;
                POSSPOSPrinterServiceImp.this.chaseCompleted.forceTimeout();
            }
            Tracer.trace(4, POSSPOSPrinterServiceImp.className, "posmPrnPrinterError()", "Exit");
        }

        public void posmPrnStatusChange(short s, int n) {
            Tracer.trace(4, POSSPOSPrinterServiceImp.className, "posmPrnStatusChange(" + Integer.toHexString(s) + ", " + Integer.toHexString(n) + ")", "Entry");
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            POSSPOSPrinterServiceImp.this.queryPrinterStatus(true);
            if (POSSPOSPrinterServiceImp.this.chaseCompleted.isFalse()) {
                if (POSSPOSPrinterServiceImp.this.printerErrorCause == 1) {
                    POSSPOSPrinterServiceImp.this.chaseCompleted.forceTimeout();
                } else if (POSSPOSPrinterServiceImp.this.serviceState.getRecEmpty() && (POSSPOSPrinterServiceImp.this.selectedStations == 2 || POSSPOSPrinterServiceImp.this.selectedStations == 32771 || POSSPOSPrinterServiceImp.this.selectedStations == 3)) {
                    POSSPOSPrinterServiceImp.this.chaseCompleted.forceTimeout();
                } else if (POSSPOSPrinterServiceImp.this.serviceState.getCapJrnPresent() && POSSPOSPrinterServiceImp.this.serviceState.getJrnEmpty() && (POSSPOSPrinterServiceImp.this.selectedStations == 1 || POSSPOSPrinterServiceImp.this.selectedStations == 32771 || POSSPOSPrinterServiceImp.this.selectedStations == 3)) {
                    POSSPOSPrinterServiceImp.this.chaseCompleted.forceTimeout();
                }
            }
            Tracer.trace(4, POSSPOSPrinterServiceImp.className, "posmPrnStatusChange()", "Exit");
        }
    }
}

