/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSKeyboardServiceImp;
import com.ibm.jpos.services.POSKeyboardServiceState;
import com.ibm.jpos.services.poss.POSKeyboardMap;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.poss.CapsLock;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosException;
import com.ibm.poss.PosmKbdWmCharListener;
import jpos.JposException;
import jpos.POSKeyboardConst;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public abstract class POSSPOSKeyboardServiceImp
extends POSSDeviceServiceImp
implements POSKeyboardServiceImp,
POSKeyboardConst {
    protected POSKeyboardServiceState serviceState = null;
    private Object eventSource = null;
    protected int[] keyTable = new int[256];
    private static final String TRANSLATION_FILENAME_PROPERTY = "KeyTranslationFile";
    private static final int NOT_WANTED = -1;
    POSKeyboardMap kbdMap;
    int kbdMapLen = 0;

    protected POSSPOSKeyboardServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.serviceState = (POSKeyboardServiceState)this.getDeviceServiceState();
        this.getPosDevice().setPosmKbdWmCharListener(new PosDeviceListener());
        int n = 0;
        while (n < this.keyTable.length) {
            this.keyTable[n] = -1;
            ++n;
        }
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        this.getPosDevice().setPosmKbdWmCharListener(null);
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
    }

    public void setEventTypes(int n) throws JposException {
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        super.open(string, eventCallbacks);
        this.eventSource = eventCallbacks.getEventSource();
        String string2 = this.getJposEntry().hasPropertyWithName(TRANSLATION_FILENAME_PROPERTY) ? (String)this.getJposEntry().getPropertyValue(TRANSLATION_FILENAME_PROPERTY) : "";
        this.makePOSKeyboardMap(string2);
        this.kbdMapLen = this.kbdMap.getKeyboardMapLen();
        int n = 0;
        while (n < this.keyTable.length) {
            this.keyTable[n] = n;
            ++n;
        }
    }

    protected abstract void makePOSKeyboardMap(String var1);

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        switch (n) {
            case 200: {
                this.directIOGetKbdLightStatus(nArray, object);
                break;
            }
            case 201: {
                this.directIOTurnKbdLightOn(nArray, object);
                break;
            }
            case 202: {
                this.directIOTurnKbdLightOff(nArray, object);
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    protected void directIOGetKbdLightStatus(int[] nArray, Object object) throws JposException {
        int n = 0;
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg()};
            posArgArray[0].setName("keyboardLightsOn");
            posArgArray[0].setValue(1);
            this.getPosDevice().ioctl(302, posArgArray);
            int n2 = (Integer)posArgArray[0].getValue();
            posArgArray[0].setValue(2);
            this.getPosDevice().ioctl(302, posArgArray);
            int n3 = (Integer)posArgArray[0].getValue();
            posArgArray[0].setValue(4);
            this.getPosDevice().ioctl(302, posArgArray);
            int n4 = (Integer)posArgArray[0].getValue();
            posArgArray[0].setValue(1);
            this.getPosDevice().ioctl(302, posArgArray);
            int n5 = (Integer)posArgArray[0].getValue();
            n = n2 & n3 & n4 & n5;
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111, posException.getMessage(), posException);
        }
        nArray[0] = n;
    }

    protected void directIOTurnKbdLightOn(int[] nArray, Object object) throws JposException {
        if (nArray == null || nArray.length < 1) {
            throw new JposException(106);
        }
        try {
            int n = nArray[0];
            if (n == 205) {
                CapsLock.setCapsLock(true);
                return;
            }
            if (n == 203 || n == 204) {
                if (n == 203) {
                    this.getPosDevice().ioctl(4716);
                } else {
                    this.getPosDevice().ioctl(4718);
                }
                return;
            }
            int[] nArray2 = new int[]{0};
            this.directIOGetKbdLightStatus(nArray2, null);
            int n2 = nArray2[0];
            PosArg[] posArgArray = new PosArg[]{new PosArg()};
            switch (n) {
                case 1: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(1 | n2);
                    break;
                }
                case 2: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(2 | n2);
                    break;
                }
                case 4: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(4 | n2);
                    break;
                }
                case 8: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(8 | n2);
                    break;
                }
                default: {
                    throw new JposException(106);
                }
            }
            this.getPosDevice().ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111, posException.getMessage(), posException);
        }
    }

    protected void directIOTurnKbdLightOff(int[] nArray, Object object) throws JposException {
        if (nArray == null || nArray.length < 1) {
            throw new JposException(106);
        }
        try {
            int n = nArray[0];
            if (n == 205) {
                CapsLock.setCapsLock(false);
                return;
            }
            if (n == 203 || n == 204) {
                if (n == 203) {
                    this.getPosDevice().ioctl(4715);
                } else {
                    this.getPosDevice().ioctl(4717);
                }
                return;
            }
            int[] nArray2 = new int[]{0};
            this.directIOGetKbdLightStatus(nArray2, null);
            int n2 = nArray2[0];
            PosArg[] posArgArray = new PosArg[]{new PosArg()};
            switch (n) {
                case 1: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(1 ^ n2);
                    break;
                }
                case 2: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(2 ^ n2);
                    break;
                }
                case 4: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(4 ^ n2);
                    break;
                }
                case 8: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(8 ^ n2);
                    break;
                }
                case 0: {
                    posArgArray[0].setName("keyboardLightsOn");
                    posArgArray[0].setValue(0);
                    break;
                }
                default: {
                    throw new JposException(106);
                }
            }
            this.getPosDevice().ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111, posException.getMessage(), posException);
        }
    }

    public void clearInput() throws JposException {
    }

    protected final String getPOSSDeviceClass() {
        return "PosKeyboard";
    }

    protected final boolean isCompositeDevice() {
        return true;
    }

    protected final boolean isLockableDevice() {
        return true;
    }

    public boolean processKey(int n, int n2, int n3, int n4) {
        if (n2 == 2 && this.serviceState.getEventTypes() == 1) {
            return false;
        }
        if (this.kbdMapLen == 0) {
            this.sendKey(n, n2, 1, 0);
        } else {
            int[][] nArray = this.kbdMap.lookupScancodes(n, n2);
            int n5 = 0;
            while (n5 < nArray.length) {
                this.sendKey(nArray[n5][0], nArray[n5][1], 1, 0);
                ++n5;
            }
        }
        return true;
    }

    public boolean sendKey(int n, int n2, int n3, int n4) {
        Object object;
        POSKeyboardServiceState pOSKeyboardServiceState = this.serviceState;
        synchronized (pOSKeyboardServiceState) {
            if (this.serviceState.getAutoDisable()) {
                try {
                    this.setDeviceEnabled(false);
                    this.serviceState.setDeviceEnabled(false);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
            }
        }
        int n5 = 0;
        while (n5 < n3) {
            try {
                object = new POSSPOSKeyboardDataEvent(n, n2);
                this.getEventQueueManager().postEvent((JposEventContainer)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n5;
        }
        if (n4 != 0) {
            object = new DirectIOEvent(this.eventSource, 0, n4, null);
            try {
                this.getEventQueueManager().postEvent((JposEvent)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private class POSSPOSKeyboardDataEvent
    implements JposEventContainer,
    POSKeyboardConst {
        private DataEvent dataEvent;
        private int keyData;
        private int keyEventType;

        public POSSPOSKeyboardDataEvent(int n, int n2) {
            this.dataEvent = new DataEvent(POSSPOSKeyboardServiceImp.this.eventSource, 0);
            this.keyData = n;
            this.keyEventType = n2;
        }

        public JposEvent getJposEvent() {
            return this.dataEvent;
        }

        public void prepareToFire() {
            POSKeyboardServiceState pOSKeyboardServiceState = POSSPOSKeyboardServiceImp.this.serviceState;
            synchronized (pOSKeyboardServiceState) {
                try {
                    POSSPOSKeyboardServiceImp.this.serviceState.setPOSKeyData(this.keyData);
                    POSSPOSKeyboardServiceImp.this.serviceState.setPOSKeyEventType(this.keyEventType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void doneFiring() {
        }
    }

    private class PosDeviceListener
    implements PosmKbdWmCharListener {
        private PosDeviceListener() {
        }

        public void posmKbdWmChar(short s, short s2, byte n) {
            if ((s2 & 4) != 4) {
                System.err.println("no need to process...");
                return;
            }
            int n2 = n >= 0 ? n : 256 + n;
            int n3 = POSSPOSKeyboardServiceImp.this.keyTable[n2];
            int n4 = (s2 & 0x40) == 64 ? 2 : 1;
            POSSPOSKeyboardServiceImp.this.processKey(n3, n4, 1, 0);
        }
    }
}

