/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.CashDrawerServiceImp;
import com.ibm.jpos.services.CashDrawerServiceState;
import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.services.poss.POSSImpFactory;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosException;
import com.ibm.poss.PosmTillClosedListener;
import com.ibm.poss.PosmTillOpenedListener;
import java.awt.Toolkit;
import jpos.JposException;
import jpos.events.StatusUpdateEvent;

public abstract class POSSCashDrawerServiceImp
extends POSSDeviceServiceImp
implements CashDrawerServiceImp {
    public static final int DEFAULT_OPEN_DRAWER_WAIT_TIME = 300;
    public static final int POSSCASHDRAWERIMP_CLAIM_TIMEOUT = 250;
    public static final int DEFAULT_WAIT_DRAWER_CLOSE_WAIT_TIME = 300;

    protected POSSCashDrawerServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.getPosDevice().setPosmTillClosedListener(new PosTillClosedListener());
        this.getPosDevice().setPosmTillOpenedListener(new PosTillOpenedListener());
    }

    protected final String getPOSSDeviceClass() {
        return "PosDrawer";
    }

    protected final boolean isShareableDevice() {
        return true;
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        this.getPosDevice().setPosmTillClosedListener(null);
        this.getPosDevice().setPosmTillOpenedListener(null);
    }

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        return POSSImpFactory.createImp(deviceServiceAbstraction);
    }

    synchronized void posmTillClosed() {
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        cashDrawerServiceState.setDrawerOpened(false);
        try {
            StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 0);
            this.getDeviceServiceAbstraction().getEventQueueManager().postEvent(statusUpdateEvent);
        }
        catch (JposException jposException) {
            jposException.printStackTrace();
        }
    }

    synchronized void posmTillOpened() {
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        cashDrawerServiceState.setDrawerOpened(true);
        try {
            StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), 1);
            this.getDeviceServiceAbstraction().getEventQueueManager().postEvent(statusUpdateEvent);
        }
        catch (JposException jposException) {
            jposException.printStackTrace();
        }
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        if (bl) {
            this.initStatus();
        }
    }

    public void openDrawer() throws JposException {
        block6: {
            int n = 5401;
            try {
                this.getPosDevice().ioctl(n);
                try {
                    Thread.currentThread();
                    Thread.sleep(this.getOpenDrawerWaitTime());
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (PosException posException) {
                int n2 = posException.getErrorCode();
                if (n2 == 315) {
                    throw new JposException(111, "JposConst.JPOS_E_FAILURE", posException);
                }
                if (n2 == 317) {
                    throw new JposException(108, "JposConst.JPOS_E_OFFLINE", posException);
                }
                if (n2 != 313) break block6;
                throw new JposException(102, "JposConst.JPOS_E_CLAIMED", posException);
            }
        }
    }

    public void waitForDrawerClose(int n, int n2, int n3, int n4) throws JposException {
    }

    public void beep(int n, int n2, int n3) throws JposException {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Throwable throwable) {
            System.out.print("\u0007");
            System.out.flush();
        }
        try {
            Thread.currentThread();
            Thread.sleep(n3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getWaitDrawerCloseWaitTime() throws JposException {
        return 300;
    }

    protected int getOpenDrawerWaitTime() {
        return 300;
    }

    protected void initStatus() throws JposException {
        PosArg[] posArgArray;
        block3: {
            int n = 302;
            posArgArray = new PosArg[]{new PosArg("tillStatus", -1)};
            try {
                this.getPosDevice().ioctl(n, posArgArray, posArgArray.length);
            }
            catch (PosException posException) {
                int n2 = posException.getErrorCode();
                if (n2 == 315) {
                    throw new JposException(111, "JposConst.JPOS_E_FAILURE", posException);
                }
                if (n2 != 317) break block3;
                throw new JposException(108, "JposConst.JPOS_E_OFFLINE", posException);
            }
        }
        int n = (Integer)posArgArray[0].getValue();
        CashDrawerServiceState cashDrawerServiceState = (CashDrawerServiceState)this.getDeviceServiceState();
        cashDrawerServiceState.setDrawerOpened((n & 4) == 4);
    }

    private class PosTillOpenedListener
    implements PosmTillOpenedListener {
        private PosTillOpenedListener() {
        }

        public void posmTillOpened() {
            POSSCashDrawerServiceImp.this.posmTillOpened();
        }
    }

    private class PosTillClosedListener
    implements PosmTillClosedListener {
        private PosTillClosedListener() {
        }

        public void posmTillClosed() {
            POSSCashDrawerServiceImp.this.posmTillClosed();
        }
    }
}

