/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.poss.POSSPrintDataCompiler;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.Tracer;
import jpos.JposException;
import jpos.POSPrinterConst;

public class POSPrinter4POSSPrintDataCompiler
extends POSSPrintDataCompiler
implements POSPrinterConst {
    private static final String className = "POSPrinter4POSSPrintDataCompiler";
    private PrinterFont selectedPrinterFont = null;

    POSPrinter4POSSPrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        super(pOSPrinterServiceState);
    }

    public byte[] compile(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        return super.compile(n, string, n2, printBitmapUtil, printerFontArray);
    }

    public void validate(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        super.validate(n, string, n2, printBitmapUtil, printerFontArray);
    }

    public PrinterFont getSelectedPrinterFont() {
        return this.selectedPrinterFont;
    }

    protected byte[] getPrologueBytes() throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getPrologueBytes()", "Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        ByteBuffer byteBuffer = new ByteBuffer();
        String string = "";
        int n = 0;
        int n2 = -1;
        switch (this.getStation()) {
            case 1: {
                string = "JrnLineChars";
                n = this.getServiceState().getJrnLineChars();
                break;
            }
            case 2: {
                string = "RecLineChars";
                n = this.getServiceState().getRecLineChars();
                break;
            }
            case 4: {
                string = "SlpLineChars";
                n = this.getServiceState().getSlpLineChars();
                break;
            }
            default: {
                throw new JposException(111);
            }
        }
        int n3 = 0;
        while (n3 < printerFontArray.length) {
            if (printerFontArray[n3].station == this.getStation()) {
                if (printerFontArray[n3].lineChars == n) {
                    n2 = n3;
                    break;
                }
                if (printerFontArray[n3].lineChars > n && (n2 == -1 || printerFontArray[n2].lineChars > printerFontArray[n3].lineChars)) {
                    n2 = n3;
                }
            }
            ++n3;
        }
        if (n2 == -1) {
            throw new JposException(111);
        }
        this.selectedPrinterFont = printerFontArray[n2];
        byteBuffer.append(27).append(59);
        switch (printerFontArray[n2].fontType) {
            case 2: {
                byteBuffer.append(27).append(58);
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                byteBuffer.append(27).append(60);
            }
        }
        Tracer.trace(4, className, "getPrologueBytes()", "Exit");
        return byteBuffer.getBytes();
    }

    protected byte[] getPrintBitmapBytes(int n, int n2) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getFeedPaperCutAndStampBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getUnderlineBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getUnderlineBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getReverseVideoBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getShadingBytes() throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getShadingBytes(int n) throws PrintDataParseException, JposException {
        if (this.isValidating()) {
            throw new JposException(111);
        }
        return new byte[0];
    }

    protected byte[] getSingleWideSingleHighBytes() throws PrintDataParseException, JposException {
        return this.getPrologueBytes();
    }

    protected byte[] getDoubleWideBytes() throws PrintDataParseException, JposException {
        return new byte[]{27, 14};
    }

    protected byte[] getDoubleHighBytes() throws PrintDataParseException, JposException {
        return new byte[]{27, 23};
    }

    protected byte[] getDoubleWideDoubleHighBytes() throws PrintDataParseException, JposException {
        return new byte[]{27, 23};
    }

    protected byte[] getNormalBytes() {
        ByteBuffer byteBuffer = new ByteBuffer();
        try {
            byteBuffer.append(27).append(75).append(this.getPrologueBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteBuffer.getBytes();
    }
}

