/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.CacheVectorEntry;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrintRawModeInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrinterRead;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrintGetDirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.PrintNormalData;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.poss.POSPrinter4610POSSPrintDataCompiler;
import com.ibm.jpos.services.poss.POSSPOSPrinterServiceImp;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.services.EventCallbacks;

public class POSPrinter4610Imp
extends POSSPOSPrinterServiceImp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "POSPrinter4610Imp";
    protected POSPrinter4610POSSPrintDataCompiler printDataCompiler = null;
    protected boolean serviceStateReset = false;
    protected int[] index = new int[1];
    private static final String JDIAG_DEBUG_PROPERTY_KEY = "jdiag.debug";
    private static final String jdiagDebug = System.getProperty("jdiag.debug");
    private static final String SELECT_RESIDENT_CHARACTER_SET_COMMAND = "\u001b%\u0000";
    private static final String SELECT_USER_DEFINED_CHARACTER_SET_COMMAND = "\u001b%\u0001";
    private static final String FONT_NON_PROP_FILE_TAG = "IBMPosPrinterSingleFont";
    private static final String FONT_PROP_FILE_TAG = "IBM4610PropFont";
    private static final int PosRAW_MODE = 159;
    private static final byte FLASH_EPROM_ERROR_MASK = 8;
    private static final int STATUS_BYTE_3_INDEX = 6;
    private String aspectRatioH = "1";
    private String aspectRatioW = "2";
    private String eccLevelH = "0";
    private String eccLevelL = "15";
    private String truncation = "0";

    protected POSPrinter4610Imp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor()", "Entry");
        Tracer.trace(4, className, "Constructor()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        this.printDataCompiler = new POSPrinter4610POSSPrintDataCompiler((POSPrinterServiceState)this.getDeviceServiceState());
        JposEntryInfo jposEntryInfo = this.serviceState.getJposEntryInfo();
        if (jposEntryInfo != null) {
            if (jposEntryInfo.getPropertyValue("aspectRatioH") != null) {
                this.aspectRatioH = (String)jposEntryInfo.getPropertyValue("aspectRatioH");
            }
            if (jposEntryInfo.getPropertyValue("aspectRatioW") != null) {
                this.aspectRatioW = (String)jposEntryInfo.getPropertyValue("aspectRatioW");
            }
            if (jposEntryInfo.getPropertyValue("eccLevelH") != null) {
                this.eccLevelH = (String)jposEntryInfo.getPropertyValue("eccLevelH");
            }
            if (jposEntryInfo.getPropertyValue("eccLevelL") != null) {
                this.eccLevelL = (String)jposEntryInfo.getPropertyValue("eccLevelL");
            }
            if (jposEntryInfo.getPropertyValue("truncation") != null) {
                this.truncation = (String)jposEntryInfo.getPropertyValue("truncation");
            }
        }
        Tracer.trace(4, className, "open()", "Exit");
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled(" + bl + ")", "Entry");
        super.setDeviceEnabled(bl);
        if (bl) {
            try {
                this.posDevice.write(new byte[]{27, 104, 49});
            }
            catch (PosException posException) {
                posException.printStackTrace();
                throw this.createJposException(posException);
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause(new PrintNormalData(0, null, false, false));
                throw this.createJposException(exception);
            }
        }
        Tracer.trace(4, className, "setDeviceEnabled()", "Exit");
    }

    protected PrintDataCompiler getPrintDataCompiler() {
        return this.printDataCompiler;
    }

    void processDynamicCapabilities() throws JposException {
        Tracer.trace(4, className, "processDynamicCapabilities()", "Entry");
        try {
            if (ByteEncoder.isDBCSCodePage(ByteEncoder.getCodePage(this.serviceState.getCharacterSet()))) {
                Tracer.trace(4, className, "processDynamicCapabilities()", "Code page is DBCS");
                this.serviceState.setCapSlpLeft90(false);
                this.serviceState.setSlpSidewaysMaxChars(0);
                this.serviceState.setSlpSidewaysMaxLines(0);
            } else {
                Tracer.trace(4, className, "processDynamicCapabilities()", "Code page is SBCS");
                this.serviceState.setCapSlpLeft90(true);
                this.serviceState.setSlpSidewaysMaxChars(147);
                this.serviceState.setSlpSidewaysMaxLines(19);
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg("printFeatures", 0)};
            this.posDevice.ioctl(302, posArgArray);
            int n = (Integer)posArgArray[0].getValue();
            if ((n & 2) != 0) {
                this.serviceState.setCapSlpBothSidesPrint(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "processDynamicCapabilities()", "Exit");
    }

    void doDirectIOFlipCheck() throws JposException {
        Tracer.trace(4, className, "doDirectIOFlipCheck()", "Entry");
        try {
            if (!this.serviceState.getCapSlpBothSidesPrint()) {
                throw new JposException(111, "Flipper not present.");
            }
            if (this.serviceState.getCoverOpen()) {
                throw new JposException(114, 201);
            }
            if (this.documentInserted.isFalse()) {
                throw new JposException(114, 204);
            }
            this.selectStations(4);
            this.posDevice.write(new byte[]{27, 53});
            this.chase(30000);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111, posException.getMessage(), posException);
        }
        Tracer.trace(4, className, "doDirectIOFlipCheck()", "Exit");
    }

    void doDirectIOPrintDownloadedBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
        Tracer.trace(4, className, "doDirectIOPrintDownloadedBitmap(" + n + ")", "Entry");
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            this.clearBitmaps();
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.removeAllElements(CacheVector.BITMAP);
            }
        } else {
            if (n > 40) {
                throw new JposException(106);
            }
            if (this.printBitmapUtil == null) {
                throw new JposException(111);
            }
            CacheVectorEntry cacheVectorEntry = this.printBitmapUtil.cacheVector.get(CacheVector.BITMAP, directIOBitmapInfo.station, n);
            if (cacheVectorEntry == null) {
                throw new JposException(111);
            }
            POSSPOSPrinterServiceImp.debugPrintBitmap.println("printing " + n + " from " + cacheVectorEntry.index);
            this.checkStations(directIOBitmapInfo.station);
            this.selectStations(directIOBitmapInfo.station);
            byte[] byArray = new byte[]{27, 112, 2, (byte)cacheVectorEntry.index};
            this.chaseCompleted.set(false);
            try {
                this.posDevice.write(byArray);
                this.chase(30000);
            }
            catch (Exception exception) {
                throw this.createJposException(exception);
            }
        }
        Tracer.trace(4, className, "doDirectIOPrintDownloadedBitmap()", "Exit");
    }

    void doDirectIOPrintDownloadedMessage(int n) throws JposException {
        Tracer.trace(4, className, "doDirectIOPrintDownloadedMessage(" + n + ")", "Entry");
        this.printDataCompiler.setLogo(1, "");
        this.printDataCompiler.setLogo(2, "");
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            this.clearMessages();
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.removeAllElements(CacheVector.MESSAGE);
            }
        } else {
            if (n > 25) {
                throw new JposException(106);
            }
            CacheVectorEntry cacheVectorEntry = this.printBitmapUtil.cacheVector.get(CacheVector.MESSAGE, -1, n);
            if (cacheVectorEntry == null) {
                throw new JposException(111);
            }
            int n2 = 2;
            try {
                this.posDevice.write(new byte[]{27, 113, (byte)cacheVectorEntry.index, 27, 71});
                this.chase();
            }
            catch (PosException posException) {
                throw this.createJposException(posException);
            }
        }
        Tracer.trace(4, className, "doDirectIOPrintDownloadedMessage()", "Exit");
    }

    public void processRotatePrint(RotatePrintData rotatePrintData) throws JposException {
        Tracer.trace(4, className, "processRotatePrint()", "Entry");
        super.processRotatePrint(rotatePrintData);
        block0 : switch (rotatePrintData.getStation()) {
            case 2: {
                switch (rotatePrintData.getRotation()) {
                    case 257: {
                        this.setRecLineSpacing(15);
                        break block0;
                    }
                    case 1: {
                        this.setRecLineSpacing(this.serviceState.getRecLineSpacing());
                    }
                }
            }
        }
        Tracer.trace(4, className, "processRotatePrint()", "Exit");
    }

    /*
     * Unable to fully structure code
     */
    public void processPrintBarCode(PrintBarCodeData var1_1) throws JposException {
        var2_2 = var1_1.getStation();
        var3_3 = var1_1.getData();
        var4_4 = var1_1.getSymbology();
        var5_5 = var1_1.getHeight();
        var6_6 = var1_1.getWidth();
        var7_7 = var1_1.getAlignment();
        var8_8 = var1_1.getTextPosition();
        var9_9 = this.serviceState.getRecLineWidth();
        Tracer.trace(4, "POSPrinter4610Imp", "processPrintBarCode(" + var2_2 + ", " + var3_3 + ", " + var4_4 + ", " + var5_5 + ", " + var6_6 + ", " + var7_7 + ", " + var8_8 + ")", "Entry");
        try {
            block37: {
                if (this.getPrintingMode(var2_2).getRotation() != 1) {
                    throw new JposException(106);
                }
                if (var6_6 > var9_9) {
                    throw new JposException(106);
                }
                this.checkStations(var2_2);
                this.selectStations(var2_2);
                var10_10 = 0;
                var11_12 = 0;
                var14_13 = false;
                var15_14 = new ByteBuffer();
                switch (var4_4) {
                    case 101: {
                        var11_12 = 0;
                        break;
                    }
                    case 102: {
                        var11_12 = 1;
                        break;
                    }
                    case 103: {
                        var11_12 = 3;
                        break;
                    }
                    case 104: {
                        var11_12 = 2;
                        break;
                    }
                    case 106: {
                        var11_12 = 5;
                        break;
                    }
                    case 107: {
                        var11_12 = 6;
                        break;
                    }
                    case 108: {
                        var11_12 = 4;
                        break;
                    }
                    case 109: {
                        var11_12 = 8;
                        break;
                    }
                    case 110: {
                        var11_12 = 7;
                        break;
                    }
                    case 201: {
                        break;
                    }
                    default: {
                        throw new JposException(111, "Internal Error: don't recognize validated symbology: " + var4_4);
                    }
                }
                this.debugPrintln("Barcode Type detected");
                switch (var8_8) {
                    case -11: {
                        var10_10 = 0;
                        break;
                    }
                    case -12: {
                        var10_10 = 1;
                        break;
                    }
                    case -13: {
                        var10_10 = 2;
                        break;
                    }
                    default: {
                        throw new JposException(111, "Internal Error: don't recognize validated textPosition: " + var8_8);
                    }
                }
                this.debugPrintln("textPosition was set");
                var12_15 = (this.mapModeCalc.convertToPrinterDots(this.serviceState.getMapMode(), var6_6, this.getDotsPerInchWide(var2_2)) + var9_9 / 6) * 3 / var9_9 + 1;
                if (var12_15 < 2) {
                    var12_15 = 2;
                } else if (var12_15 > 4) {
                    var12_15 = 4;
                }
                var13_16 = this.mapModeCalc.convertToPrinterDots(this.serviceState.getMapMode(), var5_5, this.getDotsPerInchWide(var2_2));
                if (var13_16 > 255) {
                    throw new JposException(106);
                }
                if (var4_4 != 201) {
                    var15_14.append(27).append(107);
                    var15_14.append(var11_12);
                    var15_14.append(var12_15);
                    var15_14.append(var13_16);
                    var15_14.append(var10_10);
                    var15_14.append(1);
                } else {
                    this.debugPrintln("PDF417 barcode");
                    var15_14.append(27).append(108).append(82);
                    var15_14.append(new Integer(new String(this.eccLevelH.getBytes())));
                    var15_14.append(new Integer(new String(this.eccLevelL.getBytes())));
                    var15_14.append(27).append(108).append(83);
                    var15_14.append(this.aspectRatioH.getBytes()).append(this.aspectRatioW.getBytes());
                    var15_14.append(27).append(108).append(84);
                    var15_14.append(this.truncation.getBytes());
                    var15_14.append(27).append(108).append(80);
                    this.debugPrintln("PDF417 barcode finished");
                }
                try {
                    var15_14.append(var3_3.getBytes("ISO8859_1"));
                    break block37;
                }
                catch (UnsupportedEncodingException var16_17) {
                    var17_19 = 0;
                    ** while (var17_19 < var3_3.length())
                }
lbl-1000:
                // 1 sources

                {
                    var15_14.append((byte)var3_3.charAt(var17_19));
                    ++var17_19;
                    continue;
                }
            }
            var15_14.append(0);
            var15_14.append(27).append(71);
            switch (var7_7) {
                case -1: {
                    var16_18 = new PosArg[]{new PosArg("printAlignment", 0)};
                    break;
                }
                case -2: {
                    var16_18 = new PosArg[]{new PosArg("printAlignment", 1)};
                    break;
                }
                case -3: {
                    var16_18 = new PosArg[]{new PosArg("printAlignment", 2)};
                    break;
                }
                default: {
                    throw new JposException(106, "Illegal alignment: " + var7_7);
                }
            }
            this.chaseCompleted.set(false);
            this.posDevice.ioctl(305, var16_18);
            this.posDevice.write(var15_14.getBytes());
            this.chaseCompleted.waitForTrue(10000);
        }
        catch (Exception var10_11) {
            if (this.getPrintingMode(var2_2).isTransaction()) {
                this.getPrintingMode(var2_2).clearTransaction();
            }
            this.checkPrinterErrorCause(var1_1);
            if (var10_11 instanceof JposException) {
                throw (JposException)var10_11;
            }
            throw new JposException(111);
        }
        Tracer.trace(4, "POSPrinter4610Imp", "processPrintBarCode()", "Exit");
    }

    public void checkMode(int n, int n2) throws JposException {
        Tracer.trace(4, className, "checkMode(" + n + ", " + n2 + ")", "Entry");
        if (n2 == 2 || n2 == 16) {
            Tracer.trace(4, className, "checkMode()", "Exit");
            return;
        }
        throw new JposException(106);
    }

    public void clearBitmaps() throws JposException {
        Tracer.trace(4, className, "clearBitmaps()", "Entry");
        if (!this.serviceState.getCoverOpen()) {
            this.chase(50000);
        }
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg("printMode", 0)};
            this.posDevice.ioctl(302, posArgArray);
            PosArg[] posArgArray2 = new PosArg[]{new PosArg("printMode", 16)};
            this.posDevice.ioctl(305, posArgArray2);
            this.posDevice.write(new byte[]{0, 0, 0});
            try {
                Thread.currentThread();
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.posDevice.ioctl(305, posArgArray);
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.bitmapIndex = 1;
            }
        }
        catch (PosException posException) {
            throw new JposException(111, posException.getMessage(), posException);
        }
        this.chase();
        Tracer.trace(4, className, "clearBitmaps()", "Exit");
    }

    public void clearMessages() throws JposException {
        Tracer.trace(4, className, "clearMessages()", "Entry");
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", 0), new PosArg("printMode", 0)};
            this.posDevice.ioctl(302, posArgArray);
            PosArg[] posArgArray2 = new PosArg[]{new PosArg("printStation", 1), new PosArg("printMode", 8)};
            this.posDevice.ioctl(305, posArgArray2);
            this.posDevice.write(new byte[]{0});
            this.posDevice.ioctl(305, posArgArray);
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.messageIndex = 1;
            }
        }
        catch (PosException posException) {
            throw new JposException(111, posException.getMessage(), posException);
        }
        Tracer.trace(4, className, "clearMessages()", "Exit");
    }

    public void downloadData(int n, String string, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "downloadData(" + n + ", " + string + ", " + n2 + ", " + n3 + ")", "Entry");
        int n4 = string.indexOf("\u001bF");
        if (n4 > 0) {
            try {
                string = new String(string.substring(0, n4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[string.length()];
        int n5 = 0;
        while (n5 < byArray.length) {
            byArray[n5] = (byte)string.charAt(n5);
            ++n5;
        }
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", 0), new PosArg("printMode", 0), new PosArg("printAlignment", 0)};
            this.posDevice.ioctl(302, posArgArray);
            PosArg[] posArgArray2 = new PosArg[]{new PosArg("printStation", 1), new PosArg("printMode", 8), new PosArg("printAlignment", 1)};
            this.posDevice.ioctl(305, posArgArray2);
            this.posDevice.write(byArray);
            this.posDevice.ioctl(305, posArgArray);
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
            }
        }
        catch (PosException posException) {
            throw new JposException(111, posException.getMessage(), posException);
        }
        Tracer.trace(4, className, "downloadData()", "Exit");
    }

    public void downloadData(int n, byte[] byArray, int n2, int n3) throws JposException {
        int n4;
        int n5;
        Tracer.trace(4, className, "downloadData(" + n + ", " + n2 + ", " + n3 + ")", "Entry");
        int n6 = byArray[1] & 0xFF;
        int n7 = byArray[2] & 0xFF;
        int n8 = n6 * 8 * n7 + 3;
        if (n == 2) {
            n5 = this.serviceState.getRecLineWidth() / 8;
            n4 = 255;
        } else {
            n5 = this.serviceState.getSlpLineWidth() / 8;
            n4 = 5;
        }
        Tracer.trace(4, className, "downloadData", "maxWidth: " + n5);
        Tracer.trace(4, className, "downloadData", "maxHeight: " + n4);
        Tracer.trace(4, className, "downloadData", "bitmap[1]: " + n6);
        Tracer.trace(4, className, "downloadData", "bitmap[2]: " + n7);
        Tracer.trace(4, className, "downloadData", "bitmapSize: " + n8);
        if (n8 > this.getMaxSetBitmapSize(n) || n6 > n5 || n7 > n4) {
            throw new JposException(114, 206);
        }
        this.doPrinting(n, byArray, n2, 16);
        if (this.printBitmapUtil != null) {
            this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
        }
        Tracer.trace(4, className, "downloadData()", "Exit");
    }

    public int getStationMaxBitmapHeight(int n) {
        Tracer.trace(4, className, "getStationMaxBitmapHeight(" + n + ")", "Entry");
        int n2 = 5;
        if (n == 2) {
            n2 = 255;
        }
        Tracer.trace(4, className, "getStationMaxBitmapHeight() = " + n2, "Exit");
        return n2;
    }

    public short getNextByteForStation(int n, PrintBitmapImageInfo printBitmapImageInfo) {
        short s = 0;
        s = n == 2 ? this.getNextByteForThermal(printBitmapImageInfo) : printBitmapImageInfo.getNextByteForImpact(printBitmapImageInfo);
        return s;
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace(4, className, "getPrinterFonts()", "Entry");
        PrinterFont[] printerFontArray = null;
        try {
            int n = ByteEncoder.getCodePage(this.serviceState.getCharacterSet());
            switch (n) {
                case 949: 
                case 951: 
                case 1088: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 1, 0, 34), new PrinterFont(4, 43, 474, 1, 1, 8)};
                    if (!this.serviceStateReset) {
                        this.serviceState.setRecLineChars(38);
                        this.serviceState.setSlpLineChars(43);
                        this.serviceStateReset = true;
                    }
                    break;
                }
                case 932: 
                case 950: 
                case 1381: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 5, 0, 34), new PrinterFont(2, 44, 576, 5, 0, 34), new PrinterFont(2, 48, 576, 5, 0, 34), new PrinterFont(4, 23, 474, 5, 0, 8), new PrinterFont(4, 24, 474, 5, 0, 8), new PrinterFont(4, 26, 474, 5, 0, 8), new PrinterFont(4, 27, 474, 5, 0, 8), new PrinterFont(4, 29, 474, 5, 0, 8)};
                    if (!this.serviceStateReset) {
                        this.serviceState.setRecLineChars(38);
                        this.serviceState.setSlpLineChars(24);
                        this.serviceStateReset = true;
                    }
                    break;
                }
                default: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 44, 576, 1, 0, 34), new PrinterFont(2, 34, 576, 2, 0, 34), new PrinterFont(2, 48, 576, 3, 0, 34), new PrinterFont(4, 47, 474, 1, 0, 8), new PrinterFont(4, 37, 474, 2, 0, 8), new PrinterFont(4, 52, 474, 3, 0, 8), new PrinterFont(4, 38, 384, 1, 1, 8), new PrinterFont(4, 30, 384, 2, 1, 8), new PrinterFont(4, 42, 384, 3, 1, 8)};
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "getPrinterFonts()", "Exit");
        return printerFontArray;
    }

    public synchronized void setCharacterSet(int n) throws JposException {
        this.serviceStateReset = false;
        super.setCharacterSet(n);
        Tracer.trace(4, className, "setCharacterSet(" + n + ")", "Entry");
        try {
            int n2 = ByteEncoder.getCodePage(n);
            switch (n2) {
                case 932: 
                case 949: 
                case 950: 
                case 1381: {
                    Tracer.trace(4, className, "setCharacterSet()", "Code page is DBCS");
                    this.serviceState.setCapSlpLeft90(false);
                    this.serviceState.setSlpSidewaysMaxChars(0);
                    this.serviceState.setSlpSidewaysMaxLines(0);
                    break;
                }
                default: {
                    Tracer.trace(4, className, "setCharacterSet()", "Code page is SBCS");
                    this.serviceState.setCapSlpLeft90(true);
                    this.serviceState.setSlpSidewaysMaxChars(147);
                    this.serviceState.setSlpSidewaysMaxLines(19);
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "setCharacterSet()", "Exit");
    }

    short getNextByteForThermal(PrintBitmapImageInfo printBitmapImageInfo) {
        int n = 0;
        if (printBitmapImageInfo.row >= printBitmapImageInfo.height) {
            n = 0;
            printBitmapImageInfo.col += 8L;
            if (printBitmapImageInfo.col >= printBitmapImageInfo.width) {
                if (printBitmapImageInfo.row % 8L == 7L) {
                    printBitmapImageInfo.done = true;
                } else {
                    printBitmapImageInfo.col = 0L;
                    ++printBitmapImageInfo.row;
                }
            }
        } else {
            int n2 = 0;
            while (n2 < 8) {
                int n3 = printBitmapImageInfo.pixels[(int)(printBitmapImageInfo.row * printBitmapImageInfo.width + printBitmapImageInfo.col)];
                n3 = n3 == -1 ? 1 : 0;
                n = n << 1 | n3;
                ++printBitmapImageInfo.col;
                if (printBitmapImageInfo.col == printBitmapImageInfo.width) {
                    n <<= 7 - n2;
                    n2 = 8;
                    if (printBitmapImageInfo.row == printBitmapImageInfo.height - 1L && printBitmapImageInfo.row % 8L == 7L) {
                        printBitmapImageInfo.done = true;
                    } else {
                        printBitmapImageInfo.col = 0L;
                        ++printBitmapImageInfo.row;
                    }
                }
                ++n2;
            }
        }
        return (short)n;
    }

    public byte[] getBitmapHeader(int n, int n2) {
        Tracer.trace(4, className, "getBitmapHeader(" + n + ", " + n2 + ")", "Entry");
        byte[] byArray = new byte[]{0, (byte)n, (byte)n2};
        return byArray;
    }

    public int getMaxBitmapWidth(int n) throws JposException {
        if (n == 2) {
            return 576;
        }
        return 472;
    }

    public int getMaxBitmapHeight(int n) throws JposException {
        if (n == 2) {
            return 2040;
        }
        return 40;
    }

    public int getMicronsPerStep(int n) {
        Tracer.trace(4, className, "getMicronsPerStep(" + n + ")", "Entry");
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = 125;
                break;
            }
            case 4: {
                n2 = 529;
            }
        }
        Tracer.trace(4, className, "getMicronsPerStep() = " + n2, "Exit");
        return n2;
    }

    public int getDotsPerInchHigh(int n) {
        Tracer.trace(4, className, "getDotsPerInchHigh(" + n + ")", "Entry");
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = 204;
                break;
            }
            case 4: {
                n2 = 48;
            }
        }
        Tracer.trace(4, className, "getDotsPerInchHigh() = " + n2, "Exit");
        return n2;
    }

    public int getDotsPerInchWide(int n) throws JposException {
        int n2;
        Tracer.trace(4, className, "getDotsPerInchWide(" + n + ")", "Entry");
        switch (n) {
            case 2: {
                n2 = 203;
                break;
            }
            default: {
                n2 = 152;
            }
        }
        Tracer.trace(4, className, "getDotsPerInchWide() = " + n2, "Exit");
        return n2;
    }

    public int getMaxBytesPerWrite(int n) throws JposException {
        Tracer.trace(4, className, "getMaxBytesPerWrite(" + n + ")", "Entry");
        Tracer.trace(4, className, "getMaxBytesPerWrite() = 16000", "Exit");
        return 16000;
    }

    public int getWriteBufferSize() {
        Tracer.trace(4, className, "getWriteBufferSize()", "Entry");
        Tracer.trace(4, className, "getWriteBufferSize() = 8192", "Exit");
        return 4000;
    }

    public int getMaxSetBitmapSize(int n) throws JposException {
        int n2 = this.getMaxBytesPerWrite(n);
        Tracer.trace(4, className, "getMaxSetBitmapSize() = " + n2, "Exit");
        return n2;
    }

    public int getMaxPrintBitmapSize() throws JposException {
        int n = this.getWriteBufferSize();
        Tracer.trace(4, className, "getMaxPrintBitmapSize() = " + n, "Exit");
        return n;
    }

    public boolean requiresLinefeed(int n) {
        Tracer.trace(4, className, "requiresLineFeed(" + n + ")", "Entry");
        boolean bl = true;
        if (n == 2) {
            bl = false;
        }
        Tracer.trace(4, className, "requiresLineFeed() = " + bl, "Exit");
        return bl;
    }

    void doReadMCT(int[] nArray) throws JposException {
        Tracer.trace(4, className, "doReadMCT(" + nArray[0] + ")", "Entry");
        DirectIOPrinterRead directIOPrinterRead = new DirectIOPrinterRead(null, new byte[5]);
        directIOPrinterRead.writeCommand = "\u001bS" + (char)nArray[0];
        this.doPrinterRead(directIOPrinterRead);
        nArray[0] = this.intFromByte(directIOPrinterRead.buffer[0]) * 256 + this.intFromByte(directIOPrinterRead.buffer[1]);
        Tracer.trace(4, className, "doReadMCT(" + nArray[0] + ")", "Exit");
    }

    private int intFromByte(byte by) {
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    void doDirectIOGetFontInfo(PrintGetDirectIOFontInfo printGetDirectIOFontInfo) throws JposException {
        int[] nArray = new int[4];
        int[] nArray2 = new int[2];
        this.index[0] = 86;
        this.doReadMCT(this.index);
        int n = this.index[0];
        int n2 = (n & 0xFF00) >> 8;
        int n3 = n & 0xFF;
        nArray[0] = n2 & 3;
        nArray[1] = n2 >> 2 & 3;
        nArray[2] = n2 >> 4 & 3;
        nArray[3] = n2 >> 6;
        printGetDirectIOFontInfo.setReceiptCharacterSet(nArray);
        nArray2[0] = n3 & 3;
        nArray2[1] = n3 >> 2 & 3;
        printGetDirectIOFontInfo.setSlipCharacterSet(nArray2);
        this.index[0] = 1;
        this.doReadMCT(this.index);
        int n4 = (this.index[0] & 0xFF00) >> 8;
        int n5 = this.index[0] & 0xFF;
        byte by = (byte)n4;
        byte by2 = (byte)n5;
        printGetDirectIOFontInfo.setDBCSCodePage(by2);
        printGetDirectIOFontInfo.setMatrixImpactCodePage(by);
        this.index[0] = 2;
        this.doReadMCT(this.index);
        printGetDirectIOFontInfo.setMatrixUDThermalCodePage1(this.intToByte(this.index));
        this.index[0] = 3;
        this.doReadMCT(this.index);
        printGetDirectIOFontInfo.setMatrixUDThermalCodePage2(this.intToByte(this.index));
        this.index[0] = 23;
        this.doReadMCT(this.index);
        printGetDirectIOFontInfo.setMatrixUDThermalCodePage3(this.intToByte(this.index));
        this.index[0] = 24;
        this.doReadMCT(this.index);
        printGetDirectIOFontInfo.setMatrixUDThermalCodePage4(this.intToByte(this.index));
        this.index[0] = 4;
        this.doReadMCT(this.index);
        printGetDirectIOFontInfo.setMatrixUDImpactCodePage1(this.intToByte(this.index));
        this.index[0] = 5;
        this.doReadMCT(this.index);
        printGetDirectIOFontInfo.setMatrixUDImpactCodePage2(this.intToByte(this.index));
        this.index[0] = 51;
        this.doReadMCT(this.index);
        int n6 = this.index[0];
        printGetDirectIOFontInfo.setDBCSAddressVector1(n6);
        this.index[0] = 52;
        this.doReadMCT(this.index);
        n6 = this.index[0];
        printGetDirectIOFontInfo.setDBCSAddressVector2(n6);
        this.index[0] = 53;
        this.doReadMCT(this.index);
        n6 = this.index[0];
        printGetDirectIOFontInfo.setDBCSAddressVector3(n6);
    }

    private byte[] intToByte(int[] nArray) {
        int[] nArray2 = new int[2];
        byte[] byArray = new byte[2];
        nArray2[0] = (nArray[0] & 0xFF00) >> 8;
        nArray2[1] = nArray[0] & 0xFF;
        byArray[0] = (byte)nArray2[0];
        byArray[1] = (byte)nArray2[1];
        return byArray;
    }

    void doDirectIODownloadPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        if (directIOFontInfo.station == 2) {
            if (directIOFontInfo.fontNumber < 1 || directIOFontInfo.fontNumber > 4) {
                throw new JposException(106);
            }
        } else {
            throw new JposException(106);
        }
        this.setPropFont(directIOFontInfo.fontNumber, directIOFontInfo.station, directIOFontInfo.fileName);
    }

    /*
     * Loose catch block
     */
    private void setPropFont(int n, int n2, String string) throws JposException {
        block27: {
            Exception exception2222;
            PosArg[] posArgArray;
            FileInputStream fileInputStream;
            block26: {
                String string2;
                fileInputStream = null;
                DirectIOPrintRawModeInfo directIOPrintRawModeInfo = new DirectIOPrintRawModeInfo(n2, null, true);
                posArgArray = new PosArg[]{new PosArg("printMode", 159)};
                byte[] byArray = new byte[100];
                PosArg[] posArgArray2 = new PosArg[]{new PosArg("rawPrintStatus", byArray)};
                int n3 = 0;
                int n4 = 0;
                fileInputStream = new FileInputStream(string);
                byte[] byArray2 = new byte[FONT_PROP_FILE_TAG.length()];
                fileInputStream.read(byArray2);
                String string3 = new String(byArray2);
                if (!string3.equals(FONT_PROP_FILE_TAG)) {
                    throw new JposException(106);
                }
                directIOPrintRawModeInfo.command = string2 = this.getMCTValueCommand(n, n2, 85, 85);
                this.doPrintInRawMode(directIOPrintRawModeInfo);
                byte[] byArray3 = new byte[71];
                n3 = 32;
                while (n3 < 128) {
                    int n5 = 0;
                    while (n5 < byArray3.length) {
                        byArray3[n5] = 0;
                        ++n5;
                    }
                    this.getDownloadFontCommand(n, n2, n3, n3, byArray3);
                    int n6 = fileInputStream.read();
                    fileInputStream.skip(3L);
                    int n7 = fileInputStream.read();
                    fileInputStream.skip(3L);
                    if (n6 > 16) {
                        throw new JposException(106);
                    }
                    if (n6 < 8) {
                        n6 = 8;
                    }
                    if (n7 % 2 == 1) {
                        n7 = (byte)(n7 + 1);
                    }
                    if (n7 > 32) {
                        throw new JposException(106);
                    }
                    if (n7 < 8) {
                        n7 = 8;
                    }
                    n4 = fileInputStream.read();
                    n4 += fileInputStream.read() << 8;
                    n4 += fileInputStream.read() << 16;
                    byArray3[5] = n6;
                    byArray3[6] = n7;
                    byte[] byArray4 = new byte[n4 += fileInputStream.read() << 24];
                    fileInputStream.read(byArray4);
                    int n8 = 7;
                    int n9 = 0;
                    while (n9 < n4) {
                        if (n9 % 4 == 0 || n9 % 4 == 1) {
                            byArray3[n8] = byArray4[n9];
                            ++n8;
                        }
                        ++n9;
                    }
                    this.debugPrintln("<POSPrinter4610.setPropFont>");
                    this.debugPrintln("    Character ASCII = " + n3);
                    this.debugPrintln("    Len             = " + n4);
                    this.debugPrintln("    Command (hex)   = " + this.convertToHexString(byArray3));
                    this.debugPrintln("</POSPrinter4610.setPropFont>");
                    this.posDevice.ioctl(305, posArgArray);
                    this.posDevice.write(byArray3, byArray3.length);
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.posDevice.ioctl(302, posArgArray2);
                    this.debugPrintln("<POSPrinter4610.setPropFont>");
                    this.debugPrintln("    rawPrintStatusArg = " + posArgArray2[0]);
                    this.debugPrintln("</POSPrinter4610.setPropFont>");
                    if ((((byte[])posArgArray2[0].getValue())[6] & 8) != 0) {
                        throw new JposException(110);
                    }
                    ++n3;
                }
                Object var23_25 = null;
                if (fileInputStream == null) break block26;
                try {
                    fileInputStream.close();
                }
                catch (IOException exception2222) {
                    // empty catch block
                }
            }
            try {
                posArgArray[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, posArgArray);
            }
            catch (PosException exception2222) {}
            break block27;
            {
                catch (PosException posException) {
                    throw new JposException(106);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JposException(109);
                }
                catch (IOException iOException) {
                    throw new JposException(106);
                }
            }
            catch (Throwable throwable) {
                Exception exception32222;
                Object var23_26 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException exception32222) {
                        // empty catch block
                    }
                }
                try {
                    posArgArray[0] = new PosArg("printMode", 1);
                    this.posDevice.ioctl(305, posArgArray);
                }
                catch (PosException exception32222) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void doDirectIODownloadNonPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        if (directIOFontInfo.station == 2) {
            if (directIOFontInfo.fontNumber < 1 || directIOFontInfo.fontNumber > 4) {
                throw new JposException(106);
            }
        } else if (directIOFontInfo.station == 4) {
            if (directIOFontInfo.fontNumber < 1 || directIOFontInfo.fontNumber > 2) {
                throw new JposException(106);
            }
        } else {
            throw new JposException(106);
        }
        this.setNonPropFont(directIOFontInfo.fontNumber, directIOFontInfo.station, directIOFontInfo.fileName);
    }

    void doMICRPresent(Object object) throws JposException {
        boolean[] blArray = null;
        try {
            blArray = (boolean[])object;
            PosArg[] posArgArray = new PosArg[]{new PosArg("printStatus", 0)};
            this.posDevice.ioctl(302, posArgArray);
            int n = (Integer)posArgArray[0].getValue();
            blArray[0] = (n & 0x2000) == 8192;
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111, posException.getMessage(), posException);
        }
        catch (Exception exception) {
            throw new JposException(106, exception.getMessage(), exception);
        }
    }

    /*
     * Loose catch block
     */
    private void setNonPropFont(int n, int n2, String string) throws JposException {
        block22: {
            Exception exception2222;
            PosArg[] posArgArray;
            FileInputStream fileInputStream;
            block21: {
                String string2;
                fileInputStream = null;
                DirectIOPrintRawModeInfo directIOPrintRawModeInfo = new DirectIOPrintRawModeInfo(n2, null, true);
                posArgArray = new PosArg[]{new PosArg("printMode", 159)};
                byte[] byArray = new byte[100];
                PosArg[] posArgArray2 = new PosArg[]{new PosArg("rawPrintStatus", byArray)};
                fileInputStream = new FileInputStream(string);
                byte[] byArray2 = new byte[42];
                fileInputStream.read(byArray2);
                String string3 = new String(byArray2, 0, 23);
                if (!string3.equals(FONT_NON_PROP_FILE_TAG)) {
                    throw new JposException(106);
                }
                if (byArray2[24] != 1) {
                    throw new JposException(106);
                }
                if (byArray2[28] == 0 && n2 != 2) {
                    throw new JposException(106);
                }
                if (byArray2[28] == 1 && n2 != 4) {
                    throw new JposException(106);
                }
                byte by = byArray2[30];
                byte by2 = byArray2[32];
                byte by3 = byArray2[34];
                byte by4 = byArray2[38];
                directIOPrintRawModeInfo.command = string2 = this.getMCTValueCommand(n, n2, by3, by4);
                this.doPrintInRawMode(directIOPrintRawModeInfo);
                int n3 = this.byteToInt(by);
                int n4 = this.byteToInt(by2);
                if (n4 > 127) {
                    n4 = 127;
                }
                int n5 = n2 == 2 ? by4 * 2 : by3 * 2;
                byte[] byArray3 = new byte[n5 + 5];
                while (n3 <= n4) {
                    this.getDownloadFontCommand(n, n2, n3, n3, byArray3);
                    fileInputStream.read(byArray3, 5, n5);
                    this.posDevice.ioctl(305, posArgArray);
                    this.posDevice.write(byArray3, byArray3.length);
                    ++n3;
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.posDevice.ioctl(302, posArgArray2);
                    if ((((byte[])posArgArray2[0].getValue())[6] & 8) == 0) continue;
                    throw new JposException(110);
                }
                Object var22_24 = null;
                if (fileInputStream == null) break block21;
                try {
                    fileInputStream.close();
                }
                catch (IOException exception2222) {
                    // empty catch block
                }
            }
            try {
                posArgArray[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, posArgArray);
            }
            catch (PosException exception2222) {}
            break block22;
            {
                catch (PosException posException) {
                    throw new JposException(106);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new JposException(109);
                }
                catch (IOException iOException) {
                    throw new JposException(106);
                }
            }
            catch (Throwable throwable) {
                Exception exception32222;
                Object var22_25 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException exception32222) {
                        // empty catch block
                    }
                }
                try {
                    posArgArray[0] = new PosArg("printMode", 1);
                    this.posDevice.ioctl(305, posArgArray);
                }
                catch (PosException exception32222) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void doDirectIOHeadMovement(int n) throws JposException {
        if (n < 0 || n > 3) {
            throw new JposException(106);
        }
        String string = "\u001b<" + (char)n;
        DirectIOPrintRawModeInfo directIOPrintRawModeInfo = new DirectIOPrintRawModeInfo(4, string, false);
        this.doPrintInRawMode(directIOPrintRawModeInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMCTValueCommand(int n, int n2, int n3, int n4) throws JposException {
        StringBuffer stringBuffer;
        block9: {
            block8: {
                stringBuffer = new StringBuffer(5);
                stringBuffer.append("\u001bM");
                if (n2 != 2) break block8;
                switch (n) {
                    case 1: {
                        stringBuffer.append('\u0002');
                        break block9;
                    }
                    case 2: {
                        stringBuffer.append('\u0003');
                        break block9;
                    }
                    case 3: {
                        stringBuffer.append('\u0017');
                        break block9;
                    }
                    case 4: {
                        stringBuffer.append('\u0018');
                        break block9;
                    }
                    default: {
                        throw new JposException(106);
                    }
                }
            }
            if (n2 != 4) throw new JposException(106);
            if (n == 1) {
                stringBuffer.append('\u0004');
            } else {
                if (n != 2) throw new JposException(106);
                stringBuffer.append('\u0005');
            }
        }
        stringBuffer.append((char)n3);
        stringBuffer.append((char)n4);
        return stringBuffer.toString();
    }

    private byte[] getDownloadFontCommand(int n, int n2, int n3, int n4, byte[] byArray) throws JposException {
        byArray[0] = 27;
        byArray[1] = 38;
        if (n2 == 2) {
            byArray[2] = (byte)n;
        } else if (n2 == 4) {
            byArray[2] = (byte)(n + 4);
        } else {
            throw new JposException(106);
        }
        byArray[3] = (byte)n3;
        byArray[4] = (byte)n4;
        return byArray;
    }

    void doSelectResidentCharacterSet() throws JposException {
        try {
            DirectIOPrintRawModeInfo directIOPrintRawModeInfo = new DirectIOPrintRawModeInfo(this.getCurrentStation(), SELECT_RESIDENT_CHARACTER_SET_COMMAND, false);
            this.doPrintInRawMode(directIOPrintRawModeInfo);
        }
        catch (PosException posException) {
            throw new JposException(111);
        }
    }

    void doSelectUserDefinedCharacterSet() throws JposException {
        try {
            DirectIOPrintRawModeInfo directIOPrintRawModeInfo = new DirectIOPrintRawModeInfo(this.getCurrentStation(), SELECT_USER_DEFINED_CHARACTER_SET_COMMAND, false);
            this.doPrintInRawMode(directIOPrintRawModeInfo);
        }
        catch (PosException posException) {
            throw new JposException(111);
        }
    }

    void doSelectCodePage(int n) throws JposException {
        try {
            StringBuffer stringBuffer = new StringBuffer("\u001b!");
            stringBuffer.append((char)n);
            DirectIOPrintRawModeInfo directIOPrintRawModeInfo = new DirectIOPrintRawModeInfo(this.getCurrentStation(), stringBuffer.toString(), false);
            this.doPrintInRawMode(directIOPrintRawModeInfo);
        }
        catch (PosException posException) {
            throw new JposException(111);
        }
    }

    void doEraseUserDefinedCharacterSet(int n) throws JposException {
        String string;
        if (n == 2) {
            string = "\u001b#\u0004";
        } else if (n == 4) {
            string = "\u001b#\u0003";
        } else {
            throw new JposException(106);
        }
        DirectIOPrintRawModeInfo directIOPrintRawModeInfo = new DirectIOPrintRawModeInfo(n, string, true);
        this.doPrintInRawMode(directIOPrintRawModeInfo);
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        directIOPrintRawModeInfo.command = "";
        directIOPrintRawModeInfo.keepRawMode = false;
        this.doPrintInRawMode(directIOPrintRawModeInfo);
    }

    void doPrintInRawMode(DirectIOPrintRawModeInfo directIOPrintRawModeInfo) throws JposException {
        block4: {
            int n = this.getPosNprintStation(directIOPrintRawModeInfo.station);
            PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", n), new PosArg("printMode", 159)};
            try {
                if (n == 4) {
                    this.posDevice.ioctl(4902);
                }
                this.posDevice.ioctl(305, posArgArray);
                this.posDevice.write(directIOPrintRawModeInfo.command);
                if (!directIOPrintRawModeInfo.keepRawMode) {
                    posArgArray[0] = new PosArg("printMode", 1);
                    this.posDevice.ioctl(305, posArgArray, 1);
                }
            }
            catch (PosException posException) {
                int n2 = posException.getErrorCode();
                if (n2 == 0) break block4;
                throw new JposException(111);
            }
        }
    }

    void doPrinterRead(DirectIOPrinterRead directIOPrinterRead) throws JposException {
        try {
            int n;
            PosArg[] posArgArray = new PosArg[]{new PosArg("printMode", 159)};
            this.posDevice.ioctl(305, posArgArray);
            this.posDevice.write(directIOPrinterRead.writeCommand);
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            directIOPrinterRead.length = n = this.posDevice.read(directIOPrinterRead.buffer);
            posArgArray[0] = new PosArg("printMode", 1);
            this.posDevice.ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111);
        }
    }

    int getMaxMicronsPerFeed() {
        return 30000;
    }

    private String convertToHexString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            string = string + Integer.toHexString(byArray[n]) + ", ";
            ++n;
        }
        return string;
    }

    private int byteToInt(byte n) {
        int n2 = n < 0 ? 256 + n : n;
        return n2;
    }

    private void debugPrint(String string) {
        if (jdiagDebug != null && jdiagDebug.equalsIgnoreCase("ON")) {
            System.out.print(string);
        }
    }

    private void debugPrintln(String string) {
        this.debugPrint(string + "\n");
    }

    public void changePrintSide(int n) throws JposException {
        this.doDirectIOFlipCheck();
    }
}

