/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.BeginInsertionData;
import com.ibm.jpos.services.ibmprinter.BeginRemovalData;
import com.ibm.jpos.services.ibmprinter.CutPaperData;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOData;
import com.ibm.jpos.services.ibmprinter.EndInsertionData;
import com.ibm.jpos.services.ibmprinter.EndRemovalData;
import com.ibm.jpos.services.ibmprinter.MapModeCalculator;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtilImplementor;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrintGetDirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.PrintImmediateData;
import com.ibm.jpos.services.ibmprinter.PrintNormalData;
import com.ibm.jpos.services.ibmprinter.PrintNormalDataVector;
import com.ibm.jpos.services.ibmprinter.PrintQueueData;
import com.ibm.jpos.services.ibmprinter.PrintQueueElement;
import com.ibm.jpos.services.ibmprinter.PrintQueueManager;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerCallback;
import com.ibm.jpos.services.ibmprinter.PrintTwoNormalData;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.ibmprinter.SetCharacterSetData;
import com.ibm.jpos.services.ibmprinter.SetLogoData;
import com.ibm.jpos.services.ibmprinter.TransactionPrintData;
import com.ibm.jpos.services.ibmprinter.ValidateDataData;
import com.ibm.jpos.services.jcomm.Serial4610Device;
import com.ibm.jpos.services.jcomm.Serial4610DeviceServiceImp;
import com.ibm.jpos.services.jcomm.Serial4610PrintDataCompiler;
import com.ibm.jpos.services.jcomm.Serial4610PrintImmediateData;
import com.ibm.jpos.services.jcomm.Serial4610PrintNormalData;
import com.ibm.jpos.services.jcomm.Serial4610PrintTwoNormalData;
import com.ibm.jpos.services.jcomm.Serial4610PrnChaseCompleteListener;
import com.ibm.jpos.services.jcomm.Serial4610PrnPrinterErrorListener;
import com.ibm.jpos.services.jcomm.Serial4610PrnStatusChangeListener;
import com.ibm.jpos.util.BooleanMonitor;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.Debug;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import com.ibm.poss.Printer;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public abstract class Serial4610POSPrinterServiceImp
extends Serial4610DeviceServiceImp
implements POSPrinterServiceImp,
PosDef,
Printer,
POSPrinterConst,
PrintBitmapUtilImplementor,
PrintQueueManagerCallback {
    private static final boolean debug = true;
    MapModeCalculator mapModeCalc = new MapModeCalculator();
    protected Serial4610Device serial4610Device = this.getSerial4610Device();
    POSPrinterListener printerListener = new POSPrinterListener();
    protected static Debug debugPrintBitmap = new Debug(false);
    private static final String className = "Serial4610POSPrinterServiceImp";
    protected EventCallbacks eventCallbacks = null;
    protected Object eventSource = null;
    protected POSPrinterServiceState serviceState = null;
    protected PrintBitmapUtil printBitmapUtil = null;
    protected boolean useChase = true;
    protected boolean keepInRawMode = false;
    protected BooleanMonitor documentInserted = null;
    protected BooleanMonitor documentRegistered = null;
    protected BooleanMonitor chaseCompleted = null;
    protected EventQueueManager eventQueueManager = null;
    protected PrintQueueManager printQueueManager = null;
    private PrintingMode[] printingModes = null;
    protected int selectedStations = 2;
    protected int printerErrorCause = 0;
    private BooleanMonitor commandComplete = new BooleanMonitor(false);
    private BooleanMonitor bufferEmpty = new BooleanMonitor(false);

    protected Serial4610POSPrinterServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor", "Entry");
        try {
            this.serial4610Device.addSerial4610PrnChaseCompleteListener(this.printerListener);
            this.serial4610Device.addSerial4610PrnPrinterErrorListener(this.printerListener);
            this.serial4610Device.addSerial4610PrnStatusChangeListener(this.printerListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new JposException(111, "Internal error: caught TooManyListenersException", tooManyListenersException);
        }
        Tracer.trace(4, className, "Constructor", "Exit");
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        Tracer.trace(4, className, "deleteImp()", "Entry");
        this.serial4610Device.removeSerial4610PrnChaseCompleteListener();
        this.serial4610Device.removeSerial4610PrnPrinterErrorListener();
        this.serial4610Device.removeSerial4610PrnStatusChangeListener();
        Tracer.trace(4, className, "deleteImp()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            this.eventCallbacks = eventCallbacks;
            this.eventSource = this.eventCallbacks.getEventSource();
            this.serviceState = (POSPrinterServiceState)this.getDeviceServiceState();
            this.printBitmapUtil = new PrintBitmapUtil(this.getDeviceServiceAbstraction(), this);
            this.useChase = true;
            this.keepInRawMode = false;
            this.documentInserted = new BooleanMonitor(false);
            this.documentRegistered = new BooleanMonitor(false);
            this.chaseCompleted = new BooleanMonitor(false);
            this.setupCodePages();
            this.processDynamicCapabilities();
            Tracer.trace(4, className, "open()", "Exit");
        }
    }

    public void claim(int n) throws JposException {
        Tracer.trace(4, className, "claim(" + n + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            super.claim(n);
            this.eventQueueManager = this.getDeviceServiceAbstraction().getEventQueueManager();
            this.printQueueManager = new PrintQueueManager(this.serviceState, this.eventQueueManager, this.eventCallbacks.getEventSource(), this);
            this.printingModes = new PrintingMode[5];
            this.printingModes[1] = new PrintingMode(1);
            this.printingModes[2] = new PrintingMode(2);
            this.printingModes[4] = new PrintingMode(4);
            Tracer.trace(4, className, "claim()", "Exit");
        }
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Tracer.trace(4, className, "setDeviceEnabled(" + bl + ")", "Entry");
        super.setDeviceEnabled(bl);
        if (bl) {
            this.selectedStations = 2;
            this.printerErrorCause = 0;
            this.serviceState.setSlpEmpty(true);
            this.queryPrinterStatus(true);
            this.setCharacterSet(this.serviceState.getCharacterSet());
            this.setJrnLineSpacing(this.serviceState.getJrnLineSpacing());
            this.getPrintingMode(1).setPosNlineFeed(this.calculatePosNlineFeedSJ());
            this.setRecLineSpacing(this.serviceState.getRecLineSpacing());
            this.getPrintingMode(2).setPosNlineFeed(this.calculatePosNlineFeedCR());
            this.setSlpLineSpacing(this.serviceState.getSlpLineSpacing());
            this.getPrintingMode(4).setPosNlineFeed(this.calculatePosNlineFeedDI());
        }
        this.clearOutput();
        Tracer.trace(4, className, "setDeviceEnabled()", "Exit");
    }

    private void setupCodePages() throws JposException {
        int n = -1;
        int n2 = -1;
        try {
            n = this.serial4610Device.getDefaultCodePage();
            n2 = ByteEncoder.getCharacterSet(n);
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(this.serviceState.getCharacterSetList(), ",");
            while (stringTokenizer.hasMoreElements()) {
                if (!stringTokenizer.nextToken().equals(Integer.toString(n2))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.serviceState.setCharacterSetList(this.serviceState.getCharacterSetList() + "," + n2);
            }
            this.serviceState.setCharacterSet(n2);
            this.serviceState.setCapCharacterSet(ByteEncoder.getCapCharacterSet(n2));
            PrinterFont[] printerFontArray = this.getPrinterFonts();
            int n3 = 1000;
            int n4 = 1000;
            int n5 = 1000;
            String string = "";
            String string2 = "";
            String string3 = "";
            int n6 = 0;
            while (n6 < printerFontArray.length) {
                switch (printerFontArray[n6].station) {
                    case 1: {
                        if (string.length() > 0) {
                            string = string + ",";
                        }
                        string = string + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n3) break;
                        n3 = printerFontArray[n6].lineChars;
                        break;
                    }
                    case 2: {
                        if (string2.length() > 0) {
                            string2 = string2 + ",";
                        }
                        string2 = string2 + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n4) break;
                        n4 = printerFontArray[n6].lineChars;
                        break;
                    }
                    case 4: {
                        if (string3.length() > 0) {
                            string3 = string3 + ",";
                        }
                        string3 = string3 + printerFontArray[n6].lineChars;
                        if (printerFontArray[n6].lineChars >= n5) break;
                        n5 = printerFontArray[n6].lineChars;
                    }
                }
                ++n6;
            }
            if (this.serviceState.getCapSlpPresent()) {
                this.serviceState.setSlpLineCharsList(string3);
            }
            if (this.serviceState.getCapRecPresent()) {
                this.serviceState.setRecLineCharsList(string2);
            }
            if (this.serviceState.getCapJrnPresent()) {
                this.serviceState.setJrnLineCharsList(string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JposException(111, "JPOS_E_FAILURE: Unsupported code page: " + n);
        }
    }

    public void beginInsertion(int n) throws JposException {
        Tracer.trace(4, className, "beginInsertion(" + n + ")", "Entry");
        this.printQueueManager.post(new BeginInsertionData(n));
        Tracer.trace(4, className, "beginInsertion()", "Exit");
    }

    public void processBeginInsertion(BeginInsertionData beginInsertionData) throws JposException {
        Tracer.trace(4, className, "processBeginInsertion()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (beginInsertionData.getTimeout() != 0) {
                this.documentInserted.waitForTrue(beginInsertionData.getTimeout());
            }
            Tracer.trace(4, className, "processBeginInsertion()", "Exit");
        }
    }

    public void beginRemoval(int n) throws JposException {
        Tracer.trace(4, className, "beginRemoval(" + n + ")", "Entry");
        this.printQueueManager.post(new BeginRemovalData(n));
        Tracer.trace(4, className, "beginRemoval()", "Exit");
    }

    public void processBeginRemoval(BeginRemovalData beginRemovalData) throws JposException {
        Tracer.trace(4, className, "processBeginRemoval()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            this.checkStations(4);
            if (this.documentRegistered.isTrue()) {
                this.selectStations(4);
                this.serial4610Device.write(new byte[]{27, 109});
            }
            if (beginRemovalData.getTimeout() != 0) {
                this.documentInserted.waitForFalse(beginRemovalData.getTimeout());
            }
            Tracer.trace(4, className, "processBeginRemoval()", "Exit");
        }
    }

    public void clearOutput() throws JposException {
        Tracer.trace(4, className, "clearOutput()", "Entry");
        this.printQueueManager.clearOutput();
        this.chaseCompleted.forceTimeout();
        this.documentInserted.forceTimeout();
        this.documentRegistered.forceTimeout();
        this.getPrintingMode(2).setRotation(1);
        this.getPrintingMode(4).setRotation(1);
        this.getPrintingMode(1).clearTransaction();
        this.getPrintingMode(1).clearSideways();
        this.getPrintingMode(2).clearTransaction();
        this.getPrintingMode(2).clearSideways();
        this.getPrintingMode(4).clearTransaction();
        this.getPrintingMode(4).clearSideways();
        this.eventQueueManager.removeAllErrorEvent();
        Tracer.trace(4, className, "clearOutput()", "Exit");
    }

    public void cutPaper(int n) throws JposException {
        Tracer.trace(4, className, "cutPaper(" + n + ")", "Entry");
        if (this.printQueueManager.getPostingRotation(2) != 1) {
            throw new JposException(106);
        }
        this.printQueueManager.post(new CutPaperData(n, this.serviceState.getAsyncMode()));
        Tracer.trace(4, className, "cutPaper()", "Exit");
    }

    public void processCutPaper(CutPaperData cutPaperData) throws JposException {
        Tracer.trace(4, className, "processCutPaper()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            PrintingMode printingMode = this.getPrintingMode(2);
            this.checkStations(2);
            try {
                if (!printingMode.isTransaction()) {
                    this.selectStations(2);
                }
                this.serial4610Device.write(new byte[]{27, 109});
                if (!printingMode.isTransaction()) {
                    this.chase();
                }
            }
            catch (Exception exception) {
                printingMode.clearTransaction();
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processCutPaper()", "Exit");
        }
    }

    public void endInsertion() throws JposException {
        Tracer.trace(4, className, "endInsertion()", "Entry");
        this.printQueueManager.post(new EndInsertionData());
        Tracer.trace(4, className, "endInsertion()", "Entry");
    }

    public void processEndInsertion(EndInsertionData endInsertionData) throws JposException {
        Tracer.trace(4, className, "processEndInsertion()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (this.documentInserted.isFalse()) {
                throw new JposException(114, 204);
            }
            this.checkStations(4);
            this.selectStations(4);
            if (this.documentRegistered.isFalse()) {
                try {
                    this.serial4610Device.write(new byte[]{27, 60, 5});
                    this.documentRegistered.waitForTrue(3000);
                }
                catch (JposException jposException) {
                    this.checkPrinterErrorCause(endInsertionData);
                    throw new JposException(111);
                }
            }
            Tracer.trace(4, className, "processEndInsertion()", "Exit");
        }
    }

    public void endRemoval() throws JposException {
        Tracer.trace(4, className, "endRemoval()", "Entry");
        this.printQueueManager.post(new EndRemovalData());
        Tracer.trace(4, className, "endRemoval()", "Exit");
    }

    public void processEndRemoval(EndRemovalData endRemovalData) throws JposException {
        Tracer.trace(4, className, "processEndRemoval()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            if (this.documentInserted.isTrue()) {
                throw new JposException(114, 205);
            }
            this.selectStations(2);
            Tracer.trace(4, className, "processEndRemoval()", "Exit");
        }
    }

    public void printBarCode(int n, String string, int n2, int n3, int n4, int n5, int n6) throws JposException {
        Tracer.trace(4, className, "PrintBarCode()", "Entry");
        if (this.printQueueManager.getPostingRotation(n) != 1) {
            throw new JposException(106);
        }
        switch (n2) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 201: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal symbology: " + n2);
            }
        }
        switch (n5) {
            case -3: 
            case -2: 
            case -1: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal alignment: " + n5);
            }
        }
        switch (n6) {
            case -13: 
            case -12: 
            case -11: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal textPosition: " + n6);
            }
        }
        this.printQueueManager.post(new PrintBarCodeData(n, string, n2, n3, n4, n5, n6, this.serviceState.getAsyncMode()));
        Tracer.trace(4, className, "PrintBarCode()", "Exit");
    }

    public void printBitmap(int n, String string, int n2, int n3) throws JposException {
        Tracer.trace(4, className, "printBitmap(" + n + ", " + string + ", " + n2 + ", " + n3 + ")", "Entry");
        if (this.printQueueManager.getPostingRotation(n) != 1) {
            throw new JposException(106);
        }
        int n4 = this.calcStationWidth(n);
        if (n2 != -11 && n2 > n4) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1) {
            n4 = this.convertToDots(n4, n);
            if (n2 != -11) {
                n2 = this.convertToDots(n2, n);
            }
        }
        PrintBitmapData printBitmapData = new PrintBitmapData(n, string, n2, n3, this.serviceState.getAsyncMode(), null);
        this.printBitmapUtil.validateBitmap(printBitmapData, 2, n4);
        this.printQueueManager.post(printBitmapData);
        Tracer.trace(4, className, "printBitmap()", "Exit");
    }

    public void processPrintBitmap(PrintBitmapData printBitmapData) throws JposException {
        Tracer.trace(4, className, "processPrintBitmap()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n = printBitmapData.getStation();
            PrintingMode printingMode = this.getPrintingMode(n);
            this.checkStations(n);
            try {
                if (!printingMode.isTransaction()) {
                    this.selectStations(n);
                }
                this.doPrinting(printBitmapData.getStation(), printBitmapData.getBitmapStream(), printBitmapData.getAlignment(), 2);
                if (!printingMode.isTransaction()) {
                    this.chase();
                }
            }
            catch (Exception exception) {
                printingMode.clearTransaction();
                this.checkPrinterErrorCause(printBitmapData);
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processPrintBitmap()", "Exit");
        }
    }

    public void printNormal(int n, String string) throws JposException {
        Tracer.trace(4, className, "printNormal()", "Entry");
        byte[] byArray = null;
        Serial4610PrintDataCompiler serial4610PrintDataCompiler = (Serial4610PrintDataCompiler)this.getPrintDataCompiler();
        PrintingMode printingMode = this.getPrintingMode(n);
        if (!printingMode.isTransaction()) {
            byArray = serial4610PrintDataCompiler.compile(n, string, this.printQueueManager.getPostingRotation(n), this.printBitmapUtil, this.getPrinterFonts());
        }
        this.printQueueManager.post(new Serial4610PrintNormalData(n, string, this.serviceState.getAsyncMode(), serial4610PrintDataCompiler.hasReversedLines(), this.printQueueManager.getPostingRotation(n), byArray, serial4610PrintDataCompiler.getSelectedPrinterFont()));
        Tracer.trace(4, className, "printNormal()", "Exit");
    }

    public void processPrintNormalDataVector(PrintNormalDataVector printNormalDataVector) throws JposException {
        Tracer.trace(4, className, "processPrintNormalDataVector()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            Serial4610PrintNormalData serial4610PrintNormalData;
            byte[] byArray;
            PrintQueueData printQueueData = null;
            StringBuffer stringBuffer = new StringBuffer("");
            Serial4610PrintDataCompiler serial4610PrintDataCompiler = (Serial4610PrintDataCompiler)this.getPrintDataCompiler();
            int n = 0;
            while (n < printNormalDataVector.size()) {
                printQueueData = (Serial4610PrintNormalData)printNormalDataVector.elementAt(n);
                if (stringBuffer.length() + ((PrintNormalData)printQueueData).getData().length() + 100 > this.getMaxBytesPerWrite(printQueueData.getStation())) {
                    byArray = serial4610PrintDataCompiler.compile(printQueueData.getStation(), stringBuffer.toString(), ((Serial4610PrintNormalData)printQueueData).getRotation(), this.printBitmapUtil, this.getPrinterFonts());
                    serial4610PrintNormalData = new Serial4610PrintNormalData(printQueueData.getStation(), "", printQueueData.isAsyncMode(), printQueueData.hasReversedLines(), ((Serial4610PrintNormalData)printQueueData).getRotation(), byArray, ((Serial4610PrintNormalData)printQueueData).getPrinterFont());
                    this.processPrintNormal(serial4610PrintNormalData);
                    stringBuffer = new StringBuffer("");
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\u001b|N");
                }
                stringBuffer.append(((PrintNormalData)printQueueData).getData());
                ++n;
            }
            byArray = serial4610PrintDataCompiler.compile(printQueueData.getStation(), stringBuffer.toString(), ((Serial4610PrintNormalData)printQueueData).getRotation(), this.printBitmapUtil, this.getPrinterFonts());
            serial4610PrintNormalData = new Serial4610PrintNormalData(printQueueData.getStation(), "", printQueueData.isAsyncMode(), printQueueData.hasReversedLines(), ((Serial4610PrintNormalData)printQueueData).getRotation(), byArray, ((Serial4610PrintNormalData)printQueueData).getPrinterFont());
            this.processPrintNormal(serial4610PrintNormalData);
            Tracer.trace(4, className, "processPrintNormalDataVector()", "Exit");
        }
    }

    public void processPrintNormal(PrintNormalData printNormalData) throws JposException {
        Tracer.trace(4, className, "processPrintNormal()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            Serial4610PrintNormalData serial4610PrintNormalData = (Serial4610PrintNormalData)printNormalData;
            int n = serial4610PrintNormalData.getStation();
            PrintingMode printingMode = this.getPrintingMode(n);
            Tracer.trace(4, className, "processPrintNormal()", "data: \n   " + printNormalData.getData() + "\n" + PrintDataCompiler.getByteDump(serial4610PrintNormalData.getCompiledData()));
            try {
                this.checkStations(n);
                if (n == 4 && this.documentInserted.isFalse()) {
                    throw new JposException(114, 204);
                }
                if (!printingMode.isTransaction() && !printingMode.isSideways()) {
                    this.selectStations(n);
                }
                Tracer.trace(4, className, "processPrintNormal()", "writing data");
                this.serial4610Device.write(serial4610PrintNormalData.getCompiledData());
                Tracer.trace(4, className, "processPrintNormal()", "done writing");
                if (!printingMode.isTransaction() && !printingMode.isSideways()) {
                    Tracer.trace(4, className, "processPrintNormal()", "waiting on chase");
                    this.chase();
                    Tracer.trace(4, className, "processPrintNormal()", "chase complete");
                }
            }
            catch (Exception exception) {
                if (printingMode.isSideways()) {
                    printingMode.setRotation(1);
                }
                printingMode.clearTransaction();
                printingMode.clearSideways();
                this.checkPrinterErrorCause(printNormalData);
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processPrintNormal()", "Exit");
        }
    }

    public void printImmediate(int n, String string) throws JposException {
        Tracer.trace(4, className, "printImmediate()", "Entry");
        int n2 = this.printQueueManager.getPostingRotation(n) == 259 ? 259 : 1;
        Serial4610PrintDataCompiler serial4610PrintDataCompiler = (Serial4610PrintDataCompiler)this.getPrintDataCompiler();
        byte[] byArray = serial4610PrintDataCompiler.compile(n, string, n2, this.printBitmapUtil, this.getPrinterFonts());
        this.printQueueManager.post(new Serial4610PrintImmediateData(n, string, this.serviceState.getAsyncMode(), byArray, serial4610PrintDataCompiler.getSelectedPrinterFont()));
        Tracer.trace(4, className, "printImmediate()", "Exit");
    }

    public void processPrintImmediate(PrintImmediateData printImmediateData) throws JposException {
        Tracer.trace(4, className, "processPrintImmediate()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            Serial4610PrintImmediateData serial4610PrintImmediateData = (Serial4610PrintImmediateData)printImmediateData;
            try {
                this.checkStations(serial4610PrintImmediateData.getStation());
                if (serial4610PrintImmediateData.getStation() == 4 && this.documentInserted.is(false)) {
                    throw new JposException(114, 204);
                }
                this.selectStations(serial4610PrintImmediateData.getStation());
                this.serial4610Device.write(serial4610PrintImmediateData.getCompiledData());
                this.chase();
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause(printImmediateData);
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processPrintImmediate()", "Exit");
        }
    }

    public void printTwoNormal(int n, String string, String string2) throws JposException {
        PrinterFont printerFont;
        byte[] byArray;
        PrinterFont printerFont2;
        byte[] byArray2;
        int n2;
        int n3;
        Tracer.trace(4, className, "printTwoNormal()", "Entry");
        if (string2.length() == 0) {
            string2 = string;
        }
        Serial4610PrintDataCompiler serial4610PrintDataCompiler = (Serial4610PrintDataCompiler)this.getPrintDataCompiler();
        switch (n) {
            case 3: 
            case 32771: {
                if (!this.serviceState.getCapConcurrentJrnRec()) {
                    throw new JposException(106);
                }
                n3 = 2;
                n2 = 1;
                byArray2 = serial4610PrintDataCompiler.compile(n3, string, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont2 = serial4610PrintDataCompiler.getSelectedPrinterFont();
                byArray = serial4610PrintDataCompiler.compile(n2, string2, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont = serial4610PrintDataCompiler.getSelectedPrinterFont();
                break;
            }
            case 5: 
            case 32773: {
                if (!this.serviceState.getCapConcurrentJrnSlp()) {
                    throw new JposException(106);
                }
                n3 = 4;
                n2 = 1;
                byArray2 = serial4610PrintDataCompiler.compile(n3, string, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont2 = serial4610PrintDataCompiler.getSelectedPrinterFont();
                byArray = serial4610PrintDataCompiler.compile(n2, string2, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont = serial4610PrintDataCompiler.getSelectedPrinterFont();
                break;
            }
            case 6: 
            case 32774: {
                if (!this.serviceState.getCapConcurrentRecSlp()) {
                    throw new JposException(106);
                }
                n3 = 4;
                n2 = 2;
                byArray2 = serial4610PrintDataCompiler.compile(n3, string, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont2 = serial4610PrintDataCompiler.getSelectedPrinterFont();
                byArray = serial4610PrintDataCompiler.compile(n2, string2, 1, this.printBitmapUtil, this.getPrinterFonts());
                printerFont = serial4610PrintDataCompiler.getSelectedPrinterFont();
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        this.printQueueManager.post(new Serial4610PrintTwoNormalData(n, string, string2, this.serviceState.getAsyncMode(), n3, n2, byArray2, byArray, printerFont2, printerFont));
        Tracer.trace(4, className, "printTwoNormal()", "Exit");
    }

    public void processPrintTwoNormal(PrintTwoNormalData printTwoNormalData) throws JposException {
        Tracer.trace(4, className, "processPrintTwoNormal()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            Serial4610PrintTwoNormalData serial4610PrintTwoNormalData = (Serial4610PrintTwoNormalData)printTwoNormalData;
            int n = serial4610PrintTwoNormalData.getStations();
            PrintingMode printingMode = this.getPrintingMode(serial4610PrintTwoNormalData.getStation1());
            PrintingMode printingMode2 = this.getPrintingMode(serial4610PrintTwoNormalData.getStation2());
            this.checkStations(n);
            if (printingMode.isTransaction() || printingMode.isSideways() || printingMode2.isTransaction() || printingMode2.isSideways()) {
                throw new JposException(106);
            }
            try {
                if ((n == 32773 || n == 5 || n == 32774 || n == 6) && this.documentInserted.isFalse()) {
                    throw new JposException(114, 204);
                }
                this.selectStations(serial4610PrintTwoNormalData.getStation1());
                this.serial4610Device.write(serial4610PrintTwoNormalData.getCompiledData1());
                this.chase();
                this.selectStations(serial4610PrintTwoNormalData.getStation2());
                this.serial4610Device.write(serial4610PrintTwoNormalData.getCompiledData2());
                this.chase();
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause(printTwoNormalData);
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processPrintTwoNormal()", "Exit");
        }
    }

    public void rotatePrint(int n, int n2) throws JposException {
        Tracer.trace(4, className, "rotatePrint(" + n + ", " + n2 + ")", "Entry");
        this.printQueueManager.post(new RotatePrintData(n, n2, this.serviceState.getAsyncMode()));
        Tracer.trace(4, className, "rotatePrint()", "Exit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRotatePrint(RotatePrintData rotatePrintData) throws JposException {
        Tracer.trace(4, className, "processRotatePrintData(" + rotatePrintData.getStation() + rotatePrintData.getRotation() + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n = rotatePrintData.getStation();
            PrintingMode printingMode = this.getPrintingMode(n);
            int n2 = printingMode.getRotation();
            int n3 = rotatePrintData.getRotation();
            try {
                switch (n3) {
                    case 257: 
                    case 258: {
                        printingMode.setRotation(n3);
                        this.selectStations(n);
                        break;
                    }
                    case 1: 
                    case 259: {
                        switch (n2) {
                            case 257: 
                            case 258: {
                                if (printingMode.isTransaction()) break;
                                this.chase();
                            }
                        }
                        break;
                    }
                }
                printingMode.setRotation(n3);
            }
            catch (Exception exception) {
                printingMode.setRotation(1);
                this.checkPrinterErrorCause(rotatePrintData);
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processRotatePrintData()", "Exit");
            return;
        }
    }

    public void setBitmap(int n, int n2, String string, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "setBitmap(" + n + ", " + n2 + ", " + string + ", " + n3 + ", " + n4 + ")", "Entry");
        int n5 = this.calcStationWidth(n2);
        if (n3 != -11 && n3 > n5) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1 && n3 != -11) {
            n3 = this.convertToDots(n3, n2);
        }
        this.printQueueManager.post(new SetBitmapData(n, n2, string, n3, n4, null));
        Tracer.trace(4, className, "setBitmap()", "Exit");
    }

    public void processSetBitmap(SetBitmapData setBitmapData) throws JposException {
        Tracer.trace(4, className, "processSetBitmapData()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n = setBitmapData.getStation();
            int n2 = this.calcStationWidth(n);
            if (this.serviceState.getMapMode() != 1) {
                n2 = this.convertToDots(n2, n);
            }
            this.printBitmapUtil.validateBitmap(setBitmapData, 16, n2);
            try {
                if (setBitmapData.getFileName() != "") {
                    this.selectStations(n);
                    this.printBitmapUtil.doSetBitmap(setBitmapData);
                    this.chase();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ((Serial4610PrintDataCompiler)this.getPrintDataCompiler()).updateSetBitmapData(setBitmapData);
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause(setBitmapData);
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processSetBitmapData()", "Exit");
        }
    }

    public void setLogo(int n, String string) throws JposException {
        Tracer.trace(4, className, "setLogo(" + n + ", " + string + ")", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            this.getPrintDataCompiler().setLogo(n, string);
            Tracer.trace(4, className, "setLogo(" + n + ", " + string + ")", "Exit");
        }
    }

    public void processSetLogo(SetLogoData setLogoData) {
    }

    public void transactionPrint(int n, int n2) throws JposException {
        this.printQueueManager.post(new TransactionPrintData(n, n2, this.serviceState.getAsyncMode()));
    }

    public void processTransactionPrint(TransactionPrintData transactionPrintData) throws JposException {
        Tracer.trace(4, className, "processTransactionPrint()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n = transactionPrintData.getStation();
            PrintingMode printingMode = this.getPrintingMode(n);
            try {
                switch (transactionPrintData.getControl()) {
                    case 11: {
                        this.checkStations(n);
                        this.selectStations(n);
                        printingMode.beginTransaction();
                        break;
                    }
                    case 12: {
                        printingMode.endTransaction();
                        this.chase();
                    }
                }
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause(transactionPrintData);
                throw this.createJposException(exception);
            }
            Tracer.trace(4, className, "processTransactionPrint()", "Exit");
        }
    }

    public void validateData(int n, String string) throws JposException {
        Tracer.trace(4, className, "validateData(" + n + ", " + string + ")", "Entry");
        this.printQueueManager.post(new ValidateDataData(n, string));
        Tracer.trace(4, className, "validateData()", "Exit");
    }

    public void processValidateData(ValidateDataData validateDataData) throws JposException {
        Tracer.trace(4, className, "processValidateData()", "Entry");
        int n = validateDataData.getStation();
        String string = validateDataData.getData();
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                ((Serial4610PrintDataCompiler)this.getPrintDataCompiler()).validate(n, string, this.printQueueManager.getPostingRotation(n), this.printBitmapUtil, this.getPrinterFonts());
                break;
            }
            default: {
                throw new JposException(106, "JPOS_E_ILLEGAL: Illegal station: " + n);
            }
        }
        Tracer.trace(4, className, "processValidateData()", "Exit");
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        Tracer.trace(4, className, "directIO(" + n + ")", "Entry");
        this.serviceState.isOpenClaimEnable();
        this.printQueueManager.post(new DirectIOData(n, nArray, object));
        Tracer.trace(4, className, "directIO()", "Exit");
    }

    public void processDirectIO(DirectIOData directIOData) throws JposException {
        Tracer.trace(4, className, "processDirectIO()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n = directIOData.getCommand();
            int[] nArray = directIOData.getData();
            Object object2 = directIOData.getObject();
            this.serviceState.isOpenClaimEnable();
            switch (n) {
                case 0: {
                    this.doDirectIOFlipCheck();
                    break;
                }
                case 1: {
                    this.doDirectIODownloadBitmap(nArray[0], (DirectIOBitmapInfo)object2);
                    break;
                }
                case 20: {
                    this.doDirectIOSetStamp((String)object2);
                    break;
                }
                case 2: {
                    this.doDirectIOPrintDownloadedBitmap(nArray[0], (DirectIOBitmapInfo)object2);
                    break;
                }
                case 3: {
                    this.doDirectIODownloadMessage(nArray[0], (String)object2);
                    break;
                }
                case 4: {
                    this.doDirectIOPrintDownloadedMessage(nArray[0]);
                    break;
                }
                case 5: {
                    this.doDirectIOResetPrinter();
                    break;
                }
                case 6: {
                    this.doDirectIOSetChaseMode((Boolean)object2);
                    break;
                }
                case 7: {
                    if (nArray == null || object2 == null) {
                        throw new JposException(106);
                    }
                    this.doDirectIOPrintUnvalidated(nArray[0], (String)object2);
                    break;
                }
                case 21: {
                    this.doReadMCT(nArray);
                    break;
                }
                case 22: {
                    this.doDirectIOGetFontInfo((PrintGetDirectIOFontInfo)object2);
                    break;
                }
                default: {
                    throw new JposException(106);
                }
            }
            Tracer.trace(4, className, "processDirectIO()", "Exit");
        }
    }

    public int getCurrentStation() throws PosException {
        Tracer.trace(4, className, "getCurrentStation()", "Entry");
        int n = -1;
        Tracer.trace(4, className, "getCurrentStation() = " + n, "Exit");
        return n;
    }

    protected void processDynamicCapabilities() throws JposException {
    }

    abstract void doDirectIOFlipCheck() throws JposException;

    abstract void doDirectIOPrintDownloadedBitmap(int var1, DirectIOBitmapInfo var2) throws JposException;

    abstract void doDirectIOPrintDownloadedMessage(int var1) throws JposException;

    void doDirectIODownloadBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
        Tracer.trace(4, className, "doDirectIODownloadBitmap(" + n + ")", "Entry");
        if (n == 0 || n > 40) {
            throw new JposException(106);
        }
        int n2 = directIOBitmapInfo.station;
        int n3 = directIOBitmapInfo.width;
        int n4 = this.calcStationWidth(n2);
        if (n3 != -11 && n3 > n4) {
            throw new JposException(114, 206);
        }
        if (this.serviceState.getMapMode() != 1) {
            n4 = this.convertToDots(n4, n2);
            if (n3 != -11) {
                n3 = this.convertToDots(n3, n2);
            }
        }
        SetBitmapData setBitmapData = new SetBitmapData(n, directIOBitmapInfo.station, directIOBitmapInfo.fileName, directIOBitmapInfo.width, directIOBitmapInfo.alignment, null);
        this.printBitmapUtil.validateBitmap(setBitmapData, 2, n4);
        this.processSetBitmap(setBitmapData);
        Tracer.trace(4, className, "doDirectIODownloadBitmap()", "Exit");
    }

    void doDirectIODownloadMessage(int n, String string) throws JposException {
        Tracer.trace(4, className, "doDirectIODownloadMessage(" + n + ", " + string + ")", "Entry");
        if (n == 0 || n > 25) {
            throw new JposException(106);
        }
        this.printBitmapUtil.doSetLogo(n, string);
        Tracer.trace(4, className, "doDirectIODownloadMessage()", "Exit");
    }

    void doDirectIOResetPrinter() throws JposException {
        Tracer.trace(4, className, "doDirectIOResetPrinter()", "Entry");
        this.serial4610Device.write(new byte[]{16, 5, 64});
        Tracer.trace(4, className, "doDirectIOResetPrinter()", "Exit");
    }

    void doDirectIOSetChaseMode(boolean bl) {
        Tracer.trace(4, className, "doDirectIOSetChaseMode(" + bl + ")", "Entry");
        this.useChase = bl;
        Tracer.trace(4, className, "doDirectIOSetChaseMode()", "Exit");
    }

    void doDirectIOSetStamp(String string) throws JposException {
        throw new JposException(106);
    }

    void doDirectIOPrintUnvalidated(int n, String string) throws JposException {
        Tracer.trace(4, className, "doDirectIOPrintUnvalidated(" + n + ")", "Entry");
        try {
            byte[] byArray = string.getBytes();
            this.selectStations(n);
            this.serial4610Device.write(byArray);
        }
        catch (Exception exception) {
            throw new JposException(111, exception.getMessage(), exception);
        }
        Tracer.trace(4, className, "doDirectIOPrintUnvalidated()", "Exit");
    }

    void doReadMCT(int[] nArray) throws JposException {
        throw new JposException(106);
    }

    void doDirectIOGetFontInfo(PrintGetDirectIOFontInfo printGetDirectIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    public abstract void checkMode(int var1, int var2) throws JposException;

    public void clearBitmaps() throws JposException {
        Tracer.trace(4, className, "clearBitmaps()", "Entry");
        try {
            this.bufferEmpty.waitFor(true, 3000);
            this.commandComplete.set(false);
            this.serial4610Device.write(new byte[]{27, 35, 1});
            this.commandComplete.waitFor(true, 3000);
            this.printBitmapUtil.bitmapIndex = 1;
        }
        catch (Exception exception) {
            throw new JposException(111, exception.getMessage(), exception);
        }
        Tracer.trace(4, className, "clearBitmaps()", "Exit");
    }

    public void doPrinting(int n, byte[] byArray, int n2, int n3) throws JposException {
        int n4;
        int n5 = 0;
        JposException jposException = null;
        Tracer.trace(4, className, "doPrinting(station, bitmap[], align, mode)", "Entry");
        switch (n) {
            case 1: {
                int n6 = 2;
                String string = "lineFeedSJ";
                break;
            }
            case 2: {
                int n6 = 1;
                String string = "lineFeedCR";
                break;
            }
            case 4: {
                int n6 = 4;
                String string = "lineFeedDI";
                break;
            }
            default: {
                throw new JposException(106, "Illegal station for printBitmap");
            }
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.append(27).append(97);
        switch (n2) {
            case -1: {
                n5 = 0;
                byteBuffer.append(0);
                break;
            }
            case -2: {
                n5 = 1;
                byteBuffer.append(1);
                break;
            }
            case -3: {
                n5 = 2;
                byteBuffer.append(2);
            }
        }
        switch (n3) {
            case 2: 
            case 16: {
                n4 = n3;
                break;
            }
            default: {
                throw new JposException(111, "Internal Error: Illegal mode for printBitmap: " + n3);
            }
        }
        try {
            switch (n4) {
                case 16: {
                    this.serial4610Device.write(new byte[]{29, 42});
                    int n7 = byArray[1] & 0xFF;
                    int n8 = byArray[2] & 0xFF;
                    this.serial4610Device.write(byArray, n7 * 8 * n8 + 3);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 2: {
                    int n9;
                    int n10 = this.getLineSpacing(n);
                    int n11 = 1;
                    if (n == 4) {
                        n11 = 3;
                    }
                    if (this.serviceState.getMapMode() != 1) {
                        n9 = this.mapModeCalc.convertFromMapModeToMicrons(1, n11, this.getDotsPerInchHigh(n), this.getMicronsPerStep(n));
                        n11 = this.mapModeCalc.convertFromMicronsToMapMode(this.serviceState.getMapMode(), n9, this.getDotsPerInchHigh(n), this.getMicronsPerStep(n));
                    }
                    this.setLineSpacing(n, n11);
                    this.serial4610Device.write(byteBuffer.getBytes());
                    n9 = byArray[0] & 0xFF;
                    int n12 = byArray[1] & 0xFF;
                    int n13 = byArray[2] & 0xFF;
                    byte[] byArray2 = new byte[n12 * 9 + 1];
                    try {
                        this.chase();
                        this.serial4610Device.write(new byte[]{27, 55});
                        int n14 = 0;
                        while (n14 < n13) {
                            int n15 = n14 * n12 * 8 + 3;
                            int n16 = n15 + n12 * 8;
                            byte[] byArray3 = this.getBitmapHeader(n12, n9);
                            int n17 = 0;
                            while (n17 < byArray3.length) {
                                byArray2[n17] = byArray3[n17];
                                ++n17;
                            }
                            int n18 = n15;
                            while (n18 < n16) {
                                byArray2[n17] = byArray[n18];
                                ++n18;
                                ++n17;
                            }
                            this.serial4610Device.write(byArray2);
                            if (this.requiresLinefeed(n)) {
                                this.sendLinefeed();
                            }
                            ++n14;
                        }
                    }
                    catch (JposException jposException2) {
                        jposException = jposException2;
                    }
                    this.serial4610Device.write(new byte[]{16, 5, 49});
                    this.setLineSpacing(n, n10);
                    this.serial4610Device.write(new byte[]{27, 97, 0});
                    if (jposException == null) break;
                    throw jposException;
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause(new PrintNormalData(0, null, false, false));
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "doPrinting(station, bitmap[], align, mode)", "Exit");
    }

    public abstract void downloadData(int var1, String var2, int var3, int var4) throws JposException;

    public abstract void downloadData(int var1, byte[] var2, int var3, int var4) throws JposException;

    public abstract int getStationMaxBitmapHeight(int var1);

    public abstract short getNextByteForStation(int var1, PrintBitmapImageInfo var2);

    public boolean isSlipReady() throws JposException {
        return this.documentInserted.isTrue();
    }

    public void clearPrinterError() {
        block6: {
            Tracer.trace(4, className, "clearPrinterError()", "Entry");
            try {
                Object object = this.serial4610Device.getIOSemaphore();
                synchronized (object) {
                    if (this.isOnline() && this.printerErrorCause != 0) {
                        this.getPrintDataCompiler().resetCellsBuffered();
                        this.bufferEmpty.set(false);
                        this.serial4610Device.write(new byte[]{16, 5, 50});
                        this.bufferEmpty.waitFor(true, 3000);
                        this.printerErrorCause = 0;
                    }
                }
            }
            catch (Exception exception) {
                Tracer.trace(4, className, "clearPrinterError()", "exception occurred");
                if (Tracer.getTraceLevel() < 3) break block6;
                exception.printStackTrace();
            }
        }
        Tracer.trace(4, className, "clearPrinterError()", "Exit");
    }

    public synchronized void setAsyncMode(boolean bl) throws JposException {
        Tracer.trace(4, className, "setAsncMode(" + bl + ")", "Entry");
        Tracer.trace(4, className, "setAsncMode()", "Exit");
    }

    public void setCharacterSet(int n) throws JposException {
        Tracer.trace(4, className, "setCharacterSet(" + n + ")", "Entry");
        this.printQueueManager.post(new SetCharacterSetData(n));
        Tracer.trace(4, className, "setCharacterSet()", "Exit");
    }

    public void processSetCharacterSet(SetCharacterSetData setCharacterSetData) throws JposException {
        Tracer.trace(4, className, "processSetCharacterSet()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            int n = setCharacterSetData.getCharacterSet();
            try {
                int n2 = n == 998 || n == 999 ? 858 : ByteEncoder.getCodePage(n);
                if (n2 != this.serial4610Device.getCodePage()) {
                    this.serial4610Device.setCodePage(n2);
                }
                this.serviceState.setCapCharacterSet(ByteEncoder.getCapCharacterSet(n));
                this.serviceState.setCharacterSet(n);
                PrinterFont[] printerFontArray = this.getPrinterFonts();
                int n3 = 1000;
                int n4 = 1000;
                int n5 = 1000;
                String string = "";
                String string2 = "";
                String string3 = "";
                int n6 = 0;
                while (n6 < printerFontArray.length) {
                    switch (printerFontArray[n6].station) {
                        case 1: {
                            if (string.length() > 0) {
                                string = string + ",";
                            }
                            string = string + printerFontArray[n6].lineChars;
                            if (printerFontArray[n6].lineChars >= n3) break;
                            n3 = printerFontArray[n6].lineChars;
                            break;
                        }
                        case 2: {
                            if (string2.length() > 0) {
                                string2 = string2 + ",";
                            }
                            string2 = string2 + printerFontArray[n6].lineChars;
                            if (printerFontArray[n6].lineChars >= n5) break;
                            n5 = printerFontArray[n6].lineChars;
                            break;
                        }
                        case 4: {
                            if (string3.length() > 0) {
                                string3 = string3 + ",";
                            }
                            string3 = string3 + printerFontArray[n6].lineChars;
                            if (printerFontArray[n6].lineChars >= n4) break;
                            n4 = printerFontArray[n6].lineChars;
                        }
                    }
                    ++n6;
                }
                if (this.serviceState.getCapRecPresent()) {
                    this.serviceState.setRecLineCharsList(string2);
                }
                if (this.serviceState.getCapSlpPresent()) {
                    this.serviceState.setSlpLineCharsList(string3);
                }
                if (this.serviceState.getCapJrnPresent()) {
                    this.serviceState.setJrnLineCharsList(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new JposException(106, exception.getMessage(), exception);
            }
        }
        Tracer.trace(4, className, "processSetCharacterSet()", "Exit");
    }

    public synchronized void setFlagWhenIdle(boolean bl) throws JposException {
        Tracer.trace(4, className, "setFlagWhenIdle(" + bl + ")", "Entry");
        try {
            if (bl) {
                if (this.serviceState.getState() == 2) {
                    this.serviceState.setFlagWhenIdle(false);
                    this.eventQueueManager.postEvent(new StatusUpdateEvent(this.eventSource, 1001));
                } else {
                    this.serviceState.setFlagWhenIdle(true);
                }
            } else {
                this.serviceState.setFlagWhenIdle(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "setFlagWhenIdle()", "Exit");
    }

    public synchronized void setMapMode(int n) throws JposException {
        int n2;
        int n3;
        int n4;
        int n5;
        Tracer.trace(4, className, "setMapMode(" + n + ")", "Entry");
        int n6 = this.serviceState.getMapMode();
        if (n6 == n) {
            return;
        }
        if (this.serviceState.getCapRecPresent()) {
            n5 = this.serviceState.getRecLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineSpacing(n5);
            n3 = this.serviceState.getRecLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineHeight(n3);
            n2 = this.serviceState.getRecLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(2), this.getMicronsPerStep(2));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(2), this.getMicronsPerStep(2));
            this.serviceState.setRecLineWidth(n2);
        }
        if (this.serviceState.getCapJrnPresent()) {
            n5 = this.serviceState.getJrnLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineSpacing(n5);
            n3 = this.serviceState.getJrnLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineHeight(n3);
            n2 = this.serviceState.getJrnLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(1), this.getMicronsPerStep(1));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(1), this.getMicronsPerStep(1));
            this.serviceState.setJrnLineWidth(n2);
        }
        if (this.serviceState.getCapSlpPresent()) {
            n5 = this.serviceState.getSlpLineSpacing();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n5, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            n5 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineSpacing(n5);
            n3 = this.serviceState.getSlpLineHeight();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            n3 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineHeight(n3);
            n2 = this.serviceState.getSlpLineWidth();
            n4 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, this.getDotsPerInchWide(4), this.getMicronsPerStep(4));
            n2 = this.mapModeCalc.convertFromMicronsToMapMode(n, n4, this.getDotsPerInchWide(4), this.getMicronsPerStep(4));
            this.serviceState.setSlpLineWidth(n2);
        }
        Tracer.trace(4, className, "setMapMode()", "Exit");
    }

    public synchronized void setRotateSpecial(int n) throws JposException {
        Tracer.trace(4, className, "setRotateSpecial(" + n + ")", "Entry");
        Tracer.trace(4, className, "setRotateSpecial()", "Exit");
    }

    public synchronized void setJrnLetterQuality(boolean bl) throws JposException {
        Tracer.trace(4, className, "setJrnLetterQuality(" + bl + ")", "Entry");
        if (bl) {
            throw new JposException(106);
        }
        Tracer.trace(4, className, "setJrnLetterQuality()", "Exit");
    }

    public synchronized void setJrnLineChars(int n) throws JposException {
        Tracer.trace(4, className, "setJrnLineChars(" + n + ")", "Entry");
        this.setStateLineChars(n, 1);
        Tracer.trace(4, className, "setJrnLineChars()", "Exit");
    }

    public synchronized void setJrnLineHeight(int n) throws JposException {
    }

    public synchronized void setJrnLineSpacing(int n) throws JposException {
        Tracer.trace(4, className, "setJrnLineSpacing(" + n + ")", "Entry");
        int n2 = this.setStationLineSpacing(1, n, this.serviceState.getJrnLineSpacing(), "lineFeedSJ");
        this.serviceState.setJrnLineSpacing(n2);
        Tracer.trace(4, className, "setJrnLineSpacing()", "Exit");
    }

    public synchronized void setRecLetterQuality(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106);
        }
    }

    public synchronized void setRecLineChars(int n) throws JposException {
        Tracer.trace(4, className, "setRecLineChars(" + n + ")", "Entry");
        this.setStateLineChars(n, 2);
        Tracer.trace(4, className, "setRecLineChars()", "Exit");
    }

    public synchronized void setRecLineHeight(int n) throws JposException {
    }

    public synchronized void setRecLineSpacing(int n) throws JposException {
        Tracer.trace(4, className, "setRecLineSpacing(" + n + ")", "Entry");
        int n2 = this.serviceState.getMapMode();
        int n3 = this.getDotsPerInchHigh(2);
        int n4 = this.getMicronsPerStep(2);
        int n5 = this.mapModeCalc.convertFromMapModeToMicrons(n2, this.serviceState.getRecLineSpacing(), n3, n4);
        int n6 = this.setStationLineSpacing(2, n, this.serviceState.getRecLineSpacing(), "lineFeedCR");
        if (n6 != this.serviceState.getRecLineSpacing()) {
            this.serviceState.setRecLineSpacing(n6);
            if (n6 == 0) {
                n6 = 1;
            }
            int n7 = this.mapModeCalc.convertFromMapModeToMicrons(n2, n6, n3, n4);
            int n8 = n5 * this.serviceState.getRecLinesToPaperCut();
            int n9 = n8 / (n7 == 0 ? 1 : n7) + 1;
            this.serviceState.setRecLinesToPaperCut(n9);
        }
        Tracer.trace(4, className, "setRecLineSpacing()", "Exit");
    }

    public synchronized int setStationLineSpacing(int n, int n2, int n3, String string) throws JposException {
        Tracer.trace(4, className, "setStationLineSpacing(" + n + ", " + n2 + ", " + n3 + ", " + string + ")", "Entry");
        long l = 0L;
        if (n2 != n3) {
            if (n2 < 1) {
                n2 = 1;
            }
            int n4 = this.getDotsPerInchHigh(n);
            int n5 = this.getMicronsPerStep(n);
            int n6 = this.serviceState.getMapMode();
            int n7 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n3, n4, n5);
            int n8 = this.mapModeCalc.convertFromMapModeToMicrons(n6, n2, n4, n5);
            if (n8 > this.getMaxMicronsPerFeed()) {
                n8 = this.getMaxMicronsPerFeed();
                n2 = this.mapModeCalc.convertFromMicronsToMapMode(n6, n8, n4, n5);
            }
            this.getPrintingMode(n).setPosNlineFeed(n8);
            Tracer.trace(4, className, "setStationLineSpacing() ", "microns == " + n8);
        }
        Tracer.trace(4, className, "setStationLineSpacing() = " + n2, "Exit");
        return n2;
    }

    int getMaxMicronsPerFeed() {
        return 30000;
    }

    public synchronized void setSlpLetterQuality(boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106);
        }
    }

    public synchronized void setSlpLineChars(int n) throws JposException {
        Tracer.trace(4, className, "setSlpLineChars(" + n + ")", "Entry");
        this.setStateLineChars(n, 4);
        Tracer.trace(4, className, "setSlpLineChars()", "Exit");
    }

    public synchronized void setSlpLineHeight(int n) throws JposException {
    }

    public synchronized void setSlpLineSpacing(int n) throws JposException {
        Tracer.trace(4, className, "setSlpLineSpacing(" + n + ")", "Entry");
        int n2 = this.setStationLineSpacing(4, n, this.serviceState.getSlpLineSpacing(), "lineFeedDI");
        this.serviceState.setSlpLineSpacing(n2);
        Tracer.trace(4, className, "setSlpLineSpacing()", "Exit");
    }

    public synchronized void setLineSpacing(int n, int n2) throws JposException {
        Tracer.trace(4, className, "setLineSpacing(" + n + "," + n2 + ")", "Entry");
        switch (n) {
            case 1: {
                this.setJrnLineSpacing(n2);
                break;
            }
            case 2: {
                this.setRecLineSpacing(n2);
                break;
            }
            case 4: {
                this.setSlpLineSpacing(n2);
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        Tracer.trace(4, className, "setLineSpacing()", "Exit");
    }

    public synchronized int getLineSpacing(int n) throws JposException {
        Tracer.trace(4, className, "getLineSpacing(" + n + ")", "Entry");
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = this.serviceState.getJrnLineSpacing();
                break;
            }
            case 2: {
                n2 = this.serviceState.getRecLineSpacing();
                break;
            }
            case 4: {
                n2 = this.serviceState.getSlpLineSpacing();
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        Tracer.trace(4, className, "getLineSpacing()", "Exit");
        return n2;
    }

    public void setCartridgeNotify(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106);
        }
    }

    public void setJrnCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void setRecCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void setSlpCurrentCartridge(int n) throws JposException {
        if (n != 1) {
            throw new JposException(106);
        }
    }

    public void changePrintSide(int n) throws JposException {
        throw new JposException(106);
    }

    public void markFeed(int n) throws JposException {
        throw new JposException(106);
    }

    protected abstract PrinterFont[] getPrinterFonts() throws JposException;

    protected abstract PrintDataCompiler getPrintDataCompiler();

    protected int calcStationWidth(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = this.serviceState.getRecLineWidth();
                break;
            }
            case 4: {
                n2 = this.serviceState.getSlpLineWidth();
            }
        }
        return n2;
    }

    protected int convertToDots(int n, int n2) throws JposException {
        int n3 = this.serviceState.getMapMode();
        int n4 = this.mapModeCalc.convertFromMapModeToMicrons(n3, n, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        return this.mapModeCalc.convertFromMicronsToMapMode(1, n4, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
    }

    protected int getSelectedStations() {
        return this.selectedStations;
    }

    protected void selectStations(int n) throws JposException {
        Tracer.trace(4, className, "selectStations(" + n + ")", "Entry");
        try {
            switch (n) {
                case 1: {
                    this.selectedStations = 1;
                    break;
                }
                case 2: {
                    byte by = (byte)(this.getPrintingMode(2).getPosNlineFeed() / this.getMicronsPerStep(2));
                    by = (byte)(by - by % 2);
                    this.serial4610Device.write(new byte[]{27, 99, 48, 2, 27, 99, 49, 2, 27, 33, 0, 27, 97, 0, 27, 51, by, 27, 123, this.getPrintingMode(2).getRotation() == 259 ? (byte)1 : 0});
                    this.selectedStations = 2;
                    break;
                }
                case 3: 
                case 32771: {
                    this.selectedStations = 32771;
                    break;
                }
                case 4: {
                    byte by = 4;
                    byte by2 = (byte)(this.getPrintingMode(4).getPosNlineFeed() / this.getMicronsPerStep(4));
                    if (this.getPrintingMode(4).isSideways()) {
                        by = 8;
                        if (this.serviceState.getMapMode() == 1) {
                            by2 = (byte)(by2 * 2);
                        }
                    }
                    this.serial4610Device.write(new byte[]{27, 99, 48, by, 27, 99, 49, by, 27, 33, 0, 27, 97, 0, 27, 51, by2});
                    this.selectedStations = 4;
                    break;
                }
                default: {
                    throw new JposException(111, "Internal Error: Serial4610POSPrinterServiceImp.selectStations(): bad station: " + n);
                }
            }
        }
        catch (Exception exception) {
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "selectStations()", "Exit");
    }

    protected PrintingMode getPrintingMode(int n) {
        return this.printingModes[n];
    }

    protected void checkPrinterErrorCause() throws JposException {
        this.checkPrinterErrorCause(new PrintNormalData(0, null, false, false));
    }

    protected void checkPrinterErrorCause(PrintQueueElement printQueueElement) throws JposException {
        Tracer.trace(4, className, "checkPrinterErrorCause()", "Entry");
        Serial4610PrintDataCompiler serial4610PrintDataCompiler = (Serial4610PrintDataCompiler)this.getPrintDataCompiler();
        this.queryPrinterStatus();
        try {
            if (!this.isOnline()) {
                throw new JposException(108);
            }
            switch (this.selectedStations) {
                case 1: 
                case 5: 
                case 32773: {
                    if (!this.serviceState.getJrnEmpty()) break;
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 202);
                }
                case 2: 
                case 6: 
                case 32774: {
                    if (!this.serviceState.getRecEmpty()) break;
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 203);
                }
            }
            if (this.serviceState.getCoverOpen()) {
                printQueueElement.setErrorLevel(2);
                throw new JposException(114, 201);
            }
            if (this.printerErrorCause != 0) {
                if (this.printerErrorCause == 1) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_COVER_OPEN");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 201);
                }
                if (this.printerErrorCause == 2) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_TRANSPORT_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 4) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_SJ_PAPER_ERROR");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 202);
                }
                if (this.printerErrorCause == 8) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_INSERTED");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 205);
                }
                if (this.printerErrorCause == 16) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_NOT_INSERTED");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 204);
                }
                if (this.printerErrorCause == 32) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_NOT_READY");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 204);
                }
                if (this.printerErrorCause == 64) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DOCUMENT_NOT_EJECTED");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(114, 204);
                }
                if (this.printerErrorCause == 128) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_MICR_ERROR");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 512) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_EEPROM_LOAD_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 1024) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_EEPROM_FULL");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(114, 206);
                }
                if (this.printerErrorCause == 4096) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_COMMUNICATION_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(108);
                }
                if (this.printerErrorCause == 8192) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_DI_FEED_ERROR");
                    printQueueElement.setErrorLevel(2);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 16384) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_STARTUP_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == 16385) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_UNRECOVERABLE_ERROR");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
                if (this.printerErrorCause == Short.MIN_VALUE) {
                    Tracer.trace(4, className, "checkPrinterErrorCause()", "PosERROR_COMMAND_REJECTED");
                    printQueueElement.setErrorLevel(3);
                    throw new JposException(111);
                }
            }
        }
        catch (JposException jposException) {
            serial4610PrintDataCompiler.resetCellsBuffered();
            Object object = this.serial4610Device.getIOSemaphore();
            synchronized (object) {
                try {
                    this.bufferEmpty.set(false);
                    this.serial4610Device.write(new byte[]{16, 5, 50});
                    this.bufferEmpty.waitFor(true, 3000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw jposException;
        }
        Tracer.trace(4, className, "checkPrinterErrorCause()", "Exit");
    }

    public void chase(int n) throws JposException {
        Tracer.trace(4, className, "chase(" + n + ")", "Entry");
        if (this.useChase && !this.getPrintingMode(this.selectedStations).isTransaction()) {
            try {
                this.chaseCompleted.set(false);
                this.serial4610Device.chase();
                this.chaseCompleted.waitForTrue(n);
            }
            catch (Exception exception) {
                this.checkPrinterErrorCause(new PrintNormalData(0, null, false, false));
                throw this.createJposException(exception);
            }
        }
        Tracer.trace(4, className, "chase()", "Exit");
    }

    public void chase() throws JposException {
        this.chase(30000);
    }

    int computeLineChars(int n, int n2) throws JposException {
        int n3;
        Tracer.trace(4, className, "computeLineChars(" + n + ", " + n2 + ")", "Entry");
        int n4 = 1000;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        if (n < 1) {
            throw new JposException(106);
        }
        int n7 = 0;
        while (n7 < printerFontArray.length) {
            if (printerFontArray[n7].station == n2 && printerFontArray[n7].lineChars == n) {
                bl = true;
                break;
            }
            ++n7;
        }
        if (n7 >= printerFontArray.length) {
            n7 = 0;
            while (n7 < printerFontArray.length) {
                if (printerFontArray[n7].station == n2) {
                    int n8;
                    if (printerFontArray[n7].lineChars > n6) {
                        n6 = printerFontArray[n7].lineChars;
                    }
                    if (printerFontArray[n7].lineChars > n && (n8 = Math.abs(printerFontArray[n7].lineChars - n)) < n4) {
                        n4 = n8;
                        n5 = n7;
                    }
                }
                ++n7;
            }
            if (n > n6) {
                throw new JposException(106);
            }
            if (n5 == -1) {
                throw new JposException(106);
            }
            n3 = printerFontArray[n5].lineChars;
            n7 = n5;
        } else {
            n3 = n;
        }
        Tracer.trace(4, className, "computeLineChars() =  " + n3, "Entry");
        return n7;
    }

    public void setStateLineChars(int n, int n2) throws JposException {
        Tracer.trace(4, className, "setStateLineChars(" + n + ", " + n2 + ")", "Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        int n3 = this.computeLineChars(n, n2);
        int n4 = printerFontArray[n3].lineChars;
        int n5 = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), printerFontArray[n3].lineDots, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        int n6 = this.mapModeCalc.convertFromMicronsToMapMode(this.serviceState.getMapMode(), n5, this.getDotsPerInchWide(n2), this.getMicronsPerStep(n2));
        n5 = this.mapModeCalc.convertFromMapModeToMicrons(1, printerFontArray[n3].lineSpacing, this.getDotsPerInchHigh(n2), this.getMicronsPerStep(n2));
        int n7 = this.mapModeCalc.convertFromMicronsToMapMode(this.serviceState.getMapMode(), n5, this.getDotsPerInchHigh(n2), this.getMicronsPerStep(n2));
        switch (n2) {
            case 2: {
                this.serviceState.setRecLineWidth(n6);
                this.serviceState.setRecLineChars(n);
                this.setRecLineSpacing(n7);
                break;
            }
            case 4: {
                this.serviceState.setSlpLineWidth(n6);
                this.serviceState.setSlpLineChars(n);
                break;
            }
            case 1: {
                this.serviceState.setJrnLineWidth(n6);
                this.serviceState.setJrnLineChars(n);
            }
        }
        Tracer.trace(4, className, "setStateLineChars()", "Exit");
    }

    protected void queryPrinterStatus() {
        this.queryPrinterStatus(false);
    }

    protected void queryPrinterStatus(boolean bl) {
        block34: {
            Tracer.trace(4, className, "queryPrinterStatus(" + bl + ")", "Entry");
            try {
                byte[] byArray = this.serial4610Device.getStatus();
                if ((byArray[1] & 0x40) != 0) {
                    this.bufferEmpty.set(true);
                } else {
                    this.bufferEmpty.set(false);
                }
                if ((byArray[2] & 0x80) != 0) {
                    this.commandComplete.set(true);
                }
                if (this.serviceState.getCapSlpPresent()) {
                    Tracer.trace(4, className, "queryPrinterStatus()", "Checking slip station");
                    if ((byArray[1] & 1) == 0) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Document is registered");
                        if (this.printerErrorCause == 32) {
                            this.printerErrorCause = 0;
                        }
                        this.documentRegistered.set(true);
                    } else {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Document is not registered");
                        if (this.selectedStations == 4) {
                            this.printerErrorCause = 32;
                        }
                        this.documentRegistered.set(false);
                    }
                    if ((byArray[1] & 6) == 6) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Slip station is empty");
                        if (!this.serviceState.getSlpEmpty()) {
                            this.serviceState.setSlpEmpty(true);
                            this.serviceState.setSlpPrintSide(0);
                            if (this.serviceState.getDeviceEnabled()) {
                                this.eventQueueManager.postEvent(new StatusUpdateEvent(this.eventSource, 27));
                            }
                        }
                        if (this.selectedStations == 4) {
                            this.printerErrorCause = 16;
                        }
                        this.documentInserted.set(false);
                    } else {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Slip is inserted");
                        if (this.serviceState.getSlpEmpty()) {
                            this.serviceState.setSlpEmpty(false);
                            this.serviceState.setSlpPrintSide(1);
                            if (this.serviceState.getDeviceEnabled()) {
                                this.eventQueueManager.postEvent(new StatusUpdateEvent(this.eventSource, 29));
                            }
                        }
                        if (this.printerErrorCause == 16) {
                            this.printerErrorCause = 0;
                        }
                        this.documentInserted.set(true);
                    }
                }
                if ((this.selectedStations == 2 || bl) && this.serviceState.getCapRecPresent()) {
                    StatusUpdateEvent statusUpdateEvent;
                    Tracer.trace(4, className, "queryPrinterStatus()", "Receipt station is present");
                    boolean bl2 = false;
                    if (this.serviceState.getCapRecEmptySensor()) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Receipt has empty sensor");
                        if ((byArray[0] & 0x40) == 64) {
                            Tracer.trace(4, className, "queryPrinterStatus()", "Receipt is empty");
                            if (!this.serviceState.getRecEmpty()) {
                                this.serviceState.setRecEmpty(true);
                                if (this.serviceState.getDeviceEnabled()) {
                                    statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 24);
                                    this.eventQueueManager.postEvent(statusUpdateEvent);
                                }
                            }
                        } else if (this.serviceState.getRecEmpty()) {
                            this.serviceState.setRecEmpty(false);
                            bl2 = true;
                        }
                    }
                    if (this.serviceState.getCapRecNearEndSensor()) {
                        Tracer.trace(4, className, "queryPrinterStatus()", "Receipt has low sensor");
                    }
                    if (bl2 && this.serviceState.getDeviceEnabled()) {
                        statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 26);
                        this.eventQueueManager.postEvent(statusUpdateEvent);
                    }
                }
                if ((byArray[0] & 0x60) != 0) {
                    Tracer.trace(4, className, "queryPrinterStatus()", "Cover is open");
                    this.printerErrorCause = 1;
                    if (!this.serviceState.getCoverOpen()) {
                        this.serviceState.setCoverOpen(true);
                        if (this.serviceState.getDeviceEnabled()) {
                            StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 11);
                            this.eventQueueManager.postEvent(statusUpdateEvent);
                        }
                    }
                } else {
                    if (this.printerErrorCause == 1) {
                        this.printerErrorCause = 0;
                    }
                    if (this.serviceState.getCoverOpen()) {
                        this.serviceState.setCoverOpen(false);
                        if (this.serviceState.getDeviceEnabled()) {
                            StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.eventSource, 12);
                            this.eventQueueManager.postEvent(statusUpdateEvent);
                        }
                    }
                }
            }
            catch (Exception exception) {
                Tracer.trace(4, className, "queryPrinterStatus()", "caught exception: " + exception.getMessage());
                if (Tracer.getTraceLevel() < 4) break block34;
                exception.printStackTrace();
            }
        }
        Tracer.trace(4, className, "queryPrinterStatus()", "Exit");
    }

    int getPosNprintStation(int n) throws JposException {
        switch (n) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 4;
            }
        }
        throw new JposException(106, "Illegal station");
    }

    private int getDiWidth() throws JposException {
        Tracer.trace(4, className, "getDiWidth()", "Entry");
        int n = this.computeLineChars(this.serviceState.getSlpLineChars(), 4);
        int n2 = this.getPrinterFonts()[n].diWidth;
        Tracer.trace(4, className, "getDiWidth() = " + n2, "Exit");
        return n2;
    }

    protected int calculatePosNlineFeedCR() throws JposException {
        Tracer.trace(4, className, "calculatePosNlineFeedCR()", "Entry");
        int n = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), this.serviceState.getRecLineSpacing(), this.getDotsPerInchHigh(2), this.getMicronsPerStep(2));
        Tracer.trace(4, className, "calculatePosNlineFeedCR()", "Exit (" + n + ")");
        return n;
    }

    protected int calculatePosNlineFeedDI() throws JposException {
        Tracer.trace(4, className, "getDiLineFeed()", "Entry");
        int n = 0;
        n = this.serviceState.getSlpLineSpacing();
        n = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), n, this.getDotsPerInchHigh(4), this.getMicronsPerStep(4));
        Tracer.trace(4, className, "getDiLineFeed() = " + n, "Exit");
        return n;
    }

    protected int calculatePosNlineFeedSJ() throws JposException {
        Tracer.trace(4, className, "getSjLineFeed()", "Entry");
        int n = 0;
        n = this.serviceState.getJrnLineSpacing();
        n = this.mapModeCalc.convertFromMapModeToMicrons(this.serviceState.getMapMode(), n, this.getDotsPerInchHigh(1), this.getMicronsPerStep(1));
        Tracer.trace(4, className, "getSjLineFeed() = " + n, "Exit");
        return n;
    }

    public abstract int getDotsPerInchHigh(int var1) throws JposException;

    public abstract int getDotsPerInchWide(int var1) throws JposException;

    public abstract int getMicronsPerStep(int var1) throws JposException;

    public abstract int getMaxBytesPerWrite(int var1) throws JposException;

    public abstract int getWriteBufferSize();

    public int getMaxBitmapWidth(int n) throws JposException {
        return Integer.MAX_VALUE;
    }

    public int getMaxBitmapHeight(int n) throws JposException {
        return Integer.MAX_VALUE;
    }

    public int getForcedBitmapHeight() {
        return -1;
    }

    public int getForcedBitmapWidth() {
        return -1;
    }

    public abstract byte[] getBitmapHeader(int var1, int var2) throws JposException;

    public abstract boolean requiresLinefeed(int var1);

    private void sendLinefeed() throws JposException {
        Tracer.trace(4, className, "sendLineFeed()", "Entry");
        this.serial4610Device.write(new byte[]{10});
        Tracer.trace(4, className, "sendLineFeed()", "Exit");
    }

    public void handleDeviceOnlineMessage() {
    }

    public JposException createJposException(Exception exception) throws JposException {
        if (exception instanceof JposException) {
            return (JposException)exception;
        }
        return new JposException(111, exception.getMessage(), exception);
    }

    public void checkStations(int n) throws JposException {
        this.selectedStations = n;
        if (!this.isOnline()) {
            throw new JposException(108);
        }
        if (this.serviceState.getCoverOpen()) {
            throw new JposException(114, 201);
        }
        switch (n) {
            case 1: 
            case 5: 
            case 32773: {
                if (!this.serviceState.getJrnEmpty()) break;
                throw new JposException(114, 202);
            }
            case 2: 
            case 6: 
            case 32774: {
                if (!this.serviceState.getRecEmpty()) break;
                throw new JposException(114, 203);
            }
            case 3: 
            case 32771: {
                if (this.serviceState.getJrnEmpty()) {
                    throw new JposException(114, 202);
                }
                if (!this.serviceState.getRecEmpty()) break;
                throw new JposException(114, 203);
            }
        }
    }

    private void setKeepInRawMode(boolean bl) {
        this.keepInRawMode = bl;
    }

    public abstract int getMaxPrintBitmapSize() throws JposException;

    public abstract int getMaxSetBitmapSize(int var1) throws JposException;

    public abstract void doPrinting(int var1, String var2, String var3, byte[] var4, int var5, int var6, boolean var7, boolean var8, int var9) throws JposException;

    public abstract void clearMessages() throws JposException;

    public abstract void processPrintBarCode(PrintBarCodeData var1) throws JposException;

    protected class PrintingMode {
        int station;
        int posNprintStation;
        String PosNlineFeed;
        int posNlineFeed = -1;
        int rotation = 1;
        boolean transaction = false;
        boolean sideways = false;

        public PrintingMode(int n) throws JposException {
            this.station = n;
            switch (n) {
                case 1: {
                    this.posNprintStation = 2;
                    this.PosNlineFeed = "lineFeedSJ";
                    break;
                }
                case 2: {
                    this.posNprintStation = 1;
                    this.PosNlineFeed = "lineFeedCR";
                    break;
                }
                case 4: {
                    this.posNprintStation = 4;
                    this.PosNlineFeed = "lineFeedDI";
                    break;
                }
                default: {
                    throw new JposException(111);
                }
            }
        }

        public int getPosNlineFeed() throws JposException {
            switch (this.station) {
                case 1: {
                    this.posNlineFeed = Serial4610POSPrinterServiceImp.this.calculatePosNlineFeedSJ();
                    break;
                }
                case 2: {
                    this.posNlineFeed = Serial4610POSPrinterServiceImp.this.calculatePosNlineFeedCR();
                    break;
                }
                case 4: {
                    this.posNlineFeed = Serial4610POSPrinterServiceImp.this.calculatePosNlineFeedDI();
                    break;
                }
                default: {
                    throw new JposException(111);
                }
            }
            return this.posNlineFeed;
        }

        public void setPosNlineFeed(int n) throws JposException {
            switch (this.station) {
                case 2: {
                    Serial4610POSPrinterServiceImp.this.serial4610Device.write(new byte[]{27, 99, 49, 2, 27, 51, (byte)(n / Serial4610POSPrinterServiceImp.this.getMicronsPerStep(2))});
                    break;
                }
                case 4: {
                    byte by = (byte)(n / Serial4610POSPrinterServiceImp.this.getMicronsPerStep(4));
                    if (this.isSideways() && Serial4610POSPrinterServiceImp.this.serviceState.getMapMode() == 1) {
                        by = (byte)(by * 2);
                    }
                    Serial4610POSPrinterServiceImp.this.serial4610Device.write(new byte[]{27, 99, 49, 4, 27, 51, by});
                    break;
                }
                default: {
                    return;
                }
            }
            this.posNlineFeed = n;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void setRotation(int n) throws JposException {
            Tracer.trace(4, "PrintingMode", "setRotation(" + n + ")", "Entry");
            block2 : switch (n) {
                case 1: {
                    try {
                        if (this.rotation == 258 || this.rotation == 257) {
                            try {
                                Serial4610POSPrinterServiceImp.this.chase(200000);
                            }
                            catch (Exception exception) {
                                Serial4610POSPrinterServiceImp.this.checkStations(this.station);
                                throw new JposException(111);
                            }
                        }
                        Object var4_3 = null;
                        this.rotation = 1;
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.rotation = 1;
                        throw throwable;
                    }
                }
                case 258: {
                    switch (this.rotation) {
                        case 1: {
                            Serial4610POSPrinterServiceImp.this.selectStations(this.station);
                            Serial4610POSPrinterServiceImp.this.chase(10000);
                            this.rotation = n;
                            break block2;
                        }
                        case 258: {
                            break block2;
                        }
                        case 257: 
                        case 259: {
                            throw new JposException(106);
                        }
                    }
                    break;
                }
                case 257: {
                    switch (this.rotation) {
                        case 1: {
                            Serial4610POSPrinterServiceImp.this.selectStations(this.station);
                            Serial4610POSPrinterServiceImp.this.chase(10000);
                            this.rotation = n;
                            break block2;
                        }
                        case 257: {
                            break block2;
                        }
                        case 258: 
                        case 259: {
                            throw new JposException(106);
                        }
                    }
                    break;
                }
                case 259: {
                    switch (this.rotation) {
                        case 1: {
                            this.rotation = 259;
                            break block2;
                        }
                        case 259: {
                            break block2;
                        }
                        case 257: 
                        case 258: {
                            throw new JposException(106);
                        }
                    }
                    break;
                }
                default: {
                    throw new JposException(106);
                }
            }
            Tracer.trace(4, "PrintingMode", "setRotation() = " + this.rotation, "Entry");
        }

        public boolean isSideways() {
            return this.rotation == 258 || this.rotation == 257;
        }

        public void clearSideways() {
            this.sideways = false;
        }

        public void beginTransaction() throws JposException {
            Serial4610POSPrinterServiceImp.this.selectStations(this.station);
            this.transaction = true;
        }

        public void endTransaction() throws JposException {
            try {
                try {
                    Serial4610POSPrinterServiceImp.this.chase();
                }
                catch (Exception exception) {
                    Serial4610POSPrinterServiceImp.this.checkStations(this.station);
                    throw new JposException(111);
                }
                Object var3_1 = null;
                this.transaction = false;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.transaction = false;
                throw throwable;
            }
        }

        public void clearTransaction() {
            this.transaction = false;
        }

        public boolean isTransaction() {
            return this.transaction;
        }
    }

    private class POSPrinterListener
    implements Serial4610PrnChaseCompleteListener,
    Serial4610PrnPrinterErrorListener,
    Serial4610PrnStatusChangeListener {
        private POSPrinterListener() {
        }

        public void serial4610PrnChaseCompleteOccurred() {
            Tracer.trace(3, Serial4610POSPrinterServiceImp.className, "serial4610PrnChaseCompleteOccurred()", "Entry");
            Serial4610POSPrinterServiceImp.this.chaseCompleted.set(true);
            Tracer.trace(3, Serial4610POSPrinterServiceImp.className, "serial4610PrnChaseCompleteOccurred()", "Exit");
        }

        public void serial4610PrnPrinterErrorOccurred(byte[] byArray, int n) {
            Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred(status, cause)", "Entry");
            if (Tracer.getTraceLevel() > 3) {
                switch (n) {
                    case -32768: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_COMMAND_REJECTED");
                        break;
                    }
                    case 1: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_COVER_OPEN");
                        break;
                    }
                    case 16384: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_STARTUP_ERROR");
                        break;
                    }
                    case 1024: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_EEPROM_FULL");
                        break;
                    }
                    case 512: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_EEPROM_LOAD_ERROR");
                        break;
                    }
                    case 16: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_DOCUMENT_NOT_INSERTED");
                        break;
                    }
                    case 2: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_TRANSPORT_ERROR");
                        break;
                    }
                    case 8192: {
                        Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "cause == PosERROR_DI_FEED_ERROR");
                    }
                }
            }
            Serial4610POSPrinterServiceImp.this.queryPrinterStatus();
            Serial4610POSPrinterServiceImp.this.printerErrorCause = n;
            Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "Forcing chase timeout");
            Serial4610POSPrinterServiceImp.this.chaseCompleted.forceTimeout();
            Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnPrinterErrorOccurred()", "Exit");
        }

        public void serial4610PrnStatusChangeOccurred(byte[] byArray) {
            Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnStatusChangeOccurred()", "Entry");
            Serial4610POSPrinterServiceImp.this.queryPrinterStatus(true);
            if (Serial4610POSPrinterServiceImp.this.printerErrorCause == 1 && Serial4610POSPrinterServiceImp.this.chaseCompleted.isFalse()) {
                Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnStatusChangeOccurred()", "Forcing chase timeout");
                Serial4610POSPrinterServiceImp.this.chaseCompleted.forceTimeout();
            }
            Tracer.trace(4, Serial4610POSPrinterServiceImp.className, "serial4610PrnStatusChangeOccurred()", "Exit");
        }
    }
}

